/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.event.BCloudLinkEventRecipient;
import com.tridium.cloudLink.msg.ISendEventHandler;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.baja.event.BEvent;
import javax.baja.event.BEventService;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;

@NiagaraType
@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CLOUD_LINK_CHANNEL_EVENT)", flags=1, override=true)
public class BEventsChannel
extends BAbstractClientChannel {
    public static final Property channelType = BEventsChannel.newProperty((int)1, (BValue)BString.make((String)"Event"), null);
    public static final Type TYPE = Sys.loadType(BEventsChannel.class);
    private static final Logger log = Logger.getLogger("cloudLink.channel.event");
    private static final String SEND_EVENT_ERROR = "Could not send event";

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    protected final void channelStarted() {
        if (this.getConnectionService().map(BAbstractService::isFatalFault).orElse(true).booleanValue()) {
            return;
        }
        if (!Sys.findService((Type)BEventService.TYPE).isPresent()) {
            BServiceContainer services = (BServiceContainer)Sys.getService((Type)BServiceContainer.TYPE);
            services.add("EventService", (BValue)new BEventService());
        }
        this.ensureEventRecipient();
    }

    public boolean canSend() {
        Optional<String> errMsg = this.checkChannelConfig();
        BAbstractTransport transport = this.getChannelConfig().getTransport(ISendEventHandler.getOperationId());
        if (errMsg.isPresent() || !transport.isOperational()) {
            return false;
        }
        if (transport instanceof BAbstractConnectedTransport) {
            return ((BAbstractConnectedTransport)transport).isConnected();
        }
        return true;
    }

    public CompletableFuture<Boolean> sendBatchEvents(BEvent[] events) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        BAbstractTransport transport = this.getChannelConfig().getTransport(ISendEventHandler.getOperationId());
        if (!this.canSendEvent(future, transport)) {
            return future;
        }
        ISendEventHandler eventHandler = this.getEventHandler(transport);
        for (BEvent event : events) {
            eventHandler.add(event);
        }
        return this.send(transport, eventHandler, future);
    }

    public CompletableFuture<Boolean> sendEvent(BEvent event) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        BAbstractTransport transport = this.getChannelConfig().getTransport(ISendEventHandler.getOperationId());
        if (!this.canSendEvent(future, transport)) {
            return future;
        }
        ISendEventHandler eventHandler = this.getEventHandler(transport);
        eventHandler.add(event);
        return this.send(transport, eventHandler, future);
    }

    public CompletableFuture<Boolean> sendComponentEvent(BComponentEvent componentEvent) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        BAbstractTransport transport = this.getChannelConfig().getTransport(ISendEventHandler.getOperationId());
        if (!this.canSendEvent(future, transport)) {
            return future;
        }
        ISendEventHandler eventHandler = this.getEventHandler(transport);
        eventHandler.add(componentEvent);
        return this.send(transport, eventHandler, future);
    }

    private boolean canSendEvent(CompletableFuture<Boolean> future, BAbstractTransport transport) {
        Optional<String> errMsg = this.checkChannelConfig();
        if (errMsg.isPresent()) {
            future.completeExceptionally(new IllegalStateException(errMsg.get()));
            return false;
        }
        if (!transport.canSend()) {
            future.complete(false);
            return false;
        }
        return true;
    }

    private ISendEventHandler getEventHandler(BAbstractTransport transport) {
        BAbstractCloudLinkHandlerFactory msgFactory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        ISendEventHandler eventHandler = msgFactory.getMessageHandler(ISendEventHandler.class, this.getChannelConfig());
        return eventHandler;
    }

    private CompletableFuture<Boolean> send(BAbstractTransport transport, ISendEventHandler eventHandler, CompletableFuture<Boolean> future) {
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(eventHandler.toMessage(true), eventHandler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannelConfig().enqueueMessage(ISendEventHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }

    private Optional<String> checkChannelConfig() {
        StringBuilder err = this.checkChannelConfigCommon(SEND_EVENT_ERROR);
        return err.length() > 0 ? Optional.of(err.substring(0, err.length() - 1)) : Optional.empty();
    }

    private void ensureEventRecipient() {
        BEventService eventService = (BEventService)Sys.getService((Type)BEventService.TYPE);
        if (eventService != null) {
            BCloudConnectionService ccs = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."));
            if (Arrays.stream(eventService.getChildren(BCloudLinkEventRecipient.class)).noneMatch(recipient -> {
                try {
                    return recipient.getCloudConnectionService().get() == ccs;
                }
                catch (UnresolvedException ex) {
                    log.info(() -> "Unable to resolve cloudConnectionService for " + recipient.getName());
                    return false;
                }
            })) {
                BCloudLinkEventRecipient recipient2 = new BCloudLinkEventRecipient();
                recipient2.setCloudConnectionService(ccs.getOrdInSession());
                eventService.add(lex.get("events.recipient.name") + '?', (BValue)recipient2);
            }
        } else {
            log.config("No Event Service found; cannot ensure CloudLinkEventRecipient installation.");
        }
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("EventsChannel.icon"));
    }
}

