/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.backup.BCloudBackupPolicy;
import com.tridium.cloudLink.backup.BCloudBackupPolicyContainer;
import com.tridium.cloudLink.backup.BackupJobState;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BIBackupChannelConfig;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.FileUploader;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.io.PBEEncryptingOutputStream;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.sys.station.Station;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.baja.backup.BBackupService;
import javax.baja.job.BJob;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CLOUD_LINK_CHANNEL_BACKUP)", flags=1, override=true), @NiagaraProperty(name="policies", type="BCloudBackupPolicyContainer", defaultValue="new BCloudBackupPolicyContainer()", flags=256)})
public class BBackupChannel
extends BAbstractClientChannel {
    public static final Property channelType = BBackupChannel.newProperty((int)1, (BValue)BString.make((String)"Backup"), null);
    public static final Property policies = BBackupChannel.newProperty((int)256, (BValue)new BCloudBackupPolicyContainer(), null);
    public static final Type TYPE = Sys.loadType(BBackupChannel.class);
    protected BBackupService backupService;
    private static final Logger log = Logger.getLogger("cloudLink.channel.backup");

    public BCloudBackupPolicyContainer getPolicies() {
        return (BCloudBackupPolicyContainer)this.get(policies);
    }

    public void setPolicies(BCloudBackupPolicyContainer v) {
        this.set(policies, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!AccessController.doPrivileged(this::localDaemonIsAvailable).booleanValue()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(lex.getText("backup.platform.unavailable"));
            return;
        }
        this.backupService = new BBackupService();
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("BackupChannel.icon"));
    }

    @Override
    protected void propagateStatus() {
        BCloudBackupPolicyContainer[] containers;
        super.propagateStatus();
        for (BCloudBackupPolicyContainer container : containers = (BCloudBackupPolicyContainer[])this.getChildren(BCloudBackupPolicyContainer.class)) {
            BCloudBackupPolicy[] backupPolicies;
            for (BCloudBackupPolicy backupPolicy : backupPolicies = (BCloudBackupPolicy[])container.getChildren(BCloudBackupPolicy.class)) {
                backupPolicy.updateStatus();
            }
        }
    }

    public CompletableFuture<Void> backup(BJob job, String excludeFiles, BOrdList excludeFolders, String backupNote, BPassword encryptionKey, Context cx) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (job == null) {
            future.completeExceptionally(new IllegalArgumentException("backup: job can not be null"));
            return future;
        }
        if (!this.isOperational()) {
            log.warning("backup channel is not operational.");
            job.log().message("cloudLink", "backup.job.notOperational");
            future.completeExceptionally(new Exception("backup channel not operational"));
            return future;
        }
        try {
            BackupJobState state = new BackupJobState(job, future, backupNote);
            Station.saveSync((BJob)job, (int)10);
            this.backupService.setExcludeFiles(excludeFiles);
            this.backupService.setExcludeDirectories(excludeFolders);
            Consumer<OutputStream> fileData = out -> {
                try (SecretChars encKeyChars = AccessController.doPrivileged(() -> encryptionKey.getSecretChars());){
                    PBEEncryptingOutputStream encryptingOutputStream = new PBEEncryptingOutputStream(out, encKeyChars);
                    this.backupService.zip(state.getJob(), (OutputStream)encryptingOutputStream, false);
                    encryptingOutputStream.flush();
                }
                catch (Exception ex) {
                    state.getFuture().completeExceptionally(ex);
                }
            };
            FileUploader uploader = this.getConnectionService().orElseThrow(() -> new RuntimeException("Cloud connection service not found")).getFileUploader(this).orElseThrow(() -> new RuntimeException("File uploader not available"));
            BIBackupChannelConfig config = (BIBackupChannelConfig)((Object)this.getChannelConfig());
            FileUploadRequest request = new FileUploadRequest(null, fileData, config.getMetadata(state, cx));
            BBackupChannel.checkJobStatus(job);
            uploader.upload(request).whenComplete((response, err) -> {
                if (err != null) {
                    future.completeExceptionally((Throwable)err);
                } else {
                    future.complete(null);
                }
            });
        }
        catch (Exception ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    public static void checkJobStatus(BJob job) throws InterruptedException {
        if (!job.isAlive()) {
            throw new InterruptedException(lex.getText("model.modelExportJob.statusInterrupted"));
        }
        job.heartbeat();
    }

    protected boolean localDaemonIsAvailable() {
        return LocalSessionUtil.localDaemonIsAvailable();
    }
}

