/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.clUtils.util.CloudIdConstants;
import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BMultiTransportChannelConfig;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.FileUploader;
import com.tridium.cloudLink.model.BModelIngestState;
import com.tridium.cloudLink.msg.IGetModelIngestionStatusHandler;
import com.tridium.cloudLink.msg.IModelIngestStatusResult;
import com.tridium.cloudLink.msg.ISendModelCloseHandler;
import com.tridium.cloudLink.msg.ISendModelOpenHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.util.Lexicon;

@NiagaraType
public abstract class BAbstractModelChannelConfig
extends BMultiTransportChannelConfig {
    public static final Type TYPE = Sys.loadType(BAbstractModelChannelConfig.class);
    protected static final Lexicon lex = Lexicon.make((String)"cloudLink");
    protected static final Logger log = Logger.getLogger("cloudLink.channel.model");
    private static final IModelIngestStatusResult MODEL_STATUS_CHECK_UNSUPPORTED = new IModelIngestStatusResult(){

        @Override
        public BModelIngestState getState() {
            return BModelIngestState.none;
        }

        @Override
        public String getStatus() {
            return lex.getText("modelStatus.notSupported");
        }
    };

    @Override
    public Type getType() {
        return TYPE;
    }

    public CompletableFuture<Map<String, Object>> openModel(BJob job, BCloudConnectionService connectionService, Map<String, Object> modelProperties) {
        CompletableFuture<Map<String, Object>> openModelFuture = new CompletableFuture<Map<String, Object>>();
        try {
            BAbstractModelChannelConfig.checkJobStatus(job);
            BAbstractTransport transport = this.getTransport(ISendModelOpenHandler.getOperationId());
            if (!transport.canSend()) {
                openModelFuture.completeExceptionally(new IllegalStateException("Model Open message was not sent because transport cannot send messages"));
                return openModelFuture;
            }
            BAbstractCloudLinkHandlerFactory msgFactory = connectionService.getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
            ISendModelOpenHandler openModelHandler = msgFactory.getMessageHandler(ISendModelOpenHandler.class, this);
            openModelHandler.setProperties(Collections.unmodifiableMap(modelProperties));
            MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(openModelHandler.toMessage(), openModelHandler.getFuture(openModelFuture), transport.getMessageRetries());
            AccessController.doPrivileged(() -> {
                this.enqueueMessage(ISendModelOpenHandler.getOperationId(), wrapper);
                return null;
            });
            transport.notifyPending();
        }
        catch (Exception e) {
            openModelFuture.completeExceptionally(e);
        }
        return openModelFuture;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<Map<String, Object>> closeModel(BJob job, BCloudConnectionService connectionService, Map<String, Object> modelProperties) {
        CompletableFuture<Map<String, Object>> closeModelFuture = new CompletableFuture<Map<String, Object>>();
        try {
            BAbstractModelChannelConfig.checkJobStatus(job);
            BAbstractTransport transport = this.getTransport(ISendModelCloseHandler.getOperationId());
            if (!transport.canSend()) {
                closeModelFuture.completeExceptionally(new IllegalStateException("Model Close message was not sent because transport cannot send messages"));
                return closeModelFuture;
            }
            BAbstractCloudLinkHandlerFactory msgFactory = connectionService.getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
            try (ISendModelCloseHandler closeModelHandler = msgFactory.getMessageHandler(ISendModelCloseHandler.class, this);){
                closeModelHandler.setProperties(Collections.unmodifiableMap(modelProperties));
                IMessage message = closeModelHandler.toMessage();
                if (message == null) {
                    closeModelHandler.getFuture(closeModelFuture, null);
                    return closeModelFuture;
                }
                if (message instanceof FileUploadRequest) {
                    Optional optUploader = this.getChannel().flatMap(c -> connectionService.getFileUploader((BAbstractClientChannel)((Object)c)));
                    if (!optUploader.isPresent()) {
                        log.warning("Unable to get file uploader to upload csom file.");
                        closeModelFuture.completeExceptionally(new Exception("unable to get file uploader"));
                        CompletableFuture<Map<String, Object>> completableFuture = closeModelFuture;
                        return completableFuture;
                    }
                    FileUploader uploader = (FileUploader)optUploader.get();
                    CompletableFuture<IMessageResponse> messageFuture = closeModelHandler.getFuture(closeModelFuture);
                    uploader.upload((FileUploadRequest)message).whenComplete((resp, err) -> {
                        if (err != null) {
                            messageFuture.completeExceptionally((Throwable)err);
                        } else {
                            messageFuture.complete(null);
                        }
                    });
                    return closeModelFuture;
                }
                MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(message, closeModelHandler.getFuture(closeModelFuture), transport.getMessageRetries());
                AccessController.doPrivileged(() -> {
                    this.enqueueMessage(ISendModelCloseHandler.getOperationId(), wrapper);
                    return null;
                });
                transport.notifyPending();
                return closeModelFuture;
            }
        }
        catch (Exception e) {
            closeModelFuture.completeExceptionally(e);
        }
        return closeModelFuture;
    }

    public CompletableFuture<IModelIngestStatusResult> checkModelIngestionStatus(BCloudConnectionService connectionService) {
        CompletableFuture<IModelIngestStatusResult> future = new CompletableFuture<IModelIngestStatusResult>();
        try {
            if (!this.isOperationSupported(IGetModelIngestionStatusHandler.getOperationId())) {
                future.complete(MODEL_STATUS_CHECK_UNSUPPORTED);
                return future;
            }
            BAbstractTransport transport = this.getTransport(IGetModelIngestionStatusHandler.getOperationId());
            if (!transport.canSend()) {
                future.completeExceptionally(new IllegalStateException("Cannot check model ingestion status; transport cannot send"));
                return future;
            }
            BAbstractCloudLinkHandlerFactory msgFactory = connectionService.getMessageHandlerFactory(connectionService.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
            IGetModelIngestionStatusHandler handler = msgFactory.getMessageHandler(IGetModelIngestionStatusHandler.class, this);
            this.configureIngestionStatusHandler(handler);
            MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(handler.toMessage(), handler.getFuture(future), transport.getMessageRetries());
            AccessController.doPrivileged(() -> {
                this.enqueueMessage(IGetModelIngestionStatusHandler.getOperationId(), wrapper);
                return null;
            });
            transport.notifyPending();
        }
        catch (Exception exc) {
            future.completeExceptionally(exc);
        }
        return future;
    }

    protected void configureIngestionStatusHandler(IGetModelIngestionStatusHandler handler) {
    }

    public Function<BIEntity, String> getCloudIdFunction() {
        return CloudIdConstants.CLOUD_ID_FUNCTION;
    }

    public static void checkJobStatus(BJob job) throws InterruptedException {
        if (!job.isAlive()) {
            throw new InterruptedException(lex.getText("model.modelExportJob.statusInterrupted"));
        }
        job.heartbeat();
    }

    public String getDataType(TypeInfo recordType) {
        if (recordType.is(BTrendRecord.TYPE)) {
            Type valueType = ((BTrendRecord)recordType.getInstance().as(BTrendRecord.class)).getValueProperty().getType();
            if (valueType.is(BINumeric.TYPE)) {
                return "numeric";
            }
            if (valueType.is(BIBoolean.TYPE)) {
                return "boolean";
            }
            if (valueType.is(BIEnum.TYPE)) {
                return "enum";
            }
            if (valueType.is(BString.TYPE)) {
                return "string";
            }
        }
        return "other";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDataType(BHistoryImport historyImport, HistorySpaceConnection conn) {
        TypeInfo recordType = null;
        try (BIHistory history = null;){
            BHistoryId historyId = historyImport.getHistoryId().fromShorthand(historyImport.getDevice().getName());
            history = conn.getHistory(historyId);
            if (history == null) {
                log.config(() -> String.format("Cannot determine data type: HistoryImport %s with historyId %s has no corresponding history in the history database", historyImport, historyId));
                String string = null;
                return string;
            }
            recordType = history.getRecordType().getTypeInfo();
            String string = this.getDataType(recordType);
            return string;
        }
    }
}

