/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FederatedIdentityDeviceUuidRequest
implements IMessageBuilder {
    private final String federatedIdentityHost;
    private final String deviceCode;
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final String DEVICE_CODE = "deviceCode";
    private static final String API_PATH = "/api/v1/deviceregistration/uuid";

    public FederatedIdentityDeviceUuidRequest(String server, String deviceCode) {
        this.federatedIdentityHost = server;
        this.deviceCode = deviceCode;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        StringWriter stringWriter = new StringWriter();
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)stringWriter);
        jsonSerializer.object();
        jsonSerializer.key(DEVICE_CODE).value((Object)this.deviceCode);
        jsonSerializer.endObject();
        stringWriter.flush();
        URL url = null;
        try {
            url = new URL("https://" + this.federatedIdentityHost + API_PATH);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for federated identity device uuid request", log.isLoggable(Level.FINE) ? ex : null);
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending device uuid message with correlation " + correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, Collections.singletonMap("x-activity-id", correlationId)).mimeType("application/json").body(stringWriter.getBuffer().toString()).build();
    }
}

