/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.auth;

import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.transport.BAbstractConnectionlessTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.cloudLink.util.PasswordWrapper;
import com.tridium.cloudLink.util.StringWrapper;
import com.tridium.nre.security.NiagaraBasicPermission;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.make(AUTH_PLATFORM_TYPE_PASSWORD)", flags=1, override=true), @NiagaraProperty(name="usernameAndPassword", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()", flags=64), @NiagaraProperty(name="endPoint", type="BString", defaultValue="BString.DEFAULT")})
public class BPasswordAuthenticator
extends BAbstractClientAuthenticator {
    public static final Property authenticatorId = BPasswordAuthenticator.newProperty((int)1, (BValue)BString.make((String)"Password"), null);
    public static final Property usernameAndPassword = BPasswordAuthenticator.newProperty((int)64, (BValue)new BUsernameAndPassword(), null);
    public static final Property endPoint = BPasswordAuthenticator.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BPasswordAuthenticator.class);

    public BUsernameAndPassword getUsernameAndPassword() {
        return (BUsernameAndPassword)this.get(usernameAndPassword);
    }

    public void setUsernameAndPassword(BUsernameAndPassword v) {
        this.set(usernameAndPassword, (BValue)v, null);
    }

    public String getEndPoint() {
        return this.getString(endPoint);
    }

    public void setEndPoint(String v) {
        this.setString(endPoint, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public boolean completesStarted() {
        return true;
    }

    @Override
    public void addMessageHandlerProperties(BAbstractTransport transport, String audience, Map<String, Object> encoderProps) {
        Property pToken;
        encoderProps.put("SystemId", this.getSystemId());
        if (transport instanceof BAbstractConnectionlessTransport && (pToken = this.getProperty(audience)) != null) {
            BValue token = this.get(pToken);
            encoderProps.put("Authorization", "Bearer " + token.toString());
        }
    }

    @Override
    public Map<String, Object> getPlatformProperties() {
        return Collections.emptyMap();
    }

    @Override
    public boolean canAuthenticate() {
        return !this.getUsernameAndPassword().getUsername().isEmpty() && !this.getUsernameAndPassword().getPassword().isDefault();
    }

    @Override
    public boolean isRegistered() {
        return this.canAuthenticate() && !this.getEndPoint().isEmpty();
    }

    @Override
    public final Map<String, IValueWrapper<?>> getConnectionInfo(String id) {
        NiagaraBasicPermission getConnectionStringPermission = new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION");
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || !this.isOperational()) {
            return Collections.emptyMap();
        }
        sm.checkPermission((Permission)getConnectionStringPermission);
        HashMap connectionMap = new HashMap();
        connectionMap.put("hostName", new StringWrapper(this.getEndPoint()));
        connectionMap.put("id", new StringWrapper(this.getUsernameAndPassword().getUsername()));
        connectionMap.put("token", new PasswordWrapper(this.getUsernameAndPassword().getPassword()));
        connectionMap.put("clientId", new StringWrapper(this.getSystemId()));
        return connectionMap;
    }
}

