/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.BAbstractChannelConfigFactory;
import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BNullChannelConfigFactory;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.audit.BCloudAuditHistorySource;
import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.auth.BClientAuthenticatorsFolder;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BClientChannelsFolder;
import com.tridium.cloudLink.file.BAbstractFileUploadManager;
import com.tridium.cloudLink.file.FileUploader;
import com.tridium.cloudLink.objectIdentity.BCloudIdManager;
import com.tridium.cloudLink.tag.BAncestorHasTag;
import com.tridium.cloudLink.tag.BWritablePriorityLevelsTag;
import com.tridium.cloudLink.tag.CloudLinkTagUtil;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.BTransportsFolder;
import com.tridium.cloudLink.util.BSMAExpirationMonitor;
import com.tridium.cloudLink.util.ICCSReady;
import com.tridium.cloudLink.util.LicenseLimit;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BHistoryId;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseException;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Id;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagRule;
import javax.baja.tagdictionary.TagRule;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="platformType", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="SMAExpirationMonitor", type="BSMAExpirationMonitor", defaultValue="new BSMAExpirationMonitor()"), @NiagaraProperty(name="cloudIdManager", type="BCloudIdManager", defaultValue="new BCloudIdManager()"), @NiagaraProperty(name="cloudAuditHistorySource", type="BCloudAuditHistorySource", defaultValue="new BCloudAuditHistorySource()"), @NiagaraProperty(name="authenticators", type="BClientAuthenticatorsFolder", defaultValue="new BClientAuthenticatorsFolder()", flags=256), @NiagaraProperty(name="transports", type="BTransportsFolder", defaultValue="new BTransportsFolder()", flags=256), @NiagaraProperty(name="channels", type="BClientChannelsFolder", defaultValue="new BClientChannelsFolder()", flags=256), @NiagaraProperty(name="moduleVersion", type="BString", defaultValue="Unknown", flags=1)})
public final class BCloudConnectionService
extends BAbstractService
implements BIRestrictedComponent,
LicenseLimit {
    public static final Property platformType = BCloudConnectionService.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property SMAExpirationMonitor = BCloudConnectionService.newProperty((int)0, (BValue)new BSMAExpirationMonitor(), null);
    public static final Property cloudIdManager = BCloudConnectionService.newProperty((int)0, (BValue)new BCloudIdManager(), null);
    public static final Property cloudAuditHistorySource = BCloudConnectionService.newProperty((int)0, (BValue)new BCloudAuditHistorySource(), null);
    public static final Property authenticators = BCloudConnectionService.newProperty((int)256, (BValue)new BClientAuthenticatorsFolder(), null);
    public static final Property transports = BCloudConnectionService.newProperty((int)256, (BValue)new BTransportsFolder(), null);
    public static final Property channels = BCloudConnectionService.newProperty((int)256, (BValue)new BClientChannelsFolder(), null);
    public static final Property moduleVersion = BCloudConnectionService.newProperty((int)1, (String)"Unknown", null);
    public static final Type TYPE = Sys.loadType(BCloudConnectionService.class);
    private final List<ICCSReady> startupCallbacks = new ArrayList<ICCSReady>();
    private boolean isReady;
    private String platformTypeBackup = "";
    private static final Logger log = Logger.getLogger("cloudLink.connectionService");
    private static final Lexicon lex = Lexicon.make((String)"cloudLink");
    private static final Map<String, BAbstractCloudLinkHandlerFactory> msgFactoryMap = new HashMap<String, BAbstractCloudLinkHandlerFactory>();
    private static final Map<String, BAbstractChannelConfigFactory> configFactoryMap = new HashMap<String, BAbstractChannelConfigFactory>();
    private static final Map<String, BAbstractFileUploadManager> fileUploadManagerMap = new HashMap<String, BAbstractFileUploadManager>();
    private static final String TAG_DICTIONARY_INSTALL_FAILED = "Unable to install Niagara Cloud Dictionary. Manual installation is required.";
    private static final Logger liclog = Logger.getLogger("cloudLink.license");
    private static final Logger licdbg = Logger.getLogger("cloudLink.license.debug");
    private static final HashMap<String, CcsLicenseLimit> ccsLimits = new HashMap();
    private static boolean ccsLimitsInitialized;

    public String getPlatformType() {
        return this.getString(platformType);
    }

    public void setPlatformType(String v) {
        this.setString(platformType, v, null);
    }

    public BSMAExpirationMonitor getSMAExpirationMonitor() {
        return (BSMAExpirationMonitor)this.get(SMAExpirationMonitor);
    }

    public void setSMAExpirationMonitor(BSMAExpirationMonitor v) {
        this.set(SMAExpirationMonitor, (BValue)v, null);
    }

    public BCloudIdManager getCloudIdManager() {
        return (BCloudIdManager)this.get(cloudIdManager);
    }

    public void setCloudIdManager(BCloudIdManager v) {
        this.set(cloudIdManager, (BValue)v, null);
    }

    public BCloudAuditHistorySource getCloudAuditHistorySource() {
        return (BCloudAuditHistorySource)this.get(cloudAuditHistorySource);
    }

    public void setCloudAuditHistorySource(BCloudAuditHistorySource v) {
        this.set(cloudAuditHistorySource, (BValue)v, null);
    }

    public BClientAuthenticatorsFolder getAuthenticators() {
        return (BClientAuthenticatorsFolder)this.get(authenticators);
    }

    public void setAuthenticators(BClientAuthenticatorsFolder v) {
        this.set(authenticators, (BValue)v, null);
    }

    public BTransportsFolder getTransports() {
        return (BTransportsFolder)this.get(transports);
    }

    public void setTransports(BTransportsFolder v) {
        this.set(transports, (BValue)v, null);
    }

    public BClientChannelsFolder getChannels() {
        return (BClientChannelsFolder)this.get(channels);
    }

    public void setChannels(BClientChannelsFolder v) {
        this.set(channels, (BValue)v, null);
    }

    public String getModuleVersion() {
        return this.getString(moduleVersion);
    }

    public void setModuleVersion(String v) {
        this.setString(moduleVersion, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "cloudLink");
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        if (this.isFatalFault()) {
            return;
        }
        String versionMismatchMessage = CloudLinkUtils.checkVersionMatch();
        if (!versionMismatchMessage.isEmpty()) {
            this.configFatal(versionMismatchMessage);
            return;
        }
        try {
            Type type = Sys.getType((String)"niagaraDriver:NiagaraNetwork");
            BComponent niagaraNetwork = Sys.getService((Type)type);
            niagaraNetwork.set("persistFetchedTags", (BValue)BBoolean.TRUE);
        }
        catch (ModuleException | ServiceNotFoundException | TypeException ex) {
            log.fine("Unable to locate NiagaraNetwork to set persist fetched tags");
        }
        BCloudConnectionService.initializeTagDictionary();
        this.checkMigration();
    }

    private void checkMigration() {
        if ("Forge".equals(this.getPlatformType()) && this.getAuthenticators().getAuthenticator("FederatedIdentity") != null) {
            log.finest("Updating CloudConnectionService platform type from Forge to NCS due to presence of FedIdAuth");
            this.setPlatformType("NCS");
        }
    }

    public static void initializeTagDictionary() {
        BSmartTagDictionary ncTagDict;
        log.fine("Checking for Niagara Cloud Tag Dictionary...");
        try {
            ncTagDict = CloudLinkTagUtil.getOrAddTagDictionary("nc", "module://cloudLink/module.palette|slot:/Tag$20Dictionary/Niagara$20Cloud");
            Version expected = new Version("1.0.4");
            Version actual = null;
            BValue value = ncTagDict.get("version");
            if (value instanceof BString) {
                actual = new Version(((BString)value).getString());
            }
            if (actual == null || expected.compareTo(actual) != 0) {
                TagRule writableRule;
                value = ncTagDict.getTagRules().get("Writable$20Point$20Tags");
                HashMap configItems = new HashMap();
                if (value instanceof TagRule) {
                    writableRule = (TagRule)value;
                    writableRule.getTag(Id.newId((String)"nc", (String)"writableLevels")).ifPresent(t -> {
                        if (t instanceof BWritablePriorityLevelsTag) {
                            BWritablePriorityLevelsTag tag = (BWritablePriorityLevelsTag)((Object)t);
                            configItems.put("excluded", tag.getExcluded());
                            configItems.put("strict", tag.getStrict());
                        }
                    });
                }
                if ((value = ncTagDict.getTagRules().get("Ancestor$20Max$20Write$20Duration$20Tags")) instanceof TagRule) {
                    writableRule = (TagRule)value;
                    writableRule.getTag(Id.newId((String)"nc", (String)"maxWriteDuration")).ifPresent(t -> {
                        if (t instanceof BAncestorHasTag) {
                            BAncestorHasTag tag = (BAncestorHasTag)((Object)t);
                            configItems.put("maxWriteDurationEnabled", tag.getHasDefault());
                            configItems.put("maxWriteDuration", tag.getDefaultTagValue());
                        }
                    });
                }
                BTagDictionaryService tagDictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
                tagDictionaryService.remove(ncTagDict.getPropertyInParent());
                ncTagDict = CloudLinkTagUtil.addTagDictionary("nc", "module://cloudLink/module.palette|slot:/Tag$20Dictionary/Niagara$20Cloud");
                if (!configItems.isEmpty()) {
                    TagRule writableRule2;
                    value = ncTagDict.getTagRules().get("Writable$20Point$20Tags");
                    if (value instanceof TagRule) {
                        writableRule2 = (TagRule)value;
                        writableRule2.getTag(Id.newId((String)"nc", (String)"writableLevels")).ifPresent(t -> {
                            if (t instanceof BWritablePriorityLevelsTag) {
                                BWritablePriorityLevelsTag tag = (BWritablePriorityLevelsTag)((Object)t);
                                tag.setExcluded((String)configItems.get("excluded"));
                                tag.setStrict((Boolean)configItems.get("strict"));
                            }
                        });
                    }
                    if ((value = ncTagDict.getTagRules().get("Ancestor$20Max$20Write$20Duration$20Tags")) instanceof TagRule) {
                        writableRule2 = (TagRule)value;
                        writableRule2.getTag(Id.newId((String)"nc", (String)"maxWriteDuration")).ifPresent(t -> {
                            if (t instanceof BAncestorHasTag) {
                                BAncestorHasTag tag = (BAncestorHasTag)((Object)t);
                                tag.setHasDefault((Boolean)configItems.get("maxWriteDurationEnabled"));
                                tag.setDefaultTagValue((BValue)configItems.get("maxWriteDuration"));
                            }
                        });
                    }
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, TAG_DICTIONARY_INSTALL_FAILED, log.isLoggable(Level.FINE) ? ex : null);
            return;
        }
        if (CloudLinkUtils.isModuleLoaded("ebiConnector")) {
            BCloudConnectionService.addEbiTagRulesToTagDictionary(ncTagDict);
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        BCloudConnectionService.registerConfigFactories();
        this.isReady = true;
        for (ICCSReady callback : this.startupCallbacks) {
            callback.onCCSReady();
        }
    }

    public void descendantsStopped() throws Exception {
        super.descendantsStopped();
        BCloudConnectionService.unregisterHandlerFactories();
        BCloudConnectionService.unregisterConfigFactories();
    }

    public void started() {
        this.platformTypeBackup = this.getPlatformType();
        this.setModuleVersion(TYPE.getVendorVersion().toString());
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property.equals(platformType)) {
            String newPlatformType = this.getPlatformType();
            if (this.platformTypeBackup.isEmpty()) {
                this.platformTypeBackup = newPlatformType;
                for (BAbstractClientChannel channel : this.getChannels().getChannels()) {
                    channel.updateChannelConfig();
                }
                for (BAbstractTransport transport : this.getTransports().getTransports()) {
                    if (!(transport instanceof BAbstractConnectedTransport)) continue;
                    ((BAbstractConnectedTransport)transport).setupInboundMessaging();
                }
            } else if (!this.platformTypeBackup.equals(newPlatformType)) {
                log.info(String.format("`CloudConnectionService` slot `platformType` may not be changed after being set. Reverting `platformType` back to \"%s\" from \"%s\".", this.platformTypeBackup, newPlatformType));
                this.setPlatformType(this.platformTypeBackup);
            }
        }
    }

    public void updateStatus() {
        super.updateStatus();
        this.getCloudIdManager().updateStatus();
        for (BAbstractClientAuthenticator authenticator : this.getAuthenticators().getAuthenticators()) {
            authenticator.updateStatus();
        }
        for (BAbstractTransport transport : this.getTransports().getTransports()) {
            transport.updateStatus();
        }
        for (BAbstractClientChannel channel : this.getChannels().getChannels()) {
            channel.updateStatus();
        }
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot.equals((Object)SMAExpirationMonitor)) {
            return lex.getText("smaExpirationMonitorDisplayName");
        }
        return super.getDisplayName(slot, cx);
    }

    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("CloudConnectionService.icon"));
    }

    public BAbstractClientAuthenticator getAuthenticator(String authenticatorId) {
        return this.getAuthenticators().getAuthenticator(authenticatorId);
    }

    public BAbstractTransport getTransport(String transportType) {
        return this.getTransports().getTransport(transportType);
    }

    public BAbstractClientChannel getChannel(String channelType) {
        return this.getChannels().getChannel(channelType);
    }

    public Optional<BAbstractCloudLinkHandlerFactory> getMessageHandlerFactory(String platform, String transport) {
        try {
            if (msgFactoryMap.isEmpty()) {
                BCloudConnectionService.registerHandlerFactories();
            }
            String factoryConfig = BAbstractCloudLinkHandlerFactory.getKey(platform, transport);
            BAbstractCloudLinkHandlerFactory factory = msgFactoryMap.get(factoryConfig);
            log.finer("Returning message handler factory " + (Object)((Object)factory) + " for configuration " + factoryConfig);
            return Optional.ofNullable(factory);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, String.format("Cannot create message handler factory for platform %s, transport %s", platform, transport), log.isLoggable(Level.FINE) ? ex : null);
            return Optional.empty();
        }
    }

    public Optional<BAbstractCloudLinkHandlerFactory> getMessageHandlerFactory(String transport) {
        return this.getMessageHandlerFactory(this.getPlatformType(), transport);
    }

    public Optional<BAbstractChannelConfigFactory> getChannelConfigFactory(String platform) {
        try {
            if (configFactoryMap.isEmpty()) {
                BCloudConnectionService.registerConfigFactories();
            }
            BAbstractChannelConfigFactory factory = configFactoryMap.getOrDefault(platform, BNullChannelConfigFactory.INSTANCE);
            log.finer("Returning channel config factory " + (Object)((Object)factory) + " for configuration " + platform);
            return Optional.of(factory);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, String.format("Cannot generate channel config factory for platform %s", platform), log.isLoggable(Level.FINE) ? ex : null);
            return Optional.empty();
        }
    }

    public Optional<FileUploader> getFileUploader(BAbstractClientChannel channel) {
        BAbstractFileUploadManager manager;
        if (fileUploadManagerMap.isEmpty()) {
            BCloudConnectionService.registerFileUploadManagers();
        }
        if ((manager = fileUploadManagerMap.get(this.getPlatformType())) == null) {
            return Optional.empty();
        }
        return manager.getFileUploader(channel);
    }

    public void registerForConnectionServiceReady(ICCSReady callback) {
        this.startupCallbacks.add(callback);
        if (this.isReady) {
            callback.onCCSReady();
        }
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentIsServiceContainer((BComponent)parent, (BIRestrictedComponent)this);
        BIRestrictedComponent.checkContextForSuperUser((BIRestrictedComponent)this, (Context)cx);
    }

    public static boolean isLicensed(Object o) {
        if (o instanceof BIEntity) {
            BIEntity e = (BIEntity)o;
            String licenseKey = BCloudConnectionService.getLicenseKey(e);
            CcsLicenseLimit lim = ccsLimits.get(licenseKey);
            if (lim != null && lim.limit == Integer.MAX_VALUE) {
                return true;
            }
            return TagUtil.getCloudId((BIEntity)e).filter(id -> BCloudConnectionService.getLicenseTable(licenseKey).contains(id.toString())).isPresent();
        }
        return false;
    }

    public static boolean isLicensed(String cloudId, String key) {
        CcsLicenseLimit lim = ccsLimits.get(key);
        if (lim != null && lim.limit == Integer.MAX_VALUE) {
            return true;
        }
        return BCloudConnectionService.getLicenseTable(key).contains(cloudId);
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 501: {
                return BCloudConnectionService.checkLimitForCompAndCloudId(a, (String)b, (String)c);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        try {
            Feature feature = this.getLicenseFeature();
            if (feature == null) {
                return;
            }
            feature.check();
            String platforms = feature.get("platforms");
            if (platforms == null) {
                feature = new LegacyCloudLinkFeature(feature);
            }
            List<String> licensedPlatforms = Arrays.asList(feature.get("platforms", "NCS").split(" "));
            String platformType = this.getPlatformType();
            if (!platformType.isEmpty()) {
                if (!licensedPlatforms.contains(platformType)) {
                    throw new LicenseException(lex.getText("license.wrongPlatform", new Object[]{platformType}));
                }
            } else {
                throw new LicenseException(lex.get("license.emptyPlatformType", "Empty platformType in Cloud Connection Service"));
            }
            BCloudConnectionService.checkLicense(feature);
        }
        catch (Exception licenseFailure) {
            String msg = lex.getText("license.unlicensed", new Object[]{this.toPathString()});
            this.configFatal(msg);
            log.log(Level.SEVERE, msg, licenseFailure);
        }
        this.updateStatus();
    }

    private static void checkLicense(Feature feature) {
        String[] keys;
        if (ccsLimitsInitialized) {
            return;
        }
        for (String key : keys = feature.list()) {
            if (!key.endsWith(".limit")) continue;
            String val = feature.get(key);
            int limit = Integer.MAX_VALUE;
            if (val != null && !"none".equals(TextUtil.toLowerCase((String)val))) {
                limit = Integer.parseInt(val);
            }
            CcsLicenseLimit lic = new CcsLicenseLimit();
            lic.key = key;
            lic.limit = limit;
            lic.licensedIds = new HashSet<String>();
            lic.unlicensed = new HashSet<String>();
            ccsLimits.put(key, lic);
        }
        ccsLimitsInitialized = true;
    }

    private static String checkLimitForCompAndCloudId(Object keyObj, String id, String altId) {
        if (ccsLimits == null) {
            return "no license";
        }
        if (keyObj == null) {
            return "no key license object";
        }
        String licenseFault = BCloudConnectionService.checkCcsLimit(keyObj, "cloudId.limit", id, null);
        if (licenseFault != null) {
            return "Exceeded maximum allowed cloudIds";
        }
        String key = BCloudConnectionService.getLicenseKey(keyObj);
        if (key != null && (licenseFault = BCloudConnectionService.checkCcsLimit(keyObj, key, id, altId)) != null) {
            return licenseFault;
        }
        BCloudConnectionService.addLicensedId(key, id);
        return null;
    }

    private static String getLicenseKey(Object obj) {
        if (obj instanceof BControlPoint) {
            return "point.limit";
        }
        if (obj instanceof BHistoryId) {
            return "history.limit";
        }
        if (obj instanceof BDevice) {
            return "device.limit";
        }
        if (obj instanceof BIAlarmSource) {
            return "alarm.limit";
        }
        liclog.fine(() -> String.format("Uncategorized object type %s will be applied only against cloudId.limit: ", obj.getClass()));
        return null;
    }

    private static Set<String> getLicenseTable(String key) {
        CcsLicenseLimit lim = ccsLimits.get(key);
        return lim == null ? Collections.emptySet() : lim.licensedIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String checkCcsLimit(Object keyObj, String key, String id, String altId) {
        CcsLicenseLimit ccsLimit = ccsLimits.get(key);
        if (ccsLimit == null) {
            return lex.getText("license.unlicensed", new Object[]{key});
        }
        if (ccsLimit.limit == Integer.MAX_VALUE) {
            return null;
        }
        HashMap<String, CcsLicenseLimit> hashMap = ccsLimits;
        synchronized (hashMap) {
            licdbg.fine(() -> String.format("CCS.check4Comp&Id(): key=%s; keyObj=%s; id=%s; altId=%s; ccsLimit=%s", key, keyObj, id, altId, ccsLimit));
            Set<String> table = ccsLimit.licensedIds;
            if (altId != null && table != null && table.contains(altId)) {
                licdbg.fine(() -> String.format("altId found in table for keyObj %s", keyObj));
                return null;
            }
            if (table != null && table.contains(id)) {
                licdbg.fine("CCS.check4Comp&Id(): id already in table");
                if (BCloudConnectionService.shouldSwapCloudToTelemetryId(keyObj, id, altId)) {
                    table.remove(id);
                    table.add(altId);
                    licdbg.fine(() -> String.format("Swapped in telemetryId %s for cloudId %s", altId, id));
                }
                return null;
            }
            return ccsLimit.checkSize(id);
        }
    }

    private static boolean shouldSwapCloudToTelemetryId(Object keyObject, String id, String alternateId) {
        licdbg.fine(() -> String.format("shouldSwap? keyObj=%s; id=%s; alt=%s", keyObject, id, alternateId));
        if (keyObject instanceof BHistoryImport) {
            BComponent keyComp = (BComponent)keyObject;
            if (alternateId != null && !alternateId.isEmpty() && TagUtil.getCloudId((BComponent)keyComp).orElse(CloudLinkConstants.EMPTY_CLOUD_ID).toString().equals(id)) {
                licdbg.fine("id is cloudId! swap in telemetryId");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLicensedId(String key, String id) {
        HashMap<String, CcsLicenseLimit> hashMap = ccsLimits;
        synchronized (hashMap) {
            CcsLicenseLimit ccsLimit = ccsLimits.get(key);
            if (ccsLimit != null) {
                ccsLimit.licensedIds.add(id);
                licdbg.fine(() -> String.format("%s used is now %s of %s", ccsLimit.key, ccsLimit.licensedIds.size(), ccsLimit.limit));
            }
            BCloudConnectionService.ccsLimits.get((Object)"cloudId.limit").licensedIds.add(id);
        }
    }

    private static void registerHandlerFactories() {
        try {
            TypeInfo[] factoryInfos;
            for (TypeInfo factoryInfo : factoryInfos = Sys.getRegistry().getConcreteTypes(BAbstractCloudLinkHandlerFactory.TYPE.getTypeInfo())) {
                BAbstractCloudLinkHandlerFactory factory = (BAbstractCloudLinkHandlerFactory)factoryInfo.getInstance().as(BAbstractCloudLinkHandlerFactory.class);
                String key = factory.getKey();
                if (!msgFactoryMap.containsKey(key)) {
                    msgFactoryMap.put(key, factory);
                    log.finest("Added handler factory " + (Object)((Object)factory) + " to CloudConnectionService handler factory map with key " + key);
                    continue;
                }
                log.warning(() -> String.format("Attempting to add factory with a key that has already been added, skipping. Existing %s, new %s", ((Object)((Object)msgFactoryMap.get(key))).getClass().getName(), ((Object)((Object)factory)).getClass().getName()));
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot build cloudLink message handler factory map", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    private static void unregisterHandlerFactories() {
        msgFactoryMap.clear();
    }

    private static void registerConfigFactories() {
        try {
            TypeInfo[] factoryInfos;
            for (TypeInfo factoryInfo : factoryInfos = Sys.getRegistry().getConcreteTypes(BAbstractChannelConfigFactory.TYPE.getTypeInfo())) {
                BAbstractChannelConfigFactory factory = (BAbstractChannelConfigFactory)factoryInfo.getInstance().as(BAbstractChannelConfigFactory.class);
                String key = factory.getKey();
                configFactoryMap.put(key, factory);
                log.finest("Added config factory " + (Object)((Object)factory) + " to CloudConnectionService channel config factory map with key " + key);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot build cloudLink channel config factory map", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    private static void unregisterConfigFactories() {
        configFactoryMap.clear();
    }

    private static void registerFileUploadManagers() {
        try {
            TypeInfo[] managerInfos;
            for (TypeInfo managerInfo : managerInfos = Sys.getRegistry().getConcreteTypes(BAbstractFileUploadManager.TYPE.getTypeInfo())) {
                BAbstractFileUploadManager manager = (BAbstractFileUploadManager)managerInfo.getInstance().as(BAbstractFileUploadManager.class);
                String platformType = manager.getPlatformType();
                fileUploadManagerMap.put(platformType, manager);
                log.finest("Added file upload manager " + (Object)((Object)manager) + " to CloudConnectionService file upload manager map with key " + platformType);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot build cloudLink file upload manager map", log.isLoggable(Level.FINE) ? ex : null);
        }
    }

    private static void addEbiTagRulesToTagDictionary(BSmartTagDictionary tagDictionary) {
        BTagRule rule;
        if (tagDictionary.getTagRules().get("EBI$20Proxy$20Point$20Tags") == null) {
            rule = CloudLinkTagUtil.makeProxyPointTagRule("ebiConnector:EbiConnectorProxyExt");
            tagDictionary.getTagRules().add("EBI$20Proxy$20Point$20Tags", (BValue)rule);
            rule.getTagList().add("driverPointId", (BValue)CloudLinkTagUtil.createTag(".", Arrays.asList("tagName", "parameterName")));
        }
        if (tagDictionary.getTagRules().get("EBI$20History$20Import$20Tags") == null) {
            rule = CloudLinkTagUtil.makeTagRule("ebiConnector:EbiConnectorStandardHistoryImport");
            tagDictionary.getTagRules().add("EBI$20History$20Import$20Tags", (BValue)rule);
            rule.getTagList().add("driverPointId", (BValue)CloudLinkTagUtil.createTag(".", Arrays.asList("tagName", "parameterName")));
        }
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Licensing");
        out.prop((Object)"limitsInitialized", ccsLimitsInitialized);
        if (ccsLimits != null) {
            out.startTable(true);
            out.trTitle((Object)"License Limits", 4);
            out.w((Object)"<tr>").th((Object)"Feature").th((Object)"Used").th((Object)"Limit").th((Object)"Unlicensed").w((Object)"</tr>\n");
            for (CcsLicenseLimit ccsLicenseLimit : ccsLimits.values()) {
                String limit = ccsLicenseLimit.limit == Integer.MAX_VALUE ? "none" : String.valueOf(ccsLicenseLimit.limit);
                out.tr((Object)ccsLicenseLimit.key, (Object)new DecimalFormat("#0.#").format(ccsLicenseLimit.used()), (Object)limit, (Object)ccsLicenseLimit.unlicensed.size());
            }
            out.endTable();
        }
        out.endProps();
        super.spy(out);
        out.startProps("BCloudConnectionService");
        out.trTitle((Object)"Message Handler Factories", 2);
        for (Map.Entry<String, BAbstractCloudLinkHandlerFactory> entry : msgFactoryMap.entrySet()) {
            out.prop((Object)entry.getKey(), (Object)entry.getValue());
        }
        out.trTitle((Object)"Channel Config Factories", 2);
        for (Map.Entry entry : configFactoryMap.entrySet()) {
            out.prop(entry.getKey(), entry.getValue());
        }
        out.prop((Object)"fatalFault", this.isFatalFault());
        out.endProps();
    }

    private static class LegacyCloudLinkFeature
    implements Feature {
        private final Feature feature;
        private final Properties myprops;

        LegacyCloudLinkFeature(Feature f) {
            this.feature = f;
            this.myprops = new Properties();
            String[] fprops = f.list();
            Arrays.stream(fprops).forEach(k -> this.myprops.setProperty((String)k, f.get(k)));
            this.myprops.setProperty("platforms", "NCS");
            this.myprops.setProperty("cloudId.limit", "none");
            this.myprops.setProperty("device.limit", "none");
            this.myprops.setProperty("point.limit", "none");
            this.myprops.setProperty("history.limit", "none");
            this.myprops.setProperty("alarm.limit", "none");
            this.myprops.setProperty("schedule.limit", "none");
        }

        public String getVendorName() {
            return this.feature.getVendorName();
        }

        public String getFeatureName() {
            return this.feature.getFeatureName();
        }

        public boolean isExpired() {
            return this.feature.isExpired();
        }

        public void check() throws FeatureNotLicensedException {
            this.feature.check();
        }

        public long getExpiration() {
            return this.feature.getExpiration();
        }

        public String[] list() {
            return this.myprops.keySet().toArray(new String[0]);
        }

        public String get(String key) {
            return this.myprops.getProperty(key);
        }

        public String get(String key, String def) {
            return this.myprops.getProperty(key, def);
        }

        public boolean getb(String key, boolean def) {
            String v = this.myprops.getProperty(key);
            if (v == null) {
                return def;
            }
            if ((v = TextUtil.toLowerCase((String)v)).equals("true")) {
                return true;
            }
            if (v.equals("false")) {
                return false;
            }
            throw new IllegalStateException("Invalid boolean " + v);
        }

        public int geti(String key, int def) {
            String v = this.myprops.getProperty(key);
            if (v == null) {
                return def;
            }
            return Integer.parseInt(v);
        }
    }

    static class CcsLicenseLimit {
        String key;
        int limit;
        Set<String> licensedIds;
        Set<String> unlicensed;

        CcsLicenseLimit() {
        }

        int used() {
            return this.licensedIds.size();
        }

        public String toString() {
            return String.format("%s:%d/%d%s", this.key, this.used(), this.limit, this.unlicensed.isEmpty() ? "" : " [" + this.unlicensed.size() + ']');
        }

        String checkSize(String id) {
            if (this.used() >= this.limit) {
                this.unlicensed.add(id);
                return lex.getText("license.exceeded", new Object[]{this.key, this.limit, id});
            }
            return null;
        }
    }
}

