/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.ProxyChallengeProcessor;
import com.microsoft.azure.proton.transport.proxy.impl.Constants;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyAuthenticator;
import com.microsoft.azure.proton.transport.proxy.impl.StringUtils;
import java.net.PasswordAuthentication;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestProxyChallengeProcessorImpl
implements ProxyChallengeProcessor {
    static final String DEFAULT_ALGORITHM = "MD5";
    private static final String PROXY_AUTH_DIGEST = "Digest";
    private static final char[] HEX_CODE = "0123456789ABCDEF".toCharArray();
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final Logger logger = LoggerFactory.getLogger(DigestProxyChallengeProcessorImpl.class);
    private final AtomicInteger nonceCounter = new AtomicInteger(0);
    private final Map<String, String> headers;
    private final ProxyAuthenticator proxyAuthenticator;
    private final String host;
    private final String challenge;

    DigestProxyChallengeProcessorImpl(String host, String challenge, ProxyAuthenticator authenticator) {
        Objects.requireNonNull(authenticator);
        this.host = host;
        this.challenge = challenge;
        this.headers = new HashMap<String, String>();
        this.proxyAuthenticator = authenticator;
    }

    @Override
    public Map<String, String> getHeader() {
        Scanner responseScanner = new Scanner(this.challenge);
        HashMap<String, String> challengeQuestionValues = new HashMap<String, String>();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Fetching header from:");
        }
        while (responseScanner.hasNextLine()) {
            String line = responseScanner.nextLine();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(line);
            }
            if (!line.contains(PROXY_AUTH_DIGEST)) continue;
            this.getChallengeQuestionHeaders(line, challengeQuestionValues);
            this.computeDigestAuthHeader(challengeQuestionValues, this.host, this.proxyAuthenticator.getPasswordAuthentication(Constants.DIGEST_LOWERCASE, this.host));
            this.logger.info("Finished getting auth header.");
            break;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Headers added are:");
            this.headers.forEach((key, value) -> this.logger.info("{}: {}", key, value));
        }
        return this.headers;
    }

    private void getChallengeQuestionHeaders(String line, Map<String, String> challengeQuestionValues) {
        String context = line.substring(PROXY_AUTH_DIGEST.length());
        String[] headerValues = context.split(",");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Fetching challenge questions.");
        }
        for (String headerValue : headerValues) {
            if (!headerValue.contains("=")) continue;
            String key2 = headerValue.substring(0, headerValue.indexOf("="));
            String value2 = headerValue.substring(headerValue.indexOf("=") + 1);
            challengeQuestionValues.put(key2.trim(), value2.replaceAll("\"", "").trim());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Challenge questions are: ");
            challengeQuestionValues.forEach((key, value) -> this.logger.info("{}: {}", key, value));
        }
    }

    private void computeDigestAuthHeader(Map<String, String> challengeQuestionValues, String uri, PasswordAuthentication passwordAuthentication) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Computing password authentication...");
        }
        if (!ProxyAuthenticator.isPasswordAuthenticationHasValues(passwordAuthentication)) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Password authentication does not have values. Not computing authorization header.");
            }
            return;
        }
        String proxyUserName = passwordAuthentication.getUserName();
        String proxyPassword = new String(passwordAuthentication.getPassword());
        try {
            String digestValue;
            String nonce = challengeQuestionValues.get("nonce");
            String realm = challengeQuestionValues.get("realm");
            String qop = challengeQuestionValues.get("qop");
            MessageDigest md5 = MessageDigest.getInstance(DEFAULT_ALGORITHM);
            String a1 = DigestProxyChallengeProcessorImpl.printHexBinary(md5.digest(String.format("%s:%s:%s", proxyUserName, realm, proxyPassword).getBytes(StandardCharsets.UTF_8)));
            String a2 = DigestProxyChallengeProcessorImpl.printHexBinary(md5.digest(String.format("%s:%s", "CONNECT", uri).getBytes(StandardCharsets.UTF_8)));
            byte[] cnonceBytes = new byte[16];
            SECURE_RANDOM.nextBytes(cnonceBytes);
            String cnonce = DigestProxyChallengeProcessorImpl.printHexBinary(cnonceBytes);
            if (StringUtils.isNullOrEmpty(qop)) {
                String response = DigestProxyChallengeProcessorImpl.printHexBinary(md5.digest(String.format("%s:%s:%s", a1, nonce, a2).getBytes(StandardCharsets.UTF_8)));
                digestValue = String.format("Digest username=\"%s\",realm=\"%s\",nonce=\"%s\",uri=\"%s\",cnonce=\"%s\",response=\"%s\"", proxyUserName, realm, nonce, uri, cnonce, response);
            } else {
                int nc = this.nonceCounter.incrementAndGet();
                String response = DigestProxyChallengeProcessorImpl.printHexBinary(md5.digest(String.format("%s:%s:%08X:%s:%s:%s", a1, nonce, nc, cnonce, qop, a2).getBytes(StandardCharsets.UTF_8)));
                digestValue = String.format("Digest username=\"%s\",realm=\"%s\",nonce=\"%s\",uri=\"%s\",cnonce=\"%s\",nc=%08X,response=\"%s\",qop=\"%s\"", proxyUserName, realm, nonce, uri, cnonce, nc, response, qop);
            }
            this.headers.put("Proxy-Authorization", digestValue);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Adding authorization header. {} '{}'", (Object)"Proxy-Authorization", (Object)digestValue);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Error encountered when computing header.", ex);
            }
            throw new RuntimeException(ex);
        }
    }

    static String printHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(HEX_CODE[b >> 4 & 0xF]);
            r.append(HEX_CODE[b & 0xF]);
        }
        return r.toString().toLowerCase(Locale.ROOT);
    }
}

