/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.UtcOffsetProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.UtcOffset;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;

public abstract class UtcOffsetPropertyScribe<T extends UtcOffsetProperty>
extends ICalPropertyScribe<T> {
    protected UtcOffsetPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.UTC_OFFSET);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        UtcOffset offset = (UtcOffset)((ValuedProperty)property).getValue();
        if (offset != null) {
            return offset.toString(false);
        }
        return "";
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape(value);
        return this.parse(value);
    }

    @Override
    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        String offsetStr = null;
        UtcOffset offset = (UtcOffset)((ValuedProperty)property).getValue();
        if (offset != null) {
            offsetStr = offset.toString(true);
        }
        element.append(this.dataType(property, null), offsetStr);
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDataType dataType = this.defaultDataType(context.getVersion());
        String value = element.first(dataType);
        if (value != null) {
            return this.parse(value);
        }
        throw UtcOffsetPropertyScribe.missingXmlElements(dataType);
    }

    @Override
    protected JCalValue _writeJson(T property, WriteContext context) {
        UtcOffset offset = (UtcOffset)((ValuedProperty)property).getValue();
        if (offset != null) {
            return JCalValue.single(offset.toString(true));
        }
        return JCalValue.single("");
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.parse(value.asSingle());
    }

    protected abstract T newInstance(UtcOffset var1);

    private T parse(String value) {
        if (value == null) {
            return this.newInstance(null);
        }
        try {
            return this.newInstance(UtcOffset.parse(value));
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(28, new Object[0]);
        }
    }
}

