function setElementDisabled(elements, disable)
{
  if ((elements != null) && (elements[0] != null))
  {
    elements[0].disabled = disable;
  }
}

function executeOnload(prefix)
{
  var adapterEnabled           = (document.getElementsByName(prefix + ".adapterEnabled.hidden")[0].value == "true");
  var canDisableAdapter        = (document.getElementsByName(prefix + ".canDisableAdapter.hidden")[0].value == "true");
  var ipv6Supported            = (document.getElementsByName(prefix + ".ipv6Supported.hidden")[0].value == "true");
  var ipv6Enabled              = (document.getElementsByName(prefix + ".ipv6Enabled.hidden")[0].value == "true");
  var canUseDhcp               = (document.getElementsByName(prefix + ".canUseDhcp.hidden")[0].value == "true");
  var canUseIpv6Dhcp           = (document.getElementsByName(prefix + ".canUseIpv6Dhcp.hidden")[0].value == "true");
  var dhcpEnabled              = (document.getElementsByName(prefix + ".dhcpEnabled.hidden")[0].value == "true");
  var ipv6DhcpEnabled          = (document.getElementsByName(prefix + ".ipv6DhcpEnabled.hidden")[0].value == "true");
  var usesAdapterLevelSettings = (document.getElementsByName(prefix + ".usesAdapterLevelSettings.hidden")[0].value == "true");
  var ipv6Readonly             = (document.getElementsByName(prefix + ".ipv6Readonly.hidden")[0].value == "true");
  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value == "true");   
  
  setElementDisabled(document.getElementsByName(prefix + ".ipAddress.value"),               (!adapterEnabled || dhcpEnabled || !operatorCanWrite));
  setElementDisabled(document.getElementsByName(prefix + ".subnetMask.value"),              (!adapterEnabled || dhcpEnabled || !operatorCanWrite));
  setElementDisabled(document.getElementsByName(prefix + ".gateway.value"),                 (!adapterEnabled || dhcpEnabled || !operatorCanWrite));
  setElementDisabled(document.getElementsByName(prefix + ".dnsHosts.value"),                (!adapterEnabled || dhcpEnabled || !operatorCanWrite));
  setElementDisabled(document.getElementsByName(prefix + ".domain.value"),                  (!adapterEnabled || dhcpEnabled || !operatorCanWrite));
  setElementDisabled(document.getElementsByName(prefix + ".dhcpEnabled.value"),             !(adapterEnabled && canUseDhcp  &&  operatorCanWrite));
  
  setElementDisabled(document.getElementsByName(prefix + ".ipv6Enabled.value"),             (!adapterEnabled || ipv6Readonly));
  setElementDisabled(document.getElementsByName(prefix + ".ipv6Address.value"),             (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || !operatorCanWrite || ipv6Readonly));
  setElementDisabled(document.getElementsByName(prefix + ".ipv6SubnetPrefixLength.value"),  (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || !operatorCanWrite || ipv6Readonly));
  setElementDisabled(document.getElementsByName(prefix + ".ipv6Gateway.value"),             (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || !operatorCanWrite || ipv6Readonly));
  setElementDisabled(document.getElementsByName(prefix + ".ipv6DnsHosts.value"),            (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || !operatorCanWrite || ipv6Readonly));
  setElementDisabled(document.getElementsByName(prefix + ".ipv6DhcpEnabled.value"),         !(adapterEnabled && ipv6Enabled  && canUseIpv6Dhcp  && operatorCanWrite) || ipv6Readonly);                      
}

function onDhcpEnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  var disable                  = (element.value == "true");
  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value == "true");  
	
  if (operatorCanWrite)
  {
    document.getElementsByName(prefix + ".dhcpEnabled.hidden")[0].value = element.value;
    setElementDisabled(document.getElementsByName(prefix + ".ipAddress.value"),  disable);
    setElementDisabled(document.getElementsByName(prefix + ".domain.value"),     disable);
    setElementDisabled(document.getElementsByName(prefix + ".subnetMask.value"), disable);
    setElementDisabled(document.getElementsByName(prefix + ".gateway.value"),    disable);
    setElementDisabled(document.getElementsByName(prefix + ".dnsHosts.value"),   disable);
  }
}

function onIpv6DhcpEnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  var disable          = (element.value == "true");
  var operatorCanWrite = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value == "true");  
  var ipv6Readonly     = (document.getElementsByName(prefix + ".ipv6Readonly.hidden")[0].value == "true"); 
	
  if (operatorCanWrite)
  {
    document.getElementsByName(prefix + ".ipv6DhcpEnabled.hidden")[0].value = element.value;

    setElementDisabled(document.getElementsByName(prefix + ".ipv6Address.value"),            disable || ipv6Readonly);
    setElementDisabled(document.getElementsByName(prefix + ".ipv6SubnetPrefixLength.value"), disable || ipv6Readonly);
    setElementDisabled(document.getElementsByName(prefix + ".ipv6Gateway.value"),            disable || ipv6Readonly);
    setElementDisabled(document.getElementsByName(prefix + ".ipv6DnsHosts.value"),           disable || ipv6Readonly);
  }	
}

function onAdapterEnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;
  
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  var adapterEnabled           = (element.value == "true");
  var canUseDhcp               = (document.getElementsByName(prefix + ".canUseDhcp.hidden")[0].value == "true");
  var dhcpEnabled              = (document.getElementsByName(prefix + ".dhcpEnabled.hidden")[0].value == "true");
  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value == "true");  
	
  if (operatorCanWrite) 
  {
    document.getElementsByName(prefix + ".adapterEnabled.hidden")[0].value = element.value;

    setElementDisabled(document.getElementsByName(prefix + ".ipAddress.value"),               (!adapterEnabled || dhcpEnabled));
    setElementDisabled(document.getElementsByName(prefix + ".subnetMask.value"),              (!adapterEnabled || dhcpEnabled));
    setElementDisabled(document.getElementsByName(prefix + ".gateway.value"),                 (!adapterEnabled || dhcpEnabled));
    setElementDisabled(document.getElementsByName(prefix + ".dnsHosts.value"),                (!adapterEnabled || dhcpEnabled));
    setElementDisabled(document.getElementsByName(prefix + ".domain.value"),                  (!adapterEnabled || dhcpEnabled));
    setElementDisabled(document.getElementsByName(prefix + ".dhcpEnabled.value"),             !(adapterEnabled && canUseDhcp));

    //ipv6 support
    var ipv6Enabled     = (document.getElementsByName(prefix + ".ipv6Enabled.hidden")[0].value == "true");
    var canUseIpv6Dhcp  = (document.getElementsByName(prefix + ".canUseIpv6Dhcp.hidden")[0].value == "true");
    var ipv6DhcpEnabled = (document.getElementsByName(prefix + ".ipv6DhcpEnabled.hidden")[0].value == "true");
    var ipv6Readonly    = (document.getElementsByName(prefix + ".ipv6Readonly.hidden")[0].value == "true");

    setElementDisabled(document.getElementsByName(prefix + ".ipv6Enabled.value"),             (!adapterEnabled || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6Address.value"),             (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6SubnetPrefixLength.value"),  (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6Gateway.value"),             (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6DnsHosts.value"),            (!adapterEnabled || !ipv6Enabled || ipv6DhcpEnabled || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6DhcpEnabled.value"),         !(adapterEnabled && canUseIpv6Dhcp && ipv6Enabled) || ipv6Readonly);  
  }
}

function onIpv6EnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;
  
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  var ipv6Enabled     = (element.value == "true");
  var canUseIpv6Dhcp  = (document.getElementsByName(prefix + ".canUseIpv6Dhcp.hidden")[0].value == "true");
  var ipv6DhcpEnabled = (document.getElementsByName(prefix + ".ipv6DhcpEnabled.hidden")[0].value == "true");
  var ipv6Readonly    = (document.getElementsByName(prefix + ".ipv6Readonly.hidden")[0].value == "true");
  
  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value == "true");    
  
  if (operatorCanWrite)
  {
    document.getElementsByName(prefix + ".ipv6Enabled.hidden")[0].value = element.value;

    setElementDisabled(document.getElementsByName(prefix + ".ipv6Address.value"),             (!ipv6Enabled || ipv6DhcpEnabled || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6SubnetPrefixLength.value"),  (!ipv6Enabled || ipv6DhcpEnabled || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6Gateway.value"),             (!ipv6Enabled || ipv6DhcpEnabled || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6DnsHosts.value"),            (!ipv6Enabled || ipv6DhcpEnabled || ipv6Readonly));
    setElementDisabled(document.getElementsByName(prefix + ".ipv6DhcpEnabled.value"),         !(canUseIpv6Dhcp && ipv6Enabled) || ipv6Readonly); 
  }
}

