/*  
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/**
 * BTableView JavaScript support.
 *
 * @author    Andy Frank
 * @creation  12 May 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

////////////////////////////////////////////////////////////////
// TableView
////////////////////////////////////////////////////////////////

var tableView = new TableView();
function TableView()
{
////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////
  
  /**
   * Route to RichView.get().
   */
  this.doRichGet = function(richId, viewId)
  {
    var body = tableView.getSelectedRows(viewId);
    rich.get(richId, body);
  }
  
  /**
   * Get the selected rows in the table.
   */
  this.getSelectedRows = function(id)
  {
    try
    {
      var toolbar = document.getElementById(id);
      var table = toolbar.previousSibling;
      var tbody = table.firstChild;
      var rows = "";
      
      // Skip th's
      for (var i=1; i<tbody.childNodes.length; i++)
      {
        var tr = tbody.childNodes[i];
        var td = tr.firstChild;
        var checkbox = td.firstChild;
        if (checkbox.checked)
        {
          if (rows.length > 0) rows += ",";
          rows += checkbox.value;
        }
      }
      
      return rows;
    }
    catch (err)
    {
      var details = err;
      details += "<p>id=" + id + "</p>";
      hx.doError("tableView.getSelectedRows()", null, err);
      return null;
    }
  }
}


