/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).messages;


import java.io.*;

import javax.baja.sys.*;

import $(package).camera.*;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.videoDriver.enums.*;

/**
 * Sample code
 *
 * @author   $(author)
 * @creation $(date)
*/
public class $(basePrefix)FocusControlReq
  extends NMessage
{

  public $(basePrefix)FocusControlReq(B$(basePrefix)Camera camera, BVideoFocusEnum focusEnum)
  {
    this.camera = camera;
    this.focusEnum = focusEnum;
  }
  
  public boolean toOutputStream(OutputStream out) 
  {
    PrintWriter buf = new PrintWriter(out);
    buf.write("*2"); // *2 = Telemetry control
    
    // Gets the device id that uniquely identifies the camera component within the
    // $(basePrefix)  protocol
    B$(basePrefix)CameraDeviceId cameraDeviceId = (B$(basePrefix)CameraDeviceId)camera.getVideoDeviceId();
    
    // Gets the numeric id of the camera
    int cameraId = cameraDeviceId.getCameraId();
    
    // If the numeric id of the camera is out of range [0-99]
    if (cameraId >= 100 || cameraId < 0)
    {
      throw new BajaRuntimeException(camera.getSlotPath().toDisplayString()+":Camera Id must be between 0 and 99.");
    }

    if (cameraId < 10) // If camera id is a single digit then this
      buf.write('0'); // Pads the camera id with a leading zero

    // Adds the numeric id to uniquely identify the camera to the byte array buffer
    buf.write( Integer.toString(cameraId) );

    // Gets the numeric value of the focusEnum
    int focusEnumOrdinal = focusEnum.getOrdinal();

    // Adds the $(basePrefix)  protocol string for the particular focusEnum ordinal.
    buf.write( getFocusCtrlCmd(focusEnumOrdinal) );

    buf.flush();
    return false;
  }
  
  public String getFocusCtrlCmd(int focusEnum)
  {
    if (focusEnum >= 0 && focusEnum <=1)
    { // Ordinal 1 = Focus Reset; Ordinal 0 = Focus None/Stop
      return "D";
    }
    else if (focusEnum >=2 && focusEnum <=4)
    { // Ordinals 2, 3, and 4 == Focus In
      return "7";
    }
    else if (focusEnum >=5 && focusEnum <=7)
    { // Ordinals 5, 6, and 7 == Focus Out
      return "9";
    }
    else // focusOrdinal must be > 7 or < 0
    {
      // The numeric value of the focusEnum is not something that existed at the
      // time when this method was developed
      throw new BajaRuntimeException("Unsupported BVideoFocusEnum ordinal - "+focusEnum);
    }
  }

  B$(basePrefix)Camera camera;
  BVideoFocusEnum focusEnum;
}
