/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).datatypes;


import java.net.InetAddress;

import javax.baja.sys.*;

import com.tridium.ndriver.datatypes.*;
import com.tridium.ndriver.util.*;

/**
 * B$(basePrefix)IpAddress contains ip address and port number.
 *
 * @author   $(author)
 * @creation $(date)
 */
public class B$(basePrefix)IpAddress
  extends BAddress
{
  private static BFacets sf = BFacets.makeInt(null, 0, 65536); 
  /*-
   class B$(basePrefix)IpAddress
   {
     properties
     {
      ipAddress: String
        -- The IP address of this device.
        default {[ "" ]}
        slotfacets {[ SfUtil.incl(SfUtil.MGR_EDIT,sf) ]}
      $(if.network.hasUdpCommConfig)  
      udpPort: int
        default {[ 1025 ]}
        slotfacets {[ SfUtil.incl(SfUtil.MGR_EDIT,sf) ]}
     $(end.network.hasUdpCommConfig)
     $(if.network.hasHttpCommConfig)
      httpPort: int
        default {[ 80 ]}
        slotfacets {[ SfUtil.incl(SfUtil.MGR_EDIT,sf) ]}
     $(end.network.hasHttpCommConfig)
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress(484344384)1.0$ @*/
/* Generated Fri Jun 29 14:28:59 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "ipAddress"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ipAddress</code> property.
   * The IP address of this device.
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#getIpAddress
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#setIpAddress
   */
  public static final Property ipAddress = newProperty(0, "",SfUtil.incl(SfUtil.MGR_EDIT,sf));
  
  /**
   * Get the <code>ipAddress</code> property.
   * The IP address of this device.
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#ipAddress
   */
  public String getIpAddress() { return getString(ipAddress); }
  
  /**
   * Set the <code>ipAddress</code> property.
   * The IP address of this device.
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#ipAddress
   */
  public void setIpAddress(String v) { setString(ipAddress,v,null); }

////////////////////////////////////////////////////////////////
// Property "udpPort"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>udpPort</code> property.
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#getUdpPort
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#setUdpPort
   */
  public static final Property udpPort = newProperty(0, 1025,SfUtil.incl(SfUtil.MGR_EDIT,sf));
  
  /**
   * Get the <code>udpPort</code> property.
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#udpPort
   */
  public int getUdpPort() { return getInt(udpPort); }
  
  /**
   * Set the <code>udpPort</code> property.
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#udpPort
   */
  public void setUdpPort(int v) { setInt(udpPort,v,null); }

////////////////////////////////////////////////////////////////
// Property "httpPort"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>httpPort</code> property.
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#getHttpPort
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#setHttpPort
   */
  public static final Property httpPort = newProperty(0, 80,SfUtil.incl(SfUtil.MGR_EDIT,sf));
  
  /**
   * Get the <code>httpPort</code> property.
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#httpPort
   */
  public int getHttpPort() { return getInt(httpPort); }
  
  /**
   * Set the <code>httpPort</code> property.
   * @see com.xvendor.$(basePrefix).datatypes.B$(basePrefix)IpAddress#httpPort
   */
  public void setHttpPort(int v) { setInt(httpPort,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(B$(basePrefix)IpAddress.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  /** Empty constructor  */
  public B$(basePrefix)IpAddress() {}
  
  /** constructor  
  public B$(basePrefix)IpAddress(InetAddress iadr, int port) 
  { 
    setIpAddress(iadr.getHostAddress()); 
    setPort(port);
  }
  */
  /** constructor  
  public B$(basePrefix)IpAddress(String ipAddress, int port) 
  { 
    setIpAddress(ipAddress); 
    setPort(port);
  }
  */
  $(if.network.hasHttpCommConfig)
  public BIpAddress httpAddress()
  {
    return new BIpAddress(getIpAddress(),getHttpPort());
  }
  $(end.network.hasHttpCommConfig)
  $(if.network.hasUdpCommConfig)  
  public BIpAddress udpAddress()
  {
    return new BIpAddress(getIpAddress(),getUdpPort());
  }
  $(end.network.hasUdpCommConfig)

  public InetAddress getInetAddress()
  { 
    try
    {
      return InetAddress.getByName(getIpAddress()); 
    }
    catch(Exception e)
    {
      return null;
    }    
  }
  
  public Object getAddress()
  {
    return getInetAddress();
  }
  

}
