/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).event;

import javax.baja.sys.*;

import com.tridium.driver.util.DrUtil;

import com.tridium.videoDriver.enums.*;
import com.tridium.videoDriver.event.BVideoEvent;

import com.tridium.ndriver.util.*;

import com.tridium.nvideo.event.*;

import $(package).camera.*;
import $(package).util.*;
$(if.network.hasDvrSupport)
import $(package).dvr.*;
$(end.network.hasDvrSupport)
import $(package).enums.*;

/**
 * Sample code.
 * 
 *  @author   $(author)
 * @creation $(date)
 */
public class B$(basePrefix)EventProxyExt
    extends BVideoEventProxyExt
{
  /*-
   class B$(basePrefix)EventProxyExt
   {
     properties
     {
       $(basePrefix)EventTypeEnum : B$(basePrefix)EventTypesEnum
         flags{ readonly }
         default {[ B$(basePrefix)EventTypesEnum.motionDetected ]}
         slotfacets{[ SfUtil.incl() ]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.xvendor.$(basePrefix).event.B$(basePrefix)EventProxyExt(847662304)1.0$ @*/
/* Generated Fri Jun 29 13:35:27 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "$(basePrefix)EventTypeEnum"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>$(basePrefix)EventTypeEnum</code> property.
   * @see com.xvendor.$(basePrefix).event.B$(basePrefix)EventProxyExt#get$(basePrefix)EventTypeEnum
   * @see com.xvendor.$(basePrefix).event.B$(basePrefix)EventProxyExt#set$(basePrefix)EventTypeEnum
   */
  public static final Property $(basePrefix)EventTypeEnum = newProperty(Flags.READONLY, B$(basePrefix)EventTypesEnum.motionDetected,SfUtil.incl());
  
  /**
   * Get the <code>$(basePrefix)EventTypeEnum</code> property.
   * @see com.xvendor.$(basePrefix).event.B$(basePrefix)EventProxyExt#$(basePrefix)EventTypeEnum
   */
  public B$(basePrefix)EventTypesEnum get$(basePrefix)EventTypeEnum() { return (B$(basePrefix)EventTypesEnum)get($(basePrefix)EventTypeEnum); }
  
  /**
   * Set the <code>$(basePrefix)EventTypeEnum</code> property.
   * @see com.xvendor.$(basePrefix).event.B$(basePrefix)EventProxyExt#$(basePrefix)EventTypeEnum
   */
  public void set$(basePrefix)EventTypeEnum(B$(basePrefix)EventTypesEnum v) { set($(basePrefix)EventTypeEnum,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(B$(basePrefix)EventProxyExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  public Type getDeviceExtType()
  {
    return B$(basePrefix)EventCameraExt.TYPE;
  }
  
  /**
   * Note: Driver developers need to override this.
   * 
   * @return the BVideoEventTypesEnum that identifies type of 
   * event for this proxy.
   */
  public BVideoEventTypesEnum getEventTypeEnum()
  {
    if (get$(basePrefix)EventTypeEnum() == B$(basePrefix)EventTypesEnum.motionDetected)
      return BVideoEventTypesEnum.motionStarted;
    else if (get$(basePrefix)EventTypeEnum() == B$(basePrefix)EventTypesEnum.cameraFail)
      return BVideoEventTypesEnum.fault;
    else
      return BVideoEventTypesEnum.nullEvent;
  }   

  public void videoProxyExtStarted()
  {
    super.videoProxyExtStarted();
    $(if.network.hasDvrSupport)
    // Register with dvr so point will be updated on poll
    B$(basePrefix)Dvr dvr = (B$(basePrefix)Dvr)DrUtil.getParent(this, B$(basePrefix)Dvr.TYPE);
    dvr.registerEventProxy(this,get$(basePrefix)EventTypeEnum());
    $(end.network.hasDvrSupport)
  }
  
  public void stopped()
    throws Exception
  {
    super.stopped();
    $(if.network.hasDvrSupport)
    // Register with dvr so point will be updated on poll
    B$(basePrefix)Dvr dvr = (B$(basePrefix)Dvr)DrUtil.getParent(this, B$(basePrefix)Dvr.TYPE);
    dvr.unregisterEventProxy(this,get$(basePrefix)EventTypeEnum());
    $(end.network.hasDvrSupport)
  }

  protected void implEnableDetection(boolean on) throws Exception
  {
    if(getEventTypeEnum() != BVideoEventTypesEnum.motionStarted)
      throw new BajaRuntimeException("Can only control event detection for 'motionStarted' events, not " +
                                       getEventTypeEnum() + ". Please have my program fixed.");
     
    /*
     * Uncomment the lines below for an example of enabling detection using the
     * HTTP comm
     */
    
    //B$(basePrefix)Camera cam = (B$(basePrefix)Camera)getVideoCamera();
    //$(basePrefix)HttpUtil.enableDetection(cam.hcomm(), cam.httpAddress(), getCameraId(), on);
  }

  public void readSubscribed(Context cx) throws Exception
  {
  }

  public void readUnsubscribed(Context cx) throws Exception
  {
  }

  public boolean write(Context cx) throws Exception
  {
    throw new BajaRuntimeException("B$(basePrefix)EventProxyExt " + getDisplayName(cx) + " is not writeable");
  }

  public int getCameraId() throws Exception
  {
    B$(basePrefix)Camera cam = (B$(basePrefix)Camera)getVideoCamera();
    return ((B$(basePrefix)CameraDeviceId)cam.getVideoDeviceId()).getCameraId() ;
  }
  
  // MotionDetected update received by dvr for this event proxy
  public void updateMotion(boolean motionDetected, BAbsTime cameraTime)
  {
    BVideoEvent videoEvent;
    BDynamicEnum e = BDynamicEnum.make(B$(basePrefix)EventTypesEnum.motionDetected);
    
    if (motionDetected)
    {
      videoEvent = BVideoEvent.makeMotionStarted();
      
      videoEvent.setTimestamp( cameraTime );
      videoEvent.setDescription( "VMD "+ getVideoCamera().getCameraDescription() );
    }
    else
    {
      videoEvent = BVideoEvent.makeMotionStopped();
      
      videoEvent.setMetaData(BFacets.make("$(basePrefix)EventType",e));
      videoEvent.setTimestamp( cameraTime );
    }
    BVideoEventStatus eventStaus =  new BVideoEventStatus( videoEvent );
    readOk(eventStaus);    
  }
  
  
  public void updateCameraFail(boolean cameraFail, BAbsTime cameraTime)
  {
    BVideoEvent videoEvent;
    if (cameraFail)
    {
      videoEvent = BVideoEvent.makeOffNormalEvent();
      videoEvent.setEventType( BVideoEventTypesEnum.fault );
      
      BDynamicEnum e = BDynamicEnum.make(B$(basePrefix)EventTypesEnum.cameraFail);
      videoEvent.setMetaData(BFacets.make("$(basePrefix)EventType",e));
      videoEvent.setDescription( B$(basePrefix)EventTypesEnum.cameraFail.getDisplayTag(null) );
      videoEvent.setTimestamp( cameraTime );
    }
    else
    {
      videoEvent = BVideoEvent.makeNormalEvent();
      videoEvent.setEventType( BVideoEventTypesEnum.fault );
      
      BDynamicEnum e = BDynamicEnum.make(B$(basePrefix)EventTypesEnum.cameraRestored);
      videoEvent.setMetaData(BFacets.make("$(basePrefix)EventType",e));
      videoEvent.setDescription( B$(basePrefix)EventTypesEnum.cameraRestored.getDisplayTag(null) );
      videoEvent.setTimestamp( cameraTime );
    }
    BVideoEventStatus eventStaus =  new BVideoEventStatus( videoEvent );
    readOk(eventStaus);    
  }
  
  
  
}
