/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).dvr;

import javax.baja.driver.util.*;
import javax.baja.sys.*;
import javax.baja.util.*;

import com.tridium.ndriver.comm.*;
import com.tridium.ndriver.comm.http.*;
import com.tridium.ndriver.datatypes.*;
import com.tridium.ndriver.poll.*;
import com.tridium.ndriver.util.*;
import com.tridium.nvideo.camera.*;
import com.tridium.nvideo.display.*;
import com.tridium.nvideo.dvr.*;
import com.tridium.videoDriver.videoStream.*;
import com.tridium.videoDriver.videoStream.decoder.*;

import $(package).*;
import $(package).camera.*;
import $(package).datatypes.*;
$(if.dvr.hasDisplaySupport)
import $(package).display.*;
$(end.dvr.hasDisplaySupport)
import $(package).enums.*;
import $(package).event.*;

/**
 * $(dvr.class) models a Digital Video Recorder (DVR)
 * 
 * @author   $(author)
 * @creation $(date)
 *
 */

public class B$(basePrefix)Dvr extends BVideoDvr implements BINPollable 
{
   public static final Property address = newProperty(0, new B$(basePrefix)IpAddress(),SfUtil.incl(SfUtil.MGR_EDIT));
   public static final Property videoDeviceId = newProperty(0, new B$(basePrefix)DvrId(),SfUtil.incl(SfUtil.MGR_EDIT));
  
  /*-
   class B$(basePrefix)Dvr
   {
     properties
     {
       -- TODO optional polling support
       pollFrequency : BPollFrequency
        default {[ BPollFrequency.slow ]}
         
       -- TODO optional multistream support  
       multistreamPreferences : BVideoSourcePreferences
         -- These are the default preferences that apply whenever the Niagara AX video
         -- framework requests a video stream from the Dvr where the video stream contains
         -- video frames for more than one video camera.
         default{[ new B$(basePrefix)MultistreamPreferences() ]}
     
       cameras : BCameraDeviceExt
         -- This extension is used to manage video camera.
         default {[new B$(basePrefix)CameraDeviceExt()]}
      
       $(if.dvr.hasDisplaySupport)  
       displays : BDisplayDeviceExt
          -- This extension is used to manage video displays.
         default {[new BDisplayDeviceExt()]}
       $(end.dvr.hasDisplaySupport)  
       
       -- TODO optional include as example
       credentials : BNUsernameAndPassword
         default {[ new BNUsernameAndPassword() ]}
         slotfacets {[ SfUtil.incl(SfUtil.MGR_EDIT) ]}
       
     }
     actions
     {
       -- TODO optional event support 
       activateUnsolicitedEvents()
         flags{hidden}
     }
   }
   -*/

////////////////////////////////////////////////////////////////
// Property "pollFrequency"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pollFrequency</code> property.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#getPollFrequency
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#setPollFrequency
   */
  public static final Property pollFrequency = newProperty(0, BPollFrequency.slow,null);
  
  /**
   * Get the <code>pollFrequency</code> property.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#pollFrequency
   */
  public BPollFrequency getPollFrequency() { return (BPollFrequency)get(pollFrequency); }
  
  /**
   * Set the <code>pollFrequency</code> property.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#pollFrequency
   */
  public void setPollFrequency(BPollFrequency v) { set(pollFrequency,v,null); }

////////////////////////////////////////////////////////////////
// Property "multistreamPreferences"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>multistreamPreferences</code> property.
   * These are the default preferences that apply whenever
   * the Niagara AX video framework requests a video stream
   * from the Dvr where the video stream contains video
   * frames for more than one video camera.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#getMultistreamPreferences
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#setMultistreamPreferences
   */
  public static final Property multistreamPreferences = newProperty(0, new B$(basePrefix)MultistreamPreferences(),null);
  
  /**
   * Get the <code>multistreamPreferences</code> property.
   * These are the default preferences that apply whenever
   * the Niagara AX video framework requests a video stream
   * from the Dvr where the video stream contains video
   * frames for more than one video camera.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#multistreamPreferences
   */
  public BVideoSourcePreferences getMultistreamPreferences() { return (BVideoSourcePreferences)get(multistreamPreferences); }
  
  /**
   * Set the <code>multistreamPreferences</code> property.
   * These are the default preferences that apply whenever
   * the Niagara AX video framework requests a video stream
   * from the Dvr where the video stream contains video
   * frames for more than one video camera.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#multistreamPreferences
   */
  public void setMultistreamPreferences(BVideoSourcePreferences v) { set(multistreamPreferences,v,null); }

////////////////////////////////////////////////////////////////
// Property "cameras"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>cameras</code> property.
   * This extension is used to manage video camera.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#getCameras
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#setCameras
   */
  public static final Property cameras = newProperty(0, new B$(basePrefix)CameraDeviceExt(),null);
  
  /**
   * Get the <code>cameras</code> property.
   * This extension is used to manage video camera.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#cameras
   */
  public BCameraDeviceExt getCameras() { return (BCameraDeviceExt)get(cameras); }
  
  /**
   * Set the <code>cameras</code> property.
   * This extension is used to manage video camera.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#cameras
   */
  public void setCameras(BCameraDeviceExt v) { set(cameras,v,null); }

 $(if.dvr.hasDisplaySupport)    
////////////////////////////////////////////////////////////////
// Property "displays"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>displays</code> property.
   * This extension is used to manage video displays.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#getDisplays
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#setDisplays
   */
  public static final Property displays = newProperty(0, new BDisplayDeviceExt(),null);
  
  /**
   * Get the <code>displays</code> property.
   * This extension is used to manage video displays.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#displays
   */
  public BDisplayDeviceExt getDisplays() { return (BDisplayDeviceExt)get(displays); }
  
  /**
   * Set the <code>displays</code> property.
   * This extension is used to manage video displays.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#displays
   */
  public void setDisplays(BDisplayDeviceExt v) { set(displays,v,null); }
$(end.dvr.hasDisplaySupport)

////////////////////////////////////////////////////////////////
// Property "credentials"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>credentials</code> property.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#getCredentials
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#setCredentials
   */
  public static final Property credentials = newProperty(0, new BNUsernameAndPassword(),SfUtil.incl(SfUtil.MGR_EDIT));
  
  /**
   * Get the <code>credentials</code> property.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#credentials
   */
  public BNUsernameAndPassword getCredentials() { return (BNUsernameAndPassword)get(credentials); }
  
  /**
   * Set the <code>credentials</code> property.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#credentials
   */
  public void setCredentials(BNUsernameAndPassword v) { set(credentials,v,null); }

////////////////////////////////////////////////////////////////
// Action "activateUnsolicitedEvents"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>activateUnsolicitedEvents</code> action.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#activateUnsolicitedEvents()
   */
  public static final Action activateUnsolicitedEvents = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>activateUnsolicitedEvents</code> action.
   * @see com.xvendor.nfoo.dvr.B$(basePrefix)Dvr#activateUnsolicitedEvents
   */
  public void activateUnsolicitedEvents() { invoke(activateUnsolicitedEvents,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(B$(basePrefix)Dvr.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public void descendantsStarted() throws Exception
  {
    // TODO optional polling support
    ((B$(basePrefix)Network)getNetwork()).getPoll().subscribe(this);
    
    // TODO Add start up code      
   
    super.started();
  }

  public void stopped() throws Exception
  {
    // TODO optional polling support
    ((B$(basePrefix)Network)getNetwork()).getPoll().unsubscribe(this);
    
    super.stopped();
  }  
  
  public void changed(Property property, Context context)
  {
    // TODO add code as need when any property changes
      
    // Calls super.changed to allow the ancestor to possibly process the change.
    super.changed(property, context);
  }
  
////////////////////////////////////////////////////////////////
// BVideoDevice
////////////////////////////////////////////////////////////////
  public void doPing() 
  {
    try
    {
      /* TODO Insert code which sends some basic request response message to verify dvr communicating */
      pingOk();
    }
    catch(Exception e)
    {
      pingFail(e.getLocalizedMessage());
    }
  }
  
////////////////////////////////////////////////////////////////
// BVideoDvr
////////////////////////////////////////////////////////////////
  
  public Type getVideoCameraType()
  {
    return B$(basePrefix)Camera.TYPE;
  }
  
  $(if.dvr.hasDisplaySupport) 
  public Type getVideoDisplayType()
  {
    return B$(basePrefix)Display.TYPE;
  }
  $(end.dvr.hasDisplaySupport)

  public Type getNetworkType()
  {
    return B$(basePrefix)Network.TYPE;
  }
  
////////////////////////////////////////////////////////////////
// Utilities
////////////////////////////////////////////////////////////////
  $(if.network.hasHttpCommConfig)
  public BIpAddress httpAddress()
  {
    return ((B$(basePrefix)IpAddress)getAddress()).httpAddress();
  }
  $(end.network.hasHttpCommConfig)
  $(if.network.hasUdpCommConfig)
  public BIpAddress udpAddress()
  {
    return ((B$(basePrefix)IpAddress)getAddress()).udpAddress();
  }
  $(end.network.hasUdpCommConfig)
  $(if.network.hasHttpCommConfig)
  public HttpComm hcomm()
    throws Exception
  {
    return ((B$(basePrefix)Network)getNetwork()).hcomm();
  }
  $(end.network.hasHttpCommConfig)
  
  $(if.network.hasTcpCommConfig)
  /**Access the tcp comm stack */
  public NComm tcomm()
  {
    return ((B$(basePrefix)Network)getNetwork()).tcomm();
  }
  $(end.network.hasTcpCommConfig)
  
   $(if.network.hasUdpCommConfig)
  /** Access the udp comm stack */
  public NComm ucomm() 
  {
    return ((B$(basePrefix)Network)getNetwork()).ucomm();
  }
  $(end.network.hasUdpCommConfig)
  
  $(if.network.hasSerialCommConfig)
   /**Access the serial comm stack */
  public NComm scomm()
  {
    return ((B$(basePrefix)Network)getNetwork()).scomm();
  }
  $(end.network.hasSerialCommConfig)  
  
  
////////////////////////////////////////////////////////////////
// Video stream
////////////////////////////////////////////////////////////////
  public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination)
  {
    // TODO add code establish a video stream
    //VideoStreamUtil.streamToDestination(this, playbackParams, videoDestination);
  }

////////////////////////////////////////////////////////////////
// BINPollable Implementation
////////////////////////////////////////////////////////////////
  // TODO optional polling support
  public void doPoll()
  {
    boolean success = false;
    Exception err = null;
    // TODO add code to poll thread
    
    // If there was successful comm call pingOk to short-circuit
    // current ping cycle
    if(success)
      pingOk();
    else
      pingFail(err!=null ? err.getMessage() : "");
  }

  
////////////////////////////////////////////////////////////////
// Event support 
////////////////////////////////////////////////////////////////
  // TODO optional example event support - 
  public void registerEventProxy(B$(basePrefix)EventProxyExt ext, B$(basePrefix)EventTypesEnum e)
  {
    if(e == B$(basePrefix)EventTypesEnum.motionDetected ) motion.add(ext);
    if(e == B$(basePrefix)EventTypesEnum.cameraFail ) camFail.add(ext);
  }
  public void unregisterEventProxy(B$(basePrefix)EventProxyExt ext, B$(basePrefix)EventTypesEnum e)
  {
    if(e == B$(basePrefix)EventTypesEnum.motionDetected ) motion.remove(ext);
    if(e == B$(basePrefix)EventTypesEnum.cameraFail ) camFail.remove(ext);
  }
  

  Array motion = new Array(B$(basePrefix)EventProxyExt.class);
  Array camFail = new Array(B$(basePrefix)EventProxyExt.class);

  /**
   * Implements the 'activateUnsolicitedEvents' action in the server-side JVM.
   */
  public void doActivateUnsolicitedEvents()
  {
    try
    {
      // TODO add code to activate event notification in dvr
    }
    catch(Exception e)
    {
      ((B$(basePrefix)Network)getNetwork()).log().error(e.getMessage());
    }
  } 
  
////////////////////////////////////////////////////////////////
// BIVideoDvr
////////////////////////////////////////////////////////////////

  public void initPlaybackParams(BPlaybackParams playbackParams, IVideoSession videoSession)
  {
    // TODO make custom modifications to playbackParams to support creating video stream
  }

  public IVideoDecoder makeVideoDecoder(BPlaybackParams playbackParams)
  {
    // TODO
    return null;
  }
  
  public boolean supportsMultistream()
  {
    // TODO 
    return true;
  }
  
}
