/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).camera;

import javax.baja.sys.*;
import javax.baja.nre.util.Array;

import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.discover.*;
import com.tridium.ndriver.datatypes.*;
import com.tridium.nvideo.camera.BCameraDeviceExt;

import $(package).*;
import $(package).util.*;
$(if.network.hasDvrSupport)
import $(package).dvr.*;
$(end.network.hasDvrSupport)


/**
 * Example custom BCameraDeviceExt
 *
 * @author   $(author)
 * @creation $(date)
 * 
 */
public class B$(basePrefix)CameraDeviceExt
    extends BCameraDeviceExt
{
  public static final Property discoveryPreferences = newProperty(0, new B$(basePrefix)CameraDiscoveryPreferences(),null);
  /*-
    class B$(basePrefix)CameraDeviceExt
    {
      properties
      {
      }
    }
   -*/

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(B$(basePrefix)CameraDeviceExt.class);

  /** Call back for discoveryJob to get an array of discovery objects.
   *  Override point for driver specific discover. */
  public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) 
  throws Exception
  {
    // Creates a dynamic array of B$(basePrefix)CameraDiscoveryLeaf objects
    Array discoveredCameras = new Array( B$(basePrefix)CameraDiscoveryLeaf.class );

    $(if.network.hasDvrSupport)
    //
    // TODO the following is example code - replace with code to discover available cameras 
    //

    B$(basePrefix)Dvr dvr = (B$(basePrefix)Dvr)getParent();
    B$(basePrefix)Network net = (B$(basePrefix)Network)DrUtil.getParent(this, B$(basePrefix)Network.TYPE);

    try
    {
      $(if.network.hasHttpCommConfig)
        //sample implemntation using the HTTP comm
        HttpComm hcom = net.hcomm();
        BIpAddress addr = dvr.httpAddress();
  
        String[]  cameraTitles = $(basePrefix)HttpUtil.getCameraTitles(hcom, addr);
    
        // Loops through the reported camera titles
        for (int i=0; i<cameraTitles.length; i++)
        {
          // Creates a discovery leaf for the camera that we know is 'plugged' in
          B$(basePrefix)CameraDiscoveryLeaf newLeaf = new B$(basePrefix)CameraDiscoveryLeaf();
  
          // Sets the camera id number in the B$(basePrefix)CameraDeviceId object
          newLeaf.getId().setCameraId(i+1);
  
          // Sets the camera description in the B$(basePrefix)CameraDeviceId object
          newLeaf.getId().setDescription(cameraTitles[i]);
  
          discoveredCameras.add( newLeaf );
      }
      $(end.network.hasHttpCommConfig)
      
    }
    catch(Exception e)
    {
      throw new BajaRuntimeException("Unable to discover camers in " + dvr.getDisplayName(null), e);
    }
    $(end.network.hasDvrSupport)
    
    // Returns the array of B$(basePrefix)CameraDeviceId objects to appear in the 'Discovered' list
    return (B$(basePrefix)CameraDiscoveryLeaf[])discoveredCameras.trim();
    
  }

}
