/**
 * Copyright $(year) $(vendor), Inc. All Rights Reserved.
 */
package $(package);

//import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.sys.*;
import javax.baja.util.Lexicon;

import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.*;
$(if.network.hasHttpCommConfig)
import com.tridium.ndriver.comm.http.*;
$(end.network.hasHttpCommConfig)
import com.tridium.ndriver.datatypes.*;
import com.tridium.ndriver.discover.*;
import com.tridium.ndriver.poll.*;
$(if.processUnsolicited)
import $(package).comm.$(basePrefix)Listener;
$(end.processUnsolicited)
$(if.network.hasSerialCommConfig)
import $(package).comm.B$(basePrefix)SerialCommConfig;
$(end.network.hasSerialCommConfig)
$(if.network.hasTcpCommConfig)
import $(package).comm.B$(basePrefix)TcpCommConfig;
$(end.network.hasTcpCommConfig)
$(if.autoDeviceLearn)
import $(package).learn.B$(basePrefix)DeviceDiscoveryPreferences;
$(end.autoDeviceLearn)



/**
 *  $(network.class) models a network of devices
 *
 *  @author   $(author)
 *  @creation $(date) 
 */
public class $(network.class) 
  extends BNNetwork
$(if.autoDeviceLearn)
  implements BINDiscoveryHost
$(end.autoDeviceLearn)
{
  
  /*-
    class $(network.class)
    {
      properties
      {
        pollScheduler :  BNPollScheduler
          default {[ new BNPollScheduler() ]}
$(if.network.hasHttpCommConfig)
        httpConfig : BHttpCommConfig
          default {[ new BHttpCommConfig() ]}
$(end.network.hasHttpCommConfig)
$(if.network.hasTcpCommConfig)
        tcpConfig : B$(basePrefix)TcpCommConfig
          default {[ new B$(basePrefix)TcpCommConfig() ]}
$(end.network.hasTcpCommConfig)
$(if.network.hasUdpCommConfig)
        udpConfig : BUdpCommConfig
          default {[ new BUdpCommConfig() ]}
$(end.network.hasUdpCommConfig)
$(if.network.hasSerialCommConfig)
        serialConfig : B$(basePrefix)SerialCommConfig
          default {[ new B$(basePrefix)SerialCommConfig() ]}
$(end.network.hasSerialCommConfig)
$(if.autoDeviceLearn)
        discoveryPreferences : BNDiscoveryPreferences
          flags{hidden}
          default{[ new B$(basePrefix)DeviceDiscoveryPreferences()]}
$(end.autoDeviceLearn)
      }
$(if.autoDeviceLearn)
      actions
      {
        submitDiscoveryJob( preferences : BNDiscoveryPreferences ) : BOrd
          flags{ hidden }
          default{[ new B$(basePrefix)DeviceDiscoveryPreferences()]}
      }
$(end.autoDeviceLearn)
    }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
  
////////////////////////////////////////////////////////////////
//Property "pollScheduler"
////////////////////////////////////////////////////////////////
    
    /**
     * Slot for the <code>pollScheduler</code> property.
     * @see $(package).$(network.class)#getPollScheduler
     * @see $(package).$(network.class)#setPollScheduler
     */
    public static final Property pollScheduler = newProperty(0, new BNPollScheduler(),null);
    
    /**
     * Get the <code>pollScheduler</code> property.
     * @see $(package).$(network.class)#pollScheduler
     */
    public BNPollScheduler getPollScheduler() { return (BNPollScheduler)get(pollScheduler); }
    
    /**
     * Set the <code>pollScheduler</code> property.
     * @see $(package).$(network.class)#pollScheduler
     */
    public void setPollScheduler(BNPollScheduler v) { set(pollScheduler,v,null); }

$(if.network.hasHttpCommConfig)  
  ////////////////////////////////////////////////////////////////
  // Property "httpConfig"
  ////////////////////////////////////////////////////////////////
    
    /**
     * Slot for the <code>httpConfig</code> property.
     * @see $(package).$(network.class)#getHttpConfig
     * @see $(package).$(network.class)#setHttpConfig
     */
    public static final Property httpConfig = newProperty(0, new BHttpCommConfig(),null);
    
    /**
     * Get the <code>httpConfig</code> property.
     * @see $(package).$(network.class)#httpConfig
     */
    public BHttpCommConfig getHttpConfig() { return (BHttpCommConfig)get(httpConfig); }
    
    /**
     * Set the <code>httpConfig</code> property.
     * @see $(package).$(network.class)#httpConfig
     */
    public void setHttpConfig(BHttpCommConfig v) { set(httpConfig,v,null); }
  
$(end.network.hasHttpCommConfig)  
$(if.network.hasTcpCommConfig)
  ////////////////////////////////////////////////////////////////
  // Property "tcpConfig"
  ////////////////////////////////////////////////////////////////
    
    /**
     * Slot for the <code>tcpConfig</code> property.
     * @see $(package).$(network.class)#getTcpConfig
     * @see $(package).$(network.class)#setTcpConfig
     */
    public static final Property tcpConfig = newProperty(0, new BTcpCommConfig(),null);
    
    /**
     * Get the <code>tcpConfig</code> property.
     * @see $(package).$(network.class)#tcpConfig
     */
    public BTcpCommConfig getTcpConfig() { return (BTcpCommConfig)get(tcpConfig); }
    
    /**
     * Set the <code>tcpConfig</code> property.
     * @see $(package).$(network.class)#tcpConfig
     */
    public void setTcpConfig(BTcpCommConfig v) { set(tcpConfig,v,null); }

$(end.network.hasTcpCommConfig)
$(if.network.hasUdpCommConfig)
  ////////////////////////////////////////////////////////////////
  // Property "udpConfig"
  ////////////////////////////////////////////////////////////////
    
    /**
     * Slot for the <code>udpConfig</code> property.
     * @see $(package).$(network.class)#getUdpConfig
     * @see $(package).$(network.class)#setUdpConfig
     */
    public static final Property udpConfig = newProperty(0, new BUdpCommConfig(),null);
    
    /**
     * Get the <code>udpConfig</code> property.
     * @see $(package).$(network.class)#udpConfig
     */
    public BUdpCommConfig getUdpConfig() { return (BUdpCommConfig)get(udpConfig); }
    
    /**
     * Set the <code>udpConfig</code> property.
     * @see $(package).$(network.class)#udpConfig
     */
    public void setUdpConfig(BUdpCommConfig v) { set(udpConfig,v,null); }

$(end.network.hasUdpCommConfig)
$(if.network.hasSerialCommConfig)
  ////////////////////////////////////////////////////////////////
  // Property "serialConfig"
  ////////////////////////////////////////////////////////////////
    
    /**
     * Slot for the <code>serialConfig</code> property.
     * @see $(package).$(network.class)#getSerialConfig
     * @see $(package).$(network.class)#setSerialConfig
     */
    public static final Property serialConfig = newProperty(0, new B$(basePrefix)SerialCommConfig(),null);
    
    /**
     * Get the <code>serialConfig</code> property.
     * @see $(package).$(network.class)#serialConfig
     */
    public B$(basePrefix)SerialCommConfig getSerialConfig() { return (B$(basePrefix)SerialCommConfig)get(serialConfig); }
    
    /**
     * Set the <code>serialConfig</code> property.
     * @see $(package).$(network.class)#serialConfig
     */
    public void setSerialConfig(B$(basePrefix)SerialCommConfig v) { set(serialConfig,v,null); }
  
$(end.network.hasSerialCommConfig)
$(if.autoDeviceLearn)
  ////////////////////////////////////////////////////////////////
  // Property "discoveryPreferences"
  ////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>discoveryPreferences</code> property.
   * @see $(package).$(network.class)#getDiscoveryPreferences
   * @see $(package).$(network.class)#setDiscoveryPreferences
   */
  public static final Property discoveryPreferences = newProperty(Flags.HIDDEN, new B$(basePrefix)DeviceDiscoveryPreferences(),null);
  
  /**
   * Get the <code>discoveryPreferences</code> property.
   * @see $(package).$(network.class)#discoveryPreferences
   */
  public BNDiscoveryPreferences getDiscoveryPreferences() { return (BNDiscoveryPreferences)get(discoveryPreferences); }
  
  /**
   * Set the <code>discoveryPreferences</code> property.
   * @see $(package).$(network.class)#discoveryPreferences
   */
  public void setDiscoveryPreferences(BNDiscoveryPreferences v) { set(discoveryPreferences,v,null); }

  ////////////////////////////////////////////////////////////////
  // Action "submitDiscoveryJob"
  ////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>submitDiscoveryJob</code> action.
   * @see com.tridium.smoke.BSmokeNetwork#submitDiscoveryJob()
   */
  public static final Action submitDiscoveryJob = newAction(Flags.HIDDEN,new B$(basePrefix)DeviceDiscoveryPreferences(),null);

  /**
   * Invoke the <code>submitDiscoveryJob</code> action.
   * @see com.tridium.smoke.BSmokeNetwork#submitDiscoveryJob
   */
  public BOrd submitDiscoveryJob(BNDiscoveryPreferences preferences) { return (BOrd)invoke(submitDiscoveryJob,preferences,null); }


$(end.autoDeviceLearn)

  ////////////////////////////////////////////////////////////////
  // Type
  ////////////////////////////////////////////////////////////////
    
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType($(network.class).class);

  /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
$(if.processUnsolicited)
  public void started()
      throws Exception
  {
    super.started();
$(end.processUnsolicited)
  
$(if.httpListner)
    getHttpConfig().setDefaultListener(new $(basePrefix)Listener(getHttpConfig()));
$(end.httpListner)
$(if.tcpListner)
    getTcpConfig().setDefaultListener(new $(basePrefix)Listener(getTcpConfig()));
$(end.tcpListner)
$(if.udpListner)
    getUdpConfig().setDefaultListener(new $(basePrefix)Listener(getUdpConfig()));
$(end.udpListner)
$(if.serialListner)
    getSerialConfig().setDefaultListener(new $(basePrefix)Listener(getSerialConfig()));
$(end.serialListner)  
   
$(if.processUnsolicited)
  }
$(end.processUnsolicited)

  /** Specify name for network resources. */
  public String getNetworkName() { return "$(network.type)"; }

  /** return device folder type  */
  public Type getDeviceFolderType()
  {
    return $(deviceFolder.class).TYPE;
  }

  /** return device type */
  public Type getDeviceType()
  {
    return $(device.class).TYPE;
  }
  
  /** TODO - Add license check if needed
  public final Feature getLicenseFeature()
  {
    return Sys.getLicenseManager().getFeature("?? vendor", "?? feature");
  }
  */
  
$(if.autoDeviceLearn)
////////////////////////////////////////////////////////////////
//BINDiscoveryHost
////////////////////////////////////////////////////////////////

  public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) 
     throws Exception
  {
    // TODO Auto-generated method stub
    return null;
  }
  
  public BOrd doSubmitDiscoveryJob(BNDiscoveryPreferences preferences)
  {
    // Saves the most recent device discovery parameters
    setDiscoveryPreferences((B$(basePrefix)DeviceDiscoveryPreferences)preferences.newCopy()); 
    // Instantiates an instance of BNDiscoveryJob
    BNDiscoveryJob job = new BNDiscoveryJob(this);
    // Passes the discovery parameters to the job
    job.setDiscoveryPreferences(preferences);
    // Submits the job and returns Ord 
    return job.submit(null);
  }


$(end.autoDeviceLearn)
////////////////////////////////////////////////////////////////
//Utilities
////////////////////////////////////////////////////////////////
  
$(if.network.hasHttpCommConfig)
  /** Access the http comm stack */
  public HttpComm hcomm() 
  {
    return (HttpComm)getHttpConfig().comm();
  }
$(end.network.hasHttpCommConfig)
  
$(if.network.hasTcpCommConfig)
  /**Access the tcp comm stack */
  public NComm tcomm()
  {
    return (NComm)getTcpConfig().comm();
  }
$(end.network.hasTcpCommConfig)
  
 $(if.network.hasUdpCommConfig)
  /** Access the udp comm stack */
  public NComm ucomm() 
  {
    return (NComm)getUdpConfig().comm();
  }
$(end.network.hasUdpCommConfig)
  
$(if.network.hasSerialCommConfig)
   /**Access the serial comm stack */
  public NComm scomm()
  {
    return (NComm)getSerialConfig().comm();
  }
$(end.network.hasSerialCommConfig)  
  
  public static Lexicon LEX = Lexicon.make($(network.class).class);

}
