/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */
package $(package).learn;

import java.util.Vector;

import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

import $(package).$(network.class);

/**
 * $(learnDevicesJob.class) - This job is used by the access device manager to discover connected
 * access devices.
 *
 * @author    $(author)
 * @creation  $(date)
 * @version   $Revision: 3$ $Date: 8/9/07 4:31:06 PM EDT$
 */
public class $(learnDevicesJob.class)
  extends BSimpleJob
{
  /*-
   class $(learnDevicesJob.class)
   {
    properties
    {
      learnedDevices : BFolder
        -- Contains dynamic $(learnDeviceEntry.class) slots, each slot corresponds to
        -- The discovery information about a learned device.
        flags{hidden, readonly, transient}
        default{[new BFolder()]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/

////////////////////////////////////////////////////////////////
// Property "learnedDevices"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>learnedDevices</code> property.
   * Contains dynamic $(learnDeviceEntry.class) slots, each
   * slot corresponds to The discovery information about
   * a learned device.
   * @see $(package).learn.$(learnDevicesJob.class)#getLearnedDevices
   * @see $(package).learn.$(learnDevicesJob.class)#setLearnedDevices
   */
  public static final Property learnedDevices = newProperty(Flags.HIDDEN|Flags.READONLY|Flags.TRANSIENT, new BFolder(),null);
  
  /**
   * Get the <code>learnedDevices</code> property.
   * @see $(package).learn.$(learnDevicesJob.class)#learnedDevices
   */
  public BFolder getLearnedDevices() { return (BFolder)get(learnedDevices); }
  
  /**
   * Set the <code>learnedDevices</code> property.
   * @see $(package).learn.$(learnDevicesJob.class)#learnedDevices
   */
  public void setLearnedDevices(BFolder v) { set(learnedDevices,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType($(learnDevicesJob.class).class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/



  /**
   * Constructor - $(learnDevicesJob.class)
   *
   *
   */
  public $(learnDevicesJob.class)()
  {
    super();
    this.network=null;
  }
  /**
   * Constructor - $(learnDevicesJob.class)
   */
  public $(learnDevicesJob.class)($(network.class) net )
  {
    super();
    this.network=net;
  }

  // modify this method as needed to add device to learned devices
  void addLearnedDevice(String address)
  {
    String learnName = "device" + address;
    if (getLearnedDevices().get(learnName)==null)          // If a learn entry does not yet exist for this point
    {
      getLearnedDevices().add(learnName,new B$(basePrefix)LearnDeviceEntry(address));
      logMessage("found device " + learnName);
    }
  }

  // modify this method to remove device to learned devices
  void removeLearnedDevice(int address)
  {
    String learnName = "device" + address;
    if (getLearnedDevices().get(learnName)!=null) // If a learn entry exists for this point
      getLearnedDevices().remove(learnName);      // Then this removes it.
  }

  /* (non-Javadoc)
   * @see javax.baja.job.BSimpleJob#run(javax.baja.sys.Context)
   */
  public void run(Context cx) throws Exception
  {
    logMessage("starting");
    try
    {
      /* TO DO  
      *  add code here to send what ever messages needed to the subsystem to determine what
      *  devices are connected to the network.
      *  You will need to modify the B$(basePrefix)LearnDeviceEntry to match the key data items to
      *  identify this device.
      *  You will need to modify addLearnedDevice to create and add an instance of
      *  B$(basePrefix)LearnDeviceEntry.
      
      *  Sample code
      for( int address = 0; address < MAX_ADDRESS; address++)
      {
        YourDiscoveryMessage message = new YourDiscoveryMessage(address);
        YourDiscoveryMessageResponse response;
        response = network.sendSync(message);
        if(response != null)
        {
          addLearnedDevice(address);  
        }
      }
      */
    }
    catch(Exception e)
    {
    }
  }


  final $(network.class) network;

  private void logMessage(String message)
  {
    log().message(message);

    if(network != null)
    {
      int severity = network.getLog().getSeverity();
      network.getLog().setSeverity(Log.MESSAGE);
      network.getLog().message("Learn Access Devices Job:" + message);
      network.getLog().setSeverity(severity);
    }
  }

}
