/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */
package $(package).identify;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.identify.*; 

import com.tridium.ddf.identify.BDdfReadParams;
import com.tridium.ddf.identify.BIDdfDiscoverParams;

import $(package).comm.req.B$(driverName)ReadRequest;
import $(package).discover.B$(driverName)PointDiscoveryLeaf;
import $(package).identify.*;

public class B$(driverName)ReadParams
  extends BDdfReadParams
  $(if.noDeviceMessage)
  implements BIDdfDiscoverParams
  $(end.noDeviceMessage){
  /*-
  class B$(driverName)ReadParams
  {
    properties
    {
      typeString : String
        -- This property has nothing to with the dev
        -- driver framework itself. Instead, we need
        -- to construct the toByteArray method of the
        -- driver's read request in following the
        -- driver's protocol to read data values.
        default{["analog"]}
        slotfacets{[MGR_INCLUDE]}

      direction : String
        -- This property has nothing to with the ev
        -- driver framework itself. Instead, we need
        -- to construct the toByteArray method of the
        -- driver's read request in following the
        -- driver's protocol to read data values.
        default{["outputs"]}
        slotfacets{[MGR_INCLUDE]}
    }
  }
  -*/

  public Type getReadRequestType(){return B$(driverName)ReadRequest.TYPE;}

  $(if.noDeviceMessage)
  
  /** 
   * Niagara AX requires a public, empty constructor, so that it can perform 
   * Its own introspection operations. 
   */ 
  public B$(driverName)ReadParams(){} 
  
  /** 
   * Fully specified constructor...
   */ 
  public B$(driverName)ReadParams(String typeString, String direction) 
  { 
    setTypeString(typeString); 
    setDirection(direction); 
  } 
 
  public BIDdfDiscoverParams getFirst() 
  { 
    // TODO: Return an instance of this class that encapsulates the data
    // that would be transmitted as the byte array for the point
    // discovery request in order to request the first known point or
    // group of points in the field-device. Good luck.
    return new B$(driverName)ReadParams("analog","inputs"); 
  } 
 
  public BIDdfDiscoverParams getLast() 
  { 
    // TODO: Return an instance of this class that encapsulates the data
    // that would be transmitted as the byte array for the point
    // discovery request in order to request the last known point or
    // group of points in the field-device. Good luck.
    return new B$(driverName)ReadParams("digital","outputs");
  } 
 
  public BIDdfDiscoverParams getNext() 
  {
    // TODO: Analyze the current instance of this class and return another
    // instance of this class that encapsulates the data that would be
    // transmitted as the byte array for the point discovery request
    // in order to request the next known point or group of points
    // in the field-device. Good luck.
    
    // In all truth, our typeString and direction properties essentially 
    // Could be combined into a single enumeration. Let's at least treat 
    // It that was to help make this method simple. 
    switch (getConvenientNumber()) // getConvenientNumber is a private 
    {                              // method that we created below
    
      case 0:  // Current = analog inputs   Next = analog outputs 
        return new B$(driverName)ReadParams("analog","outputs");
        
      case 1:  // Current = analog outputs  Next = digital inputs 
        return new B$(driverName)ReadParams("digital","inputs");
        
      case 2:  // Current = digital inputs  Next = digital outputs 
        return new B$(driverName)ReadParams("digital","outputs");
        
      //case 3: 
      default: // Current = digital outputs Next = analog inputs 
        return new B$(driverName)ReadParams("analog","inputs"); 
    }     
  } 
 
  public boolean isAfter(BIDdfDiscoverParams anotherId) 
  {
    // TODO: Analyze the current instance as well as the given instance
    // of this class. Return true if the current instance of this class
    // encapsulates data that would be transmitted as the byte array
    // for a point discovery request that would request a point or
    // group of points that is after those which the given instance's
    // encapsulated data would request. Good luck.
    
    // TODO: This is a hypothetical implementation. Your implementation
    // will differ based on your driver's communication protocol...
    // In all truth, our typeString and direction properties essentially 
    // Could be combined into a single enumeration. Let's at least treat 
    // It that was to help make this method simple. 
    return this.getConvenientNumber() > (( B$(driverName)ReadParams )anotherId).getConvenientNumber(); 
         
  } 
  
  /**
   * Generically implements this method by 'for' looping from this
   * instance to the given value, counting the number of loop iterations,
   * and returning that value. This is used to allow the ddf automatic
   * discovery mechanism to display progress.
   * 
   * @see BIDdfDiscoverParams
   */
  public int countTo(BIDdfDiscoverParams toDiscoverId)
  {
    BIDdfDiscoverParams fromDiscoverId = this;
    
    int numRequestsToTry=0;
    
    for (BIDdfDiscoverParams currentDiscoverId = fromDiscoverId, // Walks through the entire possible sequence of discover id's
         previousDiscoverId = fromDiscoverId;        // In order to count the number of iterations.
          !previousDiscoverId.isAfter(currentDiscoverId) && // We do this to allow us to increment the
          !currentDiscoverId.isAfter(toDiscoverId);        // Job progress in main loop of the discovery process
        previousDiscoverId=currentDiscoverId,
        currentDiscoverId = currentDiscoverId.getNext())
      numRequestsToTry++;
    
    return numRequestsToTry;
    
  }  
 
  /** 
   * The read request will also serve during the 
   * point discovery process. 
   */ 
  public Type getDiscoverRequestType() 
  { 
    return B$(driverName)ReadRequest.TYPE; 
  }
  
  public Type[] getDiscoverRequestTypes() 
  { 
    return new Type[]{B$(driverName)ReadRequest.TYPE}; 
  }
  
  /** 
   * This tells the developer driver framework that 
   * instances of B$(driverName)DiscoveryLeaf will be 
   * placed into the discovery list of the point 
   * manager to represent each data point that the 
   * driver discovers. 
   */ 
  public Type getDiscoveryLeafType() 
  { 
    return B$(driverName)PointDiscoveryLeaf.TYPE; 
  }
  
  /** 
   * This method is for the hypothetical protocol that is discussed in
   * the Tutorial for the Developer Driver Framework.
   * 
   * We created up this method to help with the isAfter and getNext methods. 
   * 
   * This method allows us to effectively enumerate all possible, reasonable 
   * instances of this class. 
   */ 
  private int getConvenientNumber() 
  { 
    // NOTE: Your driver will probably not require this exact method, however
    // fell free to implement something like this.
    
    // This creates an "ordering" on all reasonable instances of this class. 
    if (getTypeString().equals("analog") && 
        getDirection().equals("inputs")) 
    { 
      return 0; 
    } 
    else if (getTypeString().equals("analog") && 
             getDirection().equals("outputs")) 
    { 
      return 1; 
    } 
    else if (getTypeString().equals("digital") && 
             getDirection().equals("inputs")) 
    { 
      return 2; 
    } 
    else // "digital outputs" or anything else (invalid as it 
         // might be) 
    { 
      return 3; 
    } 
  }   
  
  $(end.noDeviceMessage)
  

}