/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */
package $(package).comm.req;

import javax.baja.sys.*;

import com.tridium.ddf.identify.*;
import com.tridium.ddf.comm.*;
import com.tridium.ddf.comm.req.*;
import com.tridium.ddf.comm.rsp.*;

import $(package).identify.*;
import $(package).comm.rsp.*;


public class B$(driverName)PointDiscoverRequest
  extends BDdfDiscoveryRequest
{
  /*-
  class B$(driverName)PointDiscoverRequest
  {
  }
  -*/

  public byte[] toByteArray()
  {
    // In the developer driver framework, all requests are automatically
    // assigned a deviceId when they are created. The developer driver
    // framework calls this method (function) after it creates the
    // request, therefore this particular request has already been
    // assigned a deviceId. The deviceId will be an instance of
    // B$(driverName)DeviceId - that is how the developer driver works!
    B$(driverName)DeviceId deviceId =
      (B$(driverName)DeviceId)getDeviceId();
    
    // Likewise, all discover requests are automatically assigned a 'discover'
    // parameters structure. The discoverParameters will be an instance of
    // B$(driverName)PointDiscoverParams - that is how the developer driver
    // works! The actual value will  be based on what an end-user selects
    // when he or she clicks the 'Discover' button on the device manager.
    B$(driverName)PointDiscoverParams discoverParams
      = (B$(driverName)PointDiscoverParams)getDiscoverParameters();
    
    // TODO: Construct a byte array or a byte array output stream to
    // construct the byte array that this method will return. Use the
    // data in both the 'deviceId' and the 'discoverParams' to initialize
    // the byte array or byte array output stream. The deviceId should
    // have all data necessary to identify the particular field-device.
    // The discoverParams should have all data necessary to identify which
    // point(s) to seek within the field-device.
    
    // NOTE: This is similar to a read request but could differ in that
    // instead of asking the field-device for the value of one or more
    // data points, this asks the field device about the existence and/or
    // identification of one or more data points. Try to use the data in the
    // discoverRequest as an indication of which particular data point(s)
    // to query the field-device about.
    
    // TODO: Return a byte array...good luck.
    return null;

  }
  
  public BIDdfResponse processReceive(IDdfDataFrame receiveFrame) 
     throws DdfResponseException 
  {  
    // TODO: Pass any data to the response that it will need to 
    // implement its parseDiscoveryChildren method. 
    return new B$(driverName)PointDiscoverResponse(receiveFrame); 
  }   
}