/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */
package $(package).comm.req;

import javax.baja.sys.*;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.*; 
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;

import $(package).comm.rsp.*;
import $(package).identify.*;
import $(package).point.*;

/**
 * This request is used to inform the field-device that the
 * Niagara framework is no longer controlling the value of
 * a particular data point. Typically the field-device will
 * resume control of the particular data point and update
 * the value of the data point in any manner that its
 * internal program desires.
 */
public class B$(driverName)PointAutoRequest 
  extends BDdfWriteRequest 
{ 
  /*- 
  class B$(driverName)PointAutoRequest 
  { 
  } 
  -*/
  
  public byte[] toByteArray() 
  { 
    // In the developer driver framework, all requests are automatically
    // assigned a deviceId when they are created. The developer driver
    // framework calls this method (function) after it creates the
    // request, therefore this particular request has already been
    // assigned a deviceId. The deviceId will be an instance of
    // B$(driverName)DeviceId - that is how the developer driver works!
    B$(driverName)DeviceId deviceId =
      (B$(driverName)DeviceId)getDeviceId();
    
    // Likewise, all 'auto' requests are automatically assigned a write
    // parameters structure (since auto'ing a data point is the converse
    // of writing, the same data that would be required to 'write' the
    // data-point should be the same data that would be require to 'auto'
    // the data-point). The writeParameters will be an instance of
    // B$(driverName)WriteParams - that is how the developer driver
    // works!
    B$(driverName)WriteParams writeParams
      = (B$(driverName)WriteParams)getWriteParameters();
    
    // TODO: Initialize a byte array or a byte array output stream to
    // construct the byte array that this method will return. Use the
    // data in both the 'deviceId' and the 'writeParams' to initialize
    // the byte array or byte array output stream. The deviceId has
    // all data necessary to identify the particular field-device. The
    // writeParams has all data necessary to identify "what" to 'auto'
    // within the field-device. To 'auto' a data point is to stop writing
    // to the data point.
    
    
    // Gets an array of IDdfWritables (typically the data point proxy extensions)
    // NOTE: The 'writeParameters' of the IDdfWritable proxies in the following
    // array are all equivalent to the 'writeParams' structure for this request.
    // In the simplest case, the writeableSource will be an array of length 1.
    IDdfWritable[] pointsToWrite = getWritableSource();
    
    for (int i=0; i<pointsToWrite.length; i++)
    { 
      // TODO: Add data to the byte array to further instruct the field-device
      // as to which internal points to relinquish ('auto').
      if (pointsToWrite[i] instanceof B$(driverName)ProxyExt) 
      { 
        // NOTE: At present (as of Niagara 3.3.4), all of the IDdfWritables will
        // be proxy extensions. In the future, these could be a virtual point
        B$(driverName)ProxyExt proxy // Casts to B$(driverName)ProxyExt 
          = (B$(driverName)ProxyExt)pointsToWrite[i];
        
        B$(driverName)PointId pointId // Gets information that uniquely identifies
          = (B$(driverName)PointId)proxy.getPointId(); // the particular point
        
        // TODO: Add bytes to the byte array or byte array output stream to
        // indicate each data point, and
        
      }
    }
    
    // TODO: Return a byte array that asks the device identified by the
    // 'deviceId' to 'write' the data point that is
    // identified by the 'writeParams'. Good luck.
    return null;
  }
  
  /**
   * After transmitting this request, the BDdfCommunicator will pass frames that it receives
   * here. If you implement the getTag method then the ddf communicator will only pass data frames
   * whose tag's hashcode matches your request tag's hashcode. If your request returns null from
   * the getTag method then all received data frames will be passed here, until the request times
   * out or returns a BIDdfResponse from this method.
   *
   *  This request needs to take one of the following steps:
   *   1. NOT TYPICAL: Ignore the frame and return null.
   *   2. NOT TYPICAL: Collect the frame and return a BIDdfMultiFrameResponse. In which case, you need to implement your own collection
   *      mechanism. For example, this could be as simple as putting them all in a Vector in the BIDdfMultiFrameResponse.
   *   3. TYPICAL: Return a BIDdfResponse for the data frame and NOT TYPICAL:> any previously collected frames that you determine together make up a completed response.
   *   4. TYPICAL: Throw an DdfResponseException or subclass there-of to indicate the the frame
   *   forms a complete message but indicates an error condition in the device preventing
   *   a successful response.
   *
   *   WARNING: In scenario's 2 and 3, please copy the frame's bytes as the frame's byte array could be a direct reference to an internal
   *   buffer in the receiver.
   * @param iDdfDataFrame
   * @return
   */
  public BIDdfResponse processReceive(IDdfDataFrame receiveFrame)
   throws DdfResponseException
  { 
    // NOTE: In the simplest of scenarios, the write response can be used as an 'auto' response too,
    // since the simplest of write responses only check the respone data for a negative acknowledgment.
    return new B$(driverName)WriteResponse(receiveFrame);
  }

    
  
}