/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).comm.req;

import javax.baja.sys.*;

import com.tridium.ddf.identify.*;
import com.tridium.ddf.comm.req.*;
import com.tridium.ddf.comm.rsp.*;
import com.tridium.ddf.comm.*;
$(if.pingUsed)
import com.tridium.ddf.discover.*;
$(end.pingUsed)

import $(package).identify.*;
import $(package).comm.rsp.*;

public class B$(driverName)PingRequest
  extends BDdfPingRequest
  $(if.pingUsed)
  implements BIDdfDiscoverRequest
  $(end.pingUsed)
{
   
$(if.pingUsed)   
  /*-
  class B$(driverName)PingRequest
  {
    properties
    {
      discoverParameters : BDdfIdParams
         -- This provides the necessary data that the toByteArray method
         -- Needs in order to construct the byte array.
         -- NOTE: During auto-discovery, the auto discovery job loops
         -- through all possible combinations of discoverParameters. Each
         -- pass through the loop, the next discoverParameters value for
         -- your driver is passed to this property. When you implement
         -- the toByteArray method, you may cast this to your own
         -- discoveryParameters class (that is what it will ultimately be).
        default{[new B$(driverName)DeviceId()]}
    }
  }
  -*/

  /**
   * The BDdfAutoDiscoveryJob will pass an inner instance
   * of itself to the setDiscoverer method. In there, you
   * need to save away the reference. In here, please return
   * the most recent reference that was passed to the
   * setDiscoverer method.
   */
  public IDdfDiscoverer getDiscoverer()
  {
    return discoverer;
  }

  /**
   * The BDdfAutoDiscoveryJob will pass an inner instance
   * of itself here. Please save away the reference. Other
   * than that, you should not need to concern yourself
   * with this.
   */
  public void setDiscoverer(IDdfDiscoverer discoverer)
  {
    this.discoverer=discoverer;
  }
  
  $(end.pingUsed)
  
  $(if.pingNotUsed)
  /*- 
  class B$(driverName)PingRequest 
  { 
  } 
  -*/ 
  $(end.pingNotUsed)  
  

  public byte[] toByteArray()
  {
    // In the developer driver framework, all requests are automatically
    // Assigned a deviceId when they are created. The developer driver
    // Framework calls this method (function) after it creates the
    // Request, therefore this particular request has already been
    // Assigned a deviceId. The deviceId will be an instance of
    // BYourDriverDeviceId - that is how the developer driver works!

    B$(driverName)DeviceId deviceId =
      (B$(driverName)DeviceId)getDeviceId();
    
    // TODO: Return the byte array. Good luck.
    return null;
  }

  /**
   * For this example, we will assume that the mere fact that a data
   * frame was received after transmitting this response means that
   * the equipment must have responded to the request. Since in
   * Niagara AX, the primary purpose of a ping request-response
   * transaction is to determine whether or not the corresponding
   * field-device is online, then this will suffice.
   */
  public BIDdfResponse processReceive(IDdfDataFrame recieveFrame)
    throws DdfResponseException
  {
    return new B$(driverName)PingResponse();
  }
  
$(if.pingUsed)   
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  /**
   * The setDiscoverer method will be passed an instance of
   * IDdfDiscoverer. You need to retain the reference on
   * the instance and return it (whenever requested) from
   * the getDiscoverer method.
   */
  IDdfDiscoverer discoverer = null;
$(end.pingUsed)
  
}