/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).identify;

import javax.baja.sys.*;
import javax.baja.registry.*;

import com.tridium.ddf.identify.*;
import com.tridium.ddf.discover.*;

import $(package).*;
import $(package).comm.req.*;

public class B$(driverName)DeviceId
  extends BDdfDeviceId
  $(if.pingUsed)
  implements BIDdfDiscoverParams, BIDdfDiscoveryLeaf
  $(end.pingUsed)
  $(if.pingNotUsed)
  implements BIDdfDiscoveryLeaf
  $(end.pingNotUsed)

{
  /*-
  class B$(driverName)DeviceId
  {
    properties
    {
      unitNumber : int
        -- This is the unitNumber in our hypothetical protocol.
        default{[0]}
        slotfacets{[MGR_INCLUDE]}
    }
  }
  -*/

  public Type getPingRequestType( )
  {
    return B$(driverName)PingRequest.TYPE;
  }

  /**
   * Niagara AX requires a public, empty constructor, so that it can perform
   * Its own introspection operations.
   */
  public B$(driverName)DeviceId(){}
  
  
  $(if.pingUsed)
  /**
   * This constructor is for our own convenience in the methods getFirst,
   * getNext, etc.
   */
  public B$(driverName)DeviceId(int unit)
  {
    setUnitNumber(unit);
  }
  public BIDdfDiscoverParams getFirst()
  {
    return new B$(driverName)DeviceId(FIRST_UNIT_NBR);
  }

  public BIDdfDiscoverParams getLast()
  {
    return new B$(driverName)DeviceId(LAST_UNIT_NBR);
  }

  public BIDdfDiscoverParams getNext()
  {
    int nextUnitNumber = getUnitNumber()+1;
    
    if (nextUnitNumber>LAST_UNIT_NBR) // Circles back to first
      return getFirst();
    else
      return new B$(driverName)DeviceId(nextUnitNumber);
  }

  public boolean isAfter(BIDdfDiscoverParams anotherId)
  {
    return this.getUnitNumber() >
           ((B$(driverName)DeviceId)anotherId).getUnitNumber();
  }

  /**
   * The implementing class needs to return a Type that represents
   * the discover request from the driver whose discoverId can be an
   * instance of this object's class. If the class supports more than
   * one discover request type, then this should return the type that is
   * the most appropriate for the particular instance of the implenting
   * class.
   *
   * This is fundamental to dev driver's auto-discovery features.
   *
   * @return review method description.
   */
  public Type getDiscoverRequestType()
  {
    return B$(driverName)PingRequest.TYPE;
  }
  /**
   * Some drivers might require multiple, completely different requests
   * tp be used to discover devices. This should not be the case here though.
   *
   * @return review method description.
   */
  public Type[] getDiscoverRequestTypes()
  {
    return new Type[]{getDiscoverRequestType()};
  }

  /**
   * Some drivers could hypothetically group discovery objects. This
   * method returns the Type that will ultimately form the bottom-
   * most, non-grouped discovery objects. The columns of the device
   * manager will be determined from this type.
   *
   * In this case, the discovery leaf type is also B$(driverName)DeviceId.
   *
   * @return review method description.
   */
  public Type getDiscoveryLeafType()
  {
    return getType();
  }
  
  /**
   * Generically implements this method by 'for' looping from this
   * instance to the given value, counting the number of loop iterations,
   * and returning that value. This is used to allow the ddf automatic
   * discovery mechanism to display progress.
   * 
   * @see BIDdfDiscoverParams
   */
  public int countTo(BIDdfDiscoverParams toDiscoverId)
  {
    BIDdfDiscoverParams fromDiscoverId = this;
    int numRequestsToTry=0;
    
    for (BIDdfDiscoverParams currentDiscoverId = fromDiscoverId, // Walks through the entire possible sequence of discover id's
         previousDiscoverId = fromDiscoverId;        // In order to count the number of iterations.
          !previousDiscoverId.isAfter(currentDiscoverId) && // We do this to allow us to increment the
          !currentDiscoverId.isAfter(toDiscoverId);        // Job progress in main loop of the discovery process
        previousDiscoverId=currentDiscoverId,
        currentDiscoverId = currentDiscoverId.getNext())
      numRequestsToTry++;
    
    return numRequestsToTry;
    
  }    
  $(end.pingUsed)
  
  /**
   * When a control point is added to the station from the Dev
   * Point Manager, it is given this name by default (possibly
   * with a suffix to make it unique).
   * @return
   */
  public String getDiscoveryName()
  {
    return "NewDevice";
  } 
  
  /**
   * Descendants need to return an array of TypeInfo objects corresponding
   * to all valid Niagara Ax types for this discovery object. This is
   * important when the end-user clicks 'Add' from the user interface for
   * the manager.
   *
   * For this discovery object, please  return a list of the types
   * which may be used to model it as a BComponent in the station
   * database. If the discovery object represents a device in your
   * driver then then method should return an array with size of
   * at least one, filled with TypeInfo's that wrap the Niagara AX
   * TYPE's for your driver's device components.
   *
   * The type at index 0 in the array should be the type which
   * provides the best mapping.  Please return an empty array if the
   * discovery cannot be mapped.
   */
  public TypeInfo[] getValidDatabaseTypes()
  {
    return new TypeInfo[]{B$(driverName)Device.TYPE.getTypeInfo()};
  }  
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  private static final int FIRST_UNIT_NBR = 0;
  private static final int LAST_UNIT_NBR = 50;
  
}