/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).identify;

import javax.baja.sys.*;

import com.tridium.ddf.*;
import com.tridium.ddf.identify.*;

import $(package).comm.req.*;
import $(package).discover.*;

/**
 * This Niagara AX type needs some properties to represent the
 * data that is necessary in order to construct the byte array
 * for a particular device discovery request.
 */
public class B$(driverName)DeviceDiscoverParams
  extends BDdfDiscoverParams
{
  // Hypothetical protocol example where a gateway can report about
  // devices that are connected to it based on a group number. For
  // example, in the hypothetical protocol, there could be many
  // devices per group. 
  public static final int MIN_GROUP_ID = 0;  // Hypothetical min group id = 0
  public static final int MAX_GROUP_ID = 50; // Hypothetical max group id = 50
  
/*-
  class B$(driverName)DeviceDiscoverParams
  {
    properties
    {
      groupNumber : int
        -- This would work in a hypothetical protocol where a gateway
        -- is capable of reporting devices by group.
        default{[0]}
        slotfacets{[DdfFacets.combine(MGR_INCLUDE,
                    BFacets.make( BFacets.MIN, BInteger.make(MIN_GROUP_ID) ),
                    BFacets.make( BFacets.MAX, BInteger.make(MAX_GROUP_ID)) ) ]}
    
    }
  }
  -*/

  /**
   * Niagara AX requires a public, empty constructor, so that it can perform
   * Its own introspection operations.
   */
  public B$(driverName)DeviceDiscoverParams()
  {
    
  }
  
  /**
   * Full specified constructor
   */
  public B$(driverName)DeviceDiscoverParams(int groupNo)
  {
    setGroupNumber(groupNo);
  }
  

  public BIDdfDiscoverParams getFirst()
  {
    // TODO: Return an instance of this class that encapsulates the data
    // that would be transmitted as the byte array for the device
    // discovery request in order to request the first known device or
    // group of devices on the network.
    
    // NOTE: The following auto-generated return would work for the
    // hypothetical example that this auto-generated class illustrates.
    return new B$(driverName)DeviceDiscoverParams(MIN_GROUP_ID); // TODO:
  }

  public BIDdfDiscoverParams getLast()
  {
    // TODO: Return an instance of this class that encapsulates the data
    // that would be transmitted as the byte array for the device
    // discovery request in order to request the last known device or
    // group of devices on the network.
    
    // NOTE: The following auto-generated return would work for the
    // hypothetical example that this auto-generated class illustrates.
    return new B$(driverName)DeviceDiscoverParams(MAX_GROUP_ID); // TODO:
  }

  public BIDdfDiscoverParams getNext()
  {
    // TODO: Analyze the current instance of this class and return another
    // instance of this class that encapsulates the data that would be
    // transmitted as the byte array for the device discovery request
    // in order to request the next known device or group of devices
    // on the network.  Good luck!
    
    // NOTE: The following auto-generated return would work for the
    // hypothetical example that this auto-generated class illustrates.
    int nextGroup = getGroupNumber() + 1;
    
    if (nextGroup > MAX_GROUP_ID)
      nextGroup = MAX_GROUP_ID;
    
    return new B$(driverName)DeviceDiscoverParams(nextGroup); // TODO:
  }

  public boolean isAfter(BIDdfDiscoverParams anotherId)
  {
    // TODO: Analyze the current instance as well as the given instance
    // of this class. Return true if the current instance of this class
    // encapsulates data that would be transmitted as the byte array
    // for a device discovery request that would request a device or
    // group of devices that is after those which the given instance's
    // encapsulated data would request.
    
    // NOTE: The following auto-generated/ return would work for the
    // hypothetical example that this auto- generated class illustrates.
    B$(driverName)DeviceDiscoverParams otherDeviceId = 
      (B$(driverName)DeviceDiscoverParams)anotherId;
    
    return this.getGroupNumber() > otherDeviceId.getGroupNumber(); // TODO:
  }


  public Type getDiscoverRequestType() 
  { 
    return B$(driverName)DeviceDiscoverRequest.TYPE; 
  }
  
  /**
   * This tells the developer driver framework that
   * instances of BYourDriverDiscoveryLeaf will be
   * placed into the discovery list of the point
   * manager to represent each data point that the
   * driver discovers.
   */
  public Type getDiscoveryLeafType()
  { 
    // NOTE: The deviceId can usually serve as the discovery leaf during the
    // device discovery process.
    return B$(driverName)DeviceId.TYPE;
  }
  
}