/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */
package $(package).messages;

import javax.baja.util.ByteArrayUtil;

import com.tridium.basicdriver.message.*;

/**
 * $(receivedMessage.class) is a wrapper class for a received byte array
 * message before it's contents have been interpreted.
 *
 * $(receivedMessage.class)
 
 * @author    $(author)
 * @creation  $(date)
 * @version   $Revision: 1$ $Date: 4/17/05 6:58:34 AM EDT$
 */
public class $(receivedMessage.class)
  extends ReceivedMessage
{
////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////

 /**
  * Constructor with message data in byte array form.
  * Also specifies the tag.
  */
  public $(receivedMessage.class)(byte[] data, int len)
  {
    this.data = data;
    this.len = len;
  }

////////////////////////////////////////////////////////////
// $(receivedMessage.class)
////////////////////////////////////////////////////////////

  /**
   * Returns the message data in byte array form.
   */
  public byte[] getBytes()
  {
    return data;
  }
  
  /**
   * Sets the message data in byte array form.
   */
  public void setBytes(byte[] data)
  {
    this.data = data;
  }
  
  /**
   * Returns the message length.
   */
  public int getLength()
  {
    return len;
  }
  
  /**
   * Sets the message length.
   */
  public void setLength(int len)
  {
    this.len = len;
  }
  
  /**
   * Returns the bytes in Hex String form
   */
  public String toDebugString()
  {
    return ByteArrayUtil.toHexString(data, 0, len);
  }

///////////////////////////////////////////////////////////
// Attributes
///////////////////////////////////////////////////////////
  private byte[] data;
  private int len;
}
