/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */
package $(package).point;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.driver.*;
import javax.baja.driver.point.*;
import $(package).*;
$(if.serialDriver)
import javax.baja.driver.util.*;
import javax.baja.status.*;
import com.tridium.basicdriver.point.*;
import com.tridium.basicdriver.util.*;
import $(package).messages.*;
$(end.serialDriver)

/**
 * $(proxyExt.class)
 *
 * @author    $(author)
 * @creation  $(date)
 * @version   $Revision: 6$ $Date: 4/12/06 11:23:56 AM EDT$
 */
public class $(proxyExt.class)
$(if.serialDriver)
  extends BBasicProxyExt
  implements BIBasicPollable, $(messageConst.class)
$(end.serialDriver)
$(if.notSerialDriver)
  extends BProxyExt
$(end.notSerialDriver)
{            

  /*-             
  
  class $(proxyExt.class)
  {
    properties
    {    
$(if.serialDriver)
      pollFrequency: BPollFrequency
        -- Poll frequency bucket
        default {[ BPollFrequency.normal ]}
        
$(end.serialDriver)
      address: String
        default {[ "" ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/

$(if.serialDriver)
////////////////////////////////////////////////////////////////
// Property "pollFrequency"
////////////////////////////////////////////////////////////////
  
  public static final Property pollFrequency = newProperty(0, BPollFrequency.normal,null);
  public BPollFrequency getPollFrequency() { return (BPollFrequency)get(pollFrequency); }
  public void setPollFrequency(BPollFrequency v) { set(pollFrequency,v,null); }

$(end.serialDriver)
////////////////////////////////////////////////////////////////
// Property "address"
////////////////////////////////////////////////////////////////
  
  public static final Property address = newProperty(0, "",null);
  public String getAddress() { return getString(address); }
  public void setAddress(String v) { setString(address,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType($(proxyExt.class).class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////
  
  /**
   * Get the network cast to a $(network.class).
   */
  public final $(network.class) get$(network.type)()
  {
    return ($(network.class))getNetwork();
  }

  /**
   * Get the device cast to a $(device.class).
   */
  public final $(device.class) get$(device.type)()
  {
    return ($(device.class))getDevice();
  }

  /**
   * Get the point device ext cast to a $(pointDeviceExt.class).
   */
  public final $(pointDeviceExt.class) get$(pointDeviceExt.type)()
  {
    return ($(pointDeviceExt.class))getDeviceExt();
  }

////////////////////////////////////////////////////////////////
// ProxyExt
////////////////////////////////////////////////////////////////
  
  /**
   * Return the device type. 
   */
  public Type getDeviceExtType()
  {
    return $(pointDeviceExt.class).TYPE;
  }                     
  
  /**
   * Return the read/write mode of this proxy.
   */
  public BReadWriteMode getMode()
  {
    return BReadWriteMode.readonly;
  }                        
  
$(if.notSerialDriver)
  /**
   * Callback when point enters the subscribed state.
   */
  public void readSubscribed(Context cx)
    throws Exception
  {
    // TODO
  }
  
  /**
   * Callback when point exits the subscribed state.
   */
  public void readUnsubscribed(Context cx)
    throws Exception
  {
    // TODO
  }             
  
  /**
   * Callback when time to write the point.
   */
  public boolean write(Context cx)
    throws Exception
  {
    // TODO
    return false;
  }
  
$(end.notSerialDriver)


$(if.serialDriver)

  /**
   * Override implementation of <code>BIBasicPollable</code>.
   * Causes communication to read the value of this point.
   */
  public void poll()
  {
    // If the parent point is out of service, or the parent
    // device is down, skip this poll.
    if ( isUnoperational() )
    {
     return;
    }
    
    $(network.class) network = ($(network.class))getNetwork();
    if (network.getLog().isTraceOn()) network.getLog().trace(this + ".poll()");
      
    pollForData();
      network = null;
   }


  /**
   * This method will poll for data.
   */
  private void pollForData()
  {
    $(network.class) network = ($(network.class))getNetwork();
    $(readRequest.class) req = null;
    $(readResponse.class) rsp = null;
  
    try
    {
      req = new $(readRequest.class)();
      rsp = ($(readResponse.class))(network.sendSync(req)); 
  
      if(rsp==null)
      {
        readFail("device timeout");
        // may or may not wish to also invoke pingFail on no response
        // pingFail will cause the parent device to be marked down.
        getDevice().pingFail( "timeout" );
        return;
      }
      BStatus status = BStatus.ok;
      if(isBoolean())
        readOk(new BStatusBoolean(rsp.getBooleanValue(), status));
      else if(isNumeric())
        readOk(new BStatusNumeric(rsp.getFloatValue(), status));
      else if(isString())
        readOk(new BStatusString(rsp.getStringValue(), status));
      else if(isEnum())
        readOk(new BStatusEnum(BDynamicEnum.make(rsp.getIntValue()), status));
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }
    finally
    {
      network = null;
    }
  }

  /**
   * This callback from asynchronous thread to send a write to the device.
   * Can be implemented by subclasses!
   *
   * @param BStatusValue out is the value to be sent to the foreign hardware
   */
  public void doWrite(BStatusValue value)
  {           
    // If the parent point is out of service, or the parent
    // device is down, skip this write.
    if ( isUnoperational() )
    {
      return;
    }
    
    // TODO add code here to create and send message to write the given value.
    return;
  }

  protected boolean isBoolean()
  {
    return getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
  }
  
  protected boolean isNumeric()
  {
    return getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
  }
  
  protected boolean isString()
  {
    return getParentPoint().getOutStatusValue() instanceof BStatusString;
  }
  
  protected boolean isEnum()
  {
    return getParentPoint().getOutStatusValue() instanceof BStatusEnum;
  }

$(end.serialDriver)

}
