/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).ui;

import javax.baja.sys.*;
import javax.baja.util.*;
import javax.baja.gx.*;
import javax.baja.ui.*;
import javax.baja.job.*;
import javax.baja.driver.*;
import javax.baja.driver.ui.device.*;
import javax.baja.workbench.mgr.*;
import javax.baja.workbench.mgr.folder.*;
import com.tridium.util.ArrayUtil;
import $(package).*;

/**
 * $(deviceManager.class)
 *
 * @author    $(author)
 * @creation  $(date)
 * @version   $Revision: 3$ $Date: 8/9/07 4:31:06 PM EDT$
 *          
 */
public class $(deviceManager.class)
  extends BDeviceManager
{ 
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType($(deviceManager.class).class);  

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public $(deviceManager.class)()
  {
  }


$(if.deviceManagerLearn)
  /**
   * Gets the Access network that either owns this
   * view or that is the parent of the access device
   * folder that owns this view.
   */
  public $(network.class) getNetwork()
  {
    BObject owner = getCurrentValue();
    if (owner instanceof $(deviceFolder.class))
      return ($(network.class))(($(deviceFolder.class))owner).getNetwork();
    else if (owner instanceof $(network.class))
      return ($(network.class))owner;
    else
      return null;
  }

  public void doLoadValue(BObject obj, Context cx)
  {
     super.doLoadValue(obj,cx);
     // Sets the discovery data from the pan table entries
     updateLearnData();
  }

  /**
   * This method is called by the doLoadValue method and by a inner class instance
   * of the Updater class when the pan table receives new entries.
   *
   */
  void updateLearnData()
  {
    $(learnDevicesJob.class) learnJob = ($(learnDevicesJob.class))getLearn().getJob();
    if(learnJob != null)
      getLearn().updateRoots(learnJob.getLearnedDevices().getChildren($(learnDeviceEntry.class).class) );
    //else
    //  System.out.println("NO JOB!");
  }

  public $(device.class)[] getSelectedDevices()
  {
    if(getModel()==null || getModel().getTable()==null)
    {
      return new $(device.class)[0];
    }
    else
    {
      BComponent[] selection = getModel().getTable().getSelectedComponents();
      $(device.class)[] devices = new $(device.class)[0];
      for (int i=0; i<selection.length; i++)
        if (selection[i].getType().is($(device.class).TYPE))
          devices=($(device.class)[])ArrayUtil.addOne(devices,($(device.class))selection[i]);
      return devices;
    }
  }

$(end.deviceManagerLearn)

  
////////////////////////////////////////////////////////////////
// Support
////////////////////////////////////////////////////////////////

  protected MgrModel makeModel() { return new Model(this); }
  protected MgrController makeController() { return new Controller(this); }
$(if.deviceManagerLearn)
  protected MgrLearn makeLearn() { return new Learn(this); }
$(end.deviceManagerLearn)
                                        
////////////////////////////////////////////////////////////////
// Model
////////////////////////////////////////////////////////////////
  
  class Model extends DeviceModel
  {
    Model(BDeviceManager manager) { super(manager); }
    
    protected MgrColumn[] makeColumns()
    {        
      return cols;   
    }                                   
  }                                 
                               
$(if.deviceManagerLearn)
/////////////////////////////////////////////////////////////
// Learn
//////////////////////////////////////////////////////////////
  /**
   * Helps the Niagara AX core perform the learn.
   */
  class Learn
    extends MgrLearn
  {
    Learn(BDeviceManager manager) { super(manager); }

    /**
     * Gets the information about the columns to be displayed
     * when in discover mode. The data about these columns is
     * relative to the discovery object type, which for this manager
     * is simply BInteger.
     */
    protected MgrColumn[] makeColumns()
    {
      return new MgrColumn[]{
        new MgrColumn.Prop($(learnDeviceEntry.class).address), // Shows the default device name
        //new MgrColumn.Prop($(learnDeviceEntry.class).deviceType), // Shows the discovery device's address in the discovery pane
      };
    }

    public BImage getIcon(Object dis)
    {
      return stationIcon;
    }

    public MgrTypeInfo[] toTypes(Object discovery)
    {
      return MgrTypeInfo.makeArray( getNetwork().getDeviceType());
    }

    public void toRow(Object discovery, MgrEditRow row)
    {
      $(learnDeviceEntry.class) learnEntry = ($(learnDeviceEntry.class))discovery;
      // Sets the discovered short address equal to the existing short address
      //row.setCell( colAddress, BInteger.make(learnEntry.getAddress()));
      row.setDefaultName("device??");
    }
    /**
     * Allows the core to ask us if a discovered item is equivalent
     * to a given pre-existing item.
     */
    public boolean isExisting(Object dis, BComponent comp)
    {
      $(learnDeviceEntry.class) learnEntry = ($(learnDeviceEntry.class))dis;
      $(device.class) d = ($(device.class))comp;
      return d.getAddress() ==learnEntry.getAddress();
    }
    /**
     * This callback is automatically invoked when the
     * current job set via <code>setJob()</code> completes.
     */
    public void jobComplete(BJob job)
    {
      super.jobComplete(job);
      if (job instanceof $(learnDevicesJob.class))
      {
        updateLearnData();
      }
    }
  }
$(end.deviceManagerLearn)

////////////////////////////////////////////////////////////////
// Controller
////////////////////////////////////////////////////////////////

  class Controller extends DeviceController
  {             
    Controller(BDeviceManager mgr) { super(mgr); }
  }                 
                         
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  static Lexicon lex = Lexicon.make($(deviceManager.class).class); 
  static BImage stationIcon = BImage.make("module://icons/x16/device.png");
  
  // base class columns
  MgrColumn colName         = new MgrColumn.Name();
  MgrColumn colType         = new MgrColumn.Type();
  MgrColumn colDeviceExts   = new DeviceExtsColumn(new $(device.class)());
  MgrColumn colStatus       = new MgrColumn.Prop(BDevice.status);
  MgrColumn colEnabled      = new MgrColumn.Prop(BDevice.enabled, MgrColumn.EDITABLE | MgrColumn.UNSEEN);
  MgrColumn colHealth       = new MgrColumn.Prop(BDevice.health, 0);
  
  // $(device.type) specific columns
  MgrColumn colAddress      = new MgrColumn.Prop($(device.class).address, MgrColumn.EDITABLE);
  
  MgrColumn[] cols = 
  { 
    colName, colType, colDeviceExts,
    colAddress,
    colStatus, colEnabled, colHealth, 
  };
  
}
