/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
 
/**
 * AccessControl Application JavaScript support.
 */
 
/**
 * Convenience for <code>document.getElementById(id) or document.getElementsByName(id)[0]</code>.
 */
function $$(id)
{
  var elem = document.getElementById(id);
  if(elem == null)
    elem = document.getElementsByName(id)[0];
  return elem;
}
 
var smartTable = new SmartTable();
function SmartTable()
{ 
  this.loadingId=0;
  this.forceRightClick=false;
  this.rightClickRow=null;
  this.selectAnchor;  
  
  this.addClick = function(table)
  {                  
    if(hx.ie)
    {
      document.attachEvent("onmousedown", this.unselect);
      table.attachEvent("onmousedown",    this.select);
      table.attachEvent("onselectstart",  this.disableSelection);
      table.attachEvent("oncontextmenu",  this.contextMenu);            
      table.attachEvent("ondblclick",     this.doubleClick);      
    }
    else  
    {
      document.addEventListener("mousedown", this.unselect, false);
      table.addEventListener("mousedown", this.select, false);            
      table.addEventListener("contextmenu", this.contextMenu, false);            
      table.addEventListener("dblclick", this.doubleClick, false);
    }        
  }
  
  this.contextMenu = function(e)
  {
    smartTable.forceRightClick=true;
    smartTable.select(e);
    smartTable.forceRightClick=false;

    if(!hx.ie)
      e.preventDefault();
    return false;    
  }
  
  //go to the parent until you find the scope
  this.elemFromEvent = function(event)
  {
    if(hx.ie) 
      return event.srcElement;
    else 
      return event.target;
  }
  
  this.scopeEvent = function(event)
  {
    return smartTable.scope(smartTable.elemFromEvent(event));
  }

  //go to the parent until you find the scope
  this.scope = function(elem)
  {
    if(elem == null)
      return null;
    while(elem.id.indexOf("commands") == -1 && elem.id.indexOf("records") == -1)
    {      
      elem=elem.parentNode;      
      if(elem == null)
        return null;
    }
    
    var i = elem.id.indexOf("commands");
    if( i != -1)
      return elem.id.substring(0, i);
      
    i = elem.id.indexOf("records");
    if( i != -1)
      return elem.id.substring(0, i);
  }
  
  //get the parent table
  this.getTableElem = function(elem)
  {
    while(elem.id.indexOf("records") == -1)
    {      
      elem=elem.parentNode;
      if(elem == null)
        return null;
    }
    return elem;
  }
  
  //save the double click command
  this.doubleClick = function(e)
  {
    var scope = smartTable.scopeEvent(e);
    var selectionCountElem  = $$(scope + "selectionCount");
    var selectionCount =  parseInt(selectionCountElem.value);
    if(selectionCount != 1)
      return;
    var td = smartTable.elemFromEvent(e);
    var scope = smartTable.scope(td);
    if(td.className.indexOf("row") == -1)
      return;
    
    var event = $$(smartTable.scopeEvent(e) + "doubleClick");
    if(event != null && event.value.length > 0)
    {
      var split = event.value.split("|");
      if(split[0].length > 0)
        hx.fireEvent(split[0], split[1]);    
      else
        hx.fireEvent("*", split[1]);    
    }    
  }
  
  this.add = function(elem)
  {
    while(elem.id == "")
      elem=elem.parentNode;
    
    var scope = smartTable.scope(elem);
    var selectionList   = $$( scope + "working");
    var selectionCountElem  = $$(scope + "selectionCount");
    var selectionCount =  parseInt(selectionCountElem.value);
    if(selectionCount == 0)
      selectionList.value+="|";
    selectionList.value+=elem.id;
    selectionList.value+="|";
    selectionCount++;
    selectionCountElem.value="" + selectionCount;    
  }
  
  this.remove = function(elem)
  {
    
    var scope = smartTable.scope(elem);
    while(elem.id == "")
      elem=elem.parentNode;
    
    
    var selectionListElem   = $$( scope + "working");
    var selectionList = selectionListElem.value;
    var id = "|" + elem.id + "|";
    var index = selectionList.indexOf(id);
    var length = id.length;
    var offset = 1;
    selectionList = selectionList.substring(0, index + offset) + selectionList.substring(index + length);
    selectionListElem.value = selectionList;
    
    var selectionCountElem  = $$(scope + "selectionCount");
    var selectionCount =  parseInt(selectionCountElem.value);
    selectionCount--;
    if(selectionCount == 0)
      selectionListElem.value="";
    
    selectionCountElem.value="" + selectionCount;
    if(elem == smartTable.selectAnchor)
      smartTable.selectAnchor=null;
  }

  this.select = function(e)
  {
    if(e.button == 2 && !smartTable.forceRightClick)
      return false;
    var td = smartTable.elemFromEvent(e);
    
    //ie image hack
    if(td.tagName == "SPAN" && td.style.filter.length > 0)
    {
      td=td.parentNode;      
    }
    else if(td.tagName == "IMG")
    {
      td=td.parentNode;
      if(td.tagName == "SPAN" && td.style.filter.length > 0)
        td=td.parentNode;
    }
    var scope = smartTable.scope(td);
    if(td.className.indexOf("row") == -1)
      return;
    
    var selected = false;
    var className = "";
    var index = td.className.indexOf("-selected");
    //->selected
    if(index == -1)
    {
      var classNames = td.className.split(" ");
      for (var i=0; i<classNames.length; i++)
        className += classNames[i]+"-selected ";
      selected = true;      
      smartTable.add(td);
    }
    //->stay selected, possibly unselect others
    else if(!e.ctrlKey && smartTable.getTableElem(td).className.indexOf("check") == -1 || smartTable.forceRightClick)
    {
      className=td.className;
    }
    //->unselect self,
    else
    {
      var classNames = td.className.split(" ");
      for (var i=0; i<classNames.length; i++)
      {
        var idx = classNames[i].indexOf("-selected");
        className += classNames[i].substring(0, idx)+" ";
      }
      smartTable.remove(td);
    }
    
      
    if(e.ctrlKey || selected || (smartTable.getTableElem(td).className.indexOf("check") > -1 && !smartTable.forceRightClick))
    {      
      td.className=className;
      while(td.previousSibling != null)
      {
        td=td.previousSibling;
        td.className=className;
      }
      
      while(td.nextSibling != null)
      {
        td=td.nextSibling;
        td.className=className;
      } 
    }
    
    var tr = td.parentNode;
    if(smartTable.selectAnchor != null && smartTable.scope(smartTable.selectAnchor) != scope)
      smartTable.selectAnchor=null;
    
    if(!e.shiftKey || smartTable.selectAnchor == null)
      smartTable.selectAnchor=tr;
      
    if(e.shiftKey && smartTable.selectAnchor != null)
      smartTable.shift(tr);
    
    if(!e.ctrlKey && !e.shiftKey && !smartTable.forceRightClick && (e.button != 2  || selected) && 
      smartTable.getTableElem(td).className.indexOf("check") == -1)
    {
      //remove
      smartTable.rightClickRow=tr;
      var anchorTr = tr;
      while(tr.previousSibling != null)
      {
        tr=tr.previousSibling;
        //skip headers
        if(tr.firstChild.className.indexOf("row") != -1)
          smartTable.fixRows(tr);        
      }
      
      tr = anchorTr;
      while(tr.nextSibling != null)
      {
        tr=tr.nextSibling;
        smartTable.fixRows(tr);
      }
    }
    
    smartTable.setForm(scope);
      
    var commands = smartTable.fixCommands(smartTable.elemFromEvent(e));
    //right click
    if(e.button == 2 || smartTable.forceRightClick)
    {
      smartTable.showRightClickMenu(e, commands);
      
      if(!hx.ie)
        e.preventDefault();
      return false;
    }     
  }
  
  this.setForm = function(scope)
  {
    if(parseInt($$(scope + "selectionCount").value) > 0)
    {
      var value = $$(scope + "working").value;
      if(value.length > 1)
        $$(scope + "selectionList").value = value.substring(1, value.length - 1);
      else
        $$(scope + "selectionList").value = "";
    }
    else
      $$(scope + "selectionList").value="";
  }
  
  this.shift = function(tr)
  {
    var start = smartTable.selectAnchor.rowIndex;
    var end   = tr.rowIndex;
    if(start > end)
    {
      var temp=end; end=start; start=temp;
    }
    
    var anchorTr = tr;
    while(tr.previousSibling != null)
    {
      tr=tr.previousSibling;
      //skip headers
      if(tr.firstChild.className.indexOf("row") != -1)
        smartTable.fixShiftRows(tr, start, end);      
    }
    
    tr = anchorTr;
    while(tr.nextSibling != null)
    {
      tr=tr.nextSibling;
      smartTable.fixShiftRows(tr, start, end);
    }

  }
  
  
  this.fixShiftRows = function(tr, start, end)
  {
    var select=false;
    if(tr.rowIndex >=start && tr.rowIndex <=end)
      select=true
    var className = "";
    var td = tr.firstChild;
    var index = td.className.indexOf("-selected");
    if(index == -1 && select)
    {
      var classNames = td.className.split(" ");
      for (var i=0; i<classNames.length; i++)
        className += classNames[i]+"-selected ";
      smartTable.add(td);
    }
    else if(index > -1 && !select)
    {
      className=td.className.substring(0, index);
      smartTable.remove(td);
    }
    else
      return;
    
    td.className=className;
    while(td.nextSibling != null)
    {
      td=td.nextSibling;
      td.className=className;
    } 
  }

  this.fixRows = function(tr)
  {
    var className = "";
    var td = tr.firstChild;
    var index = td.className.indexOf("-selected");
    if(index == -1)
      return;
    else
    {
      var classNames = td.className.split(" ");
      for (var i=0; i<classNames.length; i++)
      {
        var idx = classNames[i].indexOf("-selected");
        className += classNames[i].substring(0, idx)+" ";
      }
      smartTable.remove(td);
    }
    
    td.className=className;
    while(td.nextSibling != null)
    {
      td=td.nextSibling;
      td.className=className;
    } 
  }

  this.unselect = function(event) 
  {    
    
    try
    {
      var elem = smartTable.elemFromEvent(event);
      //a table unselects itself if the user user clicks in 
      //an element designated by the "unselect" css className
      if(elem.className == "unselect")
      {
        smartTable.unselectFromElem(elem);
      }
    }
    catch(err)
    {          
    }        
  }
  
  this.unselectFromElem = function(elem) 
  {
    var selectionLists = smartTable.findInputWithName("selectionList");
    for(var i=0; i<selectionLists.length; i++)      
      selectionLists[i].value="";
                   
    var selectionCounts = smartTable.findInputWithName("selectionCount");
    for(var i=0; i<selectionCounts.length; i++)
      selectionCounts[i].value="0";
    
    var workings = smartTable.findInputWithName("working");
    for(var i=0; i<workings.length; i++)
    {
      workings[i].value="";
    }
    
    smartTable.closeMenu();
    
    var tds = elem.getElementsByTagName("td");
    for (var i=0; i<tds.length; i++) 
    {
      var className = "";
      var td = tds[i];
      var index = td.className.indexOf("-selected");
      if(index != -1)
      {
        var classNames = td.className.split(" ");
        for (var j=0; j<classNames.length; j++)
        {
          var idx = classNames[j].indexOf("-selected");
          className += classNames[j].substring(0, idx)+" ";
        }
        td.className=className;
        smartTable.fixCommands(td);
      }
    }    
  }
  
  this.styleRow = function(elem, additionalClassName, selected)
  {
    var tds = elem.getElementsByTagName("td");
    for (var i=0; i<tds.length; i++) 
    {
      var td = tds[i];
      var className = td.className;
      if(additionalClassName != null && additionalClassName.length > 0 && 
        td.className.indexOf(additionalClassName) == -1)
        className+= " " + additionalClassName;
      
      
      var index = className.indexOf("-selected");
      if(index != -1)
      {
        var classNames = className.split(" ");
        className = "";
        for (var j=0; j<classNames.length; j++)
        {
          if(!selected)
          {
            var idx = classNames[j].indexOf("-selected");
            if(idx > -1)
              classNames[j] = classNames[j].substring(0, idx)+" ";            
          }
          className+=classNames[j] + " ";
        }
        td.className=className;        
      }
    }
  }
  
  this.unstyleRow = function(elem, selected)
  {
    var tds = elem.getElementsByTagName("td");
    for (var i=0; i<tds.length; i++) 
    {
      var className = "";      
      var td = tds[i];
      var classNames = td.className.split(" ");
      
      for (var j=0; j<classNames.length; j++)
      {
        if( j > 0 && classNames.length > 1)
          continue;
        
        className += classNames[j] + " ";        
      }
      
      var index = className.indexOf("-selected");
      if(index != -1)
      {
        if(!selected)
        {
          var idx = className.indexOf("-selected");
          className = className.substring(0, idx);
        }        
      }      
      td.className=className;      
    }
  }
  
  this.unselectScope = function(elem) 
  {
    var scope = smartTable.scope(elem);
    //a table unselects itself if the user user clicks in the outer portions of the html, 
    //or in an element designated by the "unselect" css className
    var selectionList = $$(scope + "selectionList").value="";
    var selectionCount = $$(scope + "selectionCount").value="0";
    var working = $$(scope + "working").value="";
    smartTable.selectAnchor=null;
    smartTable.rightClickRow=null;
    smartTable.fixCommands(elem);
  }

  
  this.disableSelection = function(e) 
  {
    if(!hx.ie)
      e.preventDefault();
    return smartTable.endEvent(e);
  }
  
  this.endEvent = function(event)
  {    
    if(event == null)
      return false;
    if (event.stopPropagation)
      event.stopPropagation();        
    else
      event.cancelBubble = true;
    
    event.returnValue = false;
    return false;
  }

  
  this.showRightClickMenu = function(event, commands)
  {
    smartTable.closeMenu();
    
                           //way to check if commands is empty (dont show dialog)
    if(commands == null || (commands.length == 1 && commands[0] == "0"))
      return false;
    
    var mx;
    var my;
    if (!event.target)
    {
      mx = event.clientX + document.body.scrollLeft;
      my = event.clientY + document.body.scrollTop;
    }
    else
    {
      mx = event.pageX - 5;
      my = event.pageY - 5;
    }

    var menu = document.createElement("div");
    menu.id = hx.menuId;
    menu.style.position = "absolute";
    menu.style.left = mx + "px";
    menu.style.top =  my + "px";
    document.body.appendChild(menu);
    
    var menu1 = document.createElement("div");
    menu1.className="menu-border";
    menu.appendChild(menu1);
    
    var menu2 = document.createElement("div");
    menu2.className="menu";
    menu1.appendChild(menu2);
    
    for(var i=0; i<commands.length; i++)
    {
      var menuItem = document.createElement("div");
      menuItem.className="menu-item";
      menuItem.innerHTML=commands[i].innerHTML;      
      if(menuItem.firstChild.nextSibling == null)
      {
        var text = document.createElement("text");
        text.innerHTML="&nbsp;" + commands[i].title;
        menuItem.appendChild(text);
      }
      
      var imgs = menuItem.getElementsByTagName('img');
      if(imgs.length == 1)
        imgs[0].title="";
        
      menu2.appendChild(menuItem);
      
      if( hx.ie)
      {
        menuItem.attachEvent("onmouseover", smartTable.menuOver);            
        menuItem.attachEvent("onmouseout", smartTable.menuOut);
        menuItem.attachEvent("onclick", commands[i].onclick);        
      }
      else
      {
        menuItem.addEventListener("mouseover", smartTable.menuOver, false);            
        menuItem.addEventListener("mouseout", smartTable.menuOut, false);                  
        menuItem.addEventListener("click", commands[i].onclick, false);                          
      }
    }
    
    if(hx.ie)
      menu.attachEvent("oncontextmenu", smartTable.disableSelection);
    else  
      menu.addEventListener("contextmenu", smartTable.disableSelection, false);          
  }
  
  this.menuOver = function(e)
  {
    var elem;
    if(hx.ie) elem=e.srcElement; else elem=e.target;
    if(elem.className.indexOf("menu-item") == -1)
      elem=elem.parentNode;
    //ie
    if(elem.className.indexOf("menu-item") == -1)
      elem=elem.parentNode;
      
    elem.className="menu-item-active";          
  }
  
  this.menuOut = function(e)
  {
    var elem;
    if(hx.ie) elem=e.srcElement; else elem=e.target;    
    if(elem.className.indexOf("menu-item") == -1)
      elem=elem.parentNode;
      
    //ie
    if(elem.className.indexOf("menu-item") == -1)
      elem=elem.parentNode;
      
    elem.className="menu-item";  
  }


  this.closeMenu = function()
  {
    var menu = $$(hx.menuId);
    if (menu != null) menu.parentNode.removeChild(menu);
  }
  
  this.changeLabel = function(elemName, oldDisplay, newDisplay)
  {
    var commands = document.getElementsByName(elemName);
    for (var i=0; i<commands.length; i++)     
    {
      var index = commands[i].innerHTML.indexOf(oldDisplay);
      if(index != -1)
      {
        commands[i].innerHTML = commands[i].innerHTML.replace(oldDisplay, newDisplay);
        return;
      }
    }
  }
  
  this.syntheticMouseDown = function(elem)
  {
    if(hx.ie)
    {
      var e = document.createEventObject();
      elem.fireEvent('onmousedown',e);      
    }
    else
    {
      var e = document.createEvent("MouseEvents");
      e.initEvent('mousedown', true, true);
      elem.dispatchEvent(e);      
    }
  }
  
  this.showContextMenu = function(elem, event, overrideSelectCount)
  {
    var commands = smartTable.fixCommands(elem, overrideSelectCount);
    smartTable.showRightClickMenu(event, commands);      
    return smartTable.endEvent(event);     
  }

  
  this.fixCommands = function(elem, overrideCount)
  {
    var commands = [0];
    var commandAmount = 0;
    var scope = smartTable.scope(elem);
    var single = document.getElementsByName(scope + "singleSelection");
    var count = parseInt($$(scope + "selectionCount").value);
    if(overrideCount != null)
      count=overrideCount;
    for (var i=0; i<single.length; i++) 
    {
      var enabled = count == 1;
      if(single[i].getAttribute('enablePolicy') != null)
      {
        var policy = single[i].getAttribute('enablePolicy');
        enabled = eval(policy);
      }        
      
      
      var index = single[i].className.indexOf("-disabled");
      if( index != -1 && enabled)
        single[i].className=single[i].className.substring(0, index);              
      else if(index == -1 && !enabled)
        single[i].className=single[i].className + "-disabled";
      
      if(enabled)
      {
        commands[commandAmount] = single[i];
        commandAmount++;
      }
    }
    
    var any = document.getElementsByName(scope + "anySelection");
    for (var i=0; i<any.length; i++) 
    {
      var enabled = count > 0;
      if(any[i].getAttribute('enablePolicy') != null)
      {
        var policy = any[i].getAttribute('enablePolicy');
        enabled = eval(policy);
      }  
        
      var index = any[i].className.indexOf("-disabled");
      if( index != -1 && enabled)
        any[i].className=any[i].className.substring(0, index);              
      else if(index == -1 && !enabled)
        any[i].className=any[i].className + "-disabled";
      
      if(enabled)
      {
        commands[commandAmount] = any[i];
        commandAmount++;
      }
    }
    
    
    var d = document.getElementsByName(scope + "doubleSelection");
    for (var i=0; i<d.length; i++) 
    {
      var enabled = count == 2;
      if(d[i].getAttribute('enablePolicy') != null)
      {
        var policy = d[i].getAttribute('enablePolicy');
        enabled = eval(policy);
      }  
      
      var index = d[i].className.indexOf("-disabled");
      if( index != -1 && enabled)
        d[i].className=d[i].className.substring(0, index);              
      else if(index == -1 && !enabled)
        d[i].className=d[i].className + "-disabled";
      
      if(enabled)
      {
        commands[commandAmount] = d[i];
        commandAmount++;        
      }
    }
    
    var m = document.getElementsByName(scope + "multiSelection");
    for (var i=0; i<m.length; i++) 
    {
      var enabled = count > 1;
      if(m[i].getAttribute('enablePolicy') != null)
      {
        var policy = m[i].getAttribute('enablePolicy');
        enabled = eval(policy);
      }  
      
      var index = m[i].className.indexOf("-disabled");
      if( index != -1 && enabled)
        m[i].className=m[i].className.substring(0, index);              
      else if(index == -1 && !enabled)
        m[i].className=m[i].className + "-disabled";
      
      if(enabled)
      {
        commands[commandAmount] = m[i];
        commandAmount++;        
      }
    }

    smartTable.fixCommandEvent(elem);
    if(single.length == 0 && any.length == 0 && d.length == 0 && m.length == 0)
      return null;        
    return commands;
  }
  
  
  this.fixCommandEvent = function(elem)
  {
    var scope = smartTable.scope(elem);
    var event = $$(scope + "fixCommandEvent");
    if(event != null)
      eval(event.value);    
  }
  
  this.findInputByName = function(key)
  {
    var inputs = document.body.getElementsByTagName("input");

    for (var i=0; i<inputs.length; i++)
    {
      if (inputs[i].name == key)
      {
        return inputs[i];        
      }
    }
    return null;
  }    
  
  
  this.findInputWithName = function(key)
  {
    var matched = [0];
    var matchedAmount = 0;
    var inputs = document.body.getElementsByTagName("input");

    for (var i=0; i<inputs.length; i++)
    {
      if(inputs[i].name.indexOf(key) > -1)
      {
        matched[matchedAmount] = inputs[i];
        matchedAmount++;
      }
    }
    
    inputs = document.body.getElementsByTagName("select");

    for (var i=0; i<inputs.length; i++)
    {
      if(inputs[i].name.indexOf(key) > -1)
      {
        matched[matchedAmount] = inputs[i];
        matchedAmount++;
      }
    }
    return matched;
  }
  
  this.disable = function(scope, checked)
  {
    var inputs = smartTable.findInputWithName(scope);
    for (var i=0; i<inputs.length; i++)
    {
      
      try
      {
        if(inputs[i].getAttribute("locked") !=null)
        continue;
      }
      catch(err)
      {        
      }        
              
      smartTable.disableInput(inputs[i], checked);
    }    
  }
  
  this.disableInput = function(input, checked)
  {
    if(input.type == "text")
    {
      if(checked)
        input.readOnly="";                  
      else
        input.readOnly="readOnly";        
    }
    else if(input.type != "hidden")
    {
      if(checked)
        input.disabled="";        
      else
        input.disabled="disabled";
    }
  }
  
  this.resetTable = function(scope)
  {
    var table = $$(scope + ".records");
    var tableLength = table.rows.length;
    for(var i=1; i<tableLength; i++)
      table.deleteRow(-1);
  }
  
  this.setTitle = function(title, scope)
  {
    var elem = $$(scope + ".title");
    elem.innerHTML = title;
  }
////////////////////////////////////////////////////////////////
// loading resources
////////////////////////////////////////////////////////////////
  this.addJavaScript = function(resourceString)
  {    
    var resource  = document.createElement("script");
    resource.type = "text/javascript";
    resource.src   = "/ord?" + resourceString;
    var head = document.getElementsByTagName("head")[0];
    head.appendChild(resource);
  }    
  
  this.addStyleSheet = function(resourceString)
  {    
    var resource  = document.createElement("link");
    resource.rel    = "stylesheet";
    resource.type = "text/css";
    resource.href = "/ord?" + resourceString;
    var head = document.getElementsByTagName("head")[0];
    head.appendChild(resource);
  }  
  
////////////////////////////////////////////////////////////////
// loading progress bar
////////////////////////////////////////////////////////////////
  this.checkLoading = function(loading, records)
  {
    if(loading == null)
      return false;
    if(records.className.indexOf("loaded") == -1)
    {
      loading.innerHTML="Loading.";
      return true;
    }
    return false; 
  }
  
  this.startLoading = function(span)
  {
    if(span == null)
      return;
    var text = span.innerHTML;
    this.loadingId++;
    var id =this.loadingId;     
    span.loadingId=id;
    
    var speed = 100;
    
    if( text.indexOf('.') == -1 || text.indexOf("Error") > -1 || text.indexOf("Paused") > -1 || text.indexOf("Warning") > -1)
    {
      span.style.color="black";   
      span.parentNode.style.width="222px";    
      text="Loading.";
    }
    else if(text == "&nbsp;")    
      text="Loading.";    
    
    span.className='smartTable-loading';
    
    
      
    if(text.length < 15)
    { 
      text +=".";
      span.innerHTML=text;      
    }
    
    setTimeout("smartTable.loading($$('" + span.id + "')," + speed + "," + id + ");", speed);        
  }
  
  this.loading = function(span, speed, id)
  {
    if(span == null)
      return;
    
    if(span.loadingId != id)
      return;
      
    var text = "";
    text = span.innerHTML;
       
    if( text.indexOf('.') == -1 || text.indexOf("Error") > -1 || text.indexOf("Paused") > -1 || text.indexOf("Warning") > -1)
    {
      return;
    }
    
    if(text.length < 25)
    { 
      text +=".";
      span.innerHTML=text;      
    }
    else
      span.innerHTML="Loading.";
    
    setTimeout("smartTable.loading($$('" + span.id + "'), " + speed + "," + id + ");", speed);
  }
  
  this.loadingException = function(span, message)
  {
    span.innerHTML="Error: " + message;
    span.style.color="red";   
    span.parentNode.style.width="";    
  }    
  
  this.pause = function(span)
  {
    span.innerHTML="Paused";
    span.style.color="red";   
    span.parentNode.style.width="";    
  }    
  
  this.warning = function(span, message)
  {
    span.innerHTML="Warning: " + message;
    span.style.color="red";   
    span.parentNode.style.width="";    
  }    

        
////////////////////////////////////////////////////////////////
// Sort
////////////////////////////////////////////////////////////////
  this.sort = function(columnIndex, scope, up)
  {
    var newSortColumn = $$(scope + columnIndex);    
    var upArrow   = $$(scope + "upArrow");
    var downArrow = $$(scope + "downArrow");    
    if(up)
    {
      upArrow.style.display="";
      downArrow.style.display="none";
      newSortColumn.appendChild(upArrow);
    }
    else
    {
      upArrow.style.display="none";
      downArrow.style.display="";
      newSortColumn.appendChild(downArrow);
    }
  }   
  
  /**
   * ie changeImage (workaround)
   */
  this.changeImage = function(sourceId, imgOrd)
  {
    var img = $$(sourceId).getElementsByTagName('IMG')[0];
    var parent = img.parentNode;
    var grandParent = parent.parentNode;
    //alert(grandParent.tagName + " " + parent.tagName + " " + img);
    
    var pngFix = imgOrd.indexOf(".png") > -1 || imgOrd.indexOf(".PNG") > -1;
    var span = document.createElement('span');
    var newImage = document.createElement('img');
    if(pngFix)
      span.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='/ord?" + imgOrd + "')";
    if(parent.style != null)
    {
      span.style.width = parent.style.width;
      span.style.height = parent.style.height;
    }
    if(parent.tagName != "IMG" && pngFix)
      newImage.style.filter = "progid:DXImageTransform.Microsoft.Alpha(opacity=0)";
    newImage.src='ord?' + imgOrd;
    grandParent.removeChild(parent);    
    var txt = grandParent.firstChild;
    if(txt != null)
      grandParent.removeChild(txt);
    
    if(parent.tagName == "IMG")
      grandParent.appendChild(newImage);
    else
    {
      span.appendChild(newImage);
      grandParent.appendChild(span);      
    }
    
    if(txt != null)                   
      grandParent.appendChild(txt);        
  }
    
////////////////////////////////////////////////////////////////
// Eventing
////////////////////////////////////////////////////////////////
  this.fireEvent = function(e, sourceId, path, eventId)
  {
    hx.fireEvent(path, eventId);
  }
  
  this.fireRowEvent = function(e, sourceId, path, eventId)
  {
    var td = smartTable.elemFromEvent(e);
    if(td != null && td.className.indexOf("row") == -1)
      return;
      
    hx.fireEvent(path, eventId);
  }
  
  this.addEvent = function(eventName, changeFunction, callNow, sourceId, param1, param2, param3)
  {
    var inputs = document.getElementsByName(sourceId);
    if(inputs.length == 0)
      inputs[0] = $$(sourceId);
    for(var i=0; i<inputs.length; i++)
    {
      smartTable.addEventForElem(inputs[i], eventName, changeFunction, callNow && i==0, sourceId, param1, param2, param3);
    }
  }
  
  this.addEventForElem = function(elem, eventName, changeFunction, callNow, sourceId, param1, param2, param3)
  {    
    var input = elem;
    //if(input == null)
    //  alert('Elem not found:' + sourceId);
    var storeName = "e" + eventName;
    while(input[storeName] != null)
      storeName="e" + storeName;
    
    if(hx.ie)
    {
      input[storeName] = function() { eval ( 'changeFunction(window.event, sourceId, param1, param2, param3);'); };
      input.attachEvent('on' + eventName, input[storeName]);      
      if(callNow)
        input[storeName].call(this, "", sourceId, param1, param2, param3);
    }
    else               
    {
      input[storeName]  = changeFunction;
      eval('input.addEventListener( eventName, function(event){input[storeName](event, sourceId, param1, param2, param3)}, false );' );
      if(callNow)
        input[storeName].call(this, "", sourceId, param1, param2, param3);    
    }
  }
  
  this.hideElem = function(e, sourceId, targetId, index)
  {
    var elem = $$(targetId);    
    var e = $$(sourceId);
    if(e.value != index)
      elem.style.display="none";
    else
      elem.style.display="";    
  }
  
  this.matchValue = function(e, sourceId, targetId, index)
  {
    var elem = $$(targetId);    
    var elem2 = $$(sourceId);
    elem.value=elem2.value;
  }
  
  this.matchChecked = function(e, sourceId, targetId, index)
  {
    var elem = $$(targetId);    
    var e = $$(sourceId);
    elem.checked=e.checked;
  }
  
  this.hideChecked = function(e, sourceId, targetId, checked)
  {
    var elem = $$(targetId);
    var e = $$(sourceId);    
    if((e.checked && checked == "true") || (!e.checked && checked == "false"))
      elem.style.display="none";
    else
      elem.style.display="";    
  }
  
  this.disableChecked = function(e, sourceId, targetId, checked)
  {
    
    var elem = $$(targetId);
    var e = $$(sourceId);
    
    if((e.checked && checked == "true") || (!e.checked && checked == "false"))
      smartTable.disableInput(elem, true);
    else
      smartTable.disableInput(elem, false);
  }
  
  this.hideLessThanElem = function(e, sourceId, targetId, index)
  {
    var elem = $$(targetId);    
    var e = $$(sourceId);
    if(parseInt(e.value) < parseInt(index))
      elem.style.display="none";
    else
      elem.style.display="";    
  }
  
  this.showElem = function(e, sourceId, targetId, index)
  {
    var elem = $$(targetId);    
    var e = $$(sourceId);
    if(e.value != index)
      elem.style.display="";
    else
      elem.style.display="none";    
  }
  
  this.checkInput = function(inputId)
  {
    var input = document.getElementById(inputId);
    input.checked = "true";
  }

  
  this.exception = function(sourceId, error)
  {
    var elem = $$(sourceId);
    if(elem == null)
      return;
    elem.firstChild.style.color='red';
    var td = elem.firstChild.nextSibling;
    td.style.color='red';
    if(elem.firstChild.nextSibling.nextSibling == null)
    {
      var newTd = document.createElement('td');
      newTd.style.color='red';
      newTd.innerHTML=error;
      elem.appendChild(newTd);
    }
    else
      elem.firstChild.nextSibling.nextSibling.innerHTML=error;        
  }
  
  this.clearException = function(sourceId)
  {
    var elem = $$(sourceId);
    if(elem == null)
      return;
    elem.firstChild.style.color="";
    var td = elem.firstChild.nextSibling;
    td.style.color="";
    if(elem.firstChild.nextSibling.nextSibling != null)
      elem.removeChild(elem.firstChild.nextSibling.nextSibling);
  }
  
  this.onEnter = function(e)
  {
    var keycode;
    if (window.event) 
      keycode = window.event.keyCode;
    else if (e) 
      keycode = e.which;
    else 
      return true;
    
    if (keycode == 13)
    {
      smartTable.disableSelection(e)
      smartTable.endEvent(e);
      return true;
    }  
    else
      return false;
  }
  
  this.fireOnChange = function(elem)
  {
    
    if(hx.ie)
    {
      elem.fireEvent("onchange");
    }
    else
    {
      var changeEvent=document.createEvent("HTMLEvents");
      changeEvent.initEvent("change", true, true);
      elem.dispatchEvent(changeEvent);
    }
  }
  
  this.setFormValue = function(key, value)
  {
    var newLineMatch = "\\n";
    var newLine = "\n";
    value = value.replace(/\\n/g , newLine);
    hx.setFormValue(key, value);
  }    
  
  this.registerMouseWheel = function(elem, path)
  {
    if(elem.registerMouseWheel != null)
      return;
    
    elem.registerMouseWheel=path;
    var mousewheelevt=(/Firefox/i.test(navigator.userAgent))? "DOMMouseScroll" : "mousewheel";
    if (elem.attachEvent)
      elem.attachEvent("on"+mousewheelevt, smartTable.mouseWheel)
    else if (elem.addEventListener)
      elem.addEventListener(mousewheelevt, smartTable.mouseWheel, false)
  }
  
  this.mouseWheel = function(e)
  {
    var event = window.event || e;
    var elem = smartTable.elemFromEvent(e);
    var path = elem.registerMouseWheel;
    if(path.length > 0)
      path+=".";
    var valueElem = $$(path + "smartTablePage");
    var count = parseInt($$(path + "smartTablePageCount").value);
    var currentPage = parseInt(valueElem.value);
    
    var delta=event.detail? event.detail*(-120) : event.wheelDelta;
    if(delta<=-20)
    {
      if(currentPage >= count)
      {
        if(event.preventDefault)
          event.preventDefault();
        return smartTable.endEvent(e);
      }
      valueElem.value=currentPage+1;
    }
    else
    {
      if(currentPage <= 1)
      {
        if(event.preventDefault)
          event.preventDefault();
        return smartTable.endEvent(e);
      }
      valueElem.value=currentPage-1;
    }
    
    
    smartTable.fireOnChange(valueElem);
    if(event.preventDefault)
      event.preventDefault();
    return smartTable.endEvent(event);
  }
  
  this.showDialog = function(body, title, doneText)
  {
    hx.showDialog(smartTable.dialogChrome(body, title, doneText));
  }
  
  this.dialogChrome = function(body, title, doneText)
  {
    var c = "";
    
    c += "<table border='0' align='center' height='100%'";    
    c += ">";
    c += "<tr><td valign='middle'>";
    c += "<div class='control-bg dialog-outerBorder'>";
    c += "<div class='dialog-innerBorder'>";
    c += "<div class='dialog-header'>";
    c += title;
    c += "</div>";
    c += "<div class='dialog-content'>";
    c += "<div id='dialog-maxHeight'>";
    c += body;
    c += "</div>";
    c += "</div>";
    c += "<div style='padding-top:10px; text-align:center;'>";
    c += "<input type='submit' class='button' value='" + doneText + "' onclick='hx.closeDialog(null,null,null);'/>";
    c += "</div>";
    c += "</div>";
    c += "</td></tr>";
    c += "</table>";
        
    
    return c;
  }

} 
