/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/**
 * color
 *
 * @author    JJ Frankovich 
 * @creation  6 Feb 06
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

////////////////////////////////////////////////////////////////
// Hx
////////////////////////////////////////////////////////////////

var color = new Color();
function Color()
{
  /**
   * Create a gradient
   */
  this.path="";
  
  this.createInitGradient = function()
  {
    var startingColor = document.getElementById(this.path + "preview").style.backgroundColor;
    this.createGradient(startingColor, this.path);
  }
  
  this.createGradient = function(startingColor, path)
  {
    
    var gradName=path + "gradientDiv";                          
    //alert(gradName);
    var gradientDiv=document.getElementById(gradName);
    var rgb;
    var hsb;               
    
    if(gradientDiv.childNodes.length > 0) //spans already exist
    {
      var changeMyColor=document.getElementById(path+"gradient0xy0");
      changeMyColor.style.backgroundColor = startingColor;
      
      rgb=this.parseBG(changeMyColor.style.backgroundColor);
      hsb=this.toHsb(rgb);   
      hsb[1]=0;                          
      hsb[2]=1;
      for (var y=0; y<24 ;y++)
      {
        hsb[1]=0.0;  
        for (var x=0; x<24; x++)
        {                               
          rgb=this.toRgb(hsb);
          bg = "#" + this.toHex(rgb[0]) + this.toHex(rgb[1]) + this.toHex(rgb[2])
          var changeMe=document.getElementById(path+"gradient"+x+"xy"+y);
          //var changeMe=setTimeout("document.getElementById(path+'gradient'+x+'xy'+y)",x+24*y);
          changeMe.style.backgroundColor=bg;
          hsb[1]=hsb[1]+(1.0/24.0);
        }                     
        hsb=this.toHsb(rgb)
        hsb[2]=hsb[2]-(1.0/24.0);
      }
      return;
    }
    //  return;                                      
        
    var gradient = document.createElement("span");
    
    //var style=gradient.style;
    
    gradient.style.padding = "0px";
    gradient.style.margin  = "0px";
    gradient.style.border  = "0px";
    
    gradient.style.backgroundColor = startingColor;
    rgb=this.parseBG(gradient.style.backgroundColor);
    hsb=this.toHsb(rgb);
    hsb[1]=0;                          
    hsb[2]=1;
    gradient.style.height = "4px";
    gradient.style.width  = "4px";
    gradient.style.fontSize  = "3px";
    if(hx.ie)                  
      gradient.style.styleFloat  = "left";
    else
      gradient.style.cssFloat  = "left";
      
    gradient.style.cursor = "crosshair";
    if(!hx.ie)
    {
      gradient.setAttribute("onmousedown", 
      "document.getElementById('" + path + "mouseDown').value='true';");
      gradient.setAttribute("onmouseup", 
      "document.getElementById('" + path + "mouseDown').value='false';");
      gradient.setAttribute("onmouseover",
      "if(document.getElementById('" + path + "mouseDown').value=='true')" +
      "{document.getElementById('" + path + "preview').style.backgroundColor=" +
      "this.style.backgroundColor;"+                                                  
      "document.getElementById('" + path + "previewToSave').value=this.style.backgroundColor;}");
      gradient.setAttribute("onclick",
      "document.getElementById('" + path + "preview').style.backgroundColor=" +
      "this.style.backgroundColor;"+                                                  
      "document.getElementById('" + path + "previewToSave').value=this.style.backgroundColor;");
    }
    else
    {
      gradient.attachEvent("onclick", this.clicked);
//      gradient.attachEvent("onmouseover",this.mouseOver);
//      gradient.attachEvent("onmouseup",this.mouseUp);
//      gradient.attachEvent("onmousedown",this.mouseDown);
    }
    
    for (var y=0; y<24 ;y++)
    {
      hsb[1]=0.0;  
      for (var x=0; x<24; x++)
      {                               
        rgb=this.toRgb(hsb);
        bg = "#" + this.toHex(rgb[0]) + this.toHex(rgb[1]) + this.toHex(rgb[2])
        gradient.style.backgroundColor=bg;
        gradient.id=path + "gradient" + x + "x" + "y" + y;
        gradient.name=path + "gradient" + x + "x" + "y" + y;
        var temp=gradient.cloneNode(false);
        gradientDiv.appendChild(temp);
//        temp.addEventListener("click",this.clickMe(temp,path),false);
//        
        hsb[1]=hsb[1]+(1.0/24.0);
        
        
      }                     
      hsb=this.toHsb(rgb)
      hsb[2]=hsb[2]-(1.0/24.0);
      //hsb[2]-=(1.0/(double)height);
    }
  }     
  this.mouseUp = function(e)
  {
    var targ = e.srcElement;
    var path=targ.id.split(".")[0];
    document.getElementById( path + ".mouseDown").value="false";
  }
  
  this.mouseDown = function(e)
  {
    var targ = e.srcElement;
    var path=targ.id.split(".")[0];
    document.getElementById( path + ".mouseDown").value="true";
  }                                                           
  
  this.mouseOver = function(e)
  {
    var targ = e.srcElement;
    var path=targ.id.split(".")[0];
    if(document.getElementById( path + ".mouseDown").value=="true")
    {
      document.getElementById(path + ".preview").style.backgroundColor=targ.style.backgroundColor;
      document.getElementById(path + ".previewToSave").value=targ.style.backgroundColor;
    }                                
  } 
  
  this.clicked = function(e)
  {
    var targ= e.srcElement;
    var dot = targ.id.lastIndexOf(".");
    var path=targ.id.substring(0,dot);
    document.getElementById(path + ".preview").style.backgroundColor=targ.style.backgroundColor;
    document.getElementById(path + ".previewToSave").value=targ.style.backgroundColor;
  }
                  
  this.parseBG = function(bg)
  {
    if(hx.ie)
      return this.parseBGie(bg);
    else
      return this.parseBGfireFox(bg)
  }

  this.parseBGfireFox = function(bg)
  {
    var r;
    var g;
    var b   
    bg=bg.split("(")[1].split(")")[0];
    var split=bg.split(",");
    return split;
    
  }
  
  this.parseBGie = function(bg)
  {
    //#ffccaa    
    var rgb= new Array(3)
    rgb[0]=parseInt(bg.substring(1,3),16);
    rgb[1]=parseInt(bg.substring(3,5),16);;
    rgb[2]=parseInt(bg.substring(5,7),16);   
    return rgb;
    
  }
  
  this.toHsb = function(rgb)
  {
    var r = parseInt(rgb[0]) / 255.0;
    var g = parseInt(rgb[1]) / 255.0;
    var b = parseInt(rgb[2]) / 255.0;
    
    var max = Math.max(r, Math.max(g, b));
    var min = Math.min(r, Math.min(g, b));
    
    var h = 0;
    var s = 0;
    var v = max;
    
    if (max != 0) 
      s = (max - min) / max;
    else 
      s = 0;
    
    if (s == 0) 
      h = 0;
    else
    {
      var delta = max - min;
      if (r == max) h = (g - b) / delta;
      else if (g == max) h = 2 + (b - r) / delta;
      else if (b == max) h = 4 + (r - g) / delta;
      h = h * 60;
      if (h < 0) h = h + 360;
    }           
    var hsb= new Array(3)
    hsb[0]=h;
    hsb[1]=s;
    hsb[2]=v;
    
    return hsb;
  }
  
  //  public static BColor toRgb(double[] hsb)
  this.toRgb = function(hsb)
  {
    var h = hsb[0];
    var s = hsb[1];
    var v = hsb[2];
    
    var r = 0;
    var g = 0;
    var b = 0;
    
    if (s == 0)
    {
      r = v;
      g = v;
      b = v;
    }
    else
    {
      if (h == 360) h = 0;
      h = h / 60;
      var i = parseInt(Math.floor(h));
      var f = h - i;
      var p = v * (1 - s);
      var q = v * (1 - (s * f));
      var t = v * (1 - (s * (1 - f)));
      
      switch (i)
      {
        case 0: r = v; g = t; b = p; break;
        case 1: r = q; g = v; b = p; break;
        case 2: r = p; g = v; b = t; break;
        case 3: r = p; g = q; b = v; break;
        case 4: r = t; g = p; b = v; break;
        case 5: r = v; g = p; b = q; break;
        default: alert("Illegal State");
      }
    }    
    
    var ir = parseInt(r * 255);
    var ig = parseInt(g * 255);
    var ib = parseInt(b * 255);
    
    var rgb= new Array(3)
    
    rgb[0]=ir;
    rgb[1]=ig;
    rgb[2]=ib;
    return rgb;
  }
   
  this.toHex = function(num)
  {
    if (num < 16)
      return '0' + num.toString(16);
    else
      return num.toString(16);
  } 
}  

