/*

 Title: jqPlot Charts

 Pure JavaScript plotting plugin for jQuery.

 About: Version

 1.0.0b2_r947 

 About: Copyright & License

 Copyright (c) 2009-2011 Chris Leonello
 jqPlot is currently available for use in all personal or commercial projects 
 under both the MIT and GPL version 2.0 licenses. This means that you can 
 choose the license that best suits your project and use it accordingly.

 See <GPL Version 2> and <MIT License> contained within this distribution for further information. 

 The author would appreciate an email letting him know of any substantial
 use of jqPlot.  You can reach the author at: chris at jqplot dot com 
 or see http://www.jqplot.com/info.php.  This is, of course, not required.

 If you are feeling kind and generous, consider supporting the project by
 making a donation at: http://www.jqplot.com/donate.php.

 sprintf functions contained in jqplot.sprintf.js by Ash Searle:

 version 2007.04.27
 author Ash Searle
 http://hexmen.com/blog/2007/03/printf-sprintf/
 http://hexmen.com/js/sprintf.js
 The author (Ash Searle) has placed this code in the public domain:
 "This code is unrestricted: you are free to use it however you like."


 About: Introduction

 jqPlot requires jQuery (1.4+ required for certain features). jQuery 1.4.2 is included in the distribution.  
 To use jqPlot include jQuery, the jqPlot jQuery plugin, the jqPlot css file and optionally 
 the excanvas script for IE support in your web page:

 > <!--[if lt IE 9]><script language="javascript" type="text/javascript" src="excanvas.js"></script><![endif]-->
 > <script language="javascript" type="text/javascript" src="jquery-1.4.4.min.js"></script>
 > <script language="javascript" type="text/javascript" src="jquery.jqplot.min.js"></script>
 > <link rel="stylesheet" type="text/css" href="jquery.jqplot.css" />

 jqPlot can be customized by overriding the defaults of any of the objects which make
 up the plot. The general usage of jqplot is:

 > chart = $.jqplot('targetElemId', [dataArray,...], {optionsObject});

 The options available to jqplot are detailed in <jqPlot Options> in the jqPlotOptions.txt file.

 An actual call to $.jqplot() may look like the 
 examples below:

 > chart = $.jqplot('chartdiv',  [[[1, 2],[3,5.12],[5,13.1],[7,33.6],[9,85.9],[11,219.9]]]);

 or

 > dataArray = [34,12,43,55,77];
 > chart = $.jqplot('targetElemId', [dataArray, ...], {title:'My Plot', axes:{yaxis:{min:20, max:100}}});

 For more inforrmation, see <jqPlot Usage>.

 About: Usage

 See <jqPlot Usage>

 About: Available Options 

 See <jqPlot Options> for a list of options available thorugh the options object (not complete yet!)

 About: Options Usage

 See <Options Tutorial>

 About: Changes

 See <Change Log>

*/
(function(g){function y(a){g.jqplot.ElemContainer.call(this);this.name=a;this._series=[];this.show=false;this.tickRenderer=g.jqplot.AxisTickRenderer;this.tickOptions={};this.labelRenderer=g.jqplot.AxisLabelRenderer;this.labelOptions={};this.label=null;this.showLabel=true;this.max=this.min=null;this.autoscale=false;this.pad=1.2;this.padMin=this.padMax=null;this.ticks=[];this.renderer=g.jqplot.LinearAxisRenderer;this.rendererOptions={};this.drawMajorGridlines=this.showMinorTicks=this.showTickMarks=
this.showTicks=true;this.drawMinorGridlines=false;this.drawMinorTickMarks=this.drawMajorTickMarks=true;this.useSeriesColor=false;this.borderColor=this.borderWidth=null;this._dataBounds={min:null,max:null};this._intervalStats=[];this._offsets={min:null,max:null};this._ticks=[];this.syncTicks=this._label=null;this.tickSpacing=75;this.__ticks=this._numberTicks=this._tickInterval=this._max=this._min=null;this._options={}}function J(a){g.jqplot.ElemContainer.call(this);this.show=false;this.location="ne";
this.labels=[];this.showSwatches=this.showLabels=true;this.placement="insideGrid";this.yoffset=this.xoffset=0;this.rowSpacing="0.5em";this.renderer=g.jqplot.TableLegendRenderer;this.rendererOptions={};this.preDraw=false;this.marginLeft=this.marginBottom=this.marginRight=this.marginTop=null;this.escapeHtml=false;this._series=[];g.extend(true,this,a)}function N(a){g.jqplot.ElemContainer.call(this);this.text=a;this.show=true;this.renderer=g.jqplot.DivTitleRenderer;this.rendererOptions={};this.escapeHtml=
false}function K(){g.jqplot.ElemContainer.call(this);this.show=true;this.xaxis="xaxis";this.yaxis="yaxis";this.gridBorderWidth=2;this.renderer=g.jqplot.LineRenderer;this.rendererOptions={};this.data=[];this.gridData=[];this.label="";this.showLabel=true;this.lineWidth=2.5;this.lineCap=this.lineJoin="round";this.linePattern="solid";this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.25;this.shadowDepth=3;this.shadowAlpha="0.1";this.breakOnNull=false;this.markerRenderer=g.jqplot.MarkerRenderer;
this.markerOptions={};this.showMarker=this.showLine=true;this._stack=this.disableStack=this.fillAndStroke=this.fill=false;this.neighborThreshold=4;this.fillToZero=false;this.fillToValue=0;this.fillAxis="y";this.useNegativeColors=true;this._stackData=[];this._plotData=[];this._plotValues={x:[],y:[]};this._intervals={x:{},y:{}};this._prevPlotData=[];this._prevGridData=[];this._stackAxis="y";this._primaryAxis="_xaxis";this.canvas=new g.jqplot.GenericCanvas;this.shadowCanvas=new g.jqplot.GenericCanvas;
this.plugins={};this._sumx=this._sumy=0;this._type=""}function O(){g.jqplot.ElemContainer.call(this);this.drawGridlines=true;this.gridLineColor="#cccccc";this.gridLineWidth=1;this.background="#fffdf6";this.borderColor="#999999";this.borderWidth=2;this.shadow=this.drawBorder=true;this.shadowAngle=45;this.shadowOffset=1.5;this.shadowDepth=this.shadowWidth=3;this.shadowColor=null;this.shadowAlpha="0.07";this._axes=[];this.renderer=g.jqplot.CanvasGridRenderer;this.rendererOptions={};this._offsets={top:null,
bottom:null,left:null,right:null}}function ga(){function a(b){for(var e,i=0;i<b.length;i++)for(var f,h=[b[i].data,b[i]._stackData,b[i]._plotData,b[i]._prevPlotData],l=0;l<4;l++){f=true;e=h[l];if(b[i]._stackAxis=="x"){for(var j=0;j<e.length;j++)if(typeof e[j][1]!="number"){f=false;break}f&&e.sort(function(n,k){return n[1]-k[1]})}else{for(j=0;j<e.length;j++)if(typeof e[j][0]!="number"){f=false;break}f&&e.sort(function(n,k){return n[0]-k[0]})}}}function c(b){var e=b.data.plot,i=e.eventCanvas._elem.offset();
b={x:b.pageX-i.left,y:b.pageY-i.top};var f={xaxis:null,yaxis:null,x2axis:null,y2axis:null,y3axis:null,y4axis:null,y5axis:null,y6axis:null,y7axis:null,y8axis:null,y9axis:null,yMidAxis:null},h=["xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis","yMidAxis"];e=e.axes;var l,j;for(l=11;l>0;l--){j=h[l-1];if(e[j].show)f[j]=e[j].series_p2u(b[j.charAt(0)])}return{offsets:i,gridPos:b,dataPos:f}}function d(b,e){var i=e.series,f,h,l,j,n,k,m,o,s,r,p,u;for(l=e.seriesStack.length-
1;l>=0;l--){f=e.seriesStack[l];j=i[f];switch(j.renderer.constructor){case g.jqplot.BarRenderer:case g.jqplot.PyramidRenderer:k=b.x;m=b.y;for(h=0;h<j._barPoints.length;h++){f=j._barPoints[h];p=j.gridData[h];if(k>f[0][0]&&k<f[2][0]&&m>f[2][1]&&m<f[0][1])return{seriesIndex:j.index,pointIndex:h,gridData:p,data:j.data[h],points:j._barPoints[h]}}break;case g.jqplot.DonutRenderer:h=j.startAngle/180*Math.PI;k=b.x-j._center[0];m=b.y-j._center[1];n=Math.sqrt(Math.pow(k,2)+Math.pow(m,2));if(k>0&&-m>=0)o=2*Math.PI-
Math.atan(-m/k);else if(k>0&&-m<0)o=-Math.atan(-m/k);else if(k<0)o=Math.PI-Math.atan(-m/k);else if(k==0&&-m>0)o=3*Math.PI/2;else if(k==0&&-m<0)o=Math.PI/2;else if(k==0&&m==0)o=0;if(h){o-=h;if(o<0)o+=2*Math.PI;else if(o>2*Math.PI)o-=2*Math.PI}k=j.sliceMargin/180*Math.PI;if(n<j._radius&&n>j._innerRadius)for(h=0;h<j.gridData.length;h++){m=h>0?j.gridData[h-1][1]+k:k;f=j.gridData[h][1];if(o>m&&o<f)return{seriesIndex:j.index,pointIndex:h,gridData:j.gridData[h],data:j.data[h]}}break;case g.jqplot.PieRenderer:h=
j.startAngle/180*Math.PI;k=b.x-j._center[0];m=b.y-j._center[1];n=Math.sqrt(Math.pow(k,2)+Math.pow(m,2));if(k>0&&-m>=0)o=2*Math.PI-Math.atan(-m/k);else if(k>0&&-m<0)o=-Math.atan(-m/k);else if(k<0)o=Math.PI-Math.atan(-m/k);else if(k==0&&-m>0)o=3*Math.PI/2;else if(k==0&&-m<0)o=Math.PI/2;else if(k==0&&m==0)o=0;if(h){o-=h;if(o<0)o+=2*Math.PI;else if(o>2*Math.PI)o-=2*Math.PI}k=j.sliceMargin/180*Math.PI;if(n<j._radius)for(h=0;h<j.gridData.length;h++){m=h>0?j.gridData[h-1][1]+k:k;f=j.gridData[h][1];if(o>
m&&o<f)return{seriesIndex:j.index,pointIndex:h,gridData:j.gridData[h],data:j.data[h]}}break;case g.jqplot.BubbleRenderer:k=b.x;m=b.y;n=null;if(j.show){for(h=0;h<j.gridData.length;h++){p=j.gridData[h];r=Math.sqrt((k-p[0])*(k-p[0])+(m-p[1])*(m-p[1]));if(r<=p[2]&&(r<=s||s==null)){s=r;n={seriesIndex:f,pointIndex:h,gridData:p,data:j.data[h]}}}if(n!=null)return n}break;case g.jqplot.FunnelRenderer:k=b.x;m=b.y;f=j._vertices;h=f[0];p=f[f.length-1];r=function(t,v,x){x=(v[1]-x[1])/(v[0]-x[0]);t+=v[1];return[(t-
(v[1]-x*v[0]))/x,t]};n=r(m,h[0],p[3]);p=r(m,h[1],p[2]);for(h=0;h<f.length;h++){r=f[h];if(m>=r[0][1]&&m<=r[3][1]&&k>=n[0]&&k<=p[0])return{seriesIndex:j.index,pointIndex:h,gridData:null,data:j.data[h]}}break;case g.jqplot.LineRenderer:k=b.x;m=b.y;n=j.renderer;if(j.show)if((j.fill||j.renderer.bands.show&&j.renderer.bands.fill)&&(!e.plugins.highlighter||!e.plugins.highlighter.show)){n=false;if(k>j._boundingBox[0][0]&&k<j._boundingBox[1][0]&&m>j._boundingBox[1][1]&&m<j._boundingBox[0][1]){p=j._areaPoints.length;
h=p-1;for(r=0;r<p;r++){u=[j._areaPoints[r][0],j._areaPoints[r][1]];h=[j._areaPoints[h][0],j._areaPoints[h][1]];if(u[1]<m&&h[1]>=m||h[1]<m&&u[1]>=m)if(u[0]+(m-u[1])/(h[1]-u[1])*(h[0]-u[0])<k)n=!n;h=r}}if(n)return{seriesIndex:f,pointIndex:null,gridData:j.gridData,data:j.data,points:j._areaPoints};break}else{h=j.markerRenderer.size/2+j.neighborThreshold;u=h>0?h:0;for(h=0;h<j.gridData.length;h++){p=j.gridData[h];if(n.constructor==g.jqplot.OHLCRenderer)if(n.candleStick){r=j._yaxis.series_u2p;if(k>=p[0]-
n._bodyWidth/2&&k<=p[0]+n._bodyWidth/2&&m>=r(j.data[h][2])&&m<=r(j.data[h][3]))return{seriesIndex:f,pointIndex:h,gridData:p,data:j.data[h]}}else if(n.hlc){r=j._yaxis.series_u2p;if(k>=p[0]-n._tickLength&&k<=p[0]+n._tickLength&&m>=r(j.data[h][1])&&m<=r(j.data[h][2]))return{seriesIndex:f,pointIndex:h,gridData:p,data:j.data[h]}}else{r=j._yaxis.series_u2p;if(k>=p[0]-n._tickLength&&k<=p[0]+n._tickLength&&m>=r(j.data[h][2])&&m<=r(j.data[h][3]))return{seriesIndex:f,pointIndex:h,gridData:p,data:j.data[h]}}else if(p[0]!=
null&&p[1]!=null){r=Math.sqrt((k-p[0])*(k-p[0])+(m-p[1])*(m-p[1]));if(r<=u&&(r<=s||s==null)){s=r;return{seriesIndex:f,pointIndex:h,gridData:p,data:j.data[h]}}}}}break;default:k=b.x;m=b.y;n=j.renderer;if(j.show){h=j.markerRenderer.size/2+j.neighborThreshold;u=h>0?h:0;for(h=0;h<j.gridData.length;h++){p=j.gridData[h];if(n.constructor==g.jqplot.OHLCRenderer)if(n.candleStick){r=j._yaxis.series_u2p;if(k>=p[0]-n._bodyWidth/2&&k<=p[0]+n._bodyWidth/2&&m>=r(j.data[h][2])&&m<=r(j.data[h][3]))return{seriesIndex:f,
pointIndex:h,gridData:p,data:j.data[h]}}else if(n.hlc){r=j._yaxis.series_u2p;if(k>=p[0]-n._tickLength&&k<=p[0]+n._tickLength&&m>=r(j.data[h][1])&&m<=r(j.data[h][2]))return{seriesIndex:f,pointIndex:h,gridData:p,data:j.data[h]}}else{r=j._yaxis.series_u2p;if(k>=p[0]-n._tickLength&&k<=p[0]+n._tickLength&&m>=r(j.data[h][2])&&m<=r(j.data[h][3]))return{seriesIndex:f,pointIndex:h,gridData:p,data:j.data[h]}}else{r=Math.sqrt((k-p[0])*(k-p[0])+(m-p[1])*(m-p[1]));if(r<=u&&(r<=s||s==null)){s=r;return{seriesIndex:f,
pointIndex:h,gridData:p,data:j.data[h]}}}}}}}return null}this.data=[];this.noDataIndicator={show:false,indicator:"Loading Data...",axes:{xaxis:{min:0,max:10,tickInterval:2,show:true},yaxis:{min:0,max:12,tickInterval:3,show:true}}};this.target=this.targetId=null;this.defaults={axesDefaults:{},axes:{xaxis:{},yaxis:{},x2axis:{},y2axis:{},y3axis:{},y4axis:{},y5axis:{},y6axis:{},y7axis:{},y8axis:{},y9axis:{},yMidAxis:{}},seriesDefaults:{},series:[]};this.series=[];this.axes={xaxis:new y("xaxis"),yaxis:new y("yaxis"),
x2axis:new y("x2axis"),y2axis:new y("y2axis"),y3axis:new y("y3axis"),y4axis:new y("y4axis"),y5axis:new y("y5axis"),y6axis:new y("y6axis"),y7axis:new y("y7axis"),y8axis:new y("y8axis"),y9axis:new y("y9axis"),yMidAxis:new y("yMidAxis")};this.grid=new O;this.legend=new J;this.baseCanvas=new g.jqplot.GenericCanvas;this.seriesStack=[];this.previousSeriesStack=[];this.eventCanvas=new g.jqplot.GenericCanvas;this._height=this._width=null;this._plotDimensions={height:null,width:null};this._gridPadding={top:null,
right:null,bottom:null,left:null};this._defaultGridPadding={top:10,right:10,bottom:23,left:10};this.syncYTicks=this.syncXTicks=true;this.seriesColors=g.jqplot.config.defaultColors;this.negativeSeriesColors=g.jqplot.config.defaultNegativeColors;this.sortData=true;this.title=new N;this.options={};this.stackSeries=false;this.defaultAxisStart=1;this._stackData=[];this._plotData=[];this.plugins={};this._drawCount=0;this.captureRightClick=this.drawIfHidden=false;this.themeEngine=new g.jqplot.ThemeEngine;
this._sumx=this._sumy=0;this.preInitHooks=new g.jqplot.HooksManager;this.postInitHooks=new g.jqplot.HooksManager;this.preParseOptionsHooks=new g.jqplot.HooksManager;this.postParseOptionsHooks=new g.jqplot.HooksManager;this.preDrawHooks=new g.jqplot.HooksManager;this.postDrawHooks=new g.jqplot.HooksManager;this.preDrawSeriesHooks=new g.jqplot.HooksManager;this.postDrawSeriesHooks=new g.jqplot.HooksManager;this.preDrawLegendHooks=new g.jqplot.HooksManager;this.addLegendRowHooks=new g.jqplot.HooksManager;
this.preSeriesInitHooks=new g.jqplot.HooksManager;this.postSeriesInitHooks=new g.jqplot.HooksManager;this.preParseSeriesOptionsHooks=new g.jqplot.HooksManager;this.postParseSeriesOptionsHooks=new g.jqplot.HooksManager;this.eventListenerHooks=new g.jqplot.EventListenerManager;this.preDrawSeriesShadowHooks=new g.jqplot.HooksManager;this.postDrawSeriesShadowHooks=new g.jqplot.HooksManager;this.colorGenerator=new g.jqplot.ColorGenerator;this.negativeColorGenerator=new g.jqplot.ColorGenerator;this.canvasManager=
new g.jqplot.CanvasManager;this.init=function(b,e,i){i=i||{};for(var f=0;f<g.jqplot.preInitHooks.length;f++)g.jqplot.preInitHooks[f].call(this,b,e,i);for(f=0;f<this.preInitHooks.hooks.length;f++)this.preInitHooks.hooks[f].call(this,b,e,i);this.targetId="#"+b;this.target=g("#"+b);this.target.removeClass("jqplot-error");if(!this.target.get(0))throw"No plot target specified";this.target.css("position")=="static"&&this.target.css("position","relative");this.target.hasClass("jqplot-target")||this.target.addClass("jqplot-target");
if(this.target.height())this._height=f=this.target.height();else{this._height=f=i&&i.height?parseInt(i.height,10):this.target.attr("data-height")?parseInt(this.target.attr("data-height"),10):parseInt(g.jqplot.config.defaultHeight,10);this.target.css("height",f+"px")}if(this.target.width())this._width=f=this.target.width();else{this._width=f=i&&i.width?parseInt(i.width,10):this.target.attr("data-width")?parseInt(this.target.attr("data-width"),10):parseInt(g.jqplot.config.defaultWidth,10);this.target.css("width",
f+"px")}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;if(this._height<=0||this._width<=0||!this._height||!this._width)throw"Canvas dimension not set";if(i.dataRenderer&&jQuery.isFunction(i.dataRenderer)){if(i.dataRendererOptions)this.dataRendererOptions=
i.dataRendererOptions;this.dataRenderer=i.dataRenderer;e=this.dataRenderer(e,this,this.dataRendererOptions)}i.noDataIndicator&&jQuery.isPlainObject(i.noDataIndicator)&&g.extend(true,this.noDataIndicator,i.noDataIndicator);if(e==null||jQuery.isArray(e)==false||e.length==0||jQuery.isArray(e[0])==false||e[0].length==0)if(this.noDataIndicator.show==false)throw{name:"DataError",message:"No data to plot."};else{for(var h in this.noDataIndicator.axes)for(var l in this.noDataIndicator.axes[h])this.axes[h][l]=
this.noDataIndicator.axes[h][l];this.postDrawHooks.add(function(){var j=this.eventCanvas.getHeight(),n=this.eventCanvas.getWidth(),k=g('<div class="jqplot-noData-container" style="position:absolute;"></div>');this.target.append(k);k.height(j);k.width(n);k.css("top",this.eventCanvas._offsets.top);k.css("left",this.eventCanvas._offsets.left);n=g('<div class="jqplot-noData-contents" style="text-align:center; position:relative; margin-left:auto; margin-right:auto;"></div>');k.append(n);n.html(this.noDataIndicator.indicator);
k=n.height();var m=n.width();n.height(k);n.width(m);n.css("top",(j-k)/2+"px")})}this.data=e;this.parseOptions(i);this.textColor&&this.target.css("color",this.textColor);this.fontFamily&&this.target.css("font-family",this.fontFamily);this.fontSize&&this.target.css("font-size",this.fontSize);this.title.init();this.legend.init();for(f=this._sumx=this._sumy=0;f<this.series.length;f++){this.seriesStack.push(f);this.previousSeriesStack.push(f);this.series[f].shadowCanvas._plotDimensions=this._plotDimensions;
this.series[f].canvas._plotDimensions=this._plotDimensions;for(h=0;h<g.jqplot.preSeriesInitHooks.length;h++)g.jqplot.preSeriesInitHooks[h].call(this.series[f],b,e,this.options.seriesDefaults,this.options.series[f],this);for(h=0;h<this.preSeriesInitHooks.hooks.length;h++)this.preSeriesInitHooks.hooks[h].call(this.series[f],b,e,this.options.seriesDefaults,this.options.series[f],this);this.populatePlotData(this.series[f],f);this.series[f]._plotDimensions=this._plotDimensions;this.series[f].init(f,this.grid.borderWidth,
this);for(h=0;h<g.jqplot.postSeriesInitHooks.length;h++)g.jqplot.postSeriesInitHooks[h].call(this.series[f],b,e,this.options.seriesDefaults,this.options.series[f],this);for(h=0;h<this.postSeriesInitHooks.hooks.length;h++)this.postSeriesInitHooks.hooks[h].call(this.series[f],b,e,this.options.seriesDefaults,this.options.series[f],this);this._sumy+=this.series[f]._sumy;this._sumx+=this.series[f]._sumx}for(f=0;f<12;f++){name=T[f];this.axes[name]._plotDimensions=this._plotDimensions;this.axes[name].init();
if(this.axes[name].borderColor==null)this.axes[name].borderColor=name.charAt(0)!=="x"&&this.axes[name].useSeriesColor===true&&this.axes[name].show?this.axes[name]._series[0].color:this.grid.borderColor}this.sortData&&a(this.series);this.grid.init();this.grid._axes=this.axes;this.legend._series=this.series;for(f=0;f<g.jqplot.postInitHooks.length;f++)g.jqplot.postInitHooks[f].call(this,b,e,i);for(f=0;f<this.postInitHooks.hooks.length;f++)this.postInitHooks.hooks[f].call(this,b,e,i)};this.resetAxesScale=
function(b,e){var i=e||{},f=b||this.axes;if(f===true)f=this.axes;if(jQuery.isArray(f))for(var h=0;h<f.length;h++)this.axes[f[h]].resetScale(i[f[h]]);else if(typeof f==="object")for(h in f)this.axes[h].resetScale(i[h])};this.reInitialize=function(){this._height=this.target.height();this._width=this.target.width();if(this._height<=0||this._width<=0||!this._height||!this._width)throw"Target dimension not set";this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=
this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;for(var b in this.axes){this.axes[b]._plotWidth=this._width;this.axes[b]._plotHeight=this._height}this.title._plotWidth=this._width;this.textColor&&this.target.css("color",this.textColor);this.fontFamily&&this.target.css("font-family",this.fontFamily);this.fontSize&&this.target.css("font-size",
this.fontSize);for(b=this._sumx=this._sumy=0;b<this.series.length;b++){this.populatePlotData(this.series[b],b);this.series[b]._type==="line"&&this.series[b].renderer.bands.show&&this.series[b].renderer.initBands.call(this.series[b],this.series[b].renderer.options,this);this.series[b]._plotDimensions=this._plotDimensions;this.series[b].canvas._plotDimensions=this._plotDimensions;this._sumy+=this.series[b]._sumy;this._sumx+=this.series[b]._sumx}for(var e=0;e<12;e++){name=T[e];var i=this.axes[name]._ticks;
for(b=0;b<i.length;b++){var f=i[b]._elem;if(f){g.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==A&&window.G_vmlCanvasManager.uninitElement(f.get(0));f.emptyForce();i._elem=null}}this.axes[name]._plotDimensions=this._plotDimensions;this.axes[name]._ticks=[]}this.sortData&&a(this.series);this.grid._axes=this.axes;this.legend._series=this.series};this.populatePlotData=function(b,e){this._plotData=[];this._stackData=[];b._stackData=[];b._plotData=[];var i={x:[],y:[]};if(this.stackSeries&&
!b.disableStack){b._stack=true;for(var f=b._stackAxis=="x"?0:1,h=g.extend(true,[],b.data),l=g.extend(true,[],b.data),j=0;j<e;j++)for(var n=this.series[j].data,k=0;k<n.length;k++){h[k][0]+=n[k][0];h[k][1]+=n[k][1];l[k][f]+=n[k][f]}for(f=0;f<l.length;f++){i.x.push(l[f][0]);i.y.push(l[f][1])}this._plotData.push(l);this._stackData.push(h);b._stackData=h;b._plotData=l}else{for(f=0;f<b.data.length;f++){i.x.push(b.data[f][0]);i.y.push(b.data[f][1])}this._stackData.push(b.data);this.series[e]._stackData=
b.data;this._plotData.push(b.data);b._plotData=b.data}b._plotValues=i;if(e>0)b._prevPlotData=this.series[e-1]._plotData;b._sumy=0;b._sumx=0;for(f=b.data.length-1;f>-1;f--){b._sumy+=b.data[f][1];b._sumx+=b.data[f][0]}};this.getNextSeriesColor=function(b){var e=0,i=b.seriesColors;return function(){e<i.length||(e=0);return i[e++]}}(this);this.parseOptions=function(b){for(var e=0;e<this.preParseOptionsHooks.hooks.length;e++)this.preParseOptionsHooks.hooks[e].call(this,b);for(e=0;e<g.jqplot.preParseOptionsHooks.length;e++)g.jqplot.preParseOptionsHooks[e].call(this,
b);this.options=g.extend(true,{},this.defaults,b);this.stackSeries=this.options.stackSeries;if(this.options.seriesColors)this.seriesColors=this.options.seriesColors;if(this.options.negativeSeriesColors)this.negativeSeriesColors=this.options.negativeSeriesColors;if(this.options.captureRightClick)this.captureRightClick=this.options.captureRightClick;this.defaultAxisStart=b&&b.defaultAxisStart!=null?b.defaultAxisStart:this.defaultAxisStart;this.colorGenerator.setColors(this.seriesColors);this.negativeColorGenerator.setColors(this.negativeSeriesColors);
g.extend(true,this._gridPadding,this.options.gridPadding);this.sortData=this.options.sortData!=null?this.options.sortData:this.sortData;for(e=0;e<12;e++){var i=T[e],f=this.axes[i];f._options=g.extend(true,{},this.options.axesDefaults,this.options.axes[i]);g.extend(true,f,this.options.axesDefaults,this.options.axes[i]);f._plotWidth=this._width;f._plotHeight=this._height}i=function(l,j,n){var k=[],m;j=j||"vertical";if(jQuery.isArray(l[0]))g.extend(true,k,l);else for(m=0;m<l.length;m++)j=="vertical"?
k.push([n+m,l[m]]):k.push([l[m],n+m]);return k};for(e=0;e<this.data.length;e++){f=new K;for(var h=0;h<g.jqplot.preParseSeriesOptionsHooks.length;h++)g.jqplot.preParseSeriesOptionsHooks[h].call(f,this.options.seriesDefaults,this.options.series[e]);for(h=0;h<this.preParseSeriesOptionsHooks.hooks.length;h++)this.preParseSeriesOptionsHooks.hooks[h].call(f,this.options.seriesDefaults,this.options.series[e]);g.extend(true,f,{seriesColors:this.seriesColors,negativeSeriesColors:this.negativeSeriesColors},
this.options.seriesDefaults,this.options.series[e]);h="vertical";if(f.renderer===g.jqplot.BarRenderer&&f.rendererOptions&&f.rendererOptions.barDirection=="horizontal"&&f.transposeData===true)h="horizontal";f.data=i(this.data[e],h,this.defaultAxisStart);switch(f.xaxis){case "xaxis":f._xaxis=this.axes.xaxis;break;case "x2axis":f._xaxis=this.axes.x2axis}f._yaxis=this.axes[f.yaxis];f._xaxis._series.push(f);f._yaxis._series.push(f);if(f.show){f._xaxis.show=true;f._yaxis.show=true}if(!f.label)f.label="Series "+
(e+1).toString();this.series.push(f);for(h=0;h<g.jqplot.postParseSeriesOptionsHooks.length;h++)g.jqplot.postParseSeriesOptionsHooks[h].call(this.series[e],this.options.seriesDefaults,this.options.series[e]);for(h=0;h<this.postParseSeriesOptionsHooks.hooks.length;h++)this.postParseSeriesOptionsHooks.hooks[h].call(this.series[e],this.options.seriesDefaults,this.options.series[e])}g.extend(true,this.grid,this.options.grid);for(e=0;e<12;e++){i=T[e];f=this.axes[i];if(f.borderWidth==null)f.borderWidth=
this.grid.borderWidth}if(typeof this.options.title=="string")this.title.text=this.options.title;else typeof this.options.title=="object"&&g.extend(true,this.title,this.options.title);this.title._plotWidth=this._width;this.legend.setOptions(this.options.legend);for(e=0;e<g.jqplot.postParseOptionsHooks.length;e++)g.jqplot.postParseOptionsHooks[e].call(this,b);for(e=0;e<this.postParseOptionsHooks.hooks.length;e++)this.postParseOptionsHooks.hooks[e].call(this,b)};this.destroy=function(){this.canvasManager.freeAllCanvases();
this.eventCanvas&&this.eventCanvas._elem&&this.eventCanvas._elem.unbind();this.target.empty();this.target[0].innerHTML=""};this.replot=function(b){b=b||{};var e=b.clear||true,i=b.resetAxes||false;this.target.trigger("jqplotPreReplot");e&&this.destroy();this.reInitialize();i&&this.resetAxesScale(i,b.axes);this.draw();this.target.trigger("jqplotPostReplot")};this.redraw=function(b){b=b!=null?b:true;this.target.trigger("jqplotPreRedraw");if(b){this.canvasManager.freeAllCanvases();this.eventCanvas._elem.unbind();
this.target.empty()}for(var e in this.axes)this.axes[e]._ticks=[];for(b=0;b<this.series.length;b++)this.populatePlotData(this.series[b],b);for(b=this._sumx=this._sumy=0;b<this.series.length;b++){this._sumy+=this.series[b]._sumy;this._sumx+=this.series[b]._sumx}this.draw();this.target.trigger("jqplotPostRedraw")};this.draw=function(){if(this.drawIfHidden||this.target.is(":visible")){this.target.trigger("jqplotPreDraw");var b,e;for(b=0;b<g.jqplot.preDrawHooks.length;b++)g.jqplot.preDrawHooks[b].call(this);
for(b=0;b<this.preDrawHooks.hooks.length;b++)this.preDrawHooks.hooks[b].call(this);this.target.append(this.baseCanvas.createElement({left:0,right:0,top:0,bottom:0},"jqplot-base-canvas",null,this));this.baseCanvas.setContext();this.target.append(this.title.draw());this.title.pack({top:0,left:0});var i=this.legend.draw(),f={top:0,left:0,bottom:0,right:0};if(this.legend.placement=="outsideGrid"){this.target.append(i);switch(this.legend.location){case "n":f.top+=this.legend.getHeight();break;case "s":f.bottom+=
this.legend.getHeight();break;case "ne":case "e":case "se":f.right+=this.legend.getWidth();break;case "nw":case "w":case "sw":f.left+=this.legend.getWidth();break;default:f.right+=this.legend.getWidth()}i=i.detach()}e=this.axes;for(b=0;b<12;b++){name=T[b];this.target.append(e[name].draw(this.baseCanvas._ctx,this));e[name].set()}if(e.yaxis.show)f.left+=e.yaxis.getWidth();var h=["y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"],l=[0,0,0,0,0,0,0,0],j=0;for(b=0;b<8;b++)if(e[h[b]].show){j+=
e[h[b]].getWidth();l[b]=j}f.right+=j;if(e.x2axis.show)f.top+=e.x2axis.getHeight();if(this.title.show)f.top+=this.title.getHeight();if(e.xaxis.show)f.bottom+=e.xaxis.getHeight();if(this.options.gridDimensions&&g.isPlainObject(this.options.gridDimensions)){var n=parseInt(this.options.gridDimensions.width,10)||0;j=parseInt(this.options.gridDimensions.height,10)||0;n=(this._width-f.left-f.right-n)/2;j=(this._height-f.top-f.bottom-j)/2;if(j>=0&&n>=0){f.top+=j;f.bottom+=j;f.left+=n;f.right+=n}}j=["top",
"bottom","left","right"];for(b in j)if(this._gridPadding[j[b]]==null&&f[j[b]]>0)this._gridPadding[j[b]]=f[j[b]];else if(this._gridPadding[j[b]]==null)this._gridPadding[j[b]]=this._defaultGridPadding[j[b]];f=this.legend.placement=="outsideGrid"?{top:this.title.getHeight(),left:0,right:0,bottom:0}:this._gridPadding;e.xaxis.pack({position:"absolute",bottom:this._gridPadding.bottom-e.xaxis.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});e.yaxis.pack({position:"absolute",
top:0,left:this._gridPadding.left-e.yaxis.getWidth(),height:this._height},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top});e.x2axis.pack({position:"absolute",top:this._gridPadding.top-e.x2axis.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});for(b=8;b>0;b--)e[h[b-1]].pack({position:"absolute",top:0,right:this._gridPadding.right-l[b-1]},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top});h=(this._width-
this._gridPadding.left-this._gridPadding.right)/2+this._gridPadding.left-e.yMidAxis.getWidth()/2;e.yMidAxis.pack({position:"absolute",top:0,left:h,zIndex:9,textAlign:"center"},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top});this.target.append(this.grid.createElement(this._gridPadding,this));this.grid.draw();for(b=0;b<this.series.length;b++){e=this.seriesStack[b];this.target.append(this.series[e].shadowCanvas.createElement(this._gridPadding,"jqplot-series-shadowCanvas",null,
this));this.series[e].shadowCanvas.setContext();this.series[e].shadowCanvas._elem.data("seriesIndex",e)}for(b=0;b<this.series.length;b++){e=this.seriesStack[b];this.target.append(this.series[e].canvas.createElement(this._gridPadding,"jqplot-series-canvas",null,this));this.series[e].canvas.setContext();this.series[e].canvas._elem.data("seriesIndex",e)}this.target.append(this.eventCanvas.createElement(this._gridPadding,"jqplot-event-canvas",null,this));this.eventCanvas.setContext();this.eventCanvas._ctx.fillStyle=
"rgba(0,0,0,0)";this.eventCanvas._ctx.fillRect(0,0,this.eventCanvas._ctx.canvas.width,this.eventCanvas._ctx.canvas.height);this.bindCustomEvents();if(this.legend.preDraw){this.eventCanvas._elem.before(i);this.legend.pack(f);this.legend._elem?this.drawSeries({legendInfo:{location:this.legend.location,placement:this.legend.placement,width:this.legend.getWidth(),height:this.legend.getHeight(),xoffset:this.legend.xoffset,yoffset:this.legend.yoffset}}):this.drawSeries()}else{this.drawSeries();this.series.length&&
g(this.series[this.series.length-1].canvas._elem).after(i);this.legend.pack(f)}for(b=0;b<g.jqplot.eventListenerHooks.length;b++)this.eventCanvas._elem.bind(g.jqplot.eventListenerHooks[b][0],{plot:this},g.jqplot.eventListenerHooks[b][1]);for(b=0;b<this.eventListenerHooks.hooks.length;b++)this.eventCanvas._elem.bind(this.eventListenerHooks.hooks[b][0],{plot:this},this.eventListenerHooks.hooks[b][1]);for(b=0;b<g.jqplot.postDrawHooks.length;b++)g.jqplot.postDrawHooks[b].call(this);for(b=0;b<this.postDrawHooks.hooks.length;b++)this.postDrawHooks.hooks[b].call(this);
if(this.target.is(":visible"))this._drawCount+=1;this.target.trigger("jqplotPostDraw",[this])}};this.bindCustomEvents=function(){this.eventCanvas._elem.bind("click",{plot:this},this.onClick);this.eventCanvas._elem.bind("dblclick",{plot:this},this.onDblClick);this.eventCanvas._elem.bind("mousedown",{plot:this},this.onMouseDown);this.eventCanvas._elem.bind("mousemove",{plot:this},this.onMouseMove);this.eventCanvas._elem.bind("mouseenter",{plot:this},this.onMouseEnter);this.eventCanvas._elem.bind("mouseleave",
{plot:this},this.onMouseLeave);this.eventCanvas._elem.bind("touchstart",{plot:this},this.onTouchStart);this.eventCanvas._elem.bind("touchend",{plot:this},this.onTouchEnd);this.eventCanvas._elem.bind("touchmove",{plot:this},this.onTouchMove);if(this.captureRightClick){this.eventCanvas._elem.bind("mouseup",{plot:this},this.onRightClick);this.eventCanvas._elem.get(0).oncontextmenu=function(){return false}}else this.eventCanvas._elem.bind("mouseup",{plot:this},this.onMouseUp)};this.onClick=function(b){var e=
c(b),i=b.data.plot,f=d(e.gridPos,i),h=jQuery.Event("jqplotClick");h.pageX=b.pageX;h.pageY=b.pageY;g(this).trigger(h,[e.gridPos,e.dataPos,f,i])};this.onDblClick=function(b){var e=c(b),i=b.data.plot,f=d(e.gridPos,i),h=jQuery.Event("jqplotDblClick");h.pageX=b.pageX;h.pageY=b.pageY;g(this).trigger(h,[e.gridPos,e.dataPos,f,i])};this.onMouseDown=function(b){var e=c(b),i=b.data.plot,f=d(e.gridPos,i),h=jQuery.Event("jqplotMouseDown");h.pageX=b.pageX;h.pageY=b.pageY;g(this).trigger(h,[e.gridPos,e.dataPos,
f,i])};this.onMouseUp=function(b){var e=c(b),i=jQuery.Event("jqplotMouseUp");i.pageX=b.pageX;i.pageY=b.pageY;g(this).trigger(i,[e.gridPos,e.dataPos,null,b.data.plot])};this.onRightClick=function(b){var e=c(b),i=b.data.plot,f=d(e.gridPos,i);if(i.captureRightClick){var h=b.which==3?jQuery.Event("jqplotRightClick"):jQuery.Event("jqplotMouseUp");h.pageX=b.pageX;h.pageY=b.pageY;g(this).trigger(h,[e.gridPos,e.dataPos,f,i])}};this.onMouseMove=function(b){var e=c(b),i=b.data.plot,f=d(e.gridPos,i),h=jQuery.Event("jqplotMouseMove");
h.pageX=b.pageX;h.pageY=b.pageY;g(this).trigger(h,[e.gridPos,e.dataPos,f,i])};this.onMouseEnter=function(b){var e=c(b),i=b.data.plot,f=jQuery.Event("jqplotMouseEnter");f.pageX=b.pageX;f.pageY=b.pageY;f.relatedTarget=b.relatedTarget;g(this).trigger(f,[e.gridPos,e.dataPos,null,i])};this.onMouseLeave=function(b){var e=c(b),i=b.data.plot,f=jQuery.Event("jqplotMouseLeave");f.pageX=b.pageX;f.pageY=b.pageY;f.relatedTarget=b.relatedTarget;g(this).trigger(f,[e.gridPos,e.dataPos,null,i])};this.onTouchStart=
function(b){b.preventDefault();var e=b.originalEvent.touches[0]||b.originalEvent.changedTouches[0];e.data=b.data;var i=c(e),f=b.data.plot,h=jQuery.Event("jqplotTouchStart");h.pageX=e.pageX;h.pageY=e.pageY;h.relatedTarget=b.relatedTarget;b=d(i.gridPos,f);g(this).trigger(h,[i.gridPos,i.dataPos,b,f])};this.onTouchEnd=function(b){b.preventDefault();var e=b.originalEvent.touches[0]||b.originalEvent.changedTouches[0];e.data=b.data;var i=c(e),f=b.data.plot,h=jQuery.Event("jqplotTouchEnd");h.pageX=e.pageX;
h.pageY=e.pageY;h.relatedTarget=b.relatedTarget;g(this).trigger(h,[i.gridPos,i.dataPos,null,f])};this.onTouchMove=function(b){var e=b.originalEvent.touches[0]||b.originalEvent.changedTouches[0];e.data=b.data;var i=c(e);b=b.data.plot;var f=d(i.gridPos,b),h=jQuery.Event("jqplotTouchMove");h.pageX=e.pageX;h.pageY=e.pageY;g(this).trigger(h,[i.gridPos,i.dataPos,f,b])};this.drawSeries=function(b,e){var i,f,h;e=typeof b==="number"&&e==null?b:e;b=typeof b==="object"?b:{};if(e!=A){f=this.series[e];h=f.shadowCanvas._ctx;
h.clearRect(0,0,h.canvas.width,h.canvas.height);f.drawShadow(h,b,this);h=f.canvas._ctx;h.clearRect(0,0,h.canvas.width,h.canvas.height);f.draw(h,b,this);f.renderer.constructor==g.jqplot.BezierCurveRenderer&&e<this.series.length-1&&this.drawSeries(e+1)}else for(i=0;i<this.series.length;i++){f=this.series[i];h=f.shadowCanvas._ctx;h.clearRect(0,0,h.canvas.width,h.canvas.height);f.drawShadow(h,b,this);h=f.canvas._ctx;h.clearRect(0,0,h.canvas.width,h.canvas.height);f.draw(h,b,this)}};this.moveSeriesToFront=
function(b){b=parseInt(b,10);var e=g.inArray(b,this.seriesStack);if(e!=-1)if(e==this.seriesStack.length-1)this.previousSeriesStack=this.seriesStack.slice(0);else{var i=this.seriesStack[this.seriesStack.length-1],f=this.series[b].canvas._elem.detach(),h=this.series[b].shadowCanvas._elem.detach();this.series[i].shadowCanvas._elem.after(h);this.series[i].canvas._elem.after(f);this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack.splice(e,1);this.seriesStack.push(b)}};this.moveSeriesToBack=
function(b){b=parseInt(b,10);var e=g.inArray(b,this.seriesStack);if(!(e==0||e==-1)){var i=this.seriesStack[0],f=this.series[b].canvas._elem.detach(),h=this.series[b].shadowCanvas._elem.detach();this.series[i].shadowCanvas._elem.before(h);this.series[i].canvas._elem.before(f);this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack.splice(e,1);this.seriesStack.unshift(b)}};this.restorePreviousSeriesOrder=function(){var b,e,i,f;if(this.seriesStack!=this.previousSeriesStack){for(b=1;b<this.previousSeriesStack.length;b++){i=
this.previousSeriesStack[b];f=this.previousSeriesStack[b-1];e=this.series[i].canvas._elem.detach();i=this.series[i].shadowCanvas._elem.detach();this.series[f].shadowCanvas._elem.after(i);this.series[f].canvas._elem.after(e)}b=this.seriesStack.slice(0);this.seriesStack=this.previousSeriesStack.slice(0);this.previousSeriesStack=b}};this.restoreOriginalSeriesOrder=function(){var b,e=[],i;for(b=0;b<this.series.length;b++)e.push(b);if(this.seriesStack!=e){this.previousSeriesStack=this.seriesStack.slice(0);
this.seriesStack=e;for(b=1;b<this.seriesStack.length;b++){e=this.series[b].canvas._elem.detach();i=this.series[b].shadowCanvas._elem.detach();this.series[b-1].shadowCanvas._elem.after(i);this.series[b-1].canvas._elem.after(e)}}};this.activateTheme=function(b){this.themeEngine.activate(this,b)}}function W(a){return(Math.exp(2*a)-1)/(Math.exp(2*a)+1)}function R(a){function c(B,L){return B-L==0?Math.pow(10,10):B-L}var d=this.renderer.smooth,b=this.canvas.getWidth(),e=this._xaxis.series_p2u,i=this._yaxis.series_p2u,
f=null;f=a.length/b;b=[];var h=[];f=isNaN(parseFloat(d))?3.9182054*Math.pow(f,-0.3534992):parseFloat(d);d=[];for(var l=[],j=0,n=a.length;j<n;j++){d.push(a[j][1]);l.push(a[j][0])}for(var k,m,o,s,r=a.length-1,p=1,u=a.length;p<u;p++){s=[];n=[];for(var t=0;t<2;t++){j=p-1+t;s[t]=j==0||j==r?Math.pow(10,10):d[j+1]-d[j]==0||d[j]-d[j-1]==0?0:(l[j+1]-l[j])/(d[j+1]-d[j])+(l[j]-l[j-1])/(d[j]-d[j-1])==0?0:(d[j+1]-d[j])*(d[j]-d[j-1])<0?0:2/(c(l[j+1],l[j])/(d[j+1]-d[j])+c(l[j],l[j-1])/(d[j]-d[j-1]))}if(p==1)s[0]=
1.5*(d[1]-d[0])/c(l[1],l[0])-s[1]/2;else if(p==r)s[1]=1.5*(d[r]-d[r-1])/c(l[r],l[r-1])-s[0]/2;n[0]=-2*(s[1]+2*s[0])/c(l[p],l[p-1])+6*(d[p]-d[p-1])/Math.pow(c(l[p],l[p-1]),2);n[1]=2*(2*s[1]+s[0])/c(l[p],l[p-1])-6*(d[p]-d[p-1])/Math.pow(c(l[p],l[p-1]),2);s=1/6*(n[1]-n[0])/c(l[p],l[p-1]);o=0.5*(l[p]*n[0]-l[p-1]*n[1])/c(l[p],l[p-1]);m=(d[p]-d[p-1]-o*(Math.pow(l[p],2)-Math.pow(l[p-1],2))-s*(Math.pow(l[p],3)-Math.pow(l[p-1],3)))/c(l[p],l[p-1]);k=d[p-1]-m*l[p-1]-o*Math.pow(l[p-1],2)-s*Math.pow(l[p-1],3);
var v=(l[p]-l[p-1])/f,x,D;t=0;for(n=f;t<n;t++){x=[];D=l[p-1]+t*v;x.push(D);x.push(k+m*D+o*Math.pow(D,2)+s*Math.pow(D,3));b.push(x);h.push([e(x[0]),i(x[1])])}}b.push(a[j]);h.push([e(a[j][0]),i(a[j][1])]);return[b,h]}function S(a){var c=this.renderer.smooth,d=this.renderer.tension,b=this.canvas.getWidth(),e=this._xaxis.series_p2u,i=this._yaxis.series_p2u,f=null,h=null,l=h=null,j=h=null;l=null;var n,k,m,o,s,r,p,u;f=a.length/b;b=[];var t=[];f=isNaN(parseFloat(c))?3.9182054*Math.pow(f,-0.3534992):parseFloat(c);
isNaN(parseFloat(d))||(d=parseFloat(d));c=0;for(var v=a.length-1;c<v;c++){if(d===null){h=Math.abs((a[c+1][1]-a[c][1])/(a[c+1][0]-a[c][0]));l=h/2.5+-1.4;h=0.15*W(l)-0.15*W(-1.4)+0.3;if(c>0)j=Math.abs((a[c][1]-a[c-1][1])/(a[c][0]-a[c-1][0]));l=j/2.5+-1.4;l=0.15*W(l)-0.15*W(-1.4)+0.3;h=(h+l)/2}else h=d;for(l=0;l<f;l++){n=l/f;k=(1+2*n)*Math.pow(1-n,2);m=n*Math.pow(1-n,2);o=Math.pow(n,2)*(3-2*n);n=Math.pow(n,2)*(n-1);if(a[c-1]){s=h*(a[c+1][0]-a[c-1][0]);r=h*(a[c+1][1]-a[c-1][1])}else{s=h*(a[c+1][0]-a[c][0]);
r=h*(a[c+1][1]-a[c][1])}if(a[c+2]){p=h*(a[c+2][0]-a[c][0]);u=h*(a[c+2][1]-a[c][1])}else{p=h*(a[c+1][0]-a[c][0]);u=h*(a[c+1][1]-a[c][1])}s=k*a[c][0]+o*a[c+1][0]+m*s+n*p;k=k*a[c][1]+o*a[c+1][1]+m*r+n*u;m=[s,k];b.push(m);t.push([e(s),i(k)])}}b.push(a[v]);t.push([e(a[v][0]),i(a[v][1])]);return[b,t]}function ha(){for(var a=0;a<this.series.length;a++)if(this.series[a].renderer.constructor==g.jqplot.LineRenderer)if(this.series[a].highlightMouseOver)this.series[a].highlightMouseDown=false}function ia(){if(this.plugins.lineRenderer&&
this.plugins.lineRenderer.highlightCanvas){this.plugins.lineRenderer.highlightCanvas.resetCanvas();this.plugins.lineRenderer.highlightCanvas=null}this.plugins.lineRenderer.highlightedSeriesIndex=null;this.plugins.lineRenderer.highlightCanvas=new g.jqplot.GenericCanvas;this.eventCanvas._elem.before(this.plugins.lineRenderer.highlightCanvas.createElement(this._gridPadding,"jqplot-lineRenderer-highlight-canvas",this._plotDimensions,this));this.plugins.lineRenderer.highlightCanvas.setContext();this.eventCanvas._elem.bind("mouseleave",
{plot:this},function(a){U(a.data.plot)})}function ba(a,c,d,b){var e=a.series[c],i=a.plugins.lineRenderer.highlightCanvas;i._ctx.clearRect(0,0,i._ctx.canvas.width,i._ctx.canvas.height);e._highlightedPoint=d;a.plugins.lineRenderer.highlightedSeriesIndex=c;a={fillStyle:e.highlightColor};if(e.type==="line"&&e.renderer.bands.show){a.fill=true;a.closePath=true}e.renderer.shapeRenderer.draw(i._ctx,b,a)}function U(a){var c=a.plugins.lineRenderer.highlightCanvas;c._ctx.clearRect(0,0,c._ctx.canvas.width,c._ctx.canvas.height);
for(c=0;c<a.series.length;c++)a.series[c]._highlightedPoint=null;a.plugins.lineRenderer.highlightedSeriesIndex=null;a.target.trigger("jqplotDataUnhighlight")}function ja(a,c,d,b,e){if(b){c=[b.seriesIndex,b.pointIndex,b.data];d=jQuery.Event("jqplotDataMouseOver");d.pageX=a.pageX;d.pageY=a.pageY;e.target.trigger(d,c);if(e.series[c[0]].highlightMouseOver&&c[0]!=e.plugins.lineRenderer.highlightedSeriesIndex){d=jQuery.Event("jqplotDataHighlight");d.pageX=a.pageX;d.pageY=a.pageY;e.target.trigger(d,c);ba(e,
b.seriesIndex,b.pointIndex,b.points)}}else b==null&&U(e)}function ka(a,c,d,b,e){if(b){c=[b.seriesIndex,b.pointIndex,b.data];if(e.series[c[0]].highlightMouseDown&&c[0]!=e.plugins.lineRenderer.highlightedSeriesIndex){d=jQuery.Event("jqplotDataHighlight");d.pageX=a.pageX;d.pageY=a.pageY;e.target.trigger(d,c);ba(e,b.seriesIndex,b.pointIndex,b.points)}}else b==null&&U(e)}function la(a,c,d,b,e){a=e.plugins.lineRenderer.highlightedSeriesIndex;a!=null&&e.series[a].highlightMouseDown&&U(e)}function ma(a,c,
d,b,e){if(b){c=[b.seriesIndex,b.pointIndex,b.data];d=jQuery.Event("jqplotDataClick");d.pageX=a.pageX;d.pageY=a.pageY;e.target.trigger(d,c)}}function na(a,c,d,b,e){if(b){c=[b.seriesIndex,b.pointIndex,b.data];d=e.plugins.lineRenderer.highlightedSeriesIndex;d!=null&&e.series[d].highlightMouseDown&&U(e);d=jQuery.Event("jqplotDataRightClick");d.pageX=a.pageX;d.pageY=a.pageY;e.target.trigger(d,c)}}function Z(a){a=Math.abs(a);return a>=10?"%d":a>1?a===parseInt(a)?"%d":"%.1f":"%."+-Math.floor(Math.log(a)/
Math.LN10)+"f"}function ca(a,c){var d=a/(c-1),b=Math.pow(10,Math.floor(Math.log(d)/Math.LN10));d/=b;return b<1?d>5?10*b:d>2?5*b:d>1?2*b:b:d>5?10*b:d>4?5*b:d>3?4*b:d>2?3*b:d>1?2*b:b}function da(a,c){var d=Math.pow(10,Math.floor(Math.log(a)/Math.LN10)),b=a/d;b/=c;return(b<=0.38?0.1:b<=1.6?0.2:b<=4?0.5:b<=8?1:b<=16?2:5)*d}function ea(a,c){return a-c}function X(a){if(a==null||typeof a!="object")return a;var c=new a.constructor,d;for(d in a)c[d]=X(a[d]);return c}function Y(a,c){if(!(c==null||typeof c!=
"object"))for(var d in c){if(d=="highlightColors")a[d]=X(c[d]);if(c[d]!=null&&typeof c[d]=="object"){a.hasOwnProperty(d)||(a[d]={});Y(a[d],c[d])}else a[d]=c[d]}}function fa(a,c){if(c.indexOf)return c.indexOf(a);for(var d=0,b=c.length;d<b;d++)if(c[d]===a)return d;return-1}function $(a){if(a===null)return"[object Null]";return Object.prototype.toString.call(a)}var A;g.fn.emptyForce=function(){for(var a=0,c;(c=g(this)[a])!=null;a++){c.nodeType===1&&jQuery.cleanData(c.getElementsByTagName("*"));if(g.jqplot_use_excanvas)c.outerHTML=
"";else for(;c.firstChild;)c.removeChild(c.firstChild)}return g(this)};g.fn.removeChildForce=function(a){for(;a.firstChild;){this.removeChildForce(a.firstChild);a.removeChild(a.firstChild)}};g.jqplot=function(a,c,d){var b,e;if(d==null)if(jQuery.isArray(c)){b=c;e=null}else{if(typeof c==="object"){b=null;e=c}}else{b=c;e=d}c=new ga;g("#"+a).removeClass("jqplot-error");if(g.jqplot.config.catchErrors)try{c.init(a,b,e);c.draw();c.themeEngine.init.call(c);return c}catch(i){b=g.jqplot.config.errorMessage||
i.message;g("#"+a).append('<div class="jqplot-error-message">'+b+"</div>");g("#"+a).addClass("jqplot-error");document.getElementById(a).style.background=g.jqplot.config.errorBackground;document.getElementById(a).style.border=g.jqplot.config.errorBorder;document.getElementById(a).style.fontFamily=g.jqplot.config.errorFontFamily;document.getElementById(a).style.fontSize=g.jqplot.config.errorFontSize;document.getElementById(a).style.fontStyle=g.jqplot.config.errorFontStyle;document.getElementById(a).style.fontWeight=
g.jqplot.config.errorFontWeight}else{c.init(a,b,e);c.draw();c.themeEngine.init.call(c);return c}};g.jqplot.version="1.0.0b2_r947";g.jqplot.CanvasManager=function(){if(typeof g.jqplot.CanvasManager.canvases=="undefined"){g.jqplot.CanvasManager.canvases=[];g.jqplot.CanvasManager.free=[]}var a=[];this.getCanvas=function(){var c,d=true;if(!g.jqplot.use_excanvas)for(var b=0,e=g.jqplot.CanvasManager.canvases.length;b<e;b++)if(g.jqplot.CanvasManager.free[b]===true){d=false;c=g.jqplot.CanvasManager.canvases[b];
g.jqplot.CanvasManager.free[b]=false;a.push(b);break}if(d){c=document.createElement("canvas");a.push(g.jqplot.CanvasManager.canvases.length);g.jqplot.CanvasManager.canvases.push(c);g.jqplot.CanvasManager.free.push(false)}return c};this.initCanvas=function(c){if(g.jqplot.use_excanvas)return window.G_vmlCanvasManager.initElement(c);return c};this.freeAllCanvases=function(){for(var c=0,d=a.length;c<d;c++)this.freeCanvas(a[c]);a=[]};this.freeCanvas=function(c){if(g.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==
A){window.G_vmlCanvasManager.uninitElement(g.jqplot.CanvasManager.canvases[c]);g.jqplot.CanvasManager.canvases[c]=null}else{var d=g.jqplot.CanvasManager.canvases[c];d.getContext("2d").clearRect(0,0,d.width,d.height);g(d).unbind().removeAttr("class").removeAttr("style");g(d).css({left:"",top:"",position:""});d.width=0;d.height=0;g.jqplot.CanvasManager.free[c]=true}}};g.jqplot.log=function(){window.console&&window.console.log.apply(window.console,arguments)};g.jqplot.config={enablePlugins:false,defaultHeight:300,
defaultWidth:400,UTCAdjust:false,timezoneOffset:new Date((new Date).getTimezoneOffset()*6E4),errorMessage:"",errorBackground:"",errorBorder:"",errorFontFamily:"",errorFontSize:"",errorFontStyle:"",errorFontWeight:"",catchErrors:false,defaultTickFormatString:"%.1f",defaultColors:["#4bb2c5","#EAA228","#c5b47f","#579575","#839557","#958c12","#953579","#4b5de4","#d8b83f","#ff5800","#0085cc","#c747a3","#cddf54","#FBD178","#26B4E3","#bd70c7"],defaultNegativeColors:["#498991","#C08840","#9F9274","#546D61",
"#646C4A","#6F6621","#6E3F5F","#4F64B0","#A89050","#C45923","#187399","#945381","#959E5C","#C7AF7B","#478396","#907294"],dashLength:4,gapLength:4,dotGapLength:2.5,srcLocation:"jqplot/src/",pluginLocation:"jqplot/src/plugins/"};g.jqplot.arrayMax=function(a){return Math.max.apply(Math,a)};g.jqplot.arrayMin=function(a){return Math.min.apply(Math,a)};g.jqplot.enablePlugins=g.jqplot.config.enablePlugins;g.jqplot.support_canvas=function(){if(typeof g.jqplot.support_canvas.result=="undefined")g.jqplot.support_canvas.result=
!!document.createElement("canvas").getContext;return g.jqplot.support_canvas.result};g.jqplot.support_canvas_text=function(){if(typeof g.jqplot.support_canvas_text.result=="undefined")g.jqplot.support_canvas_text.result=window.G_vmlCanvasManager!==A&&window.G_vmlCanvasManager._version>887?true:!!(document.createElement("canvas").getContext&&typeof document.createElement("canvas").getContext("2d").fillText=="function");return g.jqplot.support_canvas_text.result};g.jqplot.use_excanvas=g.browser.msie&&
!g.jqplot.support_canvas()?true:false;g.jqplot.preInitHooks=[];g.jqplot.postInitHooks=[];g.jqplot.preParseOptionsHooks=[];g.jqplot.postParseOptionsHooks=[];g.jqplot.preDrawHooks=[];g.jqplot.postDrawHooks=[];g.jqplot.preDrawSeriesHooks=[];g.jqplot.postDrawSeriesHooks=[];g.jqplot.preDrawLegendHooks=[];g.jqplot.addLegendRowHooks=[];g.jqplot.preSeriesInitHooks=[];g.jqplot.postSeriesInitHooks=[];g.jqplot.preParseSeriesOptionsHooks=[];g.jqplot.postParseSeriesOptionsHooks=[];g.jqplot.eventListenerHooks=
[];g.jqplot.preDrawSeriesShadowHooks=[];g.jqplot.postDrawSeriesShadowHooks=[];g.jqplot.ElemContainer=function(){this._plotDimensions={height:null,width:null}};g.jqplot.ElemContainer.prototype.createElement=function(a,c,d,b,e){this._offsets=c;c=d||"jqplot";a=document.createElement(a);this._elem=g(a);this._elem.addClass(c);this._elem.css(b);this._elem.attr(e);return this._elem};g.jqplot.ElemContainer.prototype.getWidth=function(){return this._elem?this._elem.outerWidth(true):null};g.jqplot.ElemContainer.prototype.getHeight=
function(){return this._elem?this._elem.outerHeight(true):null};g.jqplot.ElemContainer.prototype.getPosition=function(){return this._elem?this._elem.position():{top:null,left:null,bottom:null,right:null}};g.jqplot.ElemContainer.prototype.getTop=function(){return this.getPosition().top};g.jqplot.ElemContainer.prototype.getLeft=function(){return this.getPosition().left};g.jqplot.ElemContainer.prototype.getBottom=function(){return this._elem.css("bottom")};g.jqplot.ElemContainer.prototype.getRight=function(){return this._elem.css("right")};
y.prototype=new g.jqplot.ElemContainer;y.prototype.constructor=y;y.prototype.init=function(){this.renderer=new this.renderer;this.tickOptions.axis=this.name;if(this.tickOptions.showMark==null)this.tickOptions.showMark=this.showTicks;if(this.tickOptions.showMark==null)this.tickOptions.showMark=this.showTickMarks;if(this.tickOptions.showLabel==null)this.tickOptions.showLabel=this.showTicks;if(this.label==null||this.label=="")this.showLabel=false;else this.labelOptions.label=this.label;if(this.showLabel==
false)this.labelOptions.show=false;if(this.pad==0)this.pad=1;if(this.padMax==0)this.padMax=1;if(this.padMin==0)this.padMin=1;if(this.padMax==null)this.padMax=(this.pad-1)/2+1;if(this.padMin==null)this.padMin=(this.pad-1)/2+1;this.pad=this.padMax+this.padMin-1;if(this.min!=null||this.max!=null)this.autoscale=false;if(this.syncTicks==null&&this.name.indexOf("y")>-1)this.syncTicks=true;else if(this.syncTicks==null)this.syncTicks=false;this.renderer.init.call(this,this.rendererOptions)};y.prototype.draw=
function(a,c){if(this.__ticks)this.__ticks=null;return this.renderer.draw.call(this,a,c)};y.prototype.set=function(){this.renderer.set.call(this)};y.prototype.pack=function(a,c){this.show&&this.renderer.pack.call(this,a,c);if(this._min==null){this._min=this.min;this._max=this.max;this._tickInterval=this.tickInterval;this._numberTicks=this.numberTicks;this.__ticks=this._ticks}};y.prototype.reset=function(){this.renderer.reset.call(this)};y.prototype.resetScale=function(a){g.extend(true,this,{min:null,
max:null,numberTicks:null,tickInterval:null,_ticks:[],ticks:[]},a);this.resetDataBounds()};y.prototype.resetDataBounds=function(){var a=this._dataBounds;a.min=null;a.max=null;for(var c,d,b,e=this.show?true:false,i=0;i<this._series.length;i++){d=this._series[i];b=d._plotData;if(d._type==="line"&&d.renderer.bands.show&&this.name.charAt(0)!=="x")b=[[0,d.renderer.bands._min],[1,d.renderer.bands._max]];var f=1,h=1;if(d._type!=null&&d._type=="ohlc"){f=3;h=2}var l=0;for(c=b.length;l<c;l++)if(this.name==
"xaxis"||this.name=="x2axis"){if(b[l][0]!=null&&b[l][0]<a.min||a.min==null)a.min=b[l][0];if(b[l][0]!=null&&b[l][0]>a.max||a.max==null)a.max=b[l][0]}else{if(b[l][f]!=null&&b[l][f]<a.min||a.min==null)a.min=b[l][f];if(b[l][h]!=null&&b[l][h]>a.max||a.max==null)a.max=b[l][h]}if(e&&d.renderer.constructor!==g.jqplot.BarRenderer)e=false;else if(e&&this._options.hasOwnProperty("forceTickAt0")&&this._options.forceTickAt0==false)e=false;else if(e&&d.renderer.constructor===g.jqplot.BarRenderer)if(d.barDirection==
"vertical"&&this.name!="xaxis"&&this.name!="x2axis"){if(this._options.pad!=null||this._options.padMin!=null)e=false}else if(d.barDirection=="horizontal"&&(this.name=="xaxis"||this.name=="x2axis"))if(this._options.pad!=null||this._options.padMin!=null)e=false}if(e&&this.renderer.constructor===g.jqplot.LinearAxisRenderer&&a.min>=0){this.padMin=1;this.forceTickAt0=true}};J.prototype=new g.jqplot.ElemContainer;J.prototype.constructor=J;J.prototype.setOptions=function(a){g.extend(true,this,a);if(this.placement==
"inside")this.placement="insideGrid";if(this.xoffset>0){if(this.placement=="insideGrid")switch(this.location){case "nw":case "w":case "sw":if(this.marginLeft==null)this.marginLeft=this.xoffset+"px";this.marginRight="0px";break;default:if(this.marginRight==null)this.marginRight=this.xoffset+"px";this.marginLeft="0px"}else if(this.placement=="outside")switch(this.location){case "nw":case "w":case "sw":if(this.marginRight==null)this.marginRight=this.xoffset+"px";this.marginLeft="0px";break;default:if(this.marginLeft==
null)this.marginLeft=this.xoffset+"px";this.marginRight="0px"}this.xoffset=0}if(this.yoffset>0){if(this.placement=="outside")switch(this.location){case "sw":case "s":case "se":if(this.marginTop==null)this.marginTop=this.yoffset+"px";this.marginBottom="0px";break;default:if(this.marginBottom==null)this.marginBottom=this.yoffset+"px";this.marginTop="0px"}else if(this.placement=="insideGrid")switch(this.location){case "sw":case "s":case "se":if(this.marginBottom==null)this.marginBottom=this.yoffset+
"px";this.marginTop="0px";break;default:if(this.marginTop==null)this.marginTop=this.yoffset+"px";this.marginBottom="0px"}this.yoffset=0}};J.prototype.init=function(){this.renderer=new this.renderer;this.renderer.init.call(this,this.rendererOptions)};J.prototype.draw=function(a){for(var c=0;c<g.jqplot.preDrawLegendHooks.length;c++)g.jqplot.preDrawLegendHooks[c].call(this,a);return this.renderer.draw.call(this,a)};J.prototype.pack=function(a){this.renderer.pack.call(this,a)};N.prototype=new g.jqplot.ElemContainer;
N.prototype.constructor=N;N.prototype.init=function(){this.renderer=new this.renderer;this.renderer.init.call(this,this.rendererOptions)};N.prototype.draw=function(a){return this.renderer.draw.call(this,a)};N.prototype.pack=function(){this.renderer.pack.call(this)};K.prototype=new g.jqplot.ElemContainer;K.prototype.constructor=K;K.prototype.init=function(a,c,d){this.index=a;this.gridBorderWidth=c;a=this.data;c=[];var b;for(b=0;b<a.length;b++)if(this.breakOnNull)c.push(a[b]);else a[b]==null||a[b][0]==
null||a[b][1]==null||c.push(a[b]);this.data=c;if(!this.color&&this.show)this.color=d.colorGenerator.get(this.index);if(!this.negativeColor&&this.show)this.negativeColor=d.negativeColorGenerator.get(this.index);if(!this.fillColor)this.fillColor=this.color;if(this.fillAlpha){a=g.jqplot.normalize2rgb(this.fillColor);a=g.jqplot.getColorComponents(a);this.fillColor="rgba("+a[0]+","+a[1]+","+a[2]+","+this.fillAlpha+")"}this.renderer=new this.renderer;this.renderer.init.call(this,this.rendererOptions,d);
this.markerRenderer=new this.markerRenderer;if(!this.markerOptions.color)this.markerOptions.color=this.color;if(this.markerOptions.show==null)this.markerOptions.show=this.showMarker;this.showMarker=this.markerOptions.show;this.markerRenderer.init(this.markerOptions)};K.prototype.draw=function(a,c,d){c=c==A?{}:c;a=a==A?this.canvas._ctx:a;var b;for(b=0;b<g.jqplot.preDrawSeriesHooks.length;b++)g.jqplot.preDrawSeriesHooks[b].call(this,a,c);if(this.show){this.renderer.setGridData.call(this,d);c.preventJqPlotSeriesDrawTrigger||
g(a.canvas).trigger("jqplotSeriesDraw",[this.data,this.gridData]);b=c.data?c.data:this._stack?this._plotData:this.data;b=c.gridData||this.renderer.makeGridData.call(this,b,d);if(this._type==="line"&&this.renderer.smooth&&this.renderer._smoothedData.length)b=this.renderer._smoothedData;this.renderer.draw.call(this,a,b,c,d)}for(b=0;b<g.jqplot.postDrawSeriesHooks.length;b++)g.jqplot.postDrawSeriesHooks[b].call(this,a,c)};K.prototype.drawShadow=function(a,c,d){c=c==A?{}:c;a=a==A?this.shadowCanvas._ctx:
a;var b;for(b=0;b<g.jqplot.preDrawSeriesShadowHooks.length;b++)g.jqplot.preDrawSeriesShadowHooks[b].call(this,a,c);if(this.shadow){this.renderer.setGridData.call(this,d);b=c.data?c.data:this._stack?this._plotData:this.data;d=c.gridData||this.renderer.makeGridData.call(this,b,d);this.renderer.drawShadow.call(this,a,d,c)}for(b=0;b<g.jqplot.postDrawSeriesShadowHooks.length;b++)g.jqplot.postDrawSeriesShadowHooks[b].call(this,a,c)};K.prototype.toggleDisplay=function(a){var c,d;c=a.data.series?a.data.series:
this;if(a.data.speed)d=a.data.speed;if(d)if(c.canvas._elem.is(":hidden")){c.canvas._elem.removeClass("jqplot-series-hidden");c.shadowCanvas._elem&&c.shadowCanvas._elem.fadeIn(d);c.canvas._elem.fadeIn(d);c.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+c.index).fadeIn(d)}else{c.canvas._elem.addClass("jqplot-series-hidden");c.shadowCanvas._elem&&c.shadowCanvas._elem.fadeOut(d);c.canvas._elem.fadeOut(d);c.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+c.index).fadeOut(d)}else if(c.canvas._elem.is(":hidden")){c.canvas._elem.removeClass("jqplot-series-hidden");
c.shadowCanvas._elem&&c.shadowCanvas._elem.show();c.canvas._elem.show();c.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+c.index).show()}else{c.canvas._elem.addClass("jqplot-series-hidden");c.shadowCanvas._elem&&c.shadowCanvas._elem.hide();c.canvas._elem.hide();c.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+c.index).hide()}};O.prototype=new g.jqplot.ElemContainer;O.prototype.constructor=O;O.prototype.init=function(){this.renderer=new this.renderer;this.renderer.init.call(this,
this.rendererOptions)};O.prototype.createElement=function(a,c){this._offsets=a;return this.renderer.createElement.call(this,c)};O.prototype.draw=function(){this.renderer.draw.call(this)};g.jqplot.GenericCanvas=function(){g.jqplot.ElemContainer.call(this)};g.jqplot.GenericCanvas.prototype=new g.jqplot.ElemContainer;g.jqplot.GenericCanvas.prototype.constructor=g.jqplot.GenericCanvas;g.jqplot.GenericCanvas.prototype.createElement=function(a,c,d,b){this._offsets=a;a="jqplot";if(c!=A)a=c;c=b.canvasManager.getCanvas();
if(d!=null)this._plotDimensions=d;c.width=this._plotDimensions.width-this._offsets.left-this._offsets.right;c.height=this._plotDimensions.height-this._offsets.top-this._offsets.bottom;this._elem=g(c);this._elem.css({position:"absolute",left:this._offsets.left,top:this._offsets.top});this._elem.addClass(a);b.canvasManager.initCanvas(c);return this._elem};g.jqplot.GenericCanvas.prototype.setContext=function(){return this._ctx=this._elem.get(0).getContext("2d")};g.jqplot.GenericCanvas.prototype.resetCanvas=
function(){if(this._elem){g.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==A&&window.G_vmlCanvasManager.uninitElement(this._elem.get(0));this._elem.emptyForce()}this._ctx=null};g.jqplot.HooksManager=function(){this.hooks=[]};g.jqplot.HooksManager.prototype.addOnce=function(a){var c=false,d;for(d=0;d<this.hooks.length;d++)if(this.hooks[d][0]==a)c=true;c||this.hooks.push(a)};g.jqplot.HooksManager.prototype.add=function(a){this.hooks.push(a)};g.jqplot.EventListenerManager=function(){this.hooks=
[]};g.jqplot.EventListenerManager.prototype.addOnce=function(a,c){var d=false,b,e;for(e=0;e<this.hooks.length;e++){b=this.hooks[e];if(b[0]==a&&b[1]==c)d=true}d||this.hooks.push([a,c])};g.jqplot.EventListenerManager.prototype.add=function(a,c){this.hooks.push([a,c])};var T=["yMidAxis","xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];g.jqplot.computeHighlightColors=function(a){var c;if(jQuery.isArray(a)){c=[];for(var d=0;d<a.length;d++){for(var b=g.jqplot.getColorComponents(a[d]),
e=[b[0],b[1],b[2]],i=e[0]+e[1]+e[2],f=0;f<3;f++){e[f]=i>660?e[f]*0.85:0.73*e[f]+90;e[f]=parseInt(e[f],10)}e[3]=0.3+0.35*b[3];c.push("rgba("+e[0]+","+e[1]+","+e[2]+","+e[3]+")")}}else{b=g.jqplot.getColorComponents(a);e=[b[0],b[1],b[2]];i=e[0]+e[1]+e[2];for(f=0;f<3;f++){e[f]=i>660?e[f]*0.85:0.73*e[f]+90;e[f]=parseInt(e[f],10)}e[3]=0.3+0.35*b[3];c="rgba("+e[0]+","+e[1]+","+e[2]+","+e[3]+")"}return c};g.jqplot.ColorGenerator=function(a){a=a||g.jqplot.config.defaultColors;var c=0;this.next=function(){c<
a.length||(c=0);return a[c++]};this.previous=function(){if(c>0)return a[c--];else{c=a.length-1;return a[c]}};this.get=function(d){return a[d-a.length*Math.floor(d/a.length)]};this.setColors=function(d){a=d};this.reset=function(){c=0};this.getIndex=function(){return c};this.setIndex=function(d){c=d}};g.jqplot.hex2rgb=function(a,c){a=a.replace("#","");if(a.length==3)a=a.charAt(0)+a.charAt(0)+a.charAt(1)+a.charAt(1)+a.charAt(2)+a.charAt(2);var d;d="rgba("+parseInt(a.slice(0,2),16)+", "+parseInt(a.slice(2,
4),16)+", "+parseInt(a.slice(4,6),16);if(c)d+=", "+c;d+=")";return d};g.jqplot.rgb2hex=function(a){a=a.match(/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *(?:, *[0-9.]*)?\)/);for(var c="#",d=1;d<4;d++){var b;b=a[d].search(/%/)!=-1?parseInt(255*a[d]/100,10).toString(16):parseInt(a[d],10).toString(16);if(b.length==1)b="0"+b;c+=b}return c};g.jqplot.normalize2rgb=function(a,c){if(a.search(/^ *rgba?\(/)!=-1)return a;else if(a.search(/^ *#?[0-9a-fA-F]?[0-9a-fA-F]/)!=
-1)return g.jqplot.hex2rgb(a,c);else throw"invalid color spec";};g.jqplot.getColorComponents=function(a){a=g.jqplot.colorKeywordMap[a]||a;a=g.jqplot.normalize2rgb(a).match(/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *,? *([0-9.]* *)?\)/);for(var c=[],d=1;d<4;d++)c[d-1]=a[d].search(/%/)!=-1?parseInt(255*a[d]/100,10):parseInt(a[d],10);c[3]=parseFloat(a[4])?parseFloat(a[4]):1;return c};g.jqplot.colorKeywordMap={aliceblue:"rgb(240, 248, 255)",antiquewhite:"rgb(250, 235, 215)",
aqua:"rgb( 0, 255, 255)",aquamarine:"rgb(127, 255, 212)",azure:"rgb(240, 255, 255)",beige:"rgb(245, 245, 220)",bisque:"rgb(255, 228, 196)",black:"rgb( 0, 0, 0)",blanchedalmond:"rgb(255, 235, 205)",blue:"rgb( 0, 0, 255)",blueviolet:"rgb(138, 43, 226)",brown:"rgb(165, 42, 42)",burlywood:"rgb(222, 184, 135)",cadetblue:"rgb( 95, 158, 160)",chartreuse:"rgb(127, 255, 0)",chocolate:"rgb(210, 105, 30)",coral:"rgb(255, 127, 80)",cornflowerblue:"rgb(100, 149, 237)",cornsilk:"rgb(255, 248, 220)",crimson:"rgb(220, 20, 60)",
cyan:"rgb( 0, 255, 255)",darkblue:"rgb( 0, 0, 139)",darkcyan:"rgb( 0, 139, 139)",darkgoldenrod:"rgb(184, 134, 11)",darkgray:"rgb(169, 169, 169)",darkgreen:"rgb( 0, 100, 0)",darkgrey:"rgb(169, 169, 169)",darkkhaki:"rgb(189, 183, 107)",darkmagenta:"rgb(139, 0, 139)",darkolivegreen:"rgb( 85, 107, 47)",darkorange:"rgb(255, 140, 0)",darkorchid:"rgb(153, 50, 204)",darkred:"rgb(139, 0, 0)",darksalmon:"rgb(233, 150, 122)",darkseagreen:"rgb(143, 188, 143)",darkslateblue:"rgb( 72, 61, 139)",darkslategray:"rgb( 47, 79, 79)",
darkslategrey:"rgb( 47, 79, 79)",darkturquoise:"rgb( 0, 206, 209)",darkviolet:"rgb(148, 0, 211)",deeppink:"rgb(255, 20, 147)",deepskyblue:"rgb( 0, 191, 255)",dimgray:"rgb(105, 105, 105)",dimgrey:"rgb(105, 105, 105)",dodgerblue:"rgb( 30, 144, 255)",firebrick:"rgb(178, 34, 34)",floralwhite:"rgb(255, 250, 240)",forestgreen:"rgb( 34, 139, 34)",fuchsia:"rgb(255, 0, 255)",gainsboro:"rgb(220, 220, 220)",ghostwhite:"rgb(248, 248, 255)",gold:"rgb(255, 215, 0)",goldenrod:"rgb(218, 165, 32)",gray:"rgb(128, 128, 128)",
grey:"rgb(128, 128, 128)",green:"rgb( 0, 128, 0)",greenyellow:"rgb(173, 255, 47)",honeydew:"rgb(240, 255, 240)",hotpink:"rgb(255, 105, 180)",indianred:"rgb(205, 92, 92)",indigo:"rgb( 75, 0, 130)",ivory:"rgb(255, 255, 240)",khaki:"rgb(240, 230, 140)",lavender:"rgb(230, 230, 250)",lavenderblush:"rgb(255, 240, 245)",lawngreen:"rgb(124, 252, 0)",lemonchiffon:"rgb(255, 250, 205)",lightblue:"rgb(173, 216, 230)",lightcoral:"rgb(240, 128, 128)",lightcyan:"rgb(224, 255, 255)",lightgoldenrodyellow:"rgb(250, 250, 210)",
lightgray:"rgb(211, 211, 211)",lightgreen:"rgb(144, 238, 144)",lightgrey:"rgb(211, 211, 211)",lightpink:"rgb(255, 182, 193)",lightsalmon:"rgb(255, 160, 122)",lightseagreen:"rgb( 32, 178, 170)",lightskyblue:"rgb(135, 206, 250)",lightslategray:"rgb(119, 136, 153)",lightslategrey:"rgb(119, 136, 153)",lightsteelblue:"rgb(176, 196, 222)",lightyellow:"rgb(255, 255, 224)",lime:"rgb( 0, 255, 0)",limegreen:"rgb( 50, 205, 50)",linen:"rgb(250, 240, 230)",magenta:"rgb(255, 0, 255)",maroon:"rgb(128, 0, 0)",mediumaquamarine:"rgb(102, 205, 170)",
mediumblue:"rgb( 0, 0, 205)",mediumorchid:"rgb(186, 85, 211)",mediumpurple:"rgb(147, 112, 219)",mediumseagreen:"rgb( 60, 179, 113)",mediumslateblue:"rgb(123, 104, 238)",mediumspringgreen:"rgb( 0, 250, 154)",mediumturquoise:"rgb( 72, 209, 204)",mediumvioletred:"rgb(199, 21, 133)",midnightblue:"rgb( 25, 25, 112)",mintcream:"rgb(245, 255, 250)",mistyrose:"rgb(255, 228, 225)",moccasin:"rgb(255, 228, 181)",navajowhite:"rgb(255, 222, 173)",navy:"rgb( 0, 0, 128)",oldlace:"rgb(253, 245, 230)",olive:"rgb(128, 128, 0)",
olivedrab:"rgb(107, 142, 35)",orange:"rgb(255, 165, 0)",orangered:"rgb(255, 69, 0)",orchid:"rgb(218, 112, 214)",palegoldenrod:"rgb(238, 232, 170)",palegreen:"rgb(152, 251, 152)",paleturquoise:"rgb(175, 238, 238)",palevioletred:"rgb(219, 112, 147)",papayawhip:"rgb(255, 239, 213)",peachpuff:"rgb(255, 218, 185)",peru:"rgb(205, 133, 63)",pink:"rgb(255, 192, 203)",plum:"rgb(221, 160, 221)",powderblue:"rgb(176, 224, 230)",purple:"rgb(128, 0, 128)",red:"rgb(255, 0, 0)",rosybrown:"rgb(188, 143, 143)",royalblue:"rgb( 65, 105, 225)",
saddlebrown:"rgb(139, 69, 19)",salmon:"rgb(250, 128, 114)",sandybrown:"rgb(244, 164, 96)",seagreen:"rgb( 46, 139, 87)",seashell:"rgb(255, 245, 238)",sienna:"rgb(160, 82, 45)",silver:"rgb(192, 192, 192)",skyblue:"rgb(135, 206, 235)",slateblue:"rgb(106, 90, 205)",slategray:"rgb(112, 128, 144)",slategrey:"rgb(112, 128, 144)",snow:"rgb(255, 250, 250)",springgreen:"rgb( 0, 255, 127)",steelblue:"rgb( 70, 130, 180)",tan:"rgb(210, 180, 140)",teal:"rgb( 0, 128, 128)",thistle:"rgb(216, 191, 216)",tomato:"rgb(255, 99, 71)",
turquoise:"rgb( 64, 224, 208)",violet:"rgb(238, 130, 238)",wheat:"rgb(245, 222, 179)",white:"rgb(255, 255, 255)",whitesmoke:"rgb(245, 245, 245)",yellow:"rgb(255, 255, 0)",yellowgreen:"rgb(154, 205, 50)"};g.jqplot.AxisLabelRenderer=function(a){g.jqplot.ElemContainer.call(this);this.show=true;this.label="";this.textColor=this.fontSize=this.fontFamily=null;this.escapeHTML=false;g.extend(true,this,a)};g.jqplot.AxisLabelRenderer.prototype=new g.jqplot.ElemContainer;g.jqplot.AxisLabelRenderer.prototype.constructor=
g.jqplot.AxisLabelRenderer;g.jqplot.AxisLabelRenderer.prototype.init=function(a){g.extend(true,this,a)};g.jqplot.AxisLabelRenderer.prototype.draw=function(){if(this._elem){this._elem.emptyForce();this._elem=null}this._elem=g('<div style="position:absolute;" class="jqplot-'+this.axis+'-label"></div>');Number(this.label)&&this._elem.css("white-space","nowrap");this.escapeHTML?this._elem.text(this.label):this._elem.html(this.label);this.fontFamily&&this._elem.css("font-family",this.fontFamily);this.fontSize&&
this._elem.css("font-size",this.fontSize);this.textColor&&this._elem.css("color",this.textColor);return this._elem};g.jqplot.AxisLabelRenderer.prototype.pack=function(){};g.jqplot.AxisTickRenderer=function(a){g.jqplot.ElemContainer.call(this);this.mark="outside";this.showGridline=this.showMark=true;this.isMinorTick=false;this.size=4;this.markSize=6;this.showLabel=this.show=true;this.value=this.label=null;this._styles={};this.formatter=g.jqplot.DefaultTickFormatter;this.formatString=this.prefix="";
this._breakTick=this.escapeHTML=false;g.extend(true,this,a)};g.jqplot.AxisTickRenderer.prototype.init=function(a){g.extend(true,this,a)};g.jqplot.AxisTickRenderer.prototype=new g.jqplot.ElemContainer;g.jqplot.AxisTickRenderer.prototype.constructor=g.jqplot.AxisTickRenderer;g.jqplot.AxisTickRenderer.prototype.setTick=function(a,c,d){this.value=a;this.axis=c;if(d)this.isMinorTick=true;return this};g.jqplot.AxisTickRenderer.prototype.draw=function(){if(this.label===null)this.label=this.prefix+this.formatter(this.formatString,
this.value);var a={position:"absolute"};if(Number(this.label))a.whitSpace="nowrap";if(this._elem){this._elem.emptyForce();this._elem=null}this._elem=g(document.createElement("div"));this._elem.addClass("jqplot-"+this.axis+"-tick");this.escapeHTML?this._elem.text(this.label):this._elem.html(this.label);this._elem.css(a);for(var c in this._styles)this._elem.css(c,this._styles[c]);this.fontFamily&&this._elem.css("font-family",this.fontFamily);this.fontSize&&this._elem.css("font-size",this.fontSize);
this.textColor&&this._elem.css("color",this.textColor);this._breakTick&&this._elem.addClass("jqplot-breakTick");return this._elem};g.jqplot.DefaultTickFormatter=function(a,c){if(typeof c=="number"){if(!a)a=g.jqplot.config.defaultTickFormatString;return g.jqplot.sprintf(a,c)}else return String(c)};g.jqplot.AxisTickRenderer.prototype.pack=function(){};g.jqplot.CanvasGridRenderer=function(){this.shadowRenderer=new g.jqplot.ShadowRenderer};g.jqplot.CanvasGridRenderer.prototype.init=function(a){g.extend(true,
this,a);this.renderer.shadowRenderer.init({lineJoin:"miter",lineCap:"round",fill:false,isarc:false,angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.shadowWidth,closePath:false,strokeStyle:this.shadowColor})};g.jqplot.CanvasGridRenderer.prototype.createElement=function(a){var c;if(this._elem){if(g.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==A){c=this._elem.get(0);window.G_vmlCanvasManager.uninitElement(c)}this._elem.emptyForce();
this._elem=null}c=a.canvasManager.getCanvas();var d=this._plotDimensions.width,b=this._plotDimensions.height;c.width=d;c.height=b;this._elem=g(c);this._elem.addClass("jqplot-grid-canvas");this._elem.css({position:"absolute",left:0,top:0});a.canvasManager.initCanvas(c);this._top=this._offsets.top;this._bottom=b-this._offsets.bottom;this._left=this._offsets.left;this._right=d-this._offsets.right;this._width=this._right-this._left;this._height=this._bottom-this._top;return this._elem};g.jqplot.CanvasGridRenderer.prototype.draw=
function(){function a(o,s,r,p,u){c.save();u=u||{};if(u.lineWidth==null||u.lineWidth!=0){g.extend(true,c,u);c.beginPath();c.moveTo(o,s);c.lineTo(r,p);c.stroke();c.restore()}}var c=this._ctx=this._elem.get(0).getContext("2d"),d=this._axes;c.save();c.clearRect(0,0,this._plotDimensions.width,this._plotDimensions.height);c.fillStyle=this.backgroundColor||this.background;c.fillRect(this._left,this._top,this._width,this._height);c.save();c.lineJoin="miter";c.lineCap="butt";c.lineWidth=this.gridLineWidth;
c.strokeStyle=this.gridLineColor;for(var b,e,i=["xaxis","yaxis","x2axis","y2axis"],f=4;f>0;f--){var h=i[f-1],l=d[h],j=l._ticks,n=j.length;if(l.show){if(l.drawBaseline){var k={};if(l.baselineWidth!==null)k.lineWidth=l.baselineWidth;if(l.baselineColor!==null)k.strokeStyle=l.baselineColor;switch(h){case "xaxis":a(this._left,this._bottom,this._right,this._bottom,k);break;case "yaxis":a(this._left,this._bottom,this._left,this._top,k);break;case "x2axis":a(this._left,this._bottom,this._right,this._bottom,
k);break;case "y2axis":a(this._right,this._bottom,this._right,this._top,k)}}for(;n>0;n--){var m=j[n-1];if(m.show){k=Math.round(l.u2p(m.value))+0.5;switch(h){case "xaxis":if(m.showGridline&&this.drawGridlines&&(!m.isMinorTick&&l.drawMajorGridlines||m.isMinorTick&&l.drawMinorGridlines))a(k,this._top,k,this._bottom);if(m.showMark&&m.mark&&(!m.isMinorTick&&l.drawMajorTickMarks||m.isMinorTick&&l.drawMinorTickMarks)){e=m.markSize;b=m.mark;k=Math.round(l.u2p(m.value))+0.5;switch(b){case "outside":b=this._bottom;
e=this._bottom+e;break;case "inside":b=this._bottom-e;e=this._bottom;break;case "cross":b=this._bottom-e;e=this._bottom+e;break;default:b=this._bottom;e=this._bottom+e}this.shadow&&this.renderer.shadowRenderer.draw(c,[[k,b],[k,e]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false});a(k,b,k,e)}break;case "yaxis":if(m.showGridline&&this.drawGridlines&&(!m.isMinorTick&&l.drawMajorGridlines||m.isMinorTick&&l.drawMinorGridlines))a(this._right,
k,this._left,k);if(m.showMark&&m.mark&&(!m.isMinorTick&&l.drawMajorTickMarks||m.isMinorTick&&l.drawMinorTickMarks)){e=m.markSize;b=m.mark;k=Math.round(l.u2p(m.value))+0.5;switch(b){case "outside":b=this._left-e;e=this._left;break;case "inside":b=this._left;e=this._left+e;break;case "cross":b=this._left-e;e=this._left+e;break;default:b=this._left-e;e=this._left}this.shadow&&this.renderer.shadowRenderer.draw(c,[[b,k],[e,k]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*
0.75,fill:false,closePath:false});a(b,k,e,k,{strokeStyle:l.borderColor})}break;case "x2axis":if(m.showGridline&&this.drawGridlines&&(!m.isMinorTick&&l.drawMajorGridlines||m.isMinorTick&&l.drawMinorGridlines))a(k,this._bottom,k,this._top);if(m.showMark&&m.mark&&(!m.isMinorTick&&l.drawMajorTickMarks||m.isMinorTick&&l.drawMinorTickMarks)){e=m.markSize;b=m.mark;k=Math.round(l.u2p(m.value))+0.5;switch(b){case "outside":b=this._top-e;e=this._top;break;case "inside":b=this._top;e=this._top+e;break;case "cross":b=
this._top-e;e=this._top+e;break;default:b=this._top-e;e=this._top}this.shadow&&this.renderer.shadowRenderer.draw(c,[[k,b],[k,e]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false});a(k,b,k,e)}break;case "y2axis":if(m.showGridline&&this.drawGridlines&&(!m.isMinorTick&&l.drawMajorGridlines||m.isMinorTick&&l.drawMinorGridlines))a(this._left,k,this._right,k);if(m.showMark&&m.mark&&(!m.isMinorTick&&l.drawMajorTickMarks||m.isMinorTick&&l.drawMinorTickMarks)){e=
m.markSize;b=m.mark;k=Math.round(l.u2p(m.value))+0.5;switch(b){case "outside":b=this._right;e=this._right+e;break;case "inside":b=this._right-e;e=this._right;break;case "cross":b=this._right-e;e=this._right+e;break;default:b=this._right;e=this._right+e}this.shadow&&this.renderer.shadowRenderer.draw(c,[[b,k],[e,k]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false});a(b,k,e,k,{strokeStyle:l.borderColor})}}}}m=null}j=l=null}i=["y3axis","y4axis",
"y5axis","y6axis","y7axis","y8axis","y9axis","yMidAxis"];for(f=7;f>0;f--){l=d[i[f-1]];j=l._ticks;if(l.show){n=j[l.numberTicks-1];k=j[0];h=l.getLeft();m=[[h,n.getTop()+n.getHeight()/2],[h,k.getTop()+k.getHeight()/2+1]];this.shadow&&this.renderer.shadowRenderer.draw(c,m,{lineCap:"butt",fill:false,closePath:false});a(m[0][0],m[0][1],m[1][0],m[1][1],{lineCap:"butt",strokeStyle:l.borderColor,lineWidth:l.borderWidth});for(n=j.length;n>0;n--){m=j[n-1];e=m.markSize;b=m.mark;k=Math.round(l.u2p(m.value))+0.5;
if(m.showMark&&m.mark){switch(b){case "outside":b=h;e=h+e;break;case "inside":b=h-e;e=h;break;case "cross":b=h-e;e=h+e;break;default:b=h;e=h+e}m=[[b,k],[e,k]];this.shadow&&this.renderer.shadowRenderer.draw(c,m,{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false});a(b,k,e,k,{strokeStyle:l.borderColor})}m=null}k=null}j=l=null}c.restore();if(this.shadow){m=[[this._left,this._bottom],[this._right,this._bottom],[this._right,this._top]];this.renderer.shadowRenderer.draw(c,
m)}if(this.borderWidth!=0&&this.drawBorder){a(this._left,this._top,this._right,this._top,{lineCap:"round",strokeStyle:d.x2axis.borderColor,lineWidth:d.x2axis.borderWidth});a(this._right,this._top,this._right,this._bottom,{lineCap:"round",strokeStyle:d.y2axis.borderColor,lineWidth:d.y2axis.borderWidth});a(this._right,this._bottom,this._left,this._bottom,{lineCap:"round",strokeStyle:d.xaxis.borderColor,lineWidth:d.xaxis.borderWidth});a(this._left,this._bottom,this._left,this._top,{lineCap:"round",strokeStyle:d.yaxis.borderColor,
lineWidth:d.yaxis.borderWidth})}c.restore();d=c=null};g.jqplot.DivTitleRenderer=function(){};g.jqplot.DivTitleRenderer.prototype.init=function(a){g.extend(true,this,a)};g.jqplot.DivTitleRenderer.prototype.draw=function(){if(this._elem){this._elem.emptyForce();this._elem=null}var a=document.createElement("div");this._elem=g(a);this._elem.addClass("jqplot-title");if(this.text){if(this.text){var c;if(this.color)c=this.color;else if(this.textColor)c=this.textColor;a={position:"absolute",top:"0px",left:"0px"};
if(this._plotWidth)a.width=this._plotWidth+"px";if(this.fontSize)a.fontSize=this.fontSize;a.textAlign=typeof this.textAlign==="string"?this.textAlign:"center";if(c)a.color=c;if(this.paddingBottom)a.paddingBottom=this.paddingBottom;if(this.fontFamily)a.fontFamily=this.fontFamily;this._elem.css(a);this.escapeHtml?this._elem.text(this.text):this._elem.html(this.text)}}else{this.show=false;this._elem.height(0);this._elem.width(0)}return this._elem};g.jqplot.DivTitleRenderer.prototype.pack=function(){};
g.jqplot.LinePattern=function(a,c){var d={dotted:[0.1,g.jqplot.config.dotGapLength],dashed:[g.jqplot.config.dashLength,g.jqplot.config.gapLength],solid:null};if(typeof c==="string")if(c[0]==="."||c[0]==="-"){d=c;c=[];for(var b=0,e=d.length;b<e;b++){if(d[b]===".")c.push(0.1);else if(d[b]==="-")c.push(g.jqplot.config.dashLength);else continue;c.push(g.jqplot.config.gapLength)}}else c=d[c];if(!(c&&c.length))return a;var i=0,f=c[0],h=0,l=0,j=0,n=0,k=function(m,o){var s=a.lineWidth,r=m-h,p=o-l,u=Math.sqrt(r*
r+p*p);if(u>0&&s>0){r/=u;for(p/=u;;){var t=s*f;if(t<u){h+=t*r;l+=t*p;(i&1)==0?a.lineTo(h,l):a.moveTo(h,l);u-=t;i++;if(i>=c.length)i=0;f=c[i]}else{h=m;l=o;(i&1)==0?a.lineTo(h,l):a.moveTo(h,l);f-=u/s;break}}}};return{moveTo:function(m,o){a.moveTo(m,o);h=m;l=o;j=m;n=o},lineTo:k,beginPath:function(){a.beginPath()},closePath:function(){k(j,n)}}};g.jqplot.LineRenderer=function(){this.shapeRenderer=new g.jqplot.ShapeRenderer;this.shadowRenderer=new g.jqplot.ShadowRenderer};g.jqplot.LineRenderer.prototype.init=
function(a,c){a=a||{};this._type="line";this.renderer.smooth=false;this.renderer.tension=null;this.renderer.constrainSmoothing=true;this.renderer._smoothedData=[];this.renderer._smoothedPlotData=[];this.renderer._hiBandGridData=[];this.renderer._lowBandGridData=[];this.renderer._hiBandSmoothedData=[];this.renderer._lowBandSmoothedData=[];this.renderer.bandData=[];this.renderer.bands={show:false,hiData:[],lowData:[],color:this.color,showLines:false,fill:true,fillColor:null,_min:null,_max:null,interval:"3%"};
var d={highlightMouseOver:a.highlightMouseOver,highlightMouseDown:a.highlightMouseDown,highlightColor:a.highlightColor};delete a.highlightMouseOver;delete a.highlightMouseDown;delete a.highlightColor;g.extend(true,this.renderer,a);this.renderer.options=a;if(this.renderer.bandData.length>1&&(!a.bands||a.bands.show==null))this.renderer.bands.show=true;else if(a.bands&&a.bands.show==null&&a.bands.interval!=null)this.renderer.bands.show=true;if(this.fill)this.renderer.bands.show=false;this.renderer.bands.show&&
this.renderer.initBands.call(this,this.renderer.options,c);if(this._stack)this.renderer.smooth=false;this.renderer.shapeRenderer.init({lineJoin:this.lineJoin,lineCap:this.lineCap,fill:this.fill,isarc:false,strokeStyle:this.color,fillStyle:this.fillColor,lineWidth:this.lineWidth,linePattern:this.linePattern,closePath:this.fill});var b=a.shadowOffset;if(b==null)b=this.lineWidth>2.5?1.25*(1+(Math.atan(this.lineWidth/2.5)/0.785398163-1)*0.6):1.25*Math.atan(this.lineWidth/2.5)/0.785398163;this.renderer.shadowRenderer.init({lineJoin:this.lineJoin,
lineCap:this.lineCap,fill:this.fill,isarc:false,angle:this.shadowAngle,offset:b,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.lineWidth,linePattern:this.linePattern,closePath:this.fill});this._areaPoints=[];this._boundingBox=[[],[]];if(!this.isTrendline&&this.fill||this.renderer.bands.show){this.highlightMouseOver=true;this.highlightMouseDown=false;this.highlightColor=null;if(d.highlightMouseDown&&d.highlightMouseOver==null)d.highlightMouseOver=false;g.extend(true,this,{highlightMouseOver:d.highlightMouseOver,
highlightMouseDown:d.highlightMouseDown,highlightColor:d.highlightColor});if(!this.highlightColor)this.highlightColor=g.jqplot.computeHighlightColors(this.renderer.bands.show?this.renderer.bands.fillColor:this.fillColor);if(this.highlighter)this.highlighter.show=false}if(!this.isTrendline&&c){c.plugins.lineRenderer={};c.postInitHooks.addOnce(ha);c.postDrawHooks.addOnce(ia);c.eventListenerHooks.addOnce("jqplotMouseMove",ja);c.eventListenerHooks.addOnce("jqplotMouseDown",ka);c.eventListenerHooks.addOnce("jqplotMouseUp",
la);c.eventListenerHooks.addOnce("jqplotClick",ma);c.eventListenerHooks.addOnce("jqplotRightClick",na)}};g.jqplot.LineRenderer.prototype.initBands=function(a){var c=a.bandData||[];a=this.renderer.bands;a.hiData=[];a.lowData=[];var d=this.data;a._max=null;a._min=null;if(c.length==2)if(g.isArray(c[0][0])){for(var b=0,e=0,i=0,f=c[0].length;i<f;i++){d=c[0][i];if(d[1]!=null&&d[1]>a._max||a._max==null)a._max=d[1];if(d[1]!=null&&d[1]<a._min||a._min==null)a._min=d[1]}i=0;for(f=c[1].length;i<f;i++){d=c[1][i];
if(d[1]!=null&&d[1]>a._max||a._max==null){a._max=d[1];e=1}if(d[1]!=null&&d[1]<a._min||a._min==null){a._min=d[1];b=1}}if(e===b)a.show=false;a.hiData=c[e];a.lowData=c[b]}else if(c[0].length===d.length&&c[1].length===d.length){e=(b=c[0][0]>c[1][0]?0:1)?0:1;i=0;for(f=d.length;i<f;i++){a.hiData.push([d[i][0],c[b][i]]);a.lowData.push([d[i][0],c[e][i]])}}else a.show=false;else if(c.length>2&&!g.isArray(c[0][0])){e=(b=c[0][0]>c[0][1]?0:1)?0:1;i=0;for(f=c.length;i<f;i++){a.hiData.push([d[i][0],c[i][b]]);a.lowData.push([d[i][0],
c[i][e]])}}else{i=a.interval;var h=e=b=c=null;if(g.isArray(i)){c=i[0];b=i[1]}else c=i;if(isNaN(c)){if(c.charAt(c.length-1)==="%"){e="multiply";c=parseFloat(c)/100+1}}else{c=parseFloat(c);e="add"}if(b!==null&&isNaN(b)){if(b.charAt(b.length-1)==="%"){h="multiply";b=parseFloat(b)/100+1}}else if(b!==null){b=parseFloat(b);h="add"}if(c!==null){if(b===null){b=-c;h=e;if(h==="multiply")b+=2}if(c<b){i=c;c=b;b=i;i=e;e=h;h=i}i=0;for(f=d.length;i<f;i++){switch(e){case "add":a.hiData.push([d[i][0],d[i][1]+c]);
break;case "multiply":a.hiData.push([d[i][0],d[i][1]*c])}switch(h){case "add":a.lowData.push([d[i][0],d[i][1]+b]);break;case "multiply":a.lowData.push([d[i][0],d[i][1]*b])}}}else a.show=false}d=a.hiData;c=a.lowData;i=0;for(f=d.length;i<f;i++)if(d[i][1]!=null&&d[i][1]>a._max||a._max==null)a._max=d[i][1];i=0;for(f=c.length;i<f;i++)if(c[i][1]!=null&&c[i][1]<a._min||a._min==null)a._min=c[i][1];if(a.fillColor===null){i=g.jqplot.getColorComponents(a.color);i[3]*=0.5;a.fillColor="rgba("+i[0]+", "+i[1]+", "+
i[2]+", "+i[3]+")"}};g.jqplot.LineRenderer.prototype.setGridData=function(){var a=this._xaxis.series_u2p,c=this._yaxis.series_u2p,d=this._plotData,b=this._prevPlotData;this.gridData=[];this._prevGridData=[];this.renderer._smoothedData=[];this.renderer._smoothedPlotData=[];this.renderer._hiBandGridData=[];this.renderer._lowBandGridData=[];this.renderer._hiBandSmoothedData=[];this.renderer._lowBandSmoothedData=[];for(var e=this.renderer.bands,i=false,f=0,h=this.data.length;f<h;f++){if(d[f][0]!=null&&
d[f][1]!=null)this.gridData.push([a.call(this._xaxis,d[f][0]),c.call(this._yaxis,d[f][1])]);else if(d[f][0]==null){i=true;this.gridData.push([null,c.call(this._yaxis,d[f][1])])}else if(d[f][1]==null){i=true;this.gridData.push([a.call(this._xaxis,d[f][0]),null])}if(b[f]!=null&&b[f][0]!=null&&b[f][1]!=null)this._prevGridData.push([a.call(this._xaxis,b[f][0]),c.call(this._yaxis,b[f][1])]);else if(b[f]!=null&&b[f][0]==null)this._prevGridData.push([null,c.call(this._yaxis,b[f][1])]);else b[f]!=null&&b[f][0]!=
null&&b[f][1]==null&&this._prevGridData.push([a.call(this._xaxis,b[f][0]),null])}if(i){this.renderer.smooth=false;if(this._type==="line")e.show=false}if(this._type==="line"&&e.show){f=0;for(h=e.hiData.length;f<h;f++)this.renderer._hiBandGridData.push([a.call(this._xaxis,e.hiData[f][0]),c.call(this._yaxis,e.hiData[f][1])]);f=0;for(h=e.lowData.length;f<h;f++)this.renderer._lowBandGridData.push([a.call(this._xaxis,e.lowData[f][0]),c.call(this._yaxis,e.lowData[f][1])])}if(this._type==="line"&&this.renderer.smooth&&
this.gridData.length>2)if(this.renderer.constrainSmoothing){a=R.call(this,this.gridData);this.renderer._smoothedData=a[0];this.renderer._smoothedPlotData=a[1];if(e.show){a=R.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=a[0];a=R.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=a[0]}}else{a=S.call(this,this.gridData);this.renderer._smoothedData=a[0];this.renderer._smoothedPlotData=a[1];if(e.show){a=S.call(this,this.renderer._hiBandGridData);
this.renderer._hiBandSmoothedData=a[0];a=S.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=a[0]}}};g.jqplot.LineRenderer.prototype.makeGridData=function(a){var c=this._xaxis.series_u2p,d=this._yaxis.series_u2p,b=[];this.renderer._smoothedData=[];this.renderer._smoothedPlotData=[];this.renderer._hiBandGridData=[];this.renderer._lowBandGridData=[];this.renderer._hiBandSmoothedData=[];this.renderer._lowBandSmoothedData=[];for(var e=this.renderer.bands,i=false,f=0;f<a.length;f++)if(a[f][0]!=
null&&a[f][1]!=null)b.push([c.call(this._xaxis,a[f][0]),d.call(this._yaxis,a[f][1])]);else if(a[f][0]==null){i=true;b.push([null,d.call(this._yaxis,a[f][1])])}else if(a[f][1]==null){i=true;b.push([c.call(this._xaxis,a[f][0]),null])}if(i){this.renderer.smooth=false;if(this._type==="line")e.show=false}if(this._type==="line"&&e.show){f=0;for(a=e.hiData.length;f<a;f++)this.renderer._hiBandGridData.push([c.call(this._xaxis,e.hiData[f][0]),d.call(this._yaxis,e.hiData[f][1])]);f=0;for(a=e.lowData.length;f<
a;f++)this.renderer._lowBandGridData.push([c.call(this._xaxis,e.lowData[f][0]),d.call(this._yaxis,e.lowData[f][1])])}if(this._type==="line"&&this.renderer.smooth&&b.length>2)if(this.renderer.constrainSmoothing){c=R.call(this,b);this.renderer._smoothedData=c[0];this.renderer._smoothedPlotData=c[1];if(e.show){c=R.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=c[0];c=R.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=c[0]}}else{c=S.call(this,b);
this.renderer._smoothedData=c[0];this.renderer._smoothedPlotData=c[1];if(e.show){c=S.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=c[0];c=S.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=c[0]}}return b};g.jqplot.LineRenderer.prototype.draw=function(a,c,d){var b;d=g.extend(true,{},d);var e=d.shadow!=A?d.shadow:this.shadow;b=d.showLine!=A?d.showLine:this.showLine;var i=d.fill!=A?d.fill:this.fill,f=d.fillAndStroke!=A?d.fillAndStroke:this.fillAndStroke,
h,l;a.save();if(c.length){if(b)if(i){if(this.fillToZero){l=this.negativeColor;if(!this.useNegativeColors)l=d.fillStyle;var j=d.fillStyle;if(f)h=c.slice(0);if(this.index==0||!this._stack){var n=[],k=this.renderer.smooth?this.renderer._smoothedPlotData:this._plotData;this._areaPoints=[];var m=this._yaxis.series_u2p(this.fillToValue);this._xaxis.series_u2p(this.fillToValue);d.closePath=true;if(this.fillAxis=="y"){n.push([c[0][0],m]);this._areaPoints.push([c[0][0],m]);for(b=0;b<c.length-1;b++){n.push(c[b]);
this._areaPoints.push(c[b]);if(k[b][1]*k[b+1][1]<0){d.fillStyle=k[b][1]<0?l:j;var o=c[b][0]+(c[b+1][0]-c[b][0])*(m-c[b][1])/(c[b+1][1]-c[b][1]);n.push([o,m]);this._areaPoints.push([o,m]);e&&this.renderer.shadowRenderer.draw(a,n,d);this.renderer.shapeRenderer.draw(a,n,d);n=[[o,m]]}}d.fillStyle=k[c.length-1][1]<0?l:j;n.push(c[c.length-1]);this._areaPoints.push(c[c.length-1]);n.push([c[c.length-1][0],m]);this._areaPoints.push([c[c.length-1][0],m])}e&&this.renderer.shadowRenderer.draw(a,n,d);this.renderer.shapeRenderer.draw(a,
n,d)}else{l=this._prevGridData;for(b=l.length;b>0;b--)c.push(l[b-1]);e&&this.renderer.shadowRenderer.draw(a,c,d);this._areaPoints=c;this.renderer.shapeRenderer.draw(a,c,d)}}else{if(f)h=c.slice(0);if(this.index==0||!this._stack){b=a.canvas.height;c.unshift([c[0][0],b]);c.push([c[c.length-1][0],b])}else{l=this._prevGridData;for(b=l.length;b>0;b--)c.push(l[b-1])}this._areaPoints=c;e&&this.renderer.shadowRenderer.draw(a,c,d);this.renderer.shapeRenderer.draw(a,c,d)}if(f){b=g.extend(true,{},d,{fill:false,
closePath:false});this.renderer.shapeRenderer.draw(a,h,b);if(this.markerRenderer.show){if(this.renderer.smooth)h=this.gridData;for(b=0;b<h.length;b++)this.markerRenderer.draw(h[b][0],h[b][1],a,d.markerOptions)}}}else{if(this.renderer.bands.show){h=g.extend(true,{},d);if(this.renderer.bands.showLines){b=this.renderer.smooth?this.renderer._hiBandSmoothedData:this.renderer._hiBandGridData;this.renderer.shapeRenderer.draw(a,b,d);b=this.renderer.smooth?this.renderer._lowBandSmoothedData:this.renderer._lowBandGridData;
this.renderer.shapeRenderer.draw(a,b,h)}if(this.renderer.bands.fill){this._areaPoints=b=this.renderer.smooth?this.renderer._hiBandSmoothedData.concat(this.renderer._lowBandSmoothedData.reverse()):this.renderer._hiBandGridData.concat(this.renderer._lowBandGridData.reverse());h.closePath=true;h.fill=true;h.fillStyle=this.renderer.bands.fillColor;this.renderer.shapeRenderer.draw(a,b,h)}}e&&this.renderer.shadowRenderer.draw(a,c,d);this.renderer.shapeRenderer.draw(a,c,d)}e=f=h=l=null;for(b=0;b<this._areaPoints.length;b++){j=
this._areaPoints[b];if(e>j[0]||e==null)e=j[0];if(l<j[1]||l==null)l=j[1];if(f<j[0]||f==null)f=j[0];if(h>j[1]||h==null)h=j[1]}if(this.type==="line"&&this.renderer.bands.show){l=this._yaxis.series_u2p(this.renderer.bands._min);h=this._yaxis.series_u2p(this.renderer.bands._max)}this._boundingBox=[[e,l],[f,h]];if(this.markerRenderer.show&&!i){if(this.renderer.smooth)c=this.gridData;for(b=0;b<c.length;b++)c[b][0]!=null&&c[b][1]!=null&&this.markerRenderer.draw(c[b][0],c[b][1],a,d.markerOptions)}}a.restore()};
g.jqplot.LineRenderer.prototype.drawShadow=function(){};g.jqplot.LinearAxisRenderer=function(){};g.jqplot.LinearAxisRenderer.prototype.init=function(a){this.breakPoints=null;this.breakTickLabel="&asymp;";this.drawBaseline=true;this.baselineColor=this.baselineWidth=null;this.forceTickAt100=this.forceTickAt0=false;this.minorTicks=this.tickInset=0;this.alignTicks=false;this._autoFormatString="";this._overrideFormatString=false;this._scalefact=1;g.extend(true,this,a);if(this.breakPoints)if(g.isArray(this.breakPoints)){if(this.breakPoints.length<
2||this.breakPoints[1]<=this.breakPoints[0])this.breakPoints=null}else this.breakPoints=null;if(this.numberTicks!=null&&this.numberTicks<2)this.numberTicks=2;this.resetDataBounds()};g.jqplot.LinearAxisRenderer.prototype.draw=function(a,c){if(this.show){this.renderer.createTicks.call(this,c);if(this._elem){this._elem.emptyForce();this._elem=null}this._elem=g(document.createElement("div"));this._elem.addClass("jqplot-axis jqplot-"+this.name);this._elem.css("position","absolute");this.name=="xaxis"||
this.name=="x2axis"?this._elem.width(this._plotDimensions.width):this._elem.height(this._plotDimensions.height);this.labelOptions.axis=this.name;this._label=new this.labelRenderer(this.labelOptions);this._label.show&&this._label.draw(a,c).appendTo(this._elem);for(var d=this._ticks,b,e=0;e<d.length;e++){b=d[e];if(b.show&&b.showLabel&&(!b.isMinorTick||this.showMinorTicks))this._elem.append(b.draw(a,c))}}return this._elem};g.jqplot.LinearAxisRenderer.prototype.reset=function(){this.min=this._options.min;
this.max=this._options.max;this.tickInterval=this._options.tickInterval;this.numberTicks=this._options.numberTicks;this._autoFormatString="";if(this._overrideFormatString&&this.tickOptions&&this.tickOptions.formatString)this.tickOptions.formatString=""};g.jqplot.LinearAxisRenderer.prototype.set=function(){var a=0,c,d=0,b=0,e=this._label==null?false:this._label.show;if(this.show){for(var i=this._ticks,f=0;f<i.length;f++){c=i[f];if(!c._breakTick&&c.show&&c.showLabel&&(!c.isMinorTick||this.showMinorTicks)){c=
this.name=="xaxis"||this.name=="x2axis"?c._elem.outerHeight(true):c._elem.outerWidth(true);if(c>a)a=c}}if(e){d=this._label._elem.outerWidth(true);b=this._label._elem.outerHeight(true)}if(this.name=="xaxis"){a+=b;this._elem.css({height:a+"px",left:"0px",bottom:"0px"})}else if(this.name=="x2axis"){a+=b;this._elem.css({height:a+"px",left:"0px",top:"0px"})}else{if(this.name=="yaxis"){a+=d;this._elem.css({width:a+"px",left:"0px",top:"0px"})}else{a+=d;this._elem.css({width:a+"px",right:"0px",top:"0px"})}e&&
this._label.constructor==g.jqplot.AxisLabelRenderer&&this._label._elem.css("width",d+"px")}}};g.jqplot.LinearAxisRenderer.prototype.createTicks=function(a){var c=this.ticks,d=this.name,b=this._dataBounds,e,i,f=this.min;e=this.max;var h=this.numberTicks,l=this.tickInterval;if(c.length){for(i=0;i<c.length;i++){e=c[i];f=new this.tickRenderer(this.tickOptions);if(g.isArray(e)){f.value=e[0];if(this.breakPoints)if(e[0]==this.breakPoints[0]){f.label=this.breakTickLabel;f._breakTick=true;f.showGridline=false;
f.showMark=false}else{if(e[0]>this.breakPoints[0]&&e[0]<=this.breakPoints[1]){f.show=false;f.showGridline=false}f.label=e[1]}else f.label=e[1];f.setTick(e[0],this.name)}else if(g.isPlainObject(e)){g.extend(true,f,e);f.axis=this.name}else{f.value=e;if(this.breakPoints)if(e==this.breakPoints[0]){f.label=this.breakTickLabel;f._breakTick=true;f.showGridline=false;f.showMark=false}else if(e>this.breakPoints[0]&&e<=this.breakPoints[1]){f.show=false;f.showGridline=false}f.setTick(e,this.name)}this._ticks.push(f)}this.numberTicks=
c.length;this.min=this._ticks[0].value;this.max=this._ticks[this.numberTicks-1].value;this.tickInterval=(this.max-this.min)/(this.numberTicks-1)}else{d=d=="xaxis"||d=="x2axis"?this._plotDimensions.width:this._plotDimensions.height;i=this.numberTicks;if(this.alignTicks)if(this.name==="x2axis"&&a.axes.xaxis.show)i=a.axes.xaxis.numberTicks;else if(this.name.charAt(0)==="y"&&this.name!=="yaxis"&&this.name!=="yMidAxis"&&a.axes.yaxis.show)i=a.axes.yaxis.numberTicks;c=this.min!=null?this.min:b.min;a=this.max!=
null?this.max:b.max;b=a-c;if(this.tickOptions==null||!this.tickOptions.formatString)this._overrideFormatString=true;if(this.min==null&&this.max==null&&this.tickInterval==null&&!this.autoscale){if(this.forceTickAt0){if(c>0)c=0;if(a<0)a=0}if(this.forceTickAt100){if(c>100)c=100;if(a<100)a=100}this._scalefact=(Math.max(d,31)-30)/300;f=g.jqplot.LinearTickGenerator(c,a,this._scalefact,i);e=c+b*(this.padMin-1);h=a-b*(this.padMax-1);if(c<e||a>h){e=c-b*(this.padMin-1);h=a+b*(this.padMax-1);f=g.jqplot.LinearTickGenerator(e,
h,this._scalefact,i)}this.min=f[0];this.max=f[1];this.numberTicks=f[2];this._autoFormatString=f[3];this.tickInterval=f[4]}else{if(c==a){i=0.05;if(c>0)i=Math.max(Math.log(c)/Math.LN10,0.05);c-=i;a+=i}if(this.autoscale&&this.min==null&&this.max==null){var j=false,n=false;for(i=0;i<this._series.length;i++){var k=this._series[i];if(this.name==(k.fillAxis=="x"?k._xaxis.name:k._yaxis.name)){for(var m=k._plotValues[k.fillAxis],o=m[0],s=m[0],r=1;r<m.length;r++)if(m[r]<o)o=m[r];else if(m[r]>s)s=m[r];r=(s-
o)/s;if(k.renderer.constructor==g.jqplot.BarRenderer)if(o>=0&&(k.fillToZero||r>0.1))j=true;else{j=false;n=k.fill&&k.fillToZero&&o<0&&s>0?true:false}else if(k.fill)if(o>=0&&(k.fillToZero||r>0.1))j=true;else if(o<0&&s>0&&k.fillToZero){j=false;n=true}else n=j=false;else if(o<0)j=false}}if(j){this.numberTicks=2+Math.ceil((d-(this.tickSpacing-1))/this.tickSpacing);f=this.min=0;d=a/(this.numberTicks-1);a=Math.pow(10,Math.abs(Math.floor(Math.log(d)/Math.LN10)));if(d/a==parseInt(d/a,10))d+=a;this.tickInterval=
Math.ceil(d/a)*a;this.max=this.tickInterval*(this.numberTicks-1)}else if(n){this.numberTicks=2+Math.ceil((d-(this.tickSpacing-1))/this.tickSpacing);b=Math.ceil(Math.abs(c)/b*(this.numberTicks-1));i=this.numberTicks-1-b;d=Math.max(Math.abs(c/b),Math.abs(a/i));a=Math.pow(10,Math.abs(Math.floor(Math.log(d)/Math.LN10)));this.tickInterval=Math.ceil(d/a)*a;this.max=this.tickInterval*i;this.min=-this.tickInterval*b}else{if(this.numberTicks==null)this.numberTicks=this.tickInterval?3+Math.ceil(b/this.tickInterval):
2+Math.ceil((d-(this.tickSpacing-1))/this.tickSpacing);if(this.tickInterval==null){d=b/(this.numberTicks-1);a=d<1?Math.pow(10,Math.abs(Math.floor(Math.log(d)/Math.LN10))):1;this.tickInterval=Math.ceil(d*a*this.pad)/a}else a=1/this.tickInterval;d=this.tickInterval*(this.numberTicks-1);b=(d-b)/2;if(this.min==null)this.min=Math.floor(a*(c-b))/a;if(this.max==null)this.max=this.min+d}b=g.jqplot.getSignificantFigures(this.tickInterval);if(b.digitsLeft>=b.significantDigits)b="%d";else{a=Math.max(0,5-b.digitsLeft);
a=Math.min(a,b.digitsRight);b="%."+a+"f"}this._autoFormatString=b}else{c=this.min!=null?this.min:c-b*(this.padMin-1);i=this.max!=null?this.max:a+b*(this.padMax-1);b=i-c;if(this.numberTicks==null)this.numberTicks=this.tickInterval!=null?Math.ceil((i-c)/this.tickInterval)+1:d>100?parseInt(3+(d-100)/75,10):2;if(this.tickInterval==null)this.tickInterval=b/(this.numberTicks-1);if(this.max==null)i=c+this.tickInterval*(this.numberTicks-1);if(this.min==null)c=i-this.tickInterval*(this.numberTicks-1);b=g.jqplot.getSignificantFigures(this.tickInterval);
if(b.digitsLeft>=b.significantDigits)b="%d";else{a=Math.max(0,5-b.digitsLeft);a=Math.min(a,b.digitsRight);b="%."+a+"f"}this._autoFormatString=b;this.min=c;this.max=i}if(this.renderer.constructor==g.jqplot.LinearAxisRenderer&&this._autoFormatString==""){b=(new this.tickRenderer(this.tickOptions)).formatString||g.jqplot.config.defaultTickFormatString;b=b.match(g.jqplot.sprintf.regex)[0];c=0;if(b){if(b.search(/[fFeEgGpP]/)>-1)c=(c=b.match(/\%\.(\d{0,})?[eEfFgGpP]/))?parseInt(c[1],10):6;else if(b.search(/[di]/)>
-1)c=0;b=Math.pow(10,-c);if(this.tickInterval<b)if(h==null&&l==null){this.tickInterval=b;if(e==null&&f==null){this.min=Math.floor(this._dataBounds.min/b)*b;if(this.min==this._dataBounds.min)this.min=this._dataBounds.min-this.tickInterval;this.max=Math.ceil(this._dataBounds.max/b)*b;if(this.max==this._dataBounds.max)this.max=this._dataBounds.max+this.tickInterval;f=(this.max-this.min)/this.tickInterval;f=f.toFixed(11);f=Math.ceil(f);this.numberTicks=f+1}else if(e==null){f=(this._dataBounds.max-this.min)/
this.tickInterval;f=f.toFixed(11);this.numberTicks=Math.ceil(f)+2;this.max=this.min+this.tickInterval*(this.numberTicks-1)}else if(f==null){f=(this.max-this._dataBounds.min)/this.tickInterval;f=f.toFixed(11);this.numberTicks=Math.ceil(f)+2;this.min=this.max-this.tickInterval*(this.numberTicks-1)}else{this.numberTicks=Math.ceil((e-f)/this.tickInterval)+1;this.min=Math.floor(f*Math.pow(10,c))/Math.pow(10,c);this.max=Math.ceil(e*Math.pow(10,c))/Math.pow(10,c);this.numberTicks=Math.ceil((this.max-this.min)/
this.tickInterval)+1}}}}}if(this._overrideFormatString&&this._autoFormatString!=""){this.tickOptions=this.tickOptions||{};this.tickOptions.formatString=this._autoFormatString}for(i=0;i<this.numberTicks;i++){e=this.min+i*this.tickInterval;f=new this.tickRenderer(this.tickOptions);f.setTick(e,this.name);this._ticks.push(f);if(i<this.numberTicks-1)for(r=0;r<this.minorTicks;r++){e+=this.tickInterval/(this.minorTicks+1);f=g.extend(true,{},this.tickOptions,{name:this.name,value:e,label:"",isMinorTick:true});
f=new this.tickRenderer(f);this._ticks.push(f)}}}if(this.tickInset){this.min-=this.tickInset*this.tickInterval;this.max+=this.tickInset*this.tickInterval}};g.jqplot.LinearAxisRenderer.prototype.resetTickValues=function(a){if(g.isArray(a)&&a.length==this._ticks.length){for(var c,d=0;d<a.length;d++){c=this._ticks[d];c.value=a[d];c.label=c.formatter(c.formatString,a[d]);c.label=c.prefix+c.label;c._elem.html(c.label)}this.min=g.jqplot.arrayMin(a);this.max=g.jqplot.arrayMax(a);this.pack()}};g.jqplot.LinearAxisRenderer.prototype.pack=
function(a,c){a=a||{};c=c||this._offsets;var d=this._ticks,b=this.max,e=this.min,i=c.max,f=c.min,h=this._label==null?false:this._label.show,l;for(l in a)this._elem.css(l,a[l]);this._offsets=c;var j=i-f,n=b-e;if(this.breakPoints){n=n-this.breakPoints[1]+this.breakPoints[0];this.p2u=function(o){return(o-f)*n/j+e};this.u2p=function(o){if(o>this.breakPoints[0]&&o<this.breakPoints[1])o=this.breakPoints[0];return o<=this.breakPoints[0]?(o-e)*j/n+f:(o-this.breakPoints[1]+this.breakPoints[0]-e)*j/n+f};if(this.name.charAt(0)==
"x"){this.series_u2p=function(o){if(o>this.breakPoints[0]&&o<this.breakPoints[1])o=this.breakPoints[0];return o<=this.breakPoints[0]?(o-e)*j/n:(o-this.breakPoints[1]+this.breakPoints[0]-e)*j/n};this.series_p2u=function(o){return o*n/j+e}}else{this.series_u2p=function(o){if(o>this.breakPoints[0]&&o<this.breakPoints[1])o=this.breakPoints[0];return o>=this.breakPoints[1]?(o-b)*j/n:(o+this.breakPoints[1]-this.breakPoints[0]-b)*j/n};this.series_p2u=function(o){return o*n/j+b}}}else{this.p2u=function(o){return(o-
f)*n/j+e};this.u2p=function(o){return(o-e)*j/n+f};if(this.name=="xaxis"||this.name=="x2axis"){this.series_u2p=function(o){return(o-e)*j/n};this.series_p2u=function(o){return o*n/j+e}}else{this.series_u2p=function(o){return(o-b)*j/n};this.series_p2u=function(o){return o*n/j+b}}}if(this.show)if(this.name=="xaxis"||this.name=="x2axis"){for(l=0;l<d.length;l++){var k=d[l];if(k.show&&k.showLabel){var m;if(k.constructor==g.jqplot.CanvasAxisTickRenderer&&k.angle){m=this.name=="xaxis"?1:-1;switch(k.labelPosition){case "auto":m=
m*k.angle<0?-k.getWidth()+k._textRenderer.height*Math.sin(-k._textRenderer.angle)/2:-k._textRenderer.height*Math.sin(k._textRenderer.angle)/2;break;case "end":m=-k.getWidth()+k._textRenderer.height*Math.sin(-k._textRenderer.angle)/2;break;case "start":m=-k._textRenderer.height*Math.sin(k._textRenderer.angle)/2;break;case "middle":m=-k.getWidth()/2+k._textRenderer.height*Math.sin(-k._textRenderer.angle)/2;break;default:m=-k.getWidth()/2+k._textRenderer.height*Math.sin(-k._textRenderer.angle)/2}}else m=
-k.getWidth()/2;m=this.u2p(k.value)+m+"px";k._elem.css("left",m);k.pack()}}if(h){i=this._label._elem.outerWidth(true);this._label._elem.css("left",f+j/2-i/2+"px");this.name=="xaxis"?this._label._elem.css("bottom","0px"):this._label._elem.css("top","0px");this._label.pack()}}else{for(l=0;l<d.length;l++){k=d[l];if(k.show&&k.showLabel){if(k.constructor==g.jqplot.CanvasAxisTickRenderer&&k.angle){m=this.name=="yaxis"?1:-1;switch(k.labelPosition){case "auto":case "end":m=m*k.angle<0?-k._textRenderer.height*
Math.cos(-k._textRenderer.angle)/2:-k.getHeight()+k._textRenderer.height*Math.cos(k._textRenderer.angle)/2;break;case "start":m=k.angle>0?-k._textRenderer.height*Math.cos(-k._textRenderer.angle)/2:-k.getHeight()+k._textRenderer.height*Math.cos(k._textRenderer.angle)/2;break;case "middle":m=-k.getHeight()/2;break;default:m=-k.getHeight()/2}}else m=-k.getHeight()/2;m=this.u2p(k.value)+m+"px";k._elem.css("top",m);k.pack()}}if(h){d=this._label._elem.outerHeight(true);this._label._elem.css("top",i-j/2-
d/2+"px");this.name=="yaxis"?this._label._elem.css("left","0px"):this._label._elem.css("right","0px");this._label.pack()}}d=null};g.jqplot.LinearTickGenerator=function(a,c,d,b){if(a===c)c=c?0:1;if(c<a){var e=c;c=a;a=e}e=[];var i=da(c-a,d||1);if(b==null){e[0]=Math.floor(a/i)*i;e[1]=Math.ceil(c/i)*i;e[2]=Math.round((e[1]-e[0])/i+1);e[3]=Z(i);e[4]=i}else{d=[];d[0]=Math.floor(a/i)*i;d[1]=Math.ceil(c/i)*i;d[2]=Math.round((d[1]-d[0])/i+1);d[3]=Z(i);d[4]=i;if(d[2]===b)e=d;else{a=ca(d[1]-d[0],b);e[0]=d[0];
e[2]=b;e[4]=a;e[3]=Z(a);e[1]=e[0]+(e[2]-1)*e[4]}}return e};g.jqplot.LinearTickGenerator.bestLinearInterval=da;g.jqplot.LinearTickGenerator.bestInterval=ca;g.jqplot.LinearTickGenerator.bestLinearComponents=function(a,c){var d=Math.pow(10,Math.floor(Math.log(a)/Math.LN10)),b=a/d;b/=c;b=b<=0.38?0.1:b<=1.6?0.2:b<=4?0.5:b<=8?1:b<=16?2:5;return[b*d,b,d]};g.jqplot.MarkerRenderer=function(a){this.show=true;this.style="filledCircle";this.lineWidth=2;this.size=9;this.color="#666666";this.shadow=true;this.shadowAngle=
45;this.shadowOffset=1;this.shadowDepth=3;this.shadowAlpha="0.07";this.shadowRenderer=new g.jqplot.ShadowRenderer;this.shapeRenderer=new g.jqplot.ShapeRenderer;g.extend(true,this,a)};g.jqplot.MarkerRenderer.prototype.init=function(a){g.extend(true,this,a);a={angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,lineWidth:this.lineWidth,depth:this.shadowDepth,closePath:true};if(this.style.indexOf("filled")!=-1)a.fill=true;if(this.style.indexOf("ircle")!=-1){a.isarc=true;a.closePath=
false}this.shadowRenderer.init(a);a={fill:false,isarc:false,strokeStyle:this.color,fillStyle:this.color,lineWidth:this.lineWidth,closePath:true};if(this.style.indexOf("filled")!=-1)a.fill=true;if(this.style.indexOf("ircle")!=-1){a.isarc=true;a.closePath=false}this.shapeRenderer.init(a)};g.jqplot.MarkerRenderer.prototype.drawDiamond=function(a,c,d,b,e){b=this.size/2/1.2;var i=this.size/2*1.2;a=[[a-b,c],[a,c+i],[a+b,c],[a,c-i]];this.shadow&&this.shadowRenderer.draw(d,a);this.shapeRenderer.draw(d,a,
e)};g.jqplot.MarkerRenderer.prototype.drawPlus=function(a,c,d){var b=this.size/2*1,e=this.size/2*1;e=[[a,c-e],[a,c+e]];a=[[a+b,c],[a-b,c]];c=g.extend(true,{},this.options,{closePath:false});if(this.shadow){this.shadowRenderer.draw(d,e,{closePath:false});this.shadowRenderer.draw(d,a,{closePath:false})}this.shapeRenderer.draw(d,e,c);this.shapeRenderer.draw(d,a,c)};g.jqplot.MarkerRenderer.prototype.drawX=function(a,c,d){var b=this.size/2*1,e=this.size/2*1,i=g.extend(true,{},this.options,{closePath:false}),
f=[[a-b,c-e],[a+b,c+e]];a=[[a-b,c+e],[a+b,c-e]];if(this.shadow){this.shadowRenderer.draw(d,f,{closePath:false});this.shadowRenderer.draw(d,a,{closePath:false})}this.shapeRenderer.draw(d,f,i);this.shapeRenderer.draw(d,a,i)};g.jqplot.MarkerRenderer.prototype.drawDash=function(a,c,d,b,e){b=this.size/2*1;a=[[a-b,c],[a+b,c]];this.shadow&&this.shadowRenderer.draw(d,a);this.shapeRenderer.draw(d,a,e)};g.jqplot.MarkerRenderer.prototype.drawLine=function(a,c,d,b,e){a=[a,c];this.shadow&&this.shadowRenderer.draw(d,
a);this.shapeRenderer.draw(d,a,e)};g.jqplot.MarkerRenderer.prototype.drawSquare=function(a,c,d,b,e){b=this.size/2/1;var i=this.size/2*1;a=[[a-b,c-i],[a-b,c+i],[a+b,c+i],[a+b,c-i]];this.shadow&&this.shadowRenderer.draw(d,a);this.shapeRenderer.draw(d,a,e)};g.jqplot.MarkerRenderer.prototype.drawCircle=function(a,c,d,b,e){a=[a,c,this.size/2,0,2*Math.PI,true];this.shadow&&this.shadowRenderer.draw(d,a);this.shapeRenderer.draw(d,a,e)};g.jqplot.MarkerRenderer.prototype.draw=function(a,c,d,b){b=b||{};if(b.show==
null||b.show!=false){if(b.color&&!b.fillStyle)b.fillStyle=b.color;if(b.color&&!b.strokeStyle)b.strokeStyle=b.color;switch(this.style){case "diamond":this.drawDiamond(a,c,d,false,b);break;case "filledDiamond":this.drawDiamond(a,c,d,true,b);break;case "circle":this.drawCircle(a,c,d,false,b);break;case "filledCircle":this.drawCircle(a,c,d,true,b);break;case "square":this.drawSquare(a,c,d,false,b);break;case "filledSquare":this.drawSquare(a,c,d,true,b);break;case "x":this.drawX(a,c,d,true,b);break;case "plus":this.drawPlus(a,
c,d,true,b);break;case "dash":this.drawDash(a,c,d,true,b);break;case "line":this.drawLine(a,c,d,false,b);break;default:this.drawDiamond(a,c,d,false,b)}}};g.jqplot.ShadowRenderer=function(a){this.angle=45;this.offset=1;this.alpha=0.07;this.lineWidth=1.5;this.lineJoin="miter";this.lineCap="round";this.fill=this.closePath=false;this.depth=3;this.strokeStyle="rgba(0,0,0,0.1)";this.isarc=false;g.extend(true,this,a)};g.jqplot.ShadowRenderer.prototype.init=function(a){g.extend(true,this,a)};g.jqplot.ShadowRenderer.prototype.draw=
function(a,c,d){a.save();var b=d!=null?d:{};d=b.fill!=null?b.fill:this.fill;var e=b.fillRect!=null?b.fillRect:this.fillRect,i=b.closePath!=null?b.closePath:this.closePath,f=b.offset!=null?b.offset:this.offset,h=b.alpha!=null?b.alpha:this.alpha,l=b.depth!=null?b.depth:this.depth,j=b.isarc!=null?b.isarc:this.isarc,n=b.linePattern!=null?b.linePattern:this.linePattern;a.lineWidth=b.lineWidth!=null?b.lineWidth:this.lineWidth;a.lineJoin=b.lineJoin!=null?b.lineJoin:this.lineJoin;a.lineCap=b.lineCap!=null?
b.lineCap:this.lineCap;a.strokeStyle=b.strokeStyle||this.strokeStyle||"rgba(0,0,0,"+h+")";a.fillStyle=b.fillStyle||this.fillStyle||"rgba(0,0,0,"+h+")";for(b=0;b<l;b++){h=g.jqplot.LinePattern(a,n);a.translate(Math.cos(this.angle*Math.PI/180)*f,Math.sin(this.angle*Math.PI/180)*f);h.beginPath();if(j)a.arc(c[0],c[1],c[2],c[3],c[4],true);else if(e)e&&a.fillRect(c[0],c[1],c[2],c[3]);else if(c&&c.length)for(var k=true,m=0;m<c.length;m++)if(c[m][0]!=null&&c[m][1]!=null)if(k){h.moveTo(c[m][0],c[m][1]);k=false}else h.lineTo(c[m][0],
c[m][1]);else k=true;i&&h.closePath();d?a.fill():a.stroke()}a.restore()};g.jqplot.ShapeRenderer=function(a){this.lineWidth=1.5;this.linePattern="solid";this.lineJoin="miter";this.lineCap="round";this.clearRect=this.strokeRect=this.fillRect=this.isarc=this.fill=this.closePath=false;this.fillStyle=this.strokeStyle="#999999";g.extend(true,this,a)};g.jqplot.ShapeRenderer.prototype.init=function(a){g.extend(true,this,a)};g.jqplot.ShapeRenderer.prototype.draw=function(a,c,d){a.save();var b=d!=null?d:{};
d=b.fill!=null?b.fill:this.fill;var e=b.closePath!=null?b.closePath:this.closePath,i=b.fillRect!=null?b.fillRect:this.fillRect,f=b.strokeRect!=null?b.strokeRect:this.strokeRect,h=b.clearRect!=null?b.clearRect:this.clearRect,l=b.isarc!=null?b.isarc:this.isarc,j=g.jqplot.LinePattern(a,b.linePattern!=null?b.linePattern:this.linePattern);a.lineWidth=b.lineWidth||this.lineWidth;a.lineJoin=b.lineJoin||this.lineJoin;a.lineCap=b.lineCap||this.lineCap;a.strokeStyle=b.strokeStyle||b.color||this.strokeStyle;
a.fillStyle=b.fillStyle||this.fillStyle;a.beginPath();if(l){a.arc(c[0],c[1],c[2],c[3],c[4],true);e&&a.closePath();d?a.fill():a.stroke()}else if(h)a.clearRect(c[0],c[1],c[2],c[3]);else if(i||f){i&&a.fillRect(c[0],c[1],c[2],c[3]);if(f){a.strokeRect(c[0],c[1],c[2],c[3]);a.restore();return}}else if(c&&c.length){b=true;for(i=0;i<c.length;i++)if(c[i][0]!=null&&c[i][1]!=null)if(b){j.moveTo(c[i][0],c[i][1]);b=false}else j.lineTo(c[i][0],c[i][1]);else b=true;e&&j.closePath();d?a.fill():a.stroke()}a.restore()};
g.jqplot.TableLegendRenderer=function(){};g.jqplot.TableLegendRenderer.prototype.init=function(a){g.extend(true,this,a)};g.jqplot.TableLegendRenderer.prototype.addrow=function(a,c,d,b){d=d?this.rowSpacing+"px":"0px";var e,i,f;e=document.createElement("tr");e=g(e);e.addClass("jqplot-table-legend");b?e.prependTo(this._elem):e.appendTo(this._elem);if(this.showSwatches){b=g(document.createElement("td"));b.addClass("jqplot-table-legend jqplot-table-legend-swatch");b.css({textAlign:"center",paddingTop:d});
i=g(document.createElement("div"));i.addClass("jqplot-table-legend-swatch-outline");f=g(document.createElement("div"));f.addClass("jqplot-table-legend-swatch");f.css({backgroundColor:c,borderColor:c});e.append(b.append(i.append(f)))}if(this.showLabels){b=g(document.createElement("td"));b.addClass("jqplot-table-legend jqplot-table-legend-label");b.css("paddingTop",d);e.append(b);this.escapeHtml?b.text(a):b.html(a)}};g.jqplot.TableLegendRenderer.prototype.draw=function(){if(this._elem){this._elem.emptyForce();
this._elem=null}if(this.show){var a=this._series,c=document.createElement("table");this._elem=g(c);this._elem.addClass("jqplot-table-legend");for(var d=c=false,b,e=0;e<a.length;e++){b=a[e];if(b._stack||b.renderer.constructor==g.jqplot.BezierCurveRenderer)d=true;if(b.show&&b.showLabel){var i=this.labels[e]||b.label.toString();if(i){var f=b.color;if(d&&e<a.length-1)c=true;else if(d&&e==a.length-1)c=false;this.renderer.addrow.call(this,i,f,c,d);c=true}for(i=0;i<g.jqplot.addLegendRowHooks.length;i++)if(f=
g.jqplot.addLegendRowHooks[i].call(this,b)){this.renderer.addrow.call(this,f.label,f.color,c);c=true}}}}return this._elem};g.jqplot.TableLegendRenderer.prototype.pack=function(a){if(this.show)if(this.placement=="insideGrid")switch(this.location){case "nw":var c=a.left,d=a.top;this._elem.css("left",c);this._elem.css("top",d);break;case "n":c=(a.left+(this._plotDimensions.width-a.right))/2-this.getWidth()/2;d=a.top;this._elem.css("left",c);this._elem.css("top",d);break;case "ne":c=a.right;d=a.top;this._elem.css({right:c,
top:d});break;case "e":c=a.right;d=(a.top+(this._plotDimensions.height-a.bottom))/2-this.getHeight()/2;this._elem.css({right:c,top:d});break;case "se":c=a.right;d=a.bottom;this._elem.css({right:c,bottom:d});break;case "s":c=(a.left+(this._plotDimensions.width-a.right))/2-this.getWidth()/2;d=a.bottom;this._elem.css({left:c,bottom:d});break;case "sw":c=a.left;d=a.bottom;this._elem.css({left:c,bottom:d});break;case "w":c=a.left;d=(a.top+(this._plotDimensions.height-a.bottom))/2-this.getHeight()/2;this._elem.css({left:c,
top:d});break;default:c=a.right;d=a.bottom;this._elem.css({right:c,bottom:d})}else if(this.placement=="outside")switch(this.location){case "nw":c=this._plotDimensions.width-a.left;d=a.top;this._elem.css("right",c);this._elem.css("top",d);break;case "n":c=(a.left+(this._plotDimensions.width-a.right))/2-this.getWidth()/2;d=this._plotDimensions.height-a.top;this._elem.css("left",c);this._elem.css("bottom",d);break;case "ne":c=this._plotDimensions.width-a.right;d=a.top;this._elem.css({left:c,top:d});
break;case "e":c=this._plotDimensions.width-a.right;d=(a.top+(this._plotDimensions.height-a.bottom))/2-this.getHeight()/2;this._elem.css({left:c,top:d});break;case "se":c=this._plotDimensions.width-a.right;d=a.bottom;this._elem.css({left:c,bottom:d});break;case "s":c=(a.left+(this._plotDimensions.width-a.right))/2-this.getWidth()/2;d=this._plotDimensions.height-a.bottom;this._elem.css({left:c,top:d});break;case "sw":c=this._plotDimensions.width-a.left;d=a.bottom;this._elem.css({right:c,bottom:d});
break;case "w":c=this._plotDimensions.width-a.left;d=(a.top+(this._plotDimensions.height-a.bottom))/2-this.getHeight()/2;this._elem.css({right:c,top:d});break;default:c=a.right;d=a.bottom;this._elem.css({right:c,bottom:d})}else switch(this.location){case "nw":this._elem.css({left:0,top:a.top});break;case "n":c=(a.left+(this._plotDimensions.width-a.right))/2-this.getWidth()/2;this._elem.css({left:c,top:a.top});break;case "ne":this._elem.css({right:0,top:a.top});break;case "e":d=(a.top+(this._plotDimensions.height-
a.bottom))/2-this.getHeight()/2;this._elem.css({right:a.right,top:d});break;case "se":this._elem.css({right:a.right,bottom:a.bottom});break;case "s":c=(a.left+(this._plotDimensions.width-a.right))/2-this.getWidth()/2;this._elem.css({left:c,bottom:a.bottom});break;case "sw":this._elem.css({left:a.left,bottom:a.bottom});break;case "w":d=(a.top+(this._plotDimensions.height-a.bottom))/2-this.getHeight()/2;this._elem.css({left:a.left,top:d});break;default:this._elem.css({right:a.right,bottom:a.bottom})}};
g.jqplot.ThemeEngine=function(){this.themes={};this.activeTheme=null};g.jqplot.ThemeEngine.prototype.init=function(){var a=new g.jqplot.Theme({_name:"Default"}),c,d,b;for(c in a.target)a.target[c]=c=="textColor"?this.target.css("color"):this.target.css(c);if(this.title.show&&this.title._elem)for(c in a.title)a.title[c]=c=="textColor"?this.title._elem.css("color"):this.title._elem.css(c);for(c in a.grid)a.grid[c]=this.grid[c];if(a.grid.backgroundColor==null&&this.grid.background!=null)a.grid.backgroundColor=
this.grid.background;if(this.legend.show&&this.legend._elem)for(c in a.legend)a.legend[c]=c=="textColor"?this.legend._elem.css("color"):this.legend._elem.css(c);var e;for(d=0;d<this.series.length;d++){e=this.series[d];if(e.renderer.constructor==g.jqplot.LineRenderer)a.series.push(new oa);else if(e.renderer.constructor==g.jqplot.BarRenderer)a.series.push(new pa);else if(e.renderer.constructor==g.jqplot.PieRenderer)a.series.push(new qa);else if(e.renderer.constructor==g.jqplot.DonutRenderer)a.series.push(new ra);
else if(e.renderer.constructor==g.jqplot.FunnelRenderer)a.series.push(new sa);else e.renderer.constructor==g.jqplot.MeterGaugeRenderer?a.series.push(new ta):a.series.push({});for(c in a.series[d])a.series[d][c]=e[c]}for(c in this.axes){e=this.axes[c];d=a.axes[c]=new ua;d.borderColor=e.borderColor;d.borderWidth=e.borderWidth;if(e._ticks&&e._ticks[0])for(b in d.ticks)if(e._ticks[0].hasOwnProperty(b))d.ticks[b]=e._ticks[0][b];else if(e._ticks[0]._elem)d.ticks[b]=e._ticks[0]._elem.css(b);if(e._label&&
e._label.show)for(b in d.label)if(e._label[b])d.label[b]=e._label[b];else if(e._label._elem)d.label[b]=b=="textColor"?e._label._elem.css("color"):e._label._elem.css(b)}this.themeEngine._add(a);this.themeEngine.activeTheme=this.themeEngine.themes[a._name]};g.jqplot.ThemeEngine.prototype.get=function(a){return a?this.themes[a]:this.activeTheme};g.jqplot.ThemeEngine.prototype.getThemeNames=function(){var a=[],c;for(c in this.themes)a.push(c);return a.sort(ea)};g.jqplot.ThemeEngine.prototype.getThemes=
function(){var a=[],c=[],d;for(d in this.themes)a.push(d);a.sort(ea);for(d=0;d<a.length;d++)c.push(this.themes[a[d]]);return c};g.jqplot.ThemeEngine.prototype.activate=function(a,c){var d=false;if(!c&&this.activeTheme&&this.activeTheme._name)c=this.activeTheme._name;if(this.themes.hasOwnProperty(c)){var b=this.themes[c];this.activeTheme=b;var e;e=["xaxis","x2axis","yaxis","y2axis"];for(j=0;j<e.length;j++){var i=e[j];if(b.axesStyles.borderColor!=null)a.axes[i].borderColor=b.axesStyles.borderColor;
if(b.axesStyles.borderWidth!=null)a.axes[i].borderWidth=b.axesStyles.borderWidth}for(var f in a.axes){j=a.axes[f];if(j.show){i=g.jqplot.extend(true,{},b.axes[f]||{},b.axesStyles);if(i.borderColor!=null){j.borderColor=i.borderColor;d=true}if(i.borderWidth!=null){j.borderWidth=i.borderWidth;d=true}if(j._ticks&&j._ticks[0])for(var h in i.ticks){e=i.ticks[h];if(e!=null){j.tickOptions[h]=e;j._ticks=[];d=true}}if(j._label&&j._label.show)for(h in i.label){e=i.label[h];if(e!=null){j.labelOptions[h]=e;d=true}}}}for(var l in b.grid)if(b.grid[l]!=
null)a.grid[l]=b.grid[l];d||a.grid.draw();if(a.legend.show)for(l in b.legend)if(b.legend[l]!=null)a.legend[l]=b.legend[l];if(a.title.show)for(l in b.title)if(b.title[l]!=null)a.title[l]=b.title[l];var j;for(j=0;j<b.series.length;j++)for(l in b.series[j]){e=b.seriesStyles[l]!=null?b.seriesStyles[l]:b.series[j][l];if(e!=null){if(l=="color"){a.series[j].renderer.shapeRenderer.fillStyle=e;a.series[j].renderer.shapeRenderer.strokeStyle=e;a.series[j][l]=e}else if(l=="lineWidth"||l=="linePattern"){a.series[j].renderer.shapeRenderer[l]=
e;a.series[j][l]=e}else if(l=="markerOptions"){Y(a.series[j].markerOptions,e);Y(a.series[j].markerRenderer,e)}else a.series[j][l]=e;d=true}}if(d){a.target.empty();a.draw()}for(l in b.target)b.target[l]!=null&&a.target.css(l,b.target[l])}else throw Error("No theme of that name");};g.jqplot.ThemeEngine.prototype._add=function(a,c){if(c)a._name=c;if(!a._name)a._name=Date.parse(new Date);if(this.themes.hasOwnProperty(a._name))throw Error("jqplot.ThemeEngine Error: Theme already in use");else this.themes[a._name]=
a};g.jqplot.ThemeEngine.prototype.remove=function(a){if(a=="Default")return false;return delete this.themes[a]};g.jqplot.ThemeEngine.prototype.newTheme=function(a,c){if(typeof a=="object"){c=c||a;a=null}a=c&&c._name?c._name:a||Date.parse(new Date);var d=this.copy(this.themes.Default._name,a);g.jqplot.extend(d,c);return d};g.jqplot.clone=X;g.jqplot.merge=Y;g.jqplot.extend=function(){var a=arguments[0]||{},c=1,d=arguments.length,b=false,e;if(typeof a==="boolean"){b=a;a=arguments[1]||{};c=2}if(typeof a!==
"object"&&!toString.call(a)==="[object Function]")a={};for(;c<d;c++)if((e=arguments[c])!=null)for(var i in e){var f=a[i],h=e[i];if(a!==h)if(b&&h&&typeof h==="object"&&!h.nodeType)a[i]=g.jqplot.extend(b,f||(h.length!=null?[]:{}),h);else if(h!==A)a[i]=h}return a};g.jqplot.ThemeEngine.prototype.rename=function(a,c){if(a=="Default"||c=="Default")throw Error("jqplot.ThemeEngine Error: Cannot rename from/to Default");if(this.themes.hasOwnProperty(c))throw Error("jqplot.ThemeEngine Error: New name already in use.");
else if(this.themes.hasOwnProperty(a)){var d=this.copy(a,c);this.remove(a);return d}throw Error("jqplot.ThemeEngine Error: Old name or new name invalid");};g.jqplot.ThemeEngine.prototype.copy=function(a,c,d){if(c=="Default")throw Error("jqplot.ThemeEngine Error: Cannot copy over Default theme");if(!this.themes.hasOwnProperty(a))throw Error("jqplot.ThemeEngine Error: Source name invalid");if(this.themes.hasOwnProperty(c))throw Error("jqplot.ThemeEngine Error: Target name invalid");else{a=X(this.themes[a]);
a._name=c;g.jqplot.extend(true,a,d);this._add(a);return a}};g.jqplot.Theme=function(a,c){if(typeof a=="object"){c=c||a;a=null}this._name=a=a||Date.parse(new Date);this.target={backgroundColor:null};this.legend={textColor:null,fontFamily:null,fontSize:null,border:null,background:null};this.title={textColor:null,fontFamily:null,fontSize:null,textAlign:null};this.seriesStyles={};this.series=[];this.grid={drawGridlines:null,gridLineColor:null,gridLineWidth:null,backgroundColor:null,borderColor:null,borderWidth:null,
shadow:null};this.axesStyles={label:{},ticks:{}};this.axes={};if(typeof c=="string")this._name=c;else typeof c=="object"&&g.jqplot.extend(true,this,c)};var ua=function(){this.borderWidth=this.borderColor=null;this.ticks=new va;this.label=new wa},va=function(){this.fontFamily=this.fontSize=this.whiteSpace=this.textColor=this.size=this.showMark=this.showLabel=this.showGridline=this.show=null},wa=function(){this.fontWeight=this.fontFamily=this.fontSize=this.whiteSpace=this.textColor=null},oa=function(){this.showMarker=
this.fillColor=this.shadow=this.linePattern=this.lineWidth=this.color=null;this.markerOptions=new xa},xa=function(){this.shadow=this.color=this.size=this.lineWidth=this.style=this.show=null},pa=function(){this.highlightColors=this.barWidth=this.barMargin=this.barPadding=this.shadow=this.lineWidth=this.seriesColors=this.color=null},qa=function(){this.highlightColors=this.lineWidth=this.startAngle=this.shadow=this.fill=this.sliceMargin=this.padding=this.seriesColors=null},ra=function(){this.highlightColors=
this.ringMargin=this.thickness=this.innerDiameter=this.lineWidth=this.startAngle=this.shadow=this.fill=this.sliceMargin=this.padding=this.seriesColors=null},sa=function(){this.highlightColors=this.seriesColors=this.sectionMargin=this.padding=this.shadow=this.lineWidth=this.color=null},ta=function(){this.needlePad=this.needleThickness=this.hubRadius=this.intervalOuterRadius=this.intervalInnerRadius=this.intervalColors=this.ringWidth=this.tickColor=this.ringColor=this.backgroundColor=this.padding=null};
g.fn.jqplotChildText=function(){return g(this).contents().filter(function(){return this.nodeType==3}).text()};g.fn.jqplotGetComputedFontStyle=function(){for(var a=window.getComputedStyle?window.getComputedStyle(this[0]):this[0].currentStyle,c=a["font-style"]?["font-style","font-weight","font-size","font-family"]:["fontStyle","fontWeight","fontSize","fontFamily"],d=[],b=0;b<c.length;++b){var e=String(a[c[b]]);e&&e!="normal"&&d.push(e)}return d.join(" ")};g.fn.jqplotToImageCanvas=function(a){function c(v,
x,D,B,L,E){var C;C=parseInt(g(v).css("line-height"));if(isNaN(C))C=parseInt(g(v).css("font-size"))*1.2;var G=g(v).innerWidth();g(v).innerHeight();for(var w=D.split(/\s+/),P=w.length,z="",H=[],Q=L,M=B,F=0;F<P;F++){z+=w[F];if(x.measureText(z).width>G){H.push(F);z=""}}if(H.length===0){if(g(v).css("textAlign")==="center")M=B+(E-x.measureText(z).width)/2-k;x.fillText(D,M,L)}else{z=w.slice(0,H[0]).join(" ");if(g(v).css("textAlign")==="center")M=B+(E-x.measureText(z).width)/2-k;x.fillText(z,M,Q);Q+=C;F=
1;for(D=H.length;F<D;F++){z=w.slice(H[F-1],H[F]).join(" ");if(g(v).css("textAlign")==="center")M=B+(E-x.measureText(z).width)/2-k;x.fillText(z,M,Q);Q+=C}z=w.slice(H[F-1],w.length).join(" ");if(g(v).css("textAlign")==="center")M=B+(E-x.measureText(z).width)/2-k;x.fillText(z,M,Q)}}function d(v,x,D){var B=v.tagName.toLowerCase(),L=g(v).position(),E=window.getComputedStyle?window.getComputedStyle(v):v.currentStyle,C=x+L.left+parseInt(E.marginLeft)+parseInt(E.borderLeftWidth)+parseInt(E.paddingLeft),G=
D+L.top+parseInt(E.marginTop)+parseInt(E.borderTopWidth)+parseInt(E.paddingTop);x=i.width;if((B=="div"||B=="span")&&!g(v).hasClass("jqplot-highlighter-tooltip")){g(v).children().each(function(){d(this,C,G)});if(B=g(v).jqplotChildText()){t.font=g(v).jqplotGetComputedFontStyle();t.fillStyle=g(v).css("color");c(v,t,B,C,G,x)}}else if(B==="table"&&g(v).hasClass("jqplot-table-legend")){t.strokeStyle=g(v).css("border-top-color");t.fillStyle=g(v).css("background-color");t.fillRect(C,G,g(v).innerWidth(),g(v).innerHeight());
parseInt(g(v).css("border-top-width"))>0&&t.strokeRect(C,G,g(v).innerWidth(),g(v).innerHeight());g(v).find("div.jqplot-table-legend-swatch-outline").each(function(){var w=g(this);t.strokeStyle=w.css("border-top-color");var P=C+w.position().left,z=G+w.position().top;t.strokeRect(P,z,w.innerWidth(),w.innerHeight());P+=parseInt(w.css("padding-left"));z+=parseInt(w.css("padding-top"));var H=w.innerHeight()-2*parseInt(w.css("padding-top")),Q=w.innerWidth()-2*parseInt(w.css("padding-left"));w=w.children("div.jqplot-table-legend-swatch");
t.fillStyle=w.css("background-color");t.fillRect(P,z,Q,H)});g(v).find("td.jqplot-table-legend-label").each(function(){var w=g(this),P=C+w.position().left,z=G+w.position().top+parseInt(w.css("padding-top"));t.font=w.jqplotGetComputedFontStyle();t.fillStyle=w.css("color");t.fillText(w.text(),P,z)})}else B=="canvas"&&t.drawImage(v,C,G)}a=a||{};var b=a.x_offset==null?0:a.x_offset,e=a.y_offset==null?0:a.y_offset;a=a.backgroundColor==null?"rgb(255,255,255)":a.backgroundColor;if(g(this).width()==0||g(this).height()==
0)return null;if(!g.jqplot.support_canvas)return null;var i=document.createElement("canvas"),f=g(this).outerHeight(true),h=g(this).outerWidth(true),l=g(this).offset(),j=l.left,n=l.top,k=0,m=0;l=["jqplot-table-legend","jqplot-xaxis-tick","jqplot-x2axis-tick","jqplot-yaxis-tick","jqplot-y2axis-tick","jqplot-y3axis-tick","jqplot-y4axis-tick","jqplot-y5axis-tick","jqplot-y6axis-tick","jqplot-y7axis-tick","jqplot-y8axis-tick","jqplot-y9axis-tick","jqplot-xaxis-label","jqplot-x2axis-label","jqplot-yaxis-label",
"jqplot-y2axis-label","jqplot-y3axis-label","jqplot-y4axis-label","jqplot-y5axis-label","jqplot-y6axis-label","jqplot-y7axis-label","jqplot-y8axis-label","jqplot-y9axis-label"];var o,s,r,p,u;for(u in l)g(this).find("."+l[u]).each(function(){o=g(this).offset().top-n;s=g(this).offset().left-j;p=s+g(this).outerWidth(true)+k;r=o+g(this).outerHeight(true)+m;if(s<-k){h=h-k-s;k=-s}if(o<-m){f=f-m-o;m=-o}if(p>h)h=p;if(r>f)f=r});i.width=h+Number(b);i.height=f+Number(e);var t=i.getContext("2d");t.save();t.fillStyle=
a;t.fillRect(0,0,i.width,i.height);t.restore();t.translate(k,m);t.textAlign="left";t.textBaseline="top";g(this).children().each(function(){d(this,b,e)});return i};g.fn.jqplotToImageStr=function(a){return(a=g(this).jqplotToImageCanvas(a))?a.toDataURL("image/png"):null};g.fn.jqplotToImageElem=function(a){var c=document.createElement("img");a=g(this).jqplotToImageStr(a);c.src=a;return c};g.fn.jqplotToImageElemStr=function(a){return"<img src="+g(this).jqplotToImageStr(a)+" />"};g.fn.jqplotSaveImage=function(){var a=
g(this).jqplotToImageStr({});if(a)window.location.href=a.replace("image/png","image/octet-stream")};g.fn.jqplotViewImage=function(){var a=g(this).jqplotToImageElemStr({});g(this).jqplotToImageStr({});if(a){var c=window.open("");c.document.open("image/png");c.document.write(a);c.document.close()}};var q=function(){this.syntax=q.config.syntax;this._type="jsDate";this.utcOffset=(new Date).getTimezoneOffset*6E4;this.proxy=new Date;this.options={};this.locale=q.regional.getLocale();this.formatString="";
this.defaultCentury=q.config.defaultCentury;switch(arguments.length){case 0:break;case 1:if($(arguments[0])=="[object Object]"&&arguments[0]._type!="jsDate"){var a=this.options=arguments[0];this.syntax=a.syntax||this.syntax;this.defaultCentury=a.defaultCentury||this.defaultCentury;this.proxy=q.createDate(a.date)}else this.proxy=q.createDate(arguments[0]);break;default:a=[];for(var c=0;c<arguments.length;c++)a.push(arguments[c]);this.proxy=new Date(this.utcOffset);this.proxy.setFullYear.apply(this.proxy,
a.slice(0,3));a.slice(3).length&&this.proxy.setHours.apply(this.proxy,a.slice(3))}};q.config={defaultLocale:"en",syntax:"perl",defaultCentury:1900};q.prototype.add=function(a,c){var d=I[c]||I.day;typeof d=="number"?this.proxy.setTime(this.proxy.getTime()+d*a):d.add(this,a);return this};q.prototype.clone=function(){return new q(this.proxy.getTime())};q.prototype.diff=function(a,c,d){a=new q(a);if(a===null)return null;c=I[c]||I.day;a=typeof c=="number"?(this.proxy.getTime()-a.proxy.getTime())/c:c.diff(this.proxy,
a.proxy);return d?a:Math[a>0?"floor":"ceil"](a)};q.prototype.getAbbrDayName=function(){return q.regional[this.locale].dayNamesShort[this.proxy.getDay()]};q.prototype.getAbbrMonthName=function(){return q.regional[this.locale].monthNamesShort[this.proxy.getMonth()]};q.prototype.getAMPM=function(){return this.proxy.getHours()>=12?"PM":"AM"};q.prototype.getAmPm=function(){return this.proxy.getHours()>=12?"pm":"am"};q.prototype.getCentury=function(){return parseInt(this.proxy.getFullYear()/100,10)};q.prototype.getDate=
function(){return this.proxy.getDate()};q.prototype.getDay=function(){return this.proxy.getDay()};q.prototype.getDayOfWeek=function(){var a=this.proxy.getDay();return a===0?7:a};q.prototype.getDayOfYear=function(){var a=this.proxy,c=a-new Date(""+a.getFullYear()+"/1/1 GMT");c+=a.getTimezoneOffset()*6E4;return parseInt(c/6E4/60/24,10)+1};q.prototype.getDayName=function(){return q.regional[this.locale].dayNames[this.proxy.getDay()]};q.prototype.getFullWeekOfYear=function(){var a=this.proxy,c=this.getDayOfYear();
a=6-a.getDay();return parseInt((c+a)/7,10)};q.prototype.getFullYear=function(){return this.proxy.getFullYear()};q.prototype.getGmtOffset=function(){var a=this.proxy.getTimezoneOffset()/60,c=a<0?"+":"-";a=Math.abs(a);return c+aa(Math.floor(a),2)+":"+aa(a%1*60,2)};q.prototype.getHours=function(){return this.proxy.getHours()};q.prototype.getHours12=function(){var a=this.proxy.getHours();return a>12?a-12:a==0?12:a};q.prototype.getIsoWeek=function(){var a=this.proxy,c=a.getWeekOfYear(),d=(new Date(""+
a.getFullYear()+"/1/1")).getDay();c+=d>4||d<=1?0:1;if(c==53&&(new Date(""+a.getFullYear()+"/12/31")).getDay()<4)c=1;else if(c===0){a=new q(new Date(""+(a.getFullYear()-1)+"/12/31"));c=a.getIsoWeek()}return c};q.prototype.getMilliseconds=function(){return this.proxy.getMilliseconds()};q.prototype.getMinutes=function(){return this.proxy.getMinutes()};q.prototype.getMonth=function(){return this.proxy.getMonth()};q.prototype.getMonthName=function(){return q.regional[this.locale].monthNames[this.proxy.getMonth()]};
q.prototype.getMonthNumber=function(){return this.proxy.getMonth()+1};q.prototype.getSeconds=function(){return this.proxy.getSeconds()};q.prototype.getShortYear=function(){return this.proxy.getYear()%100};q.prototype.getTime=function(){return this.proxy.getTime()};q.prototype.getTimezoneAbbr=function(){return this.proxy.toString().replace(/^.*\(([^)]+)\)$/,"$1")};q.prototype.getTimezoneName=function(){var a=/(?:\((.+)\)$| ([A-Z]{3}) )/.exec(this.toString());return a[1]||a[2]||"GMT"+this.getGmtOffset()};
q.prototype.getTimezoneOffset=function(){return this.proxy.getTimezoneOffset()};q.prototype.getWeekOfYear=function(){var a=this.getDayOfYear(),c=7-this.getDayOfWeek();return parseInt((a+c)/7,10)};q.prototype.getUnix=function(){return Math.round(this.proxy.getTime()/1E3,0)};q.prototype.getYear=function(){return this.proxy.getYear()};q.prototype.next=function(a){return this.clone().add(1,a||"day")};q.prototype.set=function(){switch(arguments.length){case 0:this.proxy=new Date;break;case 1:if($(arguments[0])==
"[object Object]"&&arguments[0]._type!="jsDate"){var a=this.options=arguments[0];this.syntax=a.syntax||this.syntax;this.defaultCentury=a.defaultCentury||this.defaultCentury;this.proxy=q.createDate(a.date)}else this.proxy=q.createDate(arguments[0]);break;default:a=[];for(var c=0;c<arguments.length;c++)a.push(arguments[c]);this.proxy=new Date(this.utcOffset);this.proxy.setFullYear.apply(this.proxy,a.slice(0,3));a.slice(3).length&&this.proxy.setHours.apply(this.proxy,a.slice(3))}};q.prototype.setDate=
function(a){return this.proxy.setDate(a)};q.prototype.setFullYear=function(){return this.proxy.setFullYear.apply(this.proxy,arguments)};q.prototype.setHours=function(){return this.proxy.setHours.apply(this.proxy,arguments)};q.prototype.setMilliseconds=function(a){return this.proxy.setMilliseconds(a)};q.prototype.setMinutes=function(){return this.proxy.setMinutes.apply(this.proxy,arguments)};q.prototype.setMonth=function(){return this.proxy.setMonth.apply(this.proxy,arguments)};q.prototype.setSeconds=
function(){return this.proxy.setSeconds.apply(this.proxy,arguments)};q.prototype.setTime=function(a){return this.proxy.setTime(a)};q.prototype.setYear=function(){return this.proxy.setYear.apply(this.proxy,arguments)};q.prototype.strftime=function(a){a=a||this.formatString||q.regional[this.locale].formatString;return q.strftime(this,a,this.syntax)};q.prototype.toString=function(){return this.proxy.toString()};q.prototype.toYmdInt=function(){return this.proxy.getFullYear()*1E4+this.getMonthNumber()*
100+this.proxy.getDate()};q.regional={en:{monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],monthNamesShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],dayNames:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],dayNamesShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],formatString:"%Y-%m-%d %H:%M:%S"},fr:{monthNames:["Janvier","F\u00c3\u00a9vrier","Mars","Avril","Mai","Juin",
"Juillet","Ao\u00c3\u00bbt","Septembre","Octobre","Novembre","D\u00c3\u00a9cembre"],monthNamesShort:["Jan","F\u00c3\u00a9v","Mar","Avr","Mai","Jun","Jul","Ao\u00c3\u00bb","Sep","Oct","Nov","D\u00c3\u00a9c"],dayNames:["Dimanche","Lundi","Mardi","Mercredi","Jeudi","Vendredi","Samedi"],dayNamesShort:["Dim","Lun","Mar","Mer","Jeu","Ven","Sam"],formatString:"%Y-%m-%d %H:%M:%S"},de:{monthNames:["Januar","Februar","M\u00c3\u00a4rz","April","Mai","Juni","Juli","August","September","Oktober","November","Dezember"],
monthNamesShort:["Jan","Feb","M\u00c3\u00a4r","Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Dez"],dayNames:["Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"],dayNamesShort:["So","Mo","Di","Mi","Do","Fr","Sa"],formatString:"%Y-%m-%d %H:%M:%S"},es:{monthNames:["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"],monthNamesShort:["Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic"],dayNames:["Domingo",
"Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado"],dayNamesShort:["Dom","Lun","Mar","Mi&eacute;","Juv","Vie","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"},ru:{monthNames:["\u00d0\u00af\u00d0\u00bd\u00d0\u00b2\u00d0\u00b0\u00d1\u20ac\u00d1\u0152","\u00d0\u00a4\u00d0\u00b5\u00d0\u00b2\u00d1\u20ac\u00d0\u00b0\u00d0\u00bb\u00d1\u0152","\u00d0\u0153\u00d0\u00b0\u00d1\u20ac\u00d1\u201a","\u00d0\ufffd\u00d0\u00bf\u00d1\u20ac\u00d0\u00b5\u00d0\u00bb\u00d1\u0152","\u00d0\u0153\u00d0\u00b0\u00d0\u00b9",
"\u00d0\u02dc\u00d1\u017d\u00d0\u00bd\u00d1\u0152","\u00d0\u02dc\u00d1\u017d\u00d0\u00bb\u00d1\u0152","\u00d0\ufffd\u00d0\u00b2\u00d0\u00b3\u00d1\u0192\u00d1\ufffd\u00d1\u201a","\u00d0\u00a1\u00d0\u00b5\u00d0\u00bd\u00d1\u201a\u00d1\ufffd\u00d0\u00b1\u00d1\u20ac\u00d1\u0152","\u00d0\u017e\u00d0\u00ba\u00d1\u201a\u00d1\ufffd\u00d0\u00b1\u00d1\u20ac\u00d1\u0152","\u00d0\ufffd\u00d0\u00be\u00d1\ufffd\u00d0\u00b1\u00d1\u20ac\u00d1\u0152","\u00d0\u201d\u00d0\u00b5\u00d0\u00ba\u00d0\u00b0\u00d0\u00b1\u00d1\u20ac\u00d1\u0152"],
monthNamesShort:["\u00d0\u00af\u00d0\u00bd\u00d0\u00b2","\u00d0\u00a4\u00d0\u00b5\u00d0\u00b2","\u00d0\u0153\u00d0\u00b0\u00d1\u20ac","\u00d0\ufffd\u00d0\u00bf\u00d1\u20ac","\u00d0\u0153\u00d0\u00b0\u00d0\u00b9","\u00d0\u02dc\u00d1\u017d\u00d0\u00bd","\u00d0\u02dc\u00d1\u017d\u00d0\u00bb","\u00d0\ufffd\u00d0\u00b2\u00d0\u00b3","\u00d0\u00a1\u00d0\u00b5\u00d0\u00bd","\u00d0\u017e\u00d0\u00ba\u00d1\u201a","\u00d0\ufffd\u00d0\u00be\u00d1\ufffd","\u00d0\u201d\u00d0\u00b5\u00d0\u00ba"],dayNames:["\u00d0\u00b2\u00d0\u00be\u00d1\ufffd\u00d0\u00ba\u00d1\u20ac\u00d0\u00b5\u00d1\ufffd\u00d0\u00b5\u00d0\u00bd\u00d1\u0152\u00d0\u00b5",
"\u00d0\u00bf\u00d0\u00be\u00d0\u00bd\u00d0\u00b5\u00d0\u00b4\u00d0\u00b5\u00d0\u00bb\u00d1\u0152\u00d0\u00bd\u00d0\u00b8\u00d0\u00ba","\u00d0\u00b2\u00d1\u201a\u00d0\u00be\u00d1\u20ac\u00d0\u00bd\u00d0\u00b8\u00d0\u00ba","\u00d1\ufffd\u00d1\u20ac\u00d0\u00b5\u00d0\u00b4\u00d0\u00b0","\u00d1\u2021\u00d0\u00b5\u00d1\u201a\u00d0\u00b2\u00d0\u00b5\u00d1\u20ac\u00d0\u00b3","\u00d0\u00bf\u00d1\ufffd\u00d1\u201a\u00d0\u00bd\u00d0\u00b8\u00d1\u2020\u00d0\u00b0","\u00d1\ufffd\u00d1\u0192\u00d0\u00b1\u00d0\u00b1\u00d0\u00be\u00d1\u201a\u00d0\u00b0"],
dayNamesShort:["\u00d0\u00b2\u00d1\ufffd\u00d0\u00ba","\u00d0\u00bf\u00d0\u00bd\u00d0\u00b4","\u00d0\u00b2\u00d1\u201a\u00d1\u20ac","\u00d1\ufffd\u00d1\u20ac\u00d0\u00b4","\u00d1\u2021\u00d1\u201a\u00d0\u00b2","\u00d0\u00bf\u00d1\u201a\u00d0\u00bd","\u00d1\ufffd\u00d0\u00b1\u00d1\u201a"],formatString:"%Y-%m-%d %H:%M:%S"},ar:{monthNames:["\u00d9\u0192\u00d8\u00a7\u00d9\u2020\u00d9\u02c6\u00d9\u2020 \u00d8\u00a7\u00d9\u201e\u00d8\u00ab\u00d8\u00a7\u00d9\u2020\u00d9\u0160","\u00d8\u00b4\u00d8\u00a8\u00d8\u00a7\u00d8\u00b7",
"\u00d8\u00a2\u00d8\u00b0\u00d8\u00a7\u00d8\u00b1","\u00d9\u2020\u00d9\u0160\u00d8\u00b3\u00d8\u00a7\u00d9\u2020","\u00d8\u00a2\u00d8\u00b0\u00d8\u00a7\u00d8\u00b1","\u00d8\u00ad\u00d8\u00b2\u00d9\u0160\u00d8\u00b1\u00d8\u00a7\u00d9\u2020","\u00d8\u00aa\u00d9\u2026\u00d9\u02c6\u00d8\u00b2","\u00d8\u00a2\u00d8\u00a8","\u00d8\u00a3\u00d9\u0160\u00d9\u201e\u00d9\u02c6\u00d9\u201e","\u00d8\u00aa\u00d8\u00b4\u00d8\u00b1\u00d9\u0160\u00d9\u2020 \u00d8\u00a7\u00d9\u201e\u00d8\u00a3\u00d9\u02c6\u00d9\u201e",
"\u00d8\u00aa\u00d8\u00b4\u00d8\u00b1\u00d9\u0160\u00d9\u2020 \u00d8\u00a7\u00d9\u201e\u00d8\u00ab\u00d8\u00a7\u00d9\u2020\u00d9\u0160","\u00d9\u0192\u00d8\u00a7\u00d9\u2020\u00d9\u02c6\u00d9\u2020 \u00d8\u00a7\u00d9\u201e\u00d8\u00a3\u00d9\u02c6\u00d9\u201e"],monthNamesShort:["1","2","3","4","5","6","7","8","9","10","11","12"],dayNames:["\u00d8\u00a7\u00d9\u201e\u00d8\u00b3\u00d8\u00a8\u00d8\u00aa","\u00d8\u00a7\u00d9\u201e\u00d8\u00a3\u00d8\u00ad\u00d8\u00af","\u00d8\u00a7\u00d9\u201e\u00d8\u00a7\u00d8\u00ab\u00d9\u2020\u00d9\u0160\u00d9\u2020",
"\u00d8\u00a7\u00d9\u201e\u00d8\u00ab\u00d9\u201e\u00d8\u00a7\u00d8\u00ab\u00d8\u00a7\u00d8\u00a1","\u00d8\u00a7\u00d9\u201e\u00d8\u00a3\u00d8\u00b1\u00d8\u00a8\u00d8\u00b9\u00d8\u00a7\u00d8\u00a1","\u00d8\u00a7\u00d9\u201e\u00d8\u00ae\u00d9\u2026\u00d9\u0160\u00d8\u00b3","\u00d8\u00a7\u00d9\u201e\u00d8\u00ac\u00d9\u2026\u00d8\u00b9\u00d8\u00a9"],dayNamesShort:["\u00d8\u00b3\u00d8\u00a8\u00d8\u00aa","\u00d8\u00a3\u00d8\u00ad\u00d8\u00af","\u00d8\u00a7\u00d8\u00ab\u00d9\u2020\u00d9\u0160\u00d9\u2020",
"\u00d8\u00ab\u00d9\u201e\u00d8\u00a7\u00d8\u00ab\u00d8\u00a7\u00d8\u00a1","\u00d8\u00a3\u00d8\u00b1\u00d8\u00a8\u00d8\u00b9\u00d8\u00a7\u00d8\u00a1","\u00d8\u00ae\u00d9\u2026\u00d9\u0160\u00d8\u00b3","\u00d8\u00ac\u00d9\u2026\u00d8\u00b9\u00d8\u00a9"],formatString:"%Y-%m-%d %H:%M:%S"},pt:{monthNames:["Janeiro","Fevereiro","Mar&ccedil;o","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],monthNamesShort:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out",
"Nov","Dez"],dayNames:["Domingo","Segunda-feira","Ter&ccedil;a-feira","Quarta-feira","Quinta-feira","Sexta-feira","S&aacute;bado"],dayNamesShort:["Dom","Seg","Ter","Qua","Qui","Sex","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"},"pt-BR":{monthNames:["Janeiro","Fevereiro","Mar&ccedil;o","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],monthNamesShort:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"],dayNames:["Domingo","Segunda-feira","Ter&ccedil;a-feira",
"Quarta-feira","Quinta-feira","Sexta-feira","S&aacute;bado"],dayNamesShort:["Dom","Seg","Ter","Qua","Qui","Sex","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"}};q.regional["en-US"]=q.regional["en-GB"]=q.regional.en;q.regional.getLocale=function(){var a=q.config.defaultLocale;if(document&&document.getElementsByTagName("html")&&document.getElementsByTagName("html")[0].lang){a=document.getElementsByTagName("html")[0].lang;if(!q.regional.hasOwnProperty(a))a=q.config.defaultLocale}return a};var aa=function(a,
c){a=String(a);return String(Math.pow(10,c-a.length)).slice(1).concat(a)},I={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5,month:{add:function(a,c){I.year.add(a,Math[c>0?"floor":"ceil"](c/12));var d=a.getMonth()+c%12;if(d==12){d=0;a.setYear(a.getFullYear()+1)}else if(d==-1){d=11;a.setYear(a.getFullYear()-1)}a.setMonth(d)},diff:function(a,c){var d=a.getFullYear()-c.getFullYear();d=a.getMonth()-c.getMonth()+d*12;var b=a.getDate()-c.getDate();return d+b/30}},year:{add:function(a,
c){a.setYear(a.getFullYear()+Math[c>0?"floor":"ceil"](c))},diff:function(a,c){return I.month.diff(a,c)/12}}},V;for(V in I)if(V.substring(V.length-1)!="s")I[V+"s"]=I[V];q.strftime=function(a,c,d,b){var e="perl",i=q.regional.getLocale();if(d&&q.formats.hasOwnProperty(d))e=d;else if(d&&q.regional.hasOwnProperty(d))i=d;if(b&&q.formats.hasOwnProperty(b))e=b;else if(b&&q.regional.hasOwnProperty(b))i=b;if($(a)!="[object Object]"||a._type!="jsDate"){a=new q(a);a.locale=i}c||(c=a.formatString||q.regional[i].formatString);
c=c||"%Y-%m-%d";for(b="";c.length>0;)if(d=c.match(q.formats[e].codes.matcher)){b+=c.slice(0,d.index);i=d[1]||"";var f;f=a;var h=d[2],l=e;if(q.formats[l].shortcuts[h])f=q.strftime(f,q.formats[l].shortcuts[h],l);else{h=(q.formats[l].codes[h]||"").split(".");f=f["get"+h[0]]?f["get"+h[0]]():"";if(h[1])f=aa(f,h[1])}b+=i+f;c=c.slice(d.index+d[0].length)}else{b+=c;c=""}return b};q.formats={ISO:"%Y-%m-%dT%H:%M:%S.%N%G",SQL:"%Y-%m-%d %H:%M:%S"};q.formats.perl={codes:{matcher:/()%(#?(%|[a-z]))/i,Y:"FullYear",
y:"ShortYear.2",m:"MonthNumber.2","#m":"MonthNumber",B:"MonthName",b:"AbbrMonthName",d:"Date.2","#d":"Date",e:"Date",A:"DayName",a:"AbbrDayName",w:"Day",H:"Hours.2","#H":"Hours",I:"Hours12.2","#I":"Hours12",p:"AMPM",M:"Minutes.2","#M":"Minutes",S:"Seconds.2","#S":"Seconds",s:"Unix",N:"Milliseconds.3","#N":"Milliseconds",O:"TimezoneOffset",Z:"TimezoneName",G:"GmtOffset"},shortcuts:{F:"%Y-%m-%d",T:"%H:%M:%S",X:"%H:%M:%S",x:"%m/%d/%y",D:"%m/%d/%y","#c":"%a %b %e %H:%M:%S %Y",v:"%e-%b-%Y",R:"%H:%M",r:"%I:%M:%S %p",
t:"\t",n:"\n","%":"%"}};q.formats.php={codes:{matcher:/()%((%|[a-z]))/i,a:"AbbrDayName",A:"DayName",d:"Date.2",e:"Date",j:"DayOfYear.3",u:"DayOfWeek",w:"Day",U:"FullWeekOfYear.2",V:"IsoWeek.2",W:"WeekOfYear.2",b:"AbbrMonthName",B:"MonthName",m:"MonthNumber.2",h:"AbbrMonthName",C:"Century.2",y:"ShortYear.2",Y:"FullYear",H:"Hours.2",I:"Hours12.2",l:"Hours12",p:"AMPM",P:"AmPm",M:"Minutes.2",S:"Seconds.2",s:"Unix",O:"TimezoneOffset",z:"GmtOffset",Z:"TimezoneAbbr"},shortcuts:{D:"%m/%d/%y",F:"%Y-%m-%d",
T:"%H:%M:%S",X:"%H:%M:%S",x:"%m/%d/%y",R:"%H:%M",r:"%I:%M:%S %p",t:"\t",n:"\n","%":"%"}};q.createDate=function(a){function c(f,h){var l=parseFloat(h[1]),j=parseFloat(h[2]),n=parseFloat(h[3]),k=q.config.defaultCentury,m;if(l>31){m=n;l=k+l}else{m=j;j=l;l=k+n}return f.replace(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})/,j+"/"+m+"/"+l)}if(a==null)return new Date;if(a instanceof Date)return a;if(typeof a=="number")return new Date(a);a=String(a).replace(/^\s*(.+)\s*$/g,"$1");a=a.replace(/^([0-9]{1,4})-([0-9]{1,2})-([0-9]{1,4})/,
"$1/$2/$3");a=a.replace(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{4})/i,"$1 $2 $3");var d=a.match(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{2})\D*/i);if(d&&d.length>3){var b=parseFloat(d[3]);b=q.config.defaultCentury+b;a=a.replace(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{2})\D*/i,d[1]+" "+d[2]+" "+String(b))}if((d=a.match(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})[^0-9]/))&&d.length>3)a=c(a,d);if((d=a.match(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})$/))&&d.length>3)a=c(a,d);d=0;b=
q.matchers.length;for(var e,i=a;d<b;){e=Date.parse(i);if(!isNaN(e))return new Date(e);e=q.matchers[d];if(typeof e=="function"){e=e.call(q,i);if(e instanceof Date)return e}else i=a.replace(e[0],e[1]);d++}return NaN};q.daysInMonth=function(a,c){if(c==2)return(new Date(a,1,29)).getDate()==29?29:28;return[A,31,A,31,30,31,30,31,31,30,31,30,31][c]};q.matchers=[[/(3[01]|[0-2]\d)\s*\.\s*(1[0-2]|0\d)\s*\.\s*([1-9]\d{3})/,"$2/$1/$3"],[/([1-9]\d{3})\s*-\s*(1[0-2]|0\d)\s*-\s*(3[01]|[0-2]\d)/,"$2/$3/$1"],function(a){var c=
a.match(/^(?:(.+)\s+)?([012]?\d)(?:\s*\:\s*(\d\d))?(?:\s*\:\s*(\d\d(\.\d*)?))?\s*(am|pm)?\s*$/i);if(c){if(c[1]){a=this.createDate(c[1]);if(isNaN(a))return}else{a=new Date;a.setMilliseconds(0)}var d=parseFloat(c[2]);if(c[6])d=c[6].toLowerCase()=="am"?d==12?0:d:d==12?12:d+12;a.setHours(d,parseInt(c[3]||0,10),parseInt(c[4]||0,10),(parseFloat(c[5]||0)||0)*1E3)}return a},function(a){var c=a.match(/^(?:(.+))[T|\s+]([012]\d)(?:\:(\d\d))(?:\:(\d\d))(?:\.\d+)([\+\-]\d\d\:\d\d)$/i);if(c){if(c[1]){a=this.createDate(c[1]);
if(isNaN(a))return}else{a=new Date;a.setMilliseconds(0)}var d=parseFloat(c[2]);a.setHours(d,parseInt(c[3],10),parseInt(c[4],10),parseFloat(c[5])*1E3)}return a},function(a){var c=a.match(/^([0-3]?\d)\s*[-\/.\s]{1}\s*([a-zA-Z]{3,9})\s*[-\/.\s]{1}\s*([0-3]?\d)$/);if(c){a=new Date;var d=q.config.defaultCentury,b=parseFloat(c[1]),e=parseFloat(c[3]),i;if(b>31){i=e;d+=b}else{i=b;d+=e}b=fa(c[2],q.regional[q.regional.getLocale()].monthNamesShort);if(b==-1)b=fa(c[2],q.regional[q.regional.getLocale()].monthNames);
a.setFullYear(d,b,i);a.setHours(0,0,0,0)}return a}];g.jsDate=q;g.jqplot.sprintf=function(){function a(f,h,l,j){h=f.length>=h?"":Array(1+h-f.length>>>0).join(l);return j?f+h:h+f}function c(f){f=new String(f);for(var h=10;h>0;h--)if(f==(f=f.replace(/^(\d+)(\d{3})/,"$1"+g.jqplot.sprintf.thousandsSeparator+"$2")))break;return f}function d(f,h,l,j,n,k){var m=j-f.length;if(m>0){var o=" ";if(k)o="&nbsp;";f=l||!n?a(f,j,o,l):f.slice(0,h.length)+a("",m,"0",true)+f.slice(h.length)}return f}function b(f,h,l,
j,n,k,m,o){f>>>=0;l=l&&f&&{"2":"0b","8":"0","16":"0x"}[h]||"";f=l+a(f.toString(h),k||0,"0",false);return d(f,l,j,n,m,o)}var e=arguments,i=0;return e[i++].replace(g.jqplot.sprintf.regex,function(f,h,l,j,n,k,m){if(f=="%%")return"%";for(var o=false,s="",r=false,p=false,u=n=false,t=0;l&&t<l.length;t++)switch(l.charAt(t)){case " ":s=" ";break;case "+":s="+";break;case "-":o=true;break;case "0":r=true;break;case "#":p=true;break;case "&":n=true;break;case "'":u=true}j=j?j=="*"?+e[i++]:j.charAt(0)=="*"?
+e[j.slice(1,-1)]:+j:0;if(j<0){j=-j;o=true}if(!isFinite(j))throw Error("$.jqplot.sprintf: (minimum-)width must be finite");k=k?k=="*"?+e[i++]:k.charAt(0)=="*"?+e[k.slice(1,-1)]:+k:"fFeE".indexOf(m)>-1?6:m=="d"?0:void 0;h=h?e[h.slice(0,-1)]:e[i++];switch(m){case "s":if(h==null)return"";m=String(h);if(k!=null)m=m.slice(0,k);return d(m,"",o,j,r,n);case "c":m=String.fromCharCode(+h);if(k!=null)m=m.slice(0,k);return d(m,"",o,j,r,n);case "b":return b(h,2,p,o,j,k,r,n);case "o":return b(h,8,p,o,j,k,r,n);
case "x":return b(h,16,p,o,j,k,r,n);case "X":return b(h,16,p,o,j,k,r,n).toUpperCase();case "u":return b(h,10,p,o,j,k,r,n);case "i":h=parseInt(+h,10);if(isNaN(h))return"";f=h<0?"-":s;s=u?c(String(Math.abs(h))):String(Math.abs(h));h=f+a(s,k,"0",false);return d(h,f,o,j,r,n);case "d":h=Math.round(+h);if(isNaN(h))return"";f=h<0?"-":s;s=u?c(String(Math.abs(h))):String(Math.abs(h));h=f+a(s,k,"0",false);return d(h,f,o,j,r,n);case "e":case "E":case "f":case "F":case "g":case "G":h=+h;if(isNaN(h))return"";
f=h<0?"-":s;s=["toExponential","toFixed","toPrecision"]["efg".indexOf(m.toLowerCase())];m=["toString","toUpperCase"]["eEfFgG".indexOf(m)%2];s=Math.abs(h)[s](k);s=u?c(s):s;return d(f+s,f,o,j,r,n)[m]();case "p":case "P":h=+h;if(isNaN(h))return"";f=h<0?"-":s;s=String(Number(Math.abs(h)).toExponential()).split(/e|E/);u=s[0].indexOf(".")!=-1?s[0].length-1:s[0].length;s=s[1]<0?-s[1]-1:0;h=Math.abs(h)<1?u+s<=k?f+Math.abs(h).toPrecision(u):u<=k-1?f+Math.abs(h).toExponential(u-1):f+Math.abs(h).toExponential(k-
1):f+Math.abs(h).toPrecision(u<=k?u:k);m=["toString","toUpperCase"]["pP".indexOf(m)%2];return d(h,f,o,j,r,n)[m]();case "n":return"";default:return f}})};g.jqplot.sprintf.thousandsSeparator=",";g.jqplot.sprintf.regex=/%%|%(\d+\$)?([-+#0&\' ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([nAscboxXuidfegpEGP])/g;g.jqplot.getSignificantFigures=function(a){var c=String(Number(Math.abs(a)).toExponential()).split(/e|E/);a=c[0].indexOf(".")!=-1?c[0].length-1:c[0].length;var d=c[1]<0?-c[1]-1:0;c=parseInt(c[1]);
var b=c+1>0?c+1:0;return{significantDigits:a,digitsLeft:b,digitsRight:a<=b?0:a-c-1,zeros:d,exponent:c}};g.jqplot.getPrecision=function(a){a=g.jqplot.getSignificantFigures(a);return a[1]-1-parseInt(a[0][1])}})(jQuery);