/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.ui;

import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.user.*;
import javax.baja.util.*;
import javax.baja.ui.*;
import javax.baja.workbench.fieldeditor.*;

/**
 * BUserRoleFE is used to pick a users profile.
 *
 * @author    Andy Frank
 * @creation  22 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BUserRoleFE
  extends BWbFieldEditor
{ 

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BUserRoleFE.class);

  public BUserRoleFE()
  {
    setContent(field);
    linkTo("la", field, BListDropDown.valueModified,   setModified);
    linkTo("lb", field, BListDropDown.actionPerformed, actionPerformed);
  }
  
  protected void doSetReadonly(boolean readonly)
  { 
    field.setDropDownEnabled(!readonly);
  }  

  protected void doLoadValue(BObject value, Context cx)
  {                  
    String role = ((BString)value).getString();
    field.getList().removeAllItems(); 
    
    try
    {
      BObject base = getWbShell().getActiveOrdTarget().get();
      BUser[] proto = BApplianceUserManager.getProtos(base);
      for (int i=0; i<proto.length; i++)
      {
        String name = SlotPath.unescape(proto[i].getName());
        field.getList().addItem(name);
        if (name.equals(role)) field.getList().setSelectedIndex(i);
      }
    }
    catch (Exception e) {}    
  }
  
  protected BObject doSaveValue(BObject value, Context cx)
  {  
    String role = (String)field.getList().getSelectedItem();
    return BString.make(role);
  }                    
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  BListDropDown field = new BListDropDown();
}
