/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.ui;

import javax.baja.sys.*;
import javax.baja.collection.*;
import javax.baja.naming.*;
import javax.baja.user.*;
import javax.baja.gx.*;
import javax.baja.util.*;
import javax.baja.ui.*;
import javax.baja.workbench.*;
import javax.baja.workbench.fieldeditor.*;

/**
 * BGroupOrdFE is used to pick a group'd ord with a drop down.
 *
 * @author    Brian Frank
 * @creation  2 Jun 04
 * @version   $Revision: 2$ $Date: 26-Aug-04 11:56:19 AM$
 * @since     Baja 1.0
 */
public class BGroupOrdFE
  extends BWbFieldEditor
{ 

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BGroupOrdFE.class);

  public BGroupOrdFE()
  {
    setContent(field);
    linkTo("la", field, BListDropDown.valueModified,   setModified);
    linkTo("lb", field, BListDropDown.actionPerformed, actionPerformed);
  }
  
  protected void doSetReadonly(boolean readonly)
  { 
    field.setDropDownEnabled(!readonly);
  }  

  protected void doLoadValue(BObject value, Context cx)
  {                  
    BOrd ord = (BOrd)value;
    
    Item cur = (Item)field.getSelectedItem();
    if (cur != null && ord.equals(cur.ord))
      return;
    
    // update field and assume no drop down
    field.getList().removeAllItems();
    items = null;
    
    try
    {                    
      // find items
      items = list();
      
      // populate drop down and check for an ord match
      Item match = null;
      for(int i=0; i<items.length; ++i)
      {          
        Item item = items[i];        
        if (item.ord.equals(ord)) match = item;
        field.getList().addItem(item.icon, item);
      }       
      
      // pre-select current
      if (match != null) 
        field.setSelectedItem(match);
    }
    catch(Exception e) 
    {                   
    }    
  }
  
  protected BObject doSaveValue(BObject value, Context cx)
  {  
    Item item = (Item)field.getSelectedItem();
    if (item == null)
      return BOrd.NULL;
    else
      return item.ord;
  }                    
  
////////////////////////////////////////////////////////////////
// List
////////////////////////////////////////////////////////////////
  
  /**
   * Get the list of groups
   */
  public Item[] list()
    throws Exception
  {        
    // use bql to find all the groups in database
    BOrd bql = BOrd.make("station:|slot:/|bql:select handleOrd, displayName, icon from demoAppliance:Group");
    BITable result = (BITable)bql.get(getWbShell().getActiveOrdTarget().get());
    
    // get projection columns
    Column colOrd  = result.getColumns().get(0);
    Column colName = result.getColumns().get(1);
    Column colIcon = result.getColumns().get(2);
    
    // map result table to items
    Item[] items = new Item[result.size()];
    for(int i=0; i<items.length; ++i)
      items[i] = new Item(result.getString(i, colOrd), 
                          result.getString(i, colName), 
                          result.getString(i, colIcon));   
    return items;                      
  }
      
////////////////////////////////////////////////////////////////
// Item
////////////////////////////////////////////////////////////////

  static class Item
  {             
    Item(String ord, String displayName, String icon) 
    {
      this.ord = BOrd.make(ord);
      this.displayName = displayName;
      this.icon = BImage.make(icon);
    }
    
    public String toString() { return displayName; }
    
    BOrd ord;
    String displayName;
    BImage icon;
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  BListDropDown field = new BListDropDown();
  Item[] items;
}
