/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.ui;

import java.io.*;
import java.util.*;
import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.space.*;
import javax.baja.util.*;
import javax.baja.gx.*;
import javax.baja.ui.*;
import javax.baja.ui.event.*;
import javax.baja.ui.enums.*;
import javax.baja.workbench.*;
import javax.baja.workbench.component.table.*;
import javax.baja.workbench.mgr.*;
import javax.baja.schedule.*;
import com.tridium.workbench.transfer.*;
import appliance.*;

/**
 * BGroupManager is a simple tools for adding/removing/configuring Groups.
 *
 * @author    Brian Frank       
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BGroupManager  
  extends BAbstractManager
{   

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BGroupManager.class);
  
////////////////////////////////////////////////////////////////
// AbstractManager
////////////////////////////////////////////////////////////////

  protected MgrModel makeModel() { return new Model(this); }
  protected MgrController makeController() { return new Controller(this); }

////////////////////////////////////////////////////////////////
// Model
////////////////////////////////////////////////////////////////
  
  class Model extends MgrModel
  {                                  
    Model(BGroupManager mgr) { super(mgr); }
    
    protected String makeTableTitle()
    {        
      return "Groups";
    }  
    
    protected MgrColumn[] makeColumns()
    {
      return new MgrColumn[] 
      { 
        new MgrColumn.Name(),
        new MgrColumn("Schedule")
        {
          public Object get(Object row) 
          { 
            return ((BGroup)row).scheduleToString();
          }   
        },
        new MgrColumn.Prop(BGroup.averageTemp),
      };
    }

    public int getSubscribeDepth()
    {
      return 2;
    }
  
    public Type[] getIncludeTypes()
    {                                   
      return new Type[] { BGroup.TYPE, BGroupFolder.TYPE };      
    }                                                              
    
    public MgrTypeInfo[] getNewTypes()
    {
      return MgrTypeInfo.makeArray(BGroup.TYPE);
    }  
  }

////////////////////////////////////////////////////////////////
// Controller
////////////////////////////////////////////////////////////////
  
  class Controller extends MgrController
  {
    Controller(BGroupManager mgr) 
    { 
      super(mgr); 
      edit.setFlags(0);
      
      this.newFolder = new NewFolder(mgr);
      newFolder.setFlags(BARS | POPUP);
    }                                   

    protected IMgrCommand[] makeCommands()
    {                   
      return append(            
        new IMgrCommand[] { newFolder },
        super.makeCommands());  
    }              

    public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col)
    {                                      
      BComponent comp = table.getComponentAt(row);
      BWbShell shell = getWbShell();
      if (comp != null && shell != null)
        shell.hyperlink(new HyperlinkInfo(comp.getNavOrd(), event));
    }  

    public BMenu makePopup(BMgrTable table, ComponentTableSubject subject, BMenu menu)
    {
      menu = super.makePopup(table, subject, menu);
      return BApplianceProfile.trim(menu);
    }
    
    MgrCommand newFolder;
  }

////////////////////////////////////////////////////////////////
// New Folder
////////////////////////////////////////////////////////////////

  class NewFolder extends MgrController.MgrCommand
  {     
    NewFolder(BWidget owner) { super(owner, Lexicon.make("workbench"), "newFolder"); }
    public CommandArtifact doInvoke() throws Exception { return doNewFolder(); }
  }

  public CommandArtifact doNewFolder()
    throws Exception
  {                                           
    MgrModel model = getModel();
    BComponent parent = (BComponent)getCurrentValue();
    BComponent child  = new BGroupFolder();
    String name       = "SubGroup";
    return TransferUtil.insert(this, TransferUtil.ACTION_COPY, new Mark(child, name), parent, null, null);
  }               

}

