/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package appliance.ui;

import java.io.*;
import java.lang.reflect.Constructor;
import java.util.*;
import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.nav.*;
import javax.baja.agent.*;
import javax.baja.registry.*;
import javax.baja.util.*;
import javax.baja.gx.*;
import javax.baja.ui.*;
import javax.baja.ui.commands.*;
import javax.baja.ui.options.*;
import javax.baja.workbench.*;
import javax.baja.workbench.sidebar.*;
import javax.baja.workbench.tool.*;
import javax.baja.workbench.view.*;
import com.tridium.workbench.shell.*;

/**
 * BApplianceProfile.
 *
 * @author    Brian Frank       
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BApplianceProfile
  extends BWbProfile    
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BApplianceProfile.class);
    
////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////
    
  /**
   * Constructor with all features enabled by default.
   */
  public BApplianceProfile(BWbShell shell)
  {              
    super(shell); 
  }            

////////////////////////////////////////////////////////////////
// WbProfile
////////////////////////////////////////////////////////////////


  public BMenuBar makeMenuBar()
  {      
    BMenuBar bar = super.makeMenuBar();
    
    // extract what I want to keep        
    BMenu file = (BMenu)bar.get("file");
    BMenu edit = (BMenu)bar.get("edit");
    BMenu tools = (BMenu)bar.get("tools");
    BMenu window = (BMenu)bar.get("window");
      BMenu sidebars = window.removeSubMenu("sidebars");
    BMenu help = (BMenu)bar.get("help");            
    
    // customize file        
    file.keep(new String[] {"open", "text", "save", "export", "back", "forward", "home", "refresh", "close", "exit"});
    file.reorderToTop(file.add(null, new BSeparator()));   

    // customize edit        
    edit.keep(new String[] {"cut", "copy", "paste", "duplicate", "delete"});

    // customize help        
    help.keep(new String[] {});
    help.add("help", new HelpCommand(getShell()));
    
    // rebuild like I want
    bar.removeAll();
    bar.add("file", file);
    bar.add("edit", edit);
    bar.add("tools", tools);
    bar.add("sidebars", sidebars);
    bar.add("help", help);
    
    return bar;
  }
  
  public BToolBar makeToolBar()
  {              
    BToolBar bar = super.makeToolBar();
    bar.keep(new String[] { "back", "forward", "refresh", "home" });
    return bar;
  }

  public BWbLocatorBar makeLocatorBar()
  {
    return new BApplianceLocatorBar(getShell());
  }                         
  
  public String getAppName()
  {                        
    // this application key matches the name used in
    // module-include.xml to enable demoAppliance specific
    // views on UserManager, etc
    return "demoAppliance";
  }

  public BImage getFrameIcon()
  {                                         
    return BImage.make("module://demoAppliance/appliance/ui/initech.png");
  }

  public String getFrameTitle()
  {                                         
    return "Initech Appliance Demo";
  }

  public BOrd getStartOrd()
  {                   
    return home;
  }  

  public BOrd getHomeOrd() 
  {
    return home;
  }

  public BWbSideBar[] getDefaultSideBars()
  {                                     
    return new BWbSideBar[] 
    { 
      new BApplianceSideBar(),
    };
  }

  public boolean hasSideBar(TypeInfo typeInfo)
  {
    String s = typeInfo.toString();
    if (s.startsWith("demoAppliance")) return true;
    return false;
  }
  
  public boolean hasTool(TypeInfo typeInfo)
  {
    String s = typeInfo.toString();
    if (s.equals("workbench:ManageCredentialsTool")) return true;
    return false;
  }

  public boolean hasUserOptions(TypeInfo typeInfo)
  {
    String s = typeInfo.toString();
    if (s.equals("workbench:GeneralOptions")) return true;
    if (s.equals("bajaui:TextEditorOptions")) return true;
    return false;
  }

  public boolean hasView(BObject target, AgentInfo agentInfo)
  {   
    // hide standard views
    String s = agentInfo.getAgentType().toString();
    if (s.equals("workbench:PropertySheet")) return false;
    if (s.equals("workbench:SlotSheet")) return false;
    if (s.equals("workbench:LinkSheet")) return false;
    if (s.equals("wiresheet:WireSheet")) return false;
    if (s.equals("wbutil:CategorySheet")) return false;
    if (s.equals("pxEditor:PxEditor")) return false;
    //if (s.equals("history:DatabaseMaintenance")) return false;
    if (s.equals("workbench:TextFileEditor")) return false;
    if (s.equals("workbench:HexFileEditor")) return false;
    if (s.equals("workbench:NavContainerView")) return false;
    if (s.equals("wbutil:UserManager")) return false;
    if (s.equals("wbutil:PermissionsBrowser")) return false;
    if (s.startsWith("demoAppliance")) return true;
    if (s.toLowerCase().indexOf("wattstopper") != -1) return false;  // need to make appName
    if (agentInfo instanceof BPxView) return true;
    return true;
  }

////////////////////////////////////////////////////////////////
// Commands
////////////////////////////////////////////////////////////////

  class OpenOfflineCommand extends Command
  {
    OpenOfflineCommand(BWbShell shell) { super(shell, lex, "openOffline"); }
    public CommandArtifact doInvoke() throws Exception
    {               
      new PlatformUtil((BWbShell)getOwner()).openOffline();
      return null;
    }
  }

  class InstallSiteCommand extends Command
  {
    InstallSiteCommand(BWbShell shell) { super(shell, lex, "installSite"); }
    public CommandArtifact doInvoke() throws Exception
    {               
      new PlatformUtil((BWbShell)getOwner()).installSite();
      return null;
    }
  }

  class HelpCommand extends Command
  {
    HelpCommand(BWbShell shell) { super(shell, lex, "help"); }
    public CommandArtifact doInvoke()
    {
      WbMain.openHelp((BWbShell)getOwner(), BOrd.make("local:|module://demoAppliance/doc/index.html"));            
      return null;
    }
  }

////////////////////////////////////////////////////////////////
// Utils
////////////////////////////////////////////////////////////////

  public static BMenu trim(BMenu menu)
  {           
    if (menu == null) return null;
    
    /*             
    System.out.println("trim ");      
    BMenuItem[] items = menu.getMenuItems();
    for(int i=0; i<items.length; ++i)
      System.out.println("  " + items[i].getName());
    */
      
    BSubMenuItem views = (BSubMenuItem)menu.get("views");
    if (views != null) 
      views.getMenu().strip(new String[] { "helpGuide", "helpRef", "spyLocal", "spyRemote" });
      
    menu.keep(new String[] { "views", "cut", "copy", "paste", "duplicate", "delete", "rename", "reorder"});
    menu.removeConsecutiveSeparators();
    return menu;
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
 
  static Lexicon lex = Lexicon.make(BApplianceProfile.class);
  static BOrd home = BOrd.make("local:|module://demoAppliance/appliance/ui/about.html");

}
