/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.ui;

import javax.baja.agent.*;
import javax.baja.gx.*;
import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.ui.*;
import javax.baja.ui.enums.*;
import javax.baja.ui.event.*;
import javax.baja.ui.pane.*;
import javax.baja.ui.util.*;
import javax.baja.workbench.*;
import com.tridium.ui.*;
import com.tridium.ui.theme.*;
import com.tridium.workbench.shell.*;

/**
 * BWbLocatorBar is used by a BWbShell to visualization the
 * location/ord of the active view.
 *
 * @author    Brian Frank       
 * @creation  18 Nov 04
 * @version   $Revision$ $Date: 7/21/2004 4:14:34 PM$
 * @since     Baja 1.0
 */
public class BApplianceLocatorBar
  extends BWbLocatorBar   
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BApplianceLocatorBar.class);
  
////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BApplianceLocatorBar(BWbShell shell)
  {
    this.shell = (BNiagaraWbShell)shell;
    add(null, views);
    views.setColumnGap(-1);
    
    BEdgePane edge = new BEdgePane();
    edge.setLeft(new BLabel(BImage.make("module://demoAppliance/appliance/ui/InitechLeft.png")));
    edge.setRight(new BLabel(BImage.make("module://demoAppliance/appliance/ui/InitechRight.png")));
        
    BBorderPane banner = new BBorderPane(edge, BBorder.solid, BInsets.DEFAULT);    
    banner.setFill(BColor.make(0xcadff4).toBrush());
        
    setCenter(new BBorderPane(banner, BBorder.inset, BInsets.DEFAULT));
  }

////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////

  public void activeViewChanged()
  {                          
    try
    {
      AgentList v = shell.tab().getViewAgents();
      AgentInfo current = shell.tab().getViewAgent();
      
      views.removeAll();
      views.setColumnCount(v.size());
      for (int i=0; i<v.size(); i++)
      {
        String name = v.get(i).getDisplayName(null);
        BImage icon = BImage.make(v.get(i).getIcon(null));
        boolean active = (current == v.get(i));
        String agentId = v.get(i).getAgentId();
        BOrd ord = BOrd.make(shell.getActiveOrd(), "view:" + agentId);      
        views.add(null, new BAuxWidget(new ViewTab(name, icon, ord, active)));
      }
      views.getParentWidget().relayout();
    }
    catch(Exception e)
    {
      System.out.println("LocatarBar.activeViewChanged " + e);
    }
  }

////////////////////////////////////////////////////////////////
// BWidget
////////////////////////////////////////////////////////////////
  
  public void doLayout(BWidget[] kids)
  {
    super.doLayout(kids);
    
    views.computePreferredSize();
    double pw = views.getPreferredWidth();
    double ph = views.getPreferredHeight();
    views.setBounds(getWidth()-pw-7, getHeight()-ph, pw, ph);
  }  

////////////////////////////////////////////////////////////////
// Tabs
////////////////////////////////////////////////////////////////

  class ViewTab extends BAuxWidget.Support
  {
    public ViewTab(String name, BImage icon, BOrd ord, boolean active)
    {
      this.name = name;
      this.icon = icon;
      this.ord = ord;
      this.active = active;
    }
    
    public BSize getPreferredSize() 
    { 
      double pw = icon.getWidth() + font.width(name) + 16;
      double ph = Math.max(icon.getHeight(), font.getHeight()) + 14;
      return BSize.make(pw,ph); 
    }
    
    public void paint(Graphics g, double width, double height) 
    {
      PathGeom geom = new PathGeom();
      geom.moveTo(true,0,7);
      geom.lineTo(false,7,-7);
      geom.lineTo(false,0,7);
      geom.closePath();
      
      g.setBrush(active ? Theme.widget().getControlBackground() 
        : BColor.make(0x999999).toBrush());
      g.fill(geom);
      g.fillRect(7,0,width-9,7);
      g.fillRect(2,7,width-4, active ? height-7 : height-9);
      
      g.setBrush(BColor.black);
      g.strokeLine(7,0,0,7);
      g.strokeLine(7,0,width-1,0);
      g.strokeLine(0,7,0,height-2);
      g.strokeLine(width-1,0,width-1,height-2);
      
      g.setBrush(active ? Theme.widget().getControlHighlight() 
        : Theme.widget().getControlBackground());
      g.strokeLine(7,1,width-2,1);
      g.strokeLine(7,1,1,7);
      g.strokeLine(1,7,1,height-(active ? 2 : 3));
      
      g.setBrush(Theme.widget().getControlShadow());
      g.strokeLine(width-2,1,width-2,height-(active ? 2 : 3));
      
      double ix = (width - icon.getWidth() - 4 - font.width(name)) / 2;
      double iy = (height - icon.getHeight()) / 2;
      g.drawImage(icon, ix, iy);
      
      g.setBrush(BColor.black);
      g.setFont(font);
      double tx = ix + icon.getWidth() + 4;
      double ty = (height - font.getHeight()) / 2 + font.getAscent();
      g.drawString(name, tx, ty);
    }
        
    public void mousePressed(BMouseEvent event)
    {      
      shell.hyperlink(ord);
    }
    
    private String name;
    private BImage icon;
    private BOrd ord;
    private boolean active = true;
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  static BFont font = Theme.widget().getBoldText();

  BNiagaraWbShell shell;
  BGridPane views = new BGridPane();
}
