/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.hx;

import javax.baja.hx.*;
import javax.baja.io.*;
import javax.baja.naming.*;
import javax.baja.sys.*;
import javax.baja.user.*;
import javax.baja.util.*;
import appliance.ui.*;

/**
 * BHxUserRoleFE is used to pick a users profile.
 *
 * @author    Andy Frank
 * @creation  24 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BHxUserRoleFE
  extends BHxFieldEditor
{ 
  public static final BHxUserRoleFE INSTANCE = new BHxUserRoleFE();  
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHxUserRoleFE.class);
  
  protected BHxUserRoleFE() {}

  public void write(HxOp op)
    throws Exception
  {
    String role = ((BString)op.get()).getString();
    BUser[] protos = BApplianceUserManager.getProtos(Sys.getStation());
    
    HtmlWriter out = op.getHtmlWriter();
    out.w("<select name='").w(op.scope("role")).w("'");
    if (!op.canWrite()) out.w(" disabled='disabled'");
    out.w(">");
    for (int i=0; i<protos.length; i++)
    {
      String name = SlotPath.unescape(protos[i].getName());
      out.w("<option value='").w(name).w("'");
      if (role.equals(name)) out.w(" selected='selected'");
      out.w(">");
      out.w(name);
      out.w("</option>");  
    }
    out.w("</select>");
  }
  
  public BObject save(HxOp op)
    throws Exception
  {
    return BString.make(op.getFormValue("role"));  
  }
}
