/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.hx;

import javax.baja.collection.*;
import javax.baja.hx.*;
import javax.baja.io.*;
import javax.baja.naming.*;
import javax.baja.sys.*;

/**
 * BHxGroupOrdFE is used to pick a group'd ord with a drop down.
 *
 * @author    Andy Frank
 * @creation  19 Mar 05
 * @version   $Revision: 2$ $Date$
 * @since     Baja 1.0
 */
public class BHxGroupOrdFE
  extends BHxFieldEditor
{ 
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public static final BHxGroupOrdFE INSTANCE = new BHxGroupOrdFE();  
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHxGroupOrdFE.class);
  
  protected BHxGroupOrdFE() {}
  
////////////////////////////////////////////////////////////////
// HxView 
////////////////////////////////////////////////////////////////

  public void write(HxOp op)
    throws Exception
  {
    HtmlWriter out = op.getHtmlWriter();
    out.w("<select name='").w(op.scope("value")).w("'");
    if (!op.canWrite()) out.w(" disabled='disabled'");
    out.w(">");
    Item[] list = list();
    for (int i=0; i<list.length; i++)
      out.w("<option>").w(list[i].displayName).w("</option>");
    out.w("</select>");
    System.out.println("todo! Select current value!");
  }
  
  public BObject save(HxOp op)
    throws Exception
  {
    System.out.println("todo!  Save this value!");
    return op.get();
  }  
  
////////////////////////////////////////////////////////////////
// List
////////////////////////////////////////////////////////////////
  
  /**
   * Get the list of groups
   */
  public Item[] list()
    throws Exception
  {        
    // use bql to find all the groups in database
    BOrd bql = BOrd.make("station:|slot:/|bql:select handleOrd, displayName from demoAppliance:Group");
    BITable result = (BITable)bql.get(Sys.getStation());
    
    // get projection columns
    Column colOrd  = result.getColumns().get(0);
    Column colName = result.getColumns().get(1);    
    
    // map result table to items
    Item[] items = new Item[result.size()];
    for(int i=0; i<items.length; ++i)
      items[i] = new Item(result.getString(i, colOrd), 
                          result.getString(i, colName));   
    return items;                      
  }
      
////////////////////////////////////////////////////////////////
// Item
////////////////////////////////////////////////////////////////

  static class Item
  {             
    Item(String ord, String displayName) 
    {
      this.ord = BOrd.make(ord);
      this.displayName = displayName;      
    }
    
    public String toString() { return displayName; }
    
    BOrd ord;
    String displayName;
  }
}
