/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package appliance.hx;

import javax.baja.hx.mgr.*;
import javax.baja.sys.*;
import appliance.*;

/**
 * BHxGroupManager.
 *
 * @author    Andy Frank
 * @creation  22 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BHxGroupManager
  extends BHxAbstractManager
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public static final BHxGroupManager INSTANCE = new BHxGroupManager();
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHxGroupManager.class);
      
  protected BHxGroupManager() {}

////////////////////////////////////////////////////////////////
// Model
////////////////////////////////////////////////////////////////

  protected HxMgrModel makeModel() { return new Model(); }
  
  class Model extends HxMgrModel
  {                                  
    public String makeTableTitle()  { return "Groups";  }  
    public Type[] getIncludeTypes() { return new Type[] { BGroup.TYPE, BGroupFolder.TYPE }; }
    protected HxMgrColumn[] makeColumns()
    {
      return new HxMgrColumn[] {
        new HxMgrColumn.Name(),
        new HxMgrColumn("Schedule")
        {
          public Object get(Object row) 
          { 
            return ((BGroup)row).scheduleToString();
          }   
        },
        new HxMgrColumn.Prop(BGroup.averageTemp),
      };    
    }
  }   
}


