/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.hx;

import javax.baja.io.*;
import javax.baja.collection.*;
import javax.baja.gx.*;
import javax.baja.hx.*;
import javax.baja.naming.*;
import javax.baja.status.*;
import javax.baja.sys.*;
import javax.baja.util.*;
import appliance.*;
import appliance.driver.*;

/**
 * BHxEquipSummary shows a summary of equip assigned to a Group.
 *
 * @author    Andy Frank       
 * @creation  19 Mar 05
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BHxEquipSummary  
  extends BHxView
{   
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public static final BHxEquipSummary INSTANCE = new BHxEquipSummary();

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHxEquipSummary.class);
  
  protected BHxEquipSummary() {}
  
////////////////////////////////////////////////////////////////
// HxView
////////////////////////////////////////////////////////////////

  public void write(HxOp op)
    throws Exception
  {
    BGroup group = (BGroup)op.get();
    
    BOrd query = BOrd.make("station:|slot:/|bql:select " +
      "icon, ordInSession, displayName, type.displayName, tempToString, status "  +   
      "from demoAppliance:ApplianceDevice " +
      "where group = '" + group.getHandleOrd() + "'");
    
    BITable table = (BITable)query.resolve(group).get();
    ColumnList cols = table.getColumns();
    
    // Header
    HtmlWriter out = op.getHtmlWriter();
    out.w("<div class='controlShadow-bg tableViewHeader'>");
    out.w("<span style='float:right'>").w(table.size()).w(" objects</span>");
    out.w("Equip for " + group.getDisplayName(op));
    out.w("</div>");
    
    // Table
    out.w("<table width='100%' cellspacing='0' class='table'>");
    out.w("<tr>");
    out.w(" <th>Name</th>");
    out.w(" <th>Type</th>");
    out.w(" <th>Temp</th>");
    out.w(" <th>Status</th>");
    out.w("</tr>");
    for (int i=0; i<table.size(); i++)
    {
      String icon = table.get(i, cols.get(0)).toString();
      String ord  = table.get(i, cols.get(1)).toString();
      String name = table.get(i, cols.get(2)).toString();
      String type = table.get(i, cols.get(3)).toString();
      String temp = table.get(i, cols.get(4)).toString();
      String status = table.get(i, cols.get(5)).toString();
      
      out.w("<tr>");
      out.w(" <td>");
      out.w("  <img ").attr("src", icon).w(" alt=''/> ");
      out.w("  <a ").attr("href", ord).w(">");
      out.safe(name);
      out.w("  </a>");
      out.w("</td>");
      out.w(" <td>").safe(type).w("</td>");
      out.w(" <td>").safe(temp).w("</td>");      
      out.w(" <td width='100%'>").safe(status).w("</td>");
      out.w("</tr>");
    }    
    out.w("</table>");
  } 
}

