/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package appliance.hx;

import javax.baja.agent.*;
import javax.baja.hx.*;
import javax.baja.io.*;
import javax.baja.file.*;
import javax.baja.sys.*;

/**
 * BApplianceHxProfile.
 *
 * @author    Andy Frank
 * @creation  17 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BApplianceHxProfile
  extends BHxProfile
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public static final BApplianceHxProfile INSTANCE = new BApplianceHxProfile();

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BApplianceHxProfile.class);

  protected BApplianceHxProfile() {}

////////////////////////////////////////////////////////////////
// HxWebProfile
////////////////////////////////////////////////////////////////

  public String getAppName()
  {
    // this application key matches the name used in
    // module-include.xml to enable demoAppliance specific
    // views on UserManager, etc
    return "demoAppliance";
  }

  public void doBody(BHxView view, HxOp op)
    throws Exception
  {
    HtmlWriter out = op.getHtmlWriter();

    out.w("<div class='appliance-profile-border'");
    if (op.getUserAgent().isIE()) out.w(" style='height:1%;'");
    out.w("'>");

    // Header
    out.w("<table width='100%' cellspacing='0' cellpadding='0' class='appliance-header'>");
    out.w("<tr>");
    out.w(" <td><img ").attr("src", InitechLeft).w("/></td>");
    out.w(" <td width='100%' valign='bottom'>");
    // View Menu
    BApplianceHxViewMenu.INSTANCE.write(op.make(op));
    out.w(" </td>");
    out.w("</tr>");
    out.w("</table>");

    // Locator Bar
    BApplianceHxLocatorBar.INSTANCE.write(op.make(op));

    // Current View
    out.w("<div class='appliance-profile-content'");
    if (op.getUserAgent().isIE()) out.w(" style='height:1%;'");
    out.w("'>");
    view.write(op);
    out.w("</div>");

    out.w("</div>");

    // Do this last to make sure it gets precendance
    // over any other stylesheets included.
    op.addStyleSheet("module://demoAppliance/appliance/hx/appliance.css");
    
    displayError(op);
  }

  public void updateDocument(BHxView view, HxOp op)
    throws Exception
  {
    BApplianceHxViewMenu.INSTANCE.update(op.make(op));
    BApplianceHxLocatorBar.INSTANCE.update(op.make(op));
    view.update(op);
  }

  public boolean processDocument(BHxView view, HxOp op)
    throws Exception
  {
    if (BApplianceHxViewMenu.INSTANCE.process(op.make(op))) return true;
    if (BApplianceHxLocatorBar.INSTANCE.process(op.make(op))) return true;
    return view.process(op);
  }

  public void saveDocument(BHxView view, HxOp op)
    throws Exception
  {
    BApplianceHxViewMenu.INSTANCE.save(op.make(op));
    BApplianceHxLocatorBar.INSTANCE.save(op.make(op));
    view.save(op);
  }

  public boolean hasView(BObject target, AgentInfo agentInfo)
  {
    // hide standard views
    String s = agentInfo.getAgentType().toString();
    if (s.equals("wbutil:UserManager")) return false;
    if (s.equals("workbench:CollectionTable")) return false;
    if (s.equals("workbench:NavContainerView")) return false;
    if (s.equals("workbench:PropertySheet")) return false;
    if (s.equals("workbench:SlotSheet")) return false;
    if (s.equals("web:FileUploadView")) return false;
    if (s.toLowerCase().indexOf("wattstopper") != -1) return false;  // need to make appName
    if (agentInfo.getAgentType().is(BExporter.TYPE)) return false;
    return true;
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  static final String InitechLeft  = "module://demoAppliance/appliance/ui/InitechLeft.png";
  static final String InitechRight = "module://demoAppliance/appliance/ui/InitechRight.png";
}



