/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.driver;

import javax.baja.sys.*;
import javax.baja.agent.*;
import javax.baja.driver.*;
import appliance.*;

/**
 * BApplianceNetwork
 *
 * @author    Brian Frank
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BApplianceNetwork
  extends BDeviceNetwork   
  implements BIService
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BApplianceNetwork.class);

////////////////////////////////////////////////////////////////
// IService
////////////////////////////////////////////////////////////////

  public Type[] getServiceTypes() { return new Type[] { TYPE }; }
  public void serviceStarted() { }
  public void serviceStopped() { }

////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////

  public void added(Property prop, Context cx)
  {          
    super.added(prop, cx);
    rebuildNavFile();
  }

  public void removed(Property prop, BValue old, Context cx)
  {          
    super.removed(prop, old, cx);
    rebuildNavFile();
  }

  public void renamed(Property prop, String old, Context cx)
  {
    super.renamed(prop, old, cx);
    rebuildNavFile();
  }

  public void reordered(Context cx)
  {
    super.reordered(cx);
    rebuildNavFile();
  }
  
  void rebuildNavFile()
  {
    try
    {               
      if (isRunning()) BApplianceApp.get().rebuildNavFile();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

////////////////////////////////////////////////////////////////
// DeviceNetwork
////////////////////////////////////////////////////////////////

  public Type getDeviceType()
  {
    return BApplianceDevice.TYPE;
  } 
  
  public Type getDeviceFolderType()
  {
    return BApplianceDeviceFolder.TYPE;
  }

////////////////////////////////////////////////////////////////
// Object
////////////////////////////////////////////////////////////////

  public AgentList getAgents(Context cx)
  {      
    AgentList agents = super.getAgents(cx);
    agents.remove("driver:DeviceManager");
    return agents;
  }

}
