/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.driver;

import javax.baja.sys.*;
import javax.baja.driver.*;
import appliance.*;

/**
 * BApplianceDeviceFolder
 *
 * @author    Brian Frank
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BApplianceDeviceFolder
  extends BDeviceFolder
{                           
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BApplianceDeviceFolder.class);

////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////

  public void added(Property prop, Context cx)
  {          
    super.added(prop, cx);
    rebuildNavFile();
  }

  public void removed(Property prop, BValue old, Context cx)
  {          
    super.removed(prop, old, cx);
    rebuildNavFile();
  }
  
  void rebuildNavFile()
  {
    try
    {               
      if (isRunning()) BApplianceApp.get().rebuildNavFile();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }
  
}
