/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance;

import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.nav.*;
import javax.baja.agent.*;
import javax.baja.units.*;
import javax.baja.util.*;
import javax.baja.schedule.*;
import appliance.driver.*;

/**
 * BGroup contains other BGroups or Equipment (via indirection)
 *
 * @author    Brian Frank
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BGroup
  extends BComponent
{          

  static final BUnit degrees;
  static 
  {
    UnitDatabase.getDefault();
    degrees = BUnit.getUnit("fahrenheit");
  }

  /*-
  class BGroup
  {
    properties
    {
      unoccupiedSetpoint: double
        default {[ 65 ]}
        slotfacets {[ BFacets.make(BFacets.UNITS, degrees) ]}
        
      schedule: BBooleanSchedule
        default {[ makeSchedule() ]}
        
      averageTemp: double
        default {[ Double.NaN ]}
        slotfacets {[ BFacets.make(BFacets.UNITS, degrees) ]}
      
      alarmConfig: BAlarmConfig
        default {[ new BAlarmConfig() ]}
        
      scheduling: BPxView
        default {[ makeView("schedule.png", "file:^px/GroupScheduling.px") ]}
        
      alarming: BPxView
        default {[ makeView("alarm.png", "file:^px/GroupAlarming.px") ]}
    }             
    
    actions
    {
      compute()
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $appliance.BGroup(2061493386)1.0$ @*/
/* Generated Sat Nov 20 20:56:18 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "unoccupiedSetpoint"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>unoccupiedSetpoint</code> property.
   * @see appliance.BGroup#getUnoccupiedSetpoint
   * @see appliance.BGroup#setUnoccupiedSetpoint
   */
  public static final Property unoccupiedSetpoint = newProperty(0, 65,BFacets.make(BFacets.UNITS, degrees) );
  
  /**
   * Get the <code>unoccupiedSetpoint</code> property.
   * @see appliance.BGroup#unoccupiedSetpoint
   */
  public double getUnoccupiedSetpoint() { return getDouble(unoccupiedSetpoint); }
  
  /**
   * Set the <code>unoccupiedSetpoint</code> property.
   * @see appliance.BGroup#unoccupiedSetpoint
   */
  public void setUnoccupiedSetpoint(double v) { setDouble(unoccupiedSetpoint,v,null); }

////////////////////////////////////////////////////////////////
// Property "schedule"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>schedule</code> property.
   * @see appliance.BGroup#getSchedule
   * @see appliance.BGroup#setSchedule
   */
  public static final Property schedule = newProperty(0, makeSchedule(),null);
  
  /**
   * Get the <code>schedule</code> property.
   * @see appliance.BGroup#schedule
   */
  public BBooleanSchedule getSchedule() { return (BBooleanSchedule)get(schedule); }
  
  /**
   * Set the <code>schedule</code> property.
   * @see appliance.BGroup#schedule
   */
  public void setSchedule(BBooleanSchedule v) { set(schedule,v,null); }

////////////////////////////////////////////////////////////////
// Property "averageTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>averageTemp</code> property.
   * @see appliance.BGroup#getAverageTemp
   * @see appliance.BGroup#setAverageTemp
   */
  public static final Property averageTemp = newProperty(0, Double.NaN,BFacets.make(BFacets.UNITS, degrees) );
  
  /**
   * Get the <code>averageTemp</code> property.
   * @see appliance.BGroup#averageTemp
   */
  public double getAverageTemp() { return getDouble(averageTemp); }
  
  /**
   * Set the <code>averageTemp</code> property.
   * @see appliance.BGroup#averageTemp
   */
  public void setAverageTemp(double v) { setDouble(averageTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "alarmConfig"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>alarmConfig</code> property.
   * @see appliance.BGroup#getAlarmConfig
   * @see appliance.BGroup#setAlarmConfig
   */
  public static final Property alarmConfig = newProperty(0, new BAlarmConfig(),null);
  
  /**
   * Get the <code>alarmConfig</code> property.
   * @see appliance.BGroup#alarmConfig
   */
  public BAlarmConfig getAlarmConfig() { return (BAlarmConfig)get(alarmConfig); }
  
  /**
   * Set the <code>alarmConfig</code> property.
   * @see appliance.BGroup#alarmConfig
   */
  public void setAlarmConfig(BAlarmConfig v) { set(alarmConfig,v,null); }

////////////////////////////////////////////////////////////////
// Property "scheduling"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>scheduling</code> property.
   * @see appliance.BGroup#getScheduling
   * @see appliance.BGroup#setScheduling
   */
  public static final Property scheduling = newProperty(0, makeView("schedule.png", "file:^px/GroupScheduling.px"),null);
  
  /**
   * Get the <code>scheduling</code> property.
   * @see appliance.BGroup#scheduling
   */
  public BPxView getScheduling() { return (BPxView)get(scheduling); }
  
  /**
   * Set the <code>scheduling</code> property.
   * @see appliance.BGroup#scheduling
   */
  public void setScheduling(BPxView v) { set(scheduling,v,null); }

////////////////////////////////////////////////////////////////
// Property "alarming"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>alarming</code> property.
   * @see appliance.BGroup#getAlarming
   * @see appliance.BGroup#setAlarming
   */
  public static final Property alarming = newProperty(0, makeView("alarm.png", "file:^px/GroupAlarming.px"),null);
  
  /**
   * Get the <code>alarming</code> property.
   * @see appliance.BGroup#alarming
   */
  public BPxView getAlarming() { return (BPxView)get(alarming); }
  
  /**
   * Set the <code>alarming</code> property.
   * @see appliance.BGroup#alarming
   */
  public void setAlarming(BPxView v) { set(alarming,v,null); }

////////////////////////////////////////////////////////////////
// Action "compute"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>compute</code> action.
   * @see appliance.BGroup#compute()
   */
  public static final Action compute = newAction(0,null);
  
  /**
   * Invoke the <code>compute</code> action.
   * @see appliance.BGroup#compute
   */
  public void compute() { invoke(compute,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BGroup.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Factory
////////////////////////////////////////////////////////////////

  static BBooleanSchedule makeSchedule()
  {                      
    BBooleanSchedule sched = new BBooleanSchedule();
    sched.setFacets(BFacets.makeBoolean("Occupied", "Unoccupied"));
    return sched;
  }

  static BPxView makeView(String icon, String ord)
  {             
    BPxView v = new BPxView();
    v.setIcon(BIcon.std(icon));
    v.setPxFile(BOrd.make(ord));
    return v;
  }

////////////////////////////////////////////////////////////////
// Display
////////////////////////////////////////////////////////////////

  public BINavNode[] getNavChildren()
  {        
    return new BINavNode[0]; // nav leaf
  }

  public String scheduleToString()
  {        
    BBooleanSchedule sched = getSchedule();
    return sched.getOut().getValueValue().toString(sched.getFacets());
  }

////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////

  public void started()
  {                     
    ticket = Clock.schedulePeriodically(this, BRelTime.make(5000), compute, null);
  }

  public void stopped()
  {                  
    if (ticket != null) ticket.cancel();
  }

  public void added(Property prop, Context cx)
  {          
    super.added(prop, cx);
    rebuildNavFile();
  }

  public void removed(Property prop, BValue old, Context cx)
  {          
    super.removed(prop, old, cx);
    rebuildNavFile();
  }
  
  void rebuildNavFile()
  {
    try
    {               
      if (isRunning()) BApplianceApp.get().rebuildNavFile();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////

  public BApplianceDevice[] getDevicesInGroup()
  {
    BOrd myOrd = getHandleOrd();
    BComponent network = Sys.getService(BApplianceNetwork.TYPE);
    BApplianceDevice[] devices = (BApplianceDevice[])network.getChildren(BApplianceDevice.class);
    Array acc = new Array(BApplianceDevice.class);
    
    double sum = 0;
    double total = 0;
    
    for(int i=0; i<devices.length; ++i)
    {      
      // skip if this device is mapped to me       
      BApplianceDevice device = devices[i];
      if (myOrd.equals(device.getGroup()))
        acc.add(device);
    }                   
    
    return (BApplianceDevice[])acc.trim();
  }
  
  /**
   * Periodically sync data b/w this group and its devices
   */
  public void doCompute()
  {              
    BOrd myOrd = getHandleOrd();
    BComponent network = Sys.getService(BApplianceNetwork.TYPE);
    BApplianceDevice[] devices = (BApplianceDevice[])network.getChildren(BApplianceDevice.class);
    
    double sum = 0;
    double total = 0;
    
    for(int i=0; i<devices.length; ++i)
    {      
      // skip if this device is mapped to me       
      BApplianceDevice device = devices[i];
      if (!myOrd.equals(device.getGroup())) continue;
      
      // group -> device
      try { devices[i].compute(this); } catch(Exception e) { e.printStackTrace(); }
      
      // group <- device
      total++;
      sum += devices[i].getTemp().getValue();
    }
    
    if (total == 0)
      setAverageTemp(Double.NaN);
    else
      setAverageTemp(sum/(double)total);
  }

////////////////////////////////////////////////////////////////
// BObject
////////////////////////////////////////////////////////////////

  public AgentList getAgents(Context cx)
  {      
    AgentList agents = super.getAgents(cx);
    agents.toTop("demoAppliance:EquipSummary");
    return agents;
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("facets.png");
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  Clock.Ticket ticket;
}
