/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package foo;

import javax.baja.gx.*;
import javax.baja.sys.*;
import javax.baja.ui.*;
import javax.baja.ui.event.*;

/**
 * BExampleWidget.
 *
 * @author    Andy Frank       
 * @creation  10 Apr 06
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BExampleWidget
  extends BWidget   
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BExampleWidget.class);
  
////////////////////////////////////////////////////////////////
// BWidget Methods
////////////////////////////////////////////////////////////////
  
  public void computePreferredSize()
  {
    setPreferredSize(100, 100);
  }

  public void doLayout(BWidget[] kids)
  {
    rect = new RectGeom(10, 10, getWidth()-20, getHeight()-20);
  }
  
  public void paint(Graphics g)
  {
    g.setBrush(fill);
    g.fill(rect);
  }

  public void mousePressed(BMouseEvent event)
  {
    fill = (fill == BColor.red) ? BColor.blue : BColor.red;
    repaint();
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  BColor fill = BColor.red;
  RectGeom rect = new RectGeom();
}


