/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package foo;

import javax.baja.io.*;
import javax.baja.gx.*;
import javax.baja.naming.*;
import javax.baja.sys.*;
import javax.baja.hx.*;
import chotchkie.*;

/**
 * BExampleHxView.
 *
 * @author    Andy Frank       
 * @creation  10 Apr 06
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BExampleHxView
  extends BHxView   
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public static final BExampleHxView INSTANCE = new BExampleHxView();
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BExampleHxView.class);
  
  protected BExampleHxView() 
  {
    registerEvent(event = new SampleEvent(this));
  }
  
////////////////////////////////////////////////////////////////
// BHxView Methods
////////////////////////////////////////////////////////////////
  
  public void write(HxOp op) throws Exception
  {
    BFlair flair = (BFlair)op.get();
    
    HtmlWriter out = op.getHtmlWriter();
    out.w("<div style='padding: 20px'>");
    out.w("<h1>Flair HxConfig</h1>");
    out.w("<hr/>");
    out.w("<b>Current Name:</b> ").safe(flair.getNickName());
    out.w("<br/><br/>");
    out.w("<b>Current Level:</b> ").safe(flair.getLevel().getDisplayTag(op));
    out.w("<br/><br/>");
    out.w("<b>New Name:</b> <input type='text' ");
    out.w("name='").w(op.scope("name")).w("' ");
    out.w("value='").safe(flair.getNickName()).w("' />");
    out.w("<br/><br/>");
    out.w("<input type='submit' value='Save'/> ");
    out.w("<input type='button' value='Show Dialog' onclick='");
    out.w(event.getInvokeCode(op)).w("' />");
    out.w("</div>");
  }
  
  public BObject save(HxOp op) throws Exception
  {
    BFlair flair = (BFlair)op.get();
    String name = op.getFormValue("name");
    flair.setNickName(name);
    return flair;    
  }
  
////////////////////////////////////////////////////////////////
// Event
////////////////////////////////////////////////////////////////
  
  class SampleEvent extends Command
  {
    public SampleEvent(BHxView owner) 
    { 
      super(owner); 
      dlg = new SampleDialog(this);
    }
    
    public void handle(HxOp op) throws Exception
    {
      if (!dlg.isSubmit(op)) dlg.open(op);
      else
      {
        BFlair flair = (BFlair)op.get();
  
        BHxFieldEditor editor = BHxFieldEditor.makeFor(flair.getLevel(), op);
        OrdTarget child = new OrdTarget(op, flair.getLevel());      
        BFlairEnum newVal = (BFlairEnum)editor.save(op.make("level", child));
        flair.setLevel(newVal);
        
        refresh(op);
      }
    }
    
    private Dialog dlg;
  }

////////////////////////////////////////////////////////////////
// Dialog
////////////////////////////////////////////////////////////////

  class SampleDialog extends Dialog
  {
    public SampleDialog(Command handler) { super("SampleDialog", handler); }
    protected void writeContent(HxOp op) throws Exception
    {    
      BFlair flair = (BFlair)op.get();

      HtmlWriter out = op.getHtmlWriter();
      out.w("<div style='padding:10px;'>");
      out.w("<b>Flair Level:</b> ");      
      
      BHxFieldEditor editor = BHxFieldEditor.makeFor(flair.getLevel(), op);
      OrdTarget child = new OrdTarget(op, flair.getLevel());      
      editor.write(op.make("level", child));
      
      out.w("</div>");
    }  
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private SampleEvent event;
}


