/*
 * Copyright 2012 Tridium, Inc. All Rights Reserved.
 */
 
/**
 * ScheduleHx javascript.
 * 
 * @author    JJ Frankovich
 * @creation  01 Feb 2012
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */

var scheduleHx = new ScheduleHx();
function ScheduleHx()
{

  this.specialEventsChanged = function(id, readonly)
  {
    var select = document.getElementsByName(id)[0];
    
    var scope = "";
    var index = id.lastIndexOf(".");
    if( index > -1)
      scope = id.substring(0, index);
      
    scheduleHx.specialEventsShow(scope + "dateSchedule",       select.selectedIndex == 0, readonly);
    scheduleHx.specialEventsShow(scope + "dateRangeSchedule",  select.selectedIndex == 1, readonly);
    scheduleHx.specialEventsShow(scope + "weekAndDaySchedule", select.selectedIndex == 2, readonly);
    scheduleHx.specialEventsShow(scope + "customSchedule",     select.selectedIndex == 3, readonly);
    scheduleHx.specialEventsShow(scope + "scheduleReference",  select.selectedIndex == 4, readonly);    
}

  this.specialEventsShow = function(id, show, readonly)
{
    var elem = document.getElementById(id);
    var selects = elem.getElementsByTagName("select")
    if(show == true)
    {
      elem.style.display="";    
      for(var i=0; i<selects.length; i++)
      {
        if(!readonly)
        {
          selects[i].disabled=false;
        }
        else
          selects[i].disabled=true;
          
        if(selects[i].multiple)
          scheduleHx.multiSelectChanged(selects[i])                
      }
    }
    else
    {
      elem.style.display="none";
      for(var i=0; i<selects.length; i++)
        selects[i].disabled=true;
    }
    
    for(var i=0; i<selects.length; i++)
      this.fireOnChange(selects[i]);
  }
                                    
  this.multiSelectChanged = function(elem)
  {
    var formValue = "";
    for(var i = 0; i < elem.options.length; i++) 
    {
      if(elem.options[i].selected)
      {
        
        if(formValue.length > 0)
          formValue+=";"
        
        formValue+=elem.options[i].value;
      }
    }  
    hx.setFormValue(elem.name + "Multiple", formValue); 
  }
  
  this.fireOnChange = function(elem)
  {
    
    if(hx.ie)
    {                            
      elem.fireEvent("onchange");
    }
    else
    {
      var changeEvent=document.createEvent("HTMLEvents");
      changeEvent.initEvent("change", true, true);
      elem.dispatchEvent(changeEvent);
    }
  }


}