/**
 * Immediately invoked function to start an applet instance in the Niagara
 * Web Start application.
 * Copyright 2016 Tridium, Inc. All Rights Reserved. 
 */

/*jslint browser: true*/
/*global console, niagaraWebstart */

(function () {
  "use strict";

  var script        = document.currentScript,
      appletDiv     = document.createElement('div'),
      appletElement = document.createElement('applet'),
      paramElement,
      parentDiv,
      prop;

  try {
    appletDiv.id = 'applet';
    appletDiv.appendChild(appletElement);

    appletElement.setAttribute('width', script.appletWidth);
    appletElement.setAttribute('height', script.appletHeight);
    appletElement.setAttribute('codebase', script.appletCodebase);
    appletElement.setAttribute('code', 'WbApplet.class');

    for (prop in script.appletParams) {
      if (script.appletParams.hasOwnProperty(prop)) {
        paramElement = document.createElement('param');
        paramElement.setAttribute('name', prop);
        paramElement.setAttribute('value', script.appletParams[prop]);
        appletElement.appendChild(paramElement);
      }
    }

    parentDiv = document.querySelector('#' + script.appletDivId);
    if (parentDiv) {
      parentDiv.appendChild(appletDiv);
    } else {
      document.body.appendChild(appletDiv);
    }

    if (window.niagaraWebstart && window.niagaraWebstart.view) {
      window.niagaraWebstart.view.onAppletEmbedded();
    }
  } catch (x) {
    if (console) {
      console.log('error embedding applet: ' + x);
    }
  }
}());




