/**
 * Immediately invoked function to deploy an applet inside a specified div target
 * @author Danesh Kamal
 */
(function () {
  var DEPLOYMENT_SCRIPT       = '/ord?module://web/com/tridium/web/rc/deployJava.js',
      EMBED_APPLET_SCRIPT_ORD = 'module://web/com/tridium/web/rc/embedApplet.js';

  /**
   * Asynchronously load a script, followed by execution of the callback argument
   * @param src
   * @param callback
   */
  function getScript(src, callback) {
    var s = document.createElement('script');
    s.src = src;
    s.async = true;
    s.onreadystatechange = s.onload = function () {
      if (!callback.done && (!s.readyState || /loaded|complete/.test(s.readyState))) {
        callback.done = true;
        callback();
      }
    };
    document.querySelector('head').appendChild(s);
  }

  /**
   * Embed an applet in the div target specified by obj.id
   * @param obj Object specifying applet div id, attributes, params, and version
   */
  function embed(obj) {
    getScript(DEPLOYMENT_SCRIPT, function () {
      var div        = document.getElementById(obj.id),
          appletDiv  = document.createElement('div'),
          attributes = obj.attributes,
          params     = obj.params,
          version    = obj.version;

      appletDiv.id = 'applet';
      div.appendChild(appletDiv);

      if (deployJava) {
        deployJava.runApplet(attributes, params, version, appletDiv);
      }
    })
  }

  /**
   * Returns the script object representing the embedApplet.js script
   * @returns {Object}
   */
  function getCurrentScript() {
    var scripts = document.scripts;
    for (var i = 0; i < scripts.length; i++) {
      var script = scripts[i],
          src    = scripts[i].src;
      if (src.indexOf(EMBED_APPLET_SCRIPT_ORD) !== -1) {
        return script;
      }
    }
  }

  var script = getCurrentScript();
  if (script) {
    embed({
      id: script.appletDivId,
      attributes: script.appletAttributes,
      params: script.appletParams,
      version: script.appletVersion
    });
  }
}());






