/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/**
 * AlarmConsole JavaScript support.
 *
 * @author    Blake M Puhal
 * @creation  29 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

////////////////////////////////////////////////////////////////
// AbstractManager
////////////////////////////////////////////////////////////////

var ac = new AlarmConsole();
function AlarmConsole()
{
////////////////////////////////////////////////////////////////
// Attributes 
////////////////////////////////////////////////////////////////
  
////////////////////////////////////////////////////////////////
// Selection
////////////////////////////////////////////////////////////////
  
  this.selectAll = function(event)
  {
    try
    {
      var checkbox = (!event.target) ? window.event.srcElement : event.target;
      var tr = checkbox.parentNode.parentNode.nextSibling;
      while (tr != null)
      {
        var rowcheckbox = tr.childNodes[0].childNodes[0];
        if (rowcheckbox != null)
        {
          rowcheckbox.checked = checkbox.checked;
        }
        tr = tr.nextSibling;
      }   
    }
    catch(err)
    {}
  }
 
  /**
   * Mark the row as selected or deselected.
   */
  this.showRecurring = function(name) 
  {
    var body = "showRecurring," + name;
    var msg = new Message();    
    msg.setHeader("Content-Type", "application/x-niagara-hx-AlarmConsole-InvokeCommand");
    msg.send(window.location, body, this.doInvokeCommand);
  }
  
  this.showDetails = function(name) 
  {
    var body = "showDetails," + name;
    var msg = new Message();
    msg.setHeader("Content-Type", "application/x-niagara-hx-AlarmConsole-InvokeCommand");
    msg.send(window.location, body, this.doInvokeCommand);
  }
  
  this.showAll = function(name) 
  {
    var body = "showDetails," + name;
    var msg = new Message();    
    msg.setHeader("Content-Type", "application/x-niagara-hx-AlarmConsole-InvokeCommand");
    msg.send(window.location, body, this.doInvokeCommand);
  }
  
  this.sort = function(cmd, arg, column, order)
  {
    var body = cmd + "," + arg + "," + column + "," + order;
    var msg = new Message();
    msg.setHeader("Content-Type", "application/x-niagara-hx-AlarmConsole-InvokeCommand");    
    msg.send(window.location, body, this.doInvokeCommand);
  }
  
  this.forceClear = function(name)
  {
    var body = "forceClear,"+name;
    var msg = new Message();
    msg.setHeader("Content-Type", "application/x-niagara-hx-AlarmConsole-InvokeCommand");    
    msg.send(window.location, body, this.doInvokeCommand);
  }
  
////////////////////////////////////////////////////////////////
// Commands
////////////////////////////////////////////////////////////////
  
  /**
   * Handle invokeCommand response.
   */
  this.doInvokeCommand = function(resp)
  {
    var text = resp.responseText;
    if (text == "null") 
    {
      window.location.reload(true);
      return;
    }
    
    try
    {
      var path = resp.getResponseHeader("hxPath");
    }
    catch(error)
    {
      var path = "";
    }
    
    if (path.length > 0)
      content = document.getElementById(path + ".content");
    else
      content = document.getElementById("content");
    
    try
    {
      content.innerHTML = text;
    }
    catch(error)
    {
      var div = document.createElement("div");
      div.name = "acCmdWin";
      div.innerHTML = text;
      content.appendChild(div);
    }
  }
  
}


