/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview EULA-related scripts
 *
 * @author Logan Byam
 */

//JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: true, white: true, undef: false, nomen: false, eqeqeq: true, 
bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2, vars: true, continue: true */

/*global $, dialogs, document, history*/ 
 
(function () {
  "use strict";

  function isEulaAccepted() {
    var eulaAccepted = $.cookies.get('eulaAccepted'),
        eulaTime = new Date($('#eula-date').text()).getTime();
    
    //never accepted
    if (!eulaAccepted) {
      return false;
    }
    
    //eula updated since last accepted
    if (typeof eulaAccepted === 'number' && eulaAccepted < eulaTime) {
      return false;
    }

    return true;
  }
  
  function showEulaDialog() {
    $('#wrapper').hide();
    $('#eula').show();
    
    $('button#ok').click(function () {
      var now = new Date(),
          expiresAt = new Date(now.getFullYear() + 1, now.getMonth(), now.getDate());
      
      $.cookies.set('eulaAccepted', now.getTime(), {
        expiresAt: expiresAt 
      });
      $('#eula').hide();
      $('#wrapper').show();
      $(document).scrollTop(0);
    });
    
    
    $('button#cancel').click(function () {
      $.cookies.del('eulaAccepted');
      history.back();
    });
  }
  
  $(function () {
    if (!isEulaAccepted()) {
      showEulaDialog();
    }
  });
}());