/**
 * @license Copyright 2011, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview BajaScript Console
 *
 * @author Gareth Johnson
 * @version 0.0.1.0
 */
 
//JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: true, white: true, undef: false, nomen: false, eqeqeq: true, 
  bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2, vars: true, continue: true */

/*global $, baja, location, window, document, eval*/ 

// Global options that can be set from a Scriptlet
var bsconsole = { 
  clearOutputOnRun: true 
};

(function bajaScriptConsole() {
  // Use ECMAScript 5 Strict Mode
  "use strict";

////////////////////////////////////////////////////////////////
// Console
////////////////////////////////////////////////////////////////    
   
  var optionHtml = "<option>{fileName}</option>",
      app;
      
  function defFail(err) {
    baja.error(err); 
    
    // Close any dialogs that are open
    dialogs.close();
  }  
      
  /**
   * Return a valid Hyperlink without any search parameter
   */
  function getHref() {
    // Make sure we've got a valid href we can add a search too
    var href = location.href,
        index;    
    href = href.replace("ord?", "ord/");
    index = href.indexOf("?");
    if (index > -1) {
      href = href.substring(0, index);
    }
    return href;
  }
  
  /**
   * Called to resize certain elements that can't be done via CSS
   */
  function resize() {
    // This is a hack...
    if ($("#examples").css("display") !== "none") {
      $("#bsCode").height($("#top").height() - $("#examples").outerHeight(true) - 3);
    }
    else {
      $("#bsCode").height($("#top").height() - 3); 
    }
    $("#bajaScriptOut").height($("#bottom").height() - $("#buttons").outerHeight(true));
  }
 
  /**
   * Initialize the User Interface
   */   
  function initializeUi() {
    // Automatically resize some of the HTML elements
    $(window).resize(resize);
    resize();
  
    // Disable spell check (HTML5 only)
    $("#bsCode").get(0).spellcheck = false;                         
    $("#bajaScriptOut").get(0).spellcheck = false; 
  
    // Called when the run button is clicked  
    $("#run").click(function () {
      if (bsconsole.clearOutputOnRun) {
        baja.clearOut();
      }

      var bsOut = $("#bsCode"),
          evil = eval; // Workaround for JsLint
      
      try {      
        // Evaluate the JavaScript
        evil("(function () {" + bsOut.val() + "}());");            
      }
      catch(err) {
        baja.error(err);
      }
             
      // Scroll to the bottom of the text area
      $("#bajaScriptOut").get(0).scrollTop = bsOut.get(0).scrollHeight;    
    });

    // Called when the 'Clear Console' button is clicked
    $("#clear").click(function () {
      baja.clearOut();
    });   

    // Called when the save button is clicked
    $("#save").click(function () {
          
      // Make a server side call to load the BajaScript example
      app.serverSideCall({
        typeSpec: "testBajaScript:ConsoleServerSideHandler", 
        methodName: "saveUserFile", 
        value:  $("#bsCode").val(), 
        ok: function (id) {
          // Load the content directly from the file
          location.assign(getHref() + "?user=" + id);
        },
        fail: defFail
      });
    });    
  }
  
  // When the DOM is ready arm handlers
  $(document).ready(initializeUi);  
  
  /**
   * Called to load a user file
   */
  function loadUserFile() {
    $("#examples").hide();    
    resize();
    
    var res = /user\=(.+)/.exec(location.search),
        id;
    
    // Parse the index number...
    if (res && res.length > 1) {
      id = res[1];
    }
    else {
      defFail("Could not find valid user id: " + location.search);
      return;
    }
    
    // Make a server side call to load the BajaScript example
    app.serverSideCall({
      typeSpec: "testBajaScript:ConsoleServerSideHandler", 
      methodName: "loadUserFile", 
      value:  id, 
      ok: function (bs) {
        baja.clearOut();
        
        // Should work around IE for ignoring newlines in 'pre' and 'textarea' elements
        bs = bs.replace(/\n/g, "\r\n");
        $("#bsCode").val(bs);  
        
        // Close any dialogs that are open
        dialogs.close();
      },
      fail: defFail
    });
  }
   
  /**
   * Called to load the example files
   */   
  function loadExampleFiles() {
    app.serverSideCall({
      typeSpec: "testBajaScript:ConsoleServerSideHandler", 
      methodName: "findExampleFiles", 
      ok: function (files) {
        // Get the drop down list and append the examples to the list
        var bsExamples = $("#bsExamples"),
            fileNames = files.split("|"),
            option,
            i,
            res,
            index = 0;
                        
        for (i = 0; i < fileNames.length; ++i) { 
          option = $(optionHtml.patternReplace({
            fileName: fileNames[i]
          }));
          bsExamples.append(option); 
        }
        
        // Load the selection index     
        res = /(?:i\=([0-9]+))+/.exec(location.search);
        
        // Parse the index number...
        if (res && res.length > 1) {
          index = parseInt(res[1], 10);
        }
        
        // Select the item from the drop down...
        bsExamples.children().eq(index).attr("selected", true);
                    
        // Make a server side call to load the BajaScript example
        app.serverSideCall({
          typeSpec: "testBajaScript:ConsoleServerSideHandler", 
          methodName: "loadExampleFile", 
          value:  bsExamples.children().eq(index).text(), 
          ok: function (bs) {
            baja.clearOut();
                     
            // Should work around IE for ignoring newlines in 'pre' and 'textarea' elements
            bs = bs.replace(/\n/g, "\r\n");
            $("#bsCode").val(bs);
            
            // Close any dialogs that are open
           dialogs.close();
          },
          fail: defFail
        });
                      
        // Add a change listener for drop down select
        bsExamples.change(function (event) {
          var i = $("option:selected", bsExamples).first().index();
          if (i >= 0) {
            // Find the option that's selected
            location.replace(getHref() + "?i=" + i);
          }
        });   
      }
    });
  }  
    
  /**
   * Called to start the BajaScript Console
   */
  function startConsole() {
    // Resolve the BOX Service and invoke a Server Side Call
    baja.Ord.make("service:testBajaScript:BajaScriptTutorialsApp").get({
      ok: function() {
        app = this;
        // If the URL points to a user file then attempt to load it
        if (/user\=/.test(location.search)) {
          loadUserFile();
        }
        else {
          loadExampleFiles();
        }
      },
      fail: defFail
    });
  }
  
  // When the DOM is ready show this loading dialog...
  $(function () {
    dialogs.loading();
  });

  // Start the Console once BajaScript has started
  baja.started(startConsole);  
}());

  
